/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.entry.CaConfColumn;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

class CaconfDbExporter
extends DbPorter {
    CaconfDbExporter(DataSourceWrapper datasource, String destDir, AtomicBoolean stopMe) throws DataAccessException {
        super(datasource, destDir, stopMe);
    }

    public void export() throws Exception {
        CaCertstore.Caconf caconf = new CaCertstore.Caconf();
        caconf.setVersion(2);
        System.out.println("exporting CA configuration from database");
        this.exportDbSchema(caconf);
        this.exportSigner(caconf);
        this.exportRequestor(caconf);
        this.exportPublisher(caconf);
        this.exportCa(caconf);
        this.exportProfile(caconf);
        this.exportCaalias(caconf);
        this.exportCaHasRequestor(caconf);
        this.exportCaHasPublisher(caconf);
        this.exportCaHasProfile(caconf);
        if (this.dbSchemaVersion >= 7) {
            this.exportKeypairGen(caconf);
        }
        caconf.validate();
        try (OutputStream os = Files.newOutputStream(Paths.get(this.baseDir, "ca-configuration.json"), new OpenOption[0]);){
            JSON.writeJSONString((OutputStream)os, (Object)((Object)caconf), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
        System.out.println(" exported CA configuration from database");
    }

    private void exportCaalias(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.println("exporting table CAALIAS");
        LinkedList<CaCertstore.Caalias> caaliases = new LinkedList<CaCertstore.Caalias>();
        String sql = "SELECT NAME,CA_ID FROM CAALIAS";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT NAME,CA_ID FROM CAALIAS");
            while (rs.next()) {
                CaCertstore.Caalias caalias = new CaCertstore.Caalias();
                caalias.setName(rs.getString("NAME"));
                caalias.setCaId(rs.getInt("CA_ID"));
                caalias.validate();
                caaliases.add(caalias);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,CA_ID FROM CAALIAS", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaaliases(caaliases);
        System.out.println(" exported table CAALIAS");
    }

    private void exportRequestor(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.println("exporting table REQUESTOR");
        LinkedList<CaCertstore.IdNameTypeConf> requestors = new LinkedList<CaCertstore.IdNameTypeConf>();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM REQUESTOR";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,NAME,TYPE,CONF FROM REQUESTOR");
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.IdNameTypeConf requestor = new CaCertstore.IdNameTypeConf();
                requestor.setId(rs.getInt("ID"));
                requestor.setName(name);
                requestor.setType(rs.getString("TYPE"));
                requestor.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/cert-requestor-" + name + ".conf"));
                requestor.validate();
                requestors.add(requestor);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM REQUESTOR", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setRequestors(requestors);
        System.out.println(" exported table REQUESTOR");
    }

    private void exportDbSchema(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.println("exporting table DBSCHEMA");
        LinkedList<CaCertstore.DbSchemaEntry> entries = new LinkedList<CaCertstore.DbSchemaEntry>();
        String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT NAME,VALUE2 FROM DBSCHEMA");
            while (rs.next()) {
                CaCertstore.DbSchemaEntry entry = new CaCertstore.DbSchemaEntry();
                entry.setName(rs.getString("NAME"));
                entry.setValue(rs.getString("VALUE2"));
                entry.validate();
                entries.add(entry);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setDbSchemas(entries);
        System.out.println(" exported table DBSCHEMA");
    }

    private void exportSigner(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.println("exporting table SIGNER");
        LinkedList<CaCertstore.Signer> signers = new LinkedList<CaCertstore.Signer>();
        String sql = "SELECT NAME,TYPE,CONF,CERT FROM SIGNER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT NAME,TYPE,CONF,CERT FROM SIGNER");
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.Signer signer = new CaCertstore.Signer();
                signer.setName(name);
                signer.setType(rs.getString("TYPE"));
                signer.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-signer-" + name));
                signer.setCert(this.buildFileOrBase64Binary(rs.getString("CERT"), "ca-conf/cert-signer-" + name + ".der"));
                signer.validate();
                signers.add(signer);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,TYPE,CONF,CERT FROM SIGNER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setSigners(signers);
        System.out.println(" exported table SIGNER");
    }

    private void exportKeypairGen(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.println("exporting table KEYPAIR_GEN");
        LinkedList<CaCertstore.NameTypeConf> keypairGens = new LinkedList<CaCertstore.NameTypeConf>();
        String sql = "SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN");
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.NameTypeConf entry = new CaCertstore.NameTypeConf();
                entry.setName(name);
                entry.setType(rs.getString("TYPE"));
                entry.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-publisher-" + name));
                entry.validate();
                keypairGens.add(entry);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setKeypairGens(keypairGens);
        System.out.println(" exported table KEYPAIR_GEN");
    }

    private void exportPublisher(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.println("exporting table PUBLISHER");
        LinkedList<CaCertstore.IdNameTypeConf> publishers = new LinkedList<CaCertstore.IdNameTypeConf>();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM PUBLISHER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,NAME,TYPE,CONF FROM PUBLISHER");
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.IdNameTypeConf publisher = new CaCertstore.IdNameTypeConf();
                publisher.setId(rs.getInt("ID"));
                publisher.setName(name);
                publisher.setType(rs.getString("TYPE"));
                publisher.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-publisher-" + name));
                publisher.validate();
                publishers.add(publisher);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM PUBLISHER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setPublishers(publishers);
        System.out.println(" exported table PUBLISHER");
    }

    private void exportProfile(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.println("exporting table PROFILE");
        LinkedList<CaCertstore.IdNameTypeConf> profiles = new LinkedList<CaCertstore.IdNameTypeConf>();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM PROFILE";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,NAME,TYPE,CONF FROM PROFILE");
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.IdNameTypeConf profile = new CaCertstore.IdNameTypeConf();
                profile.setId(rs.getInt("ID"));
                profile.setName(name);
                profile.setType(rs.getString("TYPE"));
                profile.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/certprofile-" + name));
                profile.validate();
                profiles.add(profile);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM PROFILE", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setProfiles(profiles);
        System.out.println(" exported table PROFILE");
    }

    private void exportCa(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.println("exporting table CA");
        LinkedList<CaCertstore.Ca> cas = new LinkedList<CaCertstore.Ca>();
        String columns = "SELECT ID,NAME,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,REV_INFO,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN";
        columns = this.dbSchemaVersion >= 7 ? columns + ",CONF" : columns + ",SN_SIZE,CA_URIS,MAX_VALIDITY,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,VALIDITY_MODE,CRL_CONTROL,CTLOG_CONTROL,REVOKE_SUSPENDED_CONTROL,KEEP_EXPIRED_CERT_DAYS,EXTRA_CONTROL";
        String sql = columns + " FROM CA";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String confColumn;
                CaCertstore.Ca ca = new CaCertstore.Ca();
                ca.setId(rs.getInt("ID"));
                String name = rs.getString("NAME");
                ca.setName(name);
                ca.setNextCrlNo(rs.getLong("NEXT_CRLNO"));
                ca.setStatus(rs.getString("STATUS"));
                ca.setCert(this.buildFileOrBase64Binary(rs.getString("CERT"), "ca-conf/cert-ca-" + name + ".der"));
                ca.setCertchain(this.buildFileOrValue(rs.getString("CERTCHAIN"), "ca-conf/certchain-ca-" + name + ".pem"));
                ca.setSignerType(rs.getString("SIGNER_TYPE"));
                ca.setSignerConf(this.buildFileOrValue(rs.getString("SIGNER_CONF"), "ca-conf/signerconf-ca-" + name));
                ca.setRevInfo(rs.getString("REV_INFO"));
                ca.setCrlSignerName(rs.getString("CRL_SIGNER_NAME"));
                if (this.dbSchemaVersion >= 7) {
                    confColumn = rs.getString("CONF");
                    CaConfColumn.decode((String)confColumn);
                } else {
                    CaConfColumn ccc = new CaConfColumn();
                    ccc.setSnSize(rs.getInt("SN_SIZE"));
                    String str = rs.getString("CA_URIS");
                    if (StringUtil.isNotBlank((String)str)) {
                        CaUris caUris = CaUris.decode((String)str);
                        ccc.setCacertUris(caUris.getCacertUris());
                        ccc.setCrlUris(caUris.getCrlUris());
                        ccc.setDeltaCrlUris(caUris.getDeltaCrlUris());
                        ccc.setOcspUris(caUris.getOcspUris());
                    }
                    ccc.setMaxValidity(rs.getString("MAX_VALIDITY"));
                    str = rs.getString("CRL_CONTROL");
                    if (StringUtil.isNotBlank((String)str)) {
                        ccc.setCrlControl(new ConfPairs(str).asMap());
                    }
                    if (StringUtil.isNotBlank((String)(str = rs.getString("CTLOG_CONTROL")))) {
                        ccc.setCtlogControl(new ConfPairs(str).asMap());
                    }
                    ccc.setPermission(rs.getInt("PERMISSION"));
                    ccc.setExpirationPeriod(rs.getInt("EXPIRATION_PERIOD"));
                    ccc.setKeepExpiredCertDays(rs.getInt("KEEP_EXPIRED_CERT_DAYS"));
                    ccc.setValidityMode(rs.getString("VALIDITY_MODE"));
                    str = rs.getString("EXTRA_CONTROL");
                    if (StringUtil.isNotBlank((String)str)) {
                        ccc.setExtraControl(new ConfPairs(str).asMap());
                    }
                    ccc.setNumCrls(rs.getInt("NUM_CRLS"));
                    str = rs.getString("REVOKE_SUSPENDED_CONTROL");
                    if (StringUtil.isNotBlank((String)str)) {
                        ccc.setRevokeSuspendedControl(new ConfPairs(str).asMap());
                    }
                    ccc.setKeypairGenNames(Collections.singletonList("software"));
                    ccc.setSaveCert(true);
                    ccc.setSaveKeypair(false);
                    confColumn = ccc.encode();
                }
                ca.validate();
                ca.setConfColumn(this.buildFileOrValue(confColumn, "ca-conf/" + name + ".conf"));
                cas.add(ca);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCas(cas);
        System.out.println(" exported table CA");
    }

    private void exportCaHasRequestor(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.println("exporting table CA_HAS_REQUESTOR");
        LinkedList<CaCertstore.CaHasRequestor> caHasRequestors = new LinkedList<CaCertstore.CaHasRequestor>();
        String sql = "SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR");
            while (rs.next()) {
                CaCertstore.CaHasRequestor caHasRequestor = new CaCertstore.CaHasRequestor();
                caHasRequestor.setCaId(rs.getInt("CA_ID"));
                caHasRequestor.setRequestorId(rs.getInt("REQUESTOR_ID"));
                caHasRequestor.setPermission(rs.getInt("PERMISSION"));
                caHasRequestor.setProfiles(rs.getString("PROFILES"));
                caHasRequestor.validate();
                caHasRequestors.add(caHasRequestor);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaHasRequestors(caHasRequestors);
        System.out.println(" exported table CA_HAS_REQUESTOR");
    }

    private void exportCaHasPublisher(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.println("exporting table CA_HAS_PUBLISHER");
        LinkedList<CaCertstore.CaHasPublisher> caHasPublishers = new LinkedList<CaCertstore.CaHasPublisher>();
        String sql = "SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER");
            while (rs.next()) {
                CaCertstore.CaHasPublisher caHasPublisher = new CaCertstore.CaHasPublisher();
                caHasPublisher.setCaId(rs.getInt("CA_ID"));
                caHasPublisher.setPublisherId(rs.getInt("PUBLISHER_ID"));
                caHasPublisher.validate();
                caHasPublishers.add(caHasPublisher);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaHasPublishers(caHasPublishers);
        System.out.println(" exported table CA_HAS_PUBLISHER");
    }

    private void exportCaHasProfile(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.println("exporting table CA_HAS_PROFILE");
        LinkedList<CaCertstore.CaHasProfile> caHasProfiles = new LinkedList<CaCertstore.CaHasProfile>();
        String sql = "SELECT CA_ID,PROFILE_ID FROM CA_HAS_PROFILE";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT CA_ID,PROFILE_ID FROM CA_HAS_PROFILE");
            while (rs.next()) {
                CaCertstore.CaHasProfile caHasProfile = new CaCertstore.CaHasProfile();
                caHasProfile.setCaId(rs.getInt("CA_ID"));
                caHasProfile.setProfileId(rs.getInt("PROFILE_ID"));
                caHasProfile.validate();
                caHasProfiles.add(caHasProfile);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,PROFILE_ID FROM CA_HAS_PROFILE", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaHasProfiles(caHasProfiles);
        System.out.println(" exported table CA_HAS_PROFILE");
    }
}

