/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ExcludeFileFilter;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.DbWorker;
import org.xipki.ca.mgmt.db.port.CaCertstoreDbExporter;
import org.xipki.ca.mgmt.db.port.CaCertstoreDbImporter;
import org.xipki.ca.mgmt.db.port.CaconfDbExporter;
import org.xipki.ca.mgmt.db.port.CaconfDbImporter;
import org.xipki.ca.mgmt.db.port.OcspCertStoreFromCaDbImporter;
import org.xipki.ca.mgmt.db.port.OcspCertstoreDbExporter;
import org.xipki.ca.mgmt.db.port.OcspCertstoreDbImporter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.FileUtils;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public abstract class DbPortWorker
extends DbWorker {
    private static final Logger LOG = LoggerFactory.getLogger(DbPortWorker.class);
    protected char[] password;

    public DbPortWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, char[] password) throws PasswordResolverException, IOException {
        super(datasourceFactory, passwordResolver, dbConfFile);
        this.password = password;
    }

    private static ZipParameters getZipParameters() {
        ExcludeFileFilter excludeFileFilter = file -> file.isDirectory() && file.getName().equals("encrypted");
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setEncryptFiles(true);
        zipParameters.setIncludeRootFolder(false);
        zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        zipParameters.setExcludeFileFilter(excludeFileFilter);
        return zipParameters;
    }

    protected void encrypt(File dir) throws IOException {
        File zipDir = new File(dir, "encrypted");
        if (zipDir.exists()) {
            FileUtils.deleteDirectory((File)zipDir);
        }
        zipDir.mkdirs();
        ZipFile zipFile = new ZipFile(new File(zipDir, "main.zip"), this.password);
        zipFile.createSplitZipFileFromFolder(dir, DbPortWorker.getZipParameters(), true, 0x4000000L);
        this.deleteDecryptedFiles(dir.getPath());
    }

    protected void decrypt(String dir) throws IOException {
        File mainFile = new File(dir, "encrypted/main.zip");
        ZipFile zipFile = new ZipFile(mainFile, this.password);
        boolean alreadyUnzipped = false;
        for (FileHeader fh : zipFile.getFileHeaders()) {
            if (fh.isDirectory()) continue;
            alreadyUnzipped = new File(dir, fh.getFileName()).exists();
            break;
        }
        if (!alreadyUnzipped) {
            zipFile.extractAll(dir);
        }
    }

    protected void deleteDecryptedFiles(String dir) throws IOException {
        File[] files = new File(dir).listFiles();
        if (files == null) {
            return;
        }
        File mainFile = new File(dir, "encrypted");
        if (!mainFile.exists()) {
            return;
        }
        for (File f : files) {
            if (f.getName().equals("encrypted")) continue;
            LinkedList<File> failedList = new LinkedList<File>();
            BasicFileAttributes basicFileAttributes = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (basicFileAttributes.isRegularFile()) {
                if (!IoUtil.deleteFile((File)f)) {
                    failedList.add(f);
                }
            } else if (basicFileAttributes.isDirectory() && !IoUtil.deleteDir((File)f)) {
                failedList.add(f);
            }
            if (failedList.isEmpty()) continue;
            LOG.error("error deleting files & folders: {}", failedList);
        }
    }

    private static void printFinishedIn(long startMs) {
        long duration = (System.currentTimeMillis() - startMs) / 1000L;
        System.out.println("Finished in " + StringUtil.formatTime((long)duration, (boolean)false));
    }

    public static class ImportOcspFromCaDb
    extends DbPortWorker {
        private final String publisherName;
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;

        public ImportOcspFromCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String publisherName, boolean resume, String srcFolder, int batchEntriesPerCommit, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile, password);
            this.publisherName = publisherName;
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = System.currentTimeMillis();
            if (this.password != null) {
                this.decrypt(this.srcFolder);
            }
            try {
                OcspCertStoreFromCaDbImporter certStoreImporter = new OcspCertStoreFromCaDbImporter(this.datasource, this.srcFolder, this.publisherName, this.batchEntriesPerCommit, this.resume, this.stopMe);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                this.deleteDecryptedFiles(this.srcFolder);
                DbPortWorker.printFinishedIn(start);
            }
        }
    }

    public static class ImportOcspDb
    extends DbPortWorker {
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;

        public ImportOcspDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, boolean resume, String srcFolder, int batchEntriesPerCommit, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile, password);
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = System.currentTimeMillis();
            if (this.password != null) {
                this.decrypt(this.srcFolder);
            }
            try {
                OcspCertstoreDbImporter certStoreImporter = new OcspCertstoreDbImporter(this.datasource, this.srcFolder, this.batchEntriesPerCommit, this.resume, this.stopMe);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                this.deleteDecryptedFiles(this.srcFolder);
                DbPortWorker.printFinishedIn(start);
            }
        }
    }

    public static class ExportOcspDb
    extends DbPortWorker {
        private final String destFolder;
        private final boolean resume;
        private final int numCertsInBundle;
        private final int numCertsPerSelect;

        public ExportOcspDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String destFolder, boolean resume, int numCertsInBundle, int numCertsPerSelect, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile, password);
            String[] children;
            this.destFolder = Args.notBlank((String)destFolder, (String)destFolder);
            File file = new File(destFolder);
            if (!file.exists()) {
                file.mkdirs();
            } else {
                if (!file.isDirectory()) {
                    throw new IOException(destFolder + " is not a folder");
                }
                if (!file.canWrite()) {
                    throw new IOException(destFolder + " is not writable");
                }
            }
            if (!resume && (children = file.list()) != null && children.length > 0) {
                throw new IOException(destFolder + " is not empty");
            }
            this.resume = resume;
            this.numCertsInBundle = numCertsInBundle;
            this.numCertsPerSelect = numCertsPerSelect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = System.currentTimeMillis();
            try {
                OcspCertstoreDbExporter certStoreExporter = new OcspCertstoreDbExporter(this.datasource, this.destFolder, this.numCertsInBundle, this.numCertsPerSelect, this.resume, this.stopMe);
                certStoreExporter.export();
                certStoreExporter.close();
                if (this.password != null) {
                    this.encrypt(new File(this.destFolder));
                }
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                DbPortWorker.printFinishedIn(start);
            }
        }
    }

    public static class ExportCaDb
    extends DbPortWorker {
        private final String destFolder;
        private final boolean resume;
        private final int numCertsInBundle;
        private final int numCertsPerSelect;

        public ExportCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String destFolder, boolean resume, int numCertsInBundle, int numCertsPerSelect, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile, password);
            this.destFolder = IoUtil.expandFilepath((String)destFolder);
            this.resume = resume;
            this.numCertsInBundle = numCertsInBundle;
            this.numCertsPerSelect = numCertsPerSelect;
            this.checkDestFolder();
        }

        private void checkDestFolder() throws IOException {
            File file = new File(this.destFolder);
            if (!file.exists()) {
                file.mkdirs();
            } else {
                if (!file.isDirectory()) {
                    throw new IOException(this.destFolder + " is not a folder");
                }
                if (!file.canWrite()) {
                    throw new IOException(this.destFolder + " is not writable");
                }
            }
            File processLogFile = new File(this.destFolder, "export.process");
            if (this.resume) {
                if (!processLogFile.exists()) {
                    throw new IOException("could not process with '--resume' option");
                }
            } else {
                String[] children = file.list();
                if (children != null && children.length > 0) {
                    throw new IOException(this.destFolder + " is not empty");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = System.currentTimeMillis();
            try {
                if (!this.resume) {
                    CaconfDbExporter caConfExporter = new CaconfDbExporter(this.datasource, this.destFolder, this.stopMe);
                    caConfExporter.export();
                    caConfExporter.close();
                }
                CaCertstoreDbExporter certStoreExporter = new CaCertstoreDbExporter(this.datasource, this.destFolder, this.numCertsInBundle, this.numCertsPerSelect, this.resume, this.stopMe);
                certStoreExporter.export();
                certStoreExporter.close();
                if (this.password != null) {
                    this.encrypt(new File(this.destFolder));
                }
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                DbPortWorker.printFinishedIn(start);
            }
        }
    }

    public static class ImportCaDb
    extends DbPortWorker {
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;

        public ImportCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, boolean resume, String srcFolder, int batchEntriesPerCommit, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile, password);
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            if (this.password != null) {
                this.decrypt(this.srcFolder);
            }
            try {
                File processLogFile = new File(this.srcFolder, "import.process");
                if (this.resume) {
                    if (!processLogFile.exists()) {
                        throw new Exception("could not process with '--resume' option");
                    }
                } else if (processLogFile.exists()) {
                    throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
                }
            }
            finally {
                this.deleteDecryptedFiles(this.srcFolder);
            }
            long start = System.currentTimeMillis();
            try {
                if (!this.resume) {
                    CaconfDbImporter caConfImporter = new CaconfDbImporter(this.datasource, this.srcFolder, this.stopMe);
                    caConfImporter.importToDb();
                    caConfImporter.close();
                }
                CaCertstoreDbImporter certStoreImporter = new CaCertstoreDbImporter(this.datasource, this.srcFolder, this.batchEntriesPerCommit, this.resume, this.stopMe);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                this.deleteDecryptedFiles(this.srcFolder);
                DbPortWorker.printFinishedIn(start);
            }
        }
    }
}

