/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.mgmt.db.port.IdentifiedDbObject;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.ValidatableConf;
import org.xipki.util.exception.InvalidConfException;

public class CaCertstore
extends ValidatableConf {
    private int version;
    private int countCrls;
    private int countCerts;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCountCrls() {
        return this.countCrls;
    }

    public void setCountCrls(int countCrls) {
        this.countCrls = countCrls;
    }

    public int getCountCerts() {
        return this.countCerts;
    }

    public void setCountCerts(int countCerts) {
        this.countCerts = countCerts;
    }

    public void validate() throws InvalidConfException {
    }

    public static class Signer
    extends ValidatableConf {
        private String name;
        private String type;
        private FileOrValue conf;
        private FileOrBinary cert;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public void validate() throws InvalidConfException {
            Signer.notBlank((String)this.name, (String)"name");
            Signer.notBlank((String)this.type, (String)"type");
            Signer.notNull((Object)this.conf, (String)"conf");
            this.conf.validate();
            Signer.validate((ValidatableConf)this.cert, (ValidatableConf[])new ValidatableConf[0]);
        }
    }

    public static class IdNameTypeConf
    extends NameTypeConf {
        private int id;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }

    public static class NameTypeConf
    extends ValidatableConf {
        private String name;
        private String type;
        private FileOrValue conf;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public void validate() throws InvalidConfException {
            NameTypeConf.notBlank((String)this.name, (String)"name");
            NameTypeConf.notBlank((String)this.type, (String)"type");
            if (this.conf != null) {
                this.conf.validate();
            }
        }
    }

    public static class DbSchemaEntry
    extends ValidatableConf {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void validate() throws InvalidConfException {
            DbSchemaEntry.notBlank((String)this.name, (String)"name");
            DbSchemaEntry.notNull((Object)this.value, (String)"value");
        }
    }

    public static class Crls
    extends ValidatableConf {
        private List<Crl> crls;

        public List<Crl> getCrls() {
            return this.crls;
        }

        public void setCrls(List<Crl> crls) {
            this.crls = crls;
        }

        public void add(Crl crl) {
            if (this.crls == null) {
                this.crls = new LinkedList<Crl>();
            }
            this.crls.add(crl);
        }

        public void validate() throws InvalidConfException {
            Crls.validate(this.crls, (Collection[])new Collection[0]);
        }
    }

    public static class Crl
    extends IdentifiedDbObject {
        private Integer caId;
        private String crlNo;
        private String file;
        private Integer crlScope;

        public Integer getCaId() {
            return this.caId;
        }

        public void setCaId(Integer caId) {
            this.caId = caId;
        }

        public String getCrlNo() {
            return this.crlNo;
        }

        public void setCrlNo(String crlNo) {
            this.crlNo = crlNo;
        }

        public Integer getCrlScope() {
            return this.crlScope;
        }

        public void setCrlScope(Integer crlScope) {
            this.crlScope = crlScope;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Crl.notNull((Object)this.caId, (String)"caId");
            Crl.notBlank((String)this.crlNo, (String)"crlNo");
            Crl.notBlank((String)this.file, (String)"file");
            Crl.notNull((Object)this.crlScope, (String)"crlScope");
        }
    }

    public static class Certs
    extends ValidatableConf {
        private List<Cert> certs;

        public List<Cert> getCerts() {
            if (this.certs == null) {
                this.certs = new LinkedList<Cert>();
            }
            return this.certs;
        }

        public void setCerts(List<Cert> certs) {
            this.certs = certs;
        }

        public void add(Cert cert) {
            this.getCerts().add(cert);
        }

        public void validate() throws InvalidConfException {
            Certs.validate(this.certs, (Collection[])new Collection[0]);
        }
    }

    public static class Cert
    extends IdentifiedDbObject {
        private String file;
        private String privateKeyFile;
        private Integer caId;
        private String sn;
        private Integer pid;
        private Integer rid;
        private Boolean ee;
        private Long update;
        private Integer rev;
        private Integer rr;
        private Long rt;
        private Long rit;
        private String tid;
        private Long fpRs;
        private Integer crlScope;
        private String rs;

        public Integer getCaId() {
            return this.caId;
        }

        public void setCaId(Integer caId) {
            this.caId = caId;
        }

        public String getSn() {
            return this.sn;
        }

        public void setSn(String sn) {
            this.sn = sn;
        }

        public Boolean getEe() {
            return this.ee;
        }

        public void setEe(Boolean ee) {
            this.ee = ee;
        }

        public Integer getPid() {
            return this.pid;
        }

        public void setPid(Integer pid) {
            this.pid = pid;
        }

        public Integer getRid() {
            return this.rid;
        }

        public void setRid(Integer rid) {
            this.rid = rid;
        }

        public Long getUpdate() {
            return this.update;
        }

        public void setUpdate(Long update) {
            this.update = update;
        }

        public Integer getRev() {
            return this.rev;
        }

        public void setRev(Integer rev) {
            this.rev = rev;
        }

        public Integer getRr() {
            return this.rr;
        }

        public void setRr(Integer rr) {
            this.rr = rr;
        }

        public Long getRt() {
            return this.rt;
        }

        public void setRt(Long rt) {
            this.rt = rt;
        }

        public Long getRit() {
            return this.rit;
        }

        public void setRit(Long rit) {
            this.rit = rit;
        }

        public String getTid() {
            return this.tid;
        }

        public void setTid(String tid) {
            this.tid = tid;
        }

        public Long getFpRs() {
            return this.fpRs;
        }

        public void setFpRs(Long fpRs) {
            this.fpRs = fpRs;
        }

        public String getRs() {
            return this.rs;
        }

        public void setRs(String rs) {
            this.rs = rs;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        public void setPrivateKeyFile(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
        }

        public Integer getCrlScope() {
            return this.crlScope;
        }

        public void setCrlScope(Integer crlScope) {
            this.crlScope = crlScope;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Cert.notNull((Object)this.caId, (String)"caId");
            Cert.notNull((Object)this.ee, (String)"ee");
            Cert.notBlank((String)this.file, (String)"file");
            Cert.notNull((Object)this.pid, (String)"pid");
            Cert.notNull((Object)this.rev, (String)"rev");
            Cert.notNull((Object)this.rid, (String)"rid");
            Cert.notBlank((String)this.sn, (String)"sn");
            Cert.notNull((Object)this.update, (String)"update");
            Cert.notNull((Object)this.crlScope, (String)"crlScope");
            if (this.rev == 1) {
                Cert.notNull((Object)this.rr, (String)"rr");
                Cert.notNull((Object)this.rt, (String)"rt");
            }
        }
    }

    public static class CaHasRequestor
    extends CaHasEntry {
        private int requestorId;
        private int permission;
        private String profiles;

        public int getRequestorId() {
            return this.requestorId;
        }

        public void setRequestorId(int requestorId) {
            this.requestorId = requestorId;
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public String getProfiles() {
            return this.profiles;
        }

        public void setProfiles(String profiles) {
            this.profiles = profiles;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class CaHasProfile
    extends CaHasEntry {
        private int profileId;
        private String aliases;

        public int getProfileId() {
            return this.profileId;
        }

        public void setProfileId(int profileId) {
            this.profileId = profileId;
        }

        public String getAliases() {
            return this.aliases;
        }

        public void setAliases(String aliases) {
            this.aliases = aliases;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class CaHasPublisher
    extends CaHasEntry {
        private int publisherId;

        public int getPublisherId() {
            return this.publisherId;
        }

        public void setPublisherId(int publisherId) {
            this.publisherId = publisherId;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static abstract class CaHasEntry
    extends ValidatableConf {
        private int caId;

        public int getCaId() {
            return this.caId;
        }

        public void setCaId(int caId) {
            this.caId = caId;
        }
    }

    public static class Caconf
    extends ValidatableConf {
        private int version;
        private List<DbSchemaEntry> dbSchemas;
        private List<Signer> signers;
        private List<NameTypeConf> keypairGens;
        private List<IdNameTypeConf> requestors;
        private List<IdNameTypeConf> publishers;
        private List<IdNameTypeConf> profiles;
        private List<Ca> cas;
        private List<Caalias> caaliases;
        private List<CaHasRequestor> caHasRequestors;
        private List<CaHasPublisher> caHasPublishers;
        private List<CaHasProfile> caHasProfiles;

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public List<DbSchemaEntry> getDbSchemas() {
            if (this.dbSchemas == null) {
                this.dbSchemas = new LinkedList<DbSchemaEntry>();
            }
            return this.dbSchemas;
        }

        public void setDbSchemas(List<DbSchemaEntry> dbSchemas) {
            this.dbSchemas = dbSchemas;
        }

        public List<Signer> getSigners() {
            if (this.signers == null) {
                this.signers = new LinkedList<Signer>();
            }
            return this.signers;
        }

        public void setSigners(List<Signer> signers) {
            this.signers = signers;
        }

        public List<IdNameTypeConf> getRequestors() {
            if (this.requestors == null) {
                this.requestors = new LinkedList<IdNameTypeConf>();
            }
            return this.requestors;
        }

        public void setRequestors(List<IdNameTypeConf> requestors) {
            this.requestors = requestors;
        }

        public List<IdNameTypeConf> getPublishers() {
            if (this.publishers == null) {
                this.publishers = new LinkedList<IdNameTypeConf>();
            }
            return this.publishers;
        }

        public void setPublishers(List<IdNameTypeConf> publishers) {
            this.publishers = publishers;
        }

        public List<IdNameTypeConf> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<IdNameTypeConf>();
            }
            return this.profiles;
        }

        public void setProfiles(List<IdNameTypeConf> profiles) {
            this.profiles = profiles;
        }

        public List<Ca> getCas() {
            if (this.cas == null) {
                this.cas = new LinkedList<Ca>();
            }
            return this.cas;
        }

        public void setCas(List<Ca> cas) {
            this.cas = cas;
        }

        public List<Caalias> getCaaliases() {
            if (this.caaliases == null) {
                this.caaliases = new LinkedList<Caalias>();
            }
            return this.caaliases;
        }

        public void setCaaliases(List<Caalias> caaliases) {
            this.caaliases = caaliases;
        }

        public List<CaHasRequestor> getCaHasRequestors() {
            if (this.caHasRequestors == null) {
                this.caHasRequestors = new LinkedList<CaHasRequestor>();
            }
            return this.caHasRequestors;
        }

        public void setCaHasRequestors(List<CaHasRequestor> caHasRequestors) {
            this.caHasRequestors = caHasRequestors;
        }

        public List<CaHasPublisher> getCaHasPublishers() {
            if (this.caHasPublishers == null) {
                this.caHasPublishers = new LinkedList<CaHasPublisher>();
            }
            return this.caHasPublishers;
        }

        public void setCaHasPublishers(List<CaHasPublisher> caHasPublishers) {
            this.caHasPublishers = caHasPublishers;
        }

        public List<CaHasProfile> getCaHasProfiles() {
            if (this.caHasProfiles == null) {
                this.caHasProfiles = new LinkedList<CaHasProfile>();
            }
            return this.caHasProfiles;
        }

        public void setCaHasProfiles(List<CaHasProfile> caHasProfiles) {
            this.caHasProfiles = caHasProfiles;
        }

        public List<NameTypeConf> getKeypairGens() {
            return this.keypairGens;
        }

        public void setKeypairGens(List<NameTypeConf> keypairGens) {
            this.keypairGens = keypairGens;
        }

        public void validate() throws InvalidConfException {
            Caconf.validate(this.signers, (Collection[])new Collection[]{this.requestors, this.publishers, this.profiles, this.cas, this.caaliases, this.caHasRequestors, this.caHasPublishers, this.caHasProfiles, this.keypairGens});
        }
    }

    public static class Caalias
    extends ValidatableConf {
        private int caId;
        private String name;

        public int getCaId() {
            return this.caId;
        }

        public void setCaId(int caId) {
            this.caId = caId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            Caalias.notBlank((String)this.name, (String)"name");
        }
    }

    public static class Ca
    extends ValidatableConf {
        private int id;
        private String name;
        private long nextCrlNo;
        private String status;
        private FileOrBinary cert;
        private FileOrValue certchain;
        private String signerType;
        private FileOrValue signerConf;
        private String revInfo;
        private String crlSignerName;
        private FileOrValue confColumn;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getNextCrlNo() {
            return this.nextCrlNo;
        }

        public void setNextCrlNo(long nextCrlNo) {
            this.nextCrlNo = nextCrlNo;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public FileOrValue getCertchain() {
            return this.certchain;
        }

        public void setCertchain(FileOrValue certchain) {
            this.certchain = certchain;
        }

        public String getSignerType() {
            return this.signerType;
        }

        public void setSignerType(String signerType) {
            this.signerType = signerType;
        }

        public FileOrValue getSignerConf() {
            return this.signerConf;
        }

        public void setSignerConf(FileOrValue signerConf) {
            this.signerConf = signerConf;
        }

        public String getRevInfo() {
            return this.revInfo;
        }

        public void setRevInfo(String revInfo) {
            this.revInfo = revInfo;
        }

        public String getCrlSignerName() {
            return this.crlSignerName;
        }

        public void setCrlSignerName(String crlSignerName) {
            this.crlSignerName = crlSignerName;
        }

        public FileOrValue getConfColumn() {
            return this.confColumn;
        }

        public void setConfColumn(FileOrValue confColumn) {
            this.confColumn = confColumn;
        }

        public void validate() throws InvalidConfException {
            Ca.notBlank((String)this.name, (String)"name");
            Ca.notBlank((String)this.status, (String)"status");
            Ca.notNull((Object)this.cert, (String)"cert");
            this.cert.validate();
            Ca.notBlank((String)this.signerType, (String)"signerType");
            Ca.notNull((Object)this.signerConf, (String)"signerConf");
            this.signerConf.validate();
        }
    }
}

