/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.cert.CRLException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.JSON;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;

class CaCertstoreDbExporter
extends DbPorter {
    private static final Logger LOG = LoggerFactory.getLogger(CaCertstoreDbExporter.class);
    private final int numCertsInBundle;
    private final int numCertsPerSelect;
    private final boolean resume;

    CaCertstoreDbExporter(DataSourceWrapper datasource, String baseDir, int numCertsInBundle, int numCertsPerSelect, boolean resume, AtomicBoolean stopMe) throws DataAccessException {
        super(datasource, baseDir, stopMe);
        this.numCertsInBundle = Args.positive((int)numCertsInBundle, (String)"numCertsInBundle");
        this.numCertsPerSelect = Args.positive((int)numCertsPerSelect, (String)"numCertsPerSelect");
        this.resume = resume;
    }

    public void export() throws Exception {
        CaCertstore certstore;
        Path path = Paths.get(this.baseDir, "ca-certstore.json");
        if (this.resume) {
            certstore = (CaCertstore)((Object)JSON.parseObject((Path)path, CaCertstore.class));
            certstore.validate();
            if (certstore.getVersion() > 2) {
                throw new Exception("could not continue with CertStore greater than 2: " + certstore.getVersion());
            }
        } else {
            certstore = new CaCertstore();
            certstore.setVersion(2);
        }
        Exception exception = null;
        System.out.println("exporting CA certstore from database");
        try {
            DbPorter.CaDbEntryType[] types;
            byte[] content;
            File processLogFile = new File(this.baseDir, "export.process");
            Long idProcessedInLastProcess = null;
            DbPorter.CaDbEntryType typeProcessedInLastProcess = null;
            if (processLogFile.exists() && (content = IoUtil.read((File)processLogFile)).length > 0) {
                DbPorter.CaDbEntryType[] str = StringUtil.toUtf8String((byte[])content);
                int idx = str.indexOf(58);
                String typeName = str.substring(0, idx).trim();
                typeProcessedInLastProcess = DbPorter.CaDbEntryType.valueOf(typeName);
                idProcessedInLastProcess = Long.parseLong(str.substring(idx + 1).trim());
            }
            if (DbPorter.CaDbEntryType.CRL == typeProcessedInLastProcess || typeProcessedInLastProcess == null) {
                exception = this.exportEntries(DbPorter.CaDbEntryType.CRL, certstore, processLogFile, idProcessedInLastProcess);
                typeProcessedInLastProcess = null;
                idProcessedInLastProcess = null;
            }
            for (DbPorter.CaDbEntryType type : types = new DbPorter.CaDbEntryType[]{DbPorter.CaDbEntryType.CERT}) {
                if (exception != null || type != typeProcessedInLastProcess && typeProcessedInLastProcess != null) continue;
                exception = this.exportEntries(type, certstore, processLogFile, idProcessedInLastProcess);
                typeProcessedInLastProcess = null;
                idProcessedInLastProcess = null;
            }
            certstore.validate();
            try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                JSON.writeJSON((Object)((Object)certstore), (OutputStream)os);
            }
        }
        catch (Exception ex) {
            System.err.println("could not export CA certstore from database");
            exception = ex;
        }
        if (exception != null) {
            throw exception;
        }
        System.out.println(" exported CA certstore from database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception exportEntries(DbPorter.CaDbEntryType type, CaCertstore certstore, File processLogFile, Long idProcessedInLastProcess) {
        String tablesText = "table " + type.getTableName();
        File dir = new File(this.baseDir, type.getDirName());
        try {
            IoUtil.mkdirs((File)dir);
        }
        catch (IOException ex) {
            LOG.error("IO Exception", (Throwable)ex);
            return ex;
        }
        OutputStream entriesFileOs = null;
        try {
            entriesFileOs = Files.newOutputStream(Paths.get(this.baseDir, type.getDirName() + ".mf"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            this.exportEntries(type, certstore, processLogFile, entriesFileOs, idProcessedInLastProcess);
            Exception exception = null;
            IoUtil.closeQuietly((Closeable)entriesFileOs);
            return exception;
        }
        catch (Exception ex) {
            CaCertstoreDbExporter.deleteTmpFiles(this.baseDir, "tmp-");
            System.err.println("\nexporting " + tablesText + " has been cancelled due to error,\nplease continue with the option '--resume'");
            LOG.error("Exception", (Throwable)ex);
            Exception exception = ex;
            return exception;
        }
        finally {
            IoUtil.closeQuietly(entriesFileOs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEntries(DbPorter.CaDbEntryType type, CaCertstore certstore, File processLogFile, OutputStream filenameListOs, Long idProcessedInLastProcess) throws Exception {
        Object coreSql;
        int numProcessedBefore;
        int numEntriesPerSelect = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerSelect));
        int numEntriesPerZip = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsInBundle));
        File entriesDir = new File(this.baseDir, type.getDirName());
        String tableName = type.getTableName();
        if (type == DbPorter.CaDbEntryType.CERT) {
            numProcessedBefore = certstore.getCountCerts();
            Object columns = "ID,SN,CA_ID,PID,RID,TID,EE,LUPDATE,REV,RR,RT,RIT,FP_RS,REQ_SUBJECT,CRL_SCOPE,CERT";
            if (this.dbSchemaVersion >= 7) {
                columns = (String)columns + ",PRIVATE_KEY";
            }
            coreSql = (String)columns + " FROM CERT WHERE ID>=?";
        } else if (type == DbPorter.CaDbEntryType.CRL) {
            numProcessedBefore = certstore.getCountCrls();
            coreSql = "ID,CA_ID,CRL_SCOPE,CRL FROM CRL WHERE ID>=?";
        } else {
            throw new IllegalStateException("unknown CaDbEntryType " + type);
        }
        long minId = idProcessedInLastProcess != null ? idProcessedInLastProcess + 1L : this.min(tableName, "ID");
        String tablesText = "table " + type.getTableName();
        System.out.println("exporting " + tablesText + " from ID " + minId);
        long maxId = this.max(tableName, "ID");
        long total = Math.max(1, this.count(tableName) - numProcessedBefore);
        String sql = this.datasource.buildSelectFirstSql(numEntriesPerSelect, "ID ASC", (String)coreSql);
        Object entriesInCurrentFile = CaCertstoreDbExporter.createContainer(type);
        PreparedStatement ps = this.prepareStatement(sql);
        int numEntriesInCurrentFile = 0;
        int sum = 0;
        File currentEntriesZipFile = new File(this.baseDir, "tmp-" + type.getDirName() + "-" + Clock.systemUTC().millis() + ".zip");
        ZipOutputStream currentEntriesZip = CaCertstoreDbExporter.getZipOutputStream(currentEntriesZipFile);
        long minIdOfCurrentFile = -1L;
        long maxIdOfCurrentFile = -1L;
        ProcessLog processLog = new ProcessLog(total);
        processLog.printHeader();
        try {
            Long id = null;
            boolean interrupted = false;
            long lastMaxId = minId - 1L;
            while (true) {
                if (this.stopMe.get()) {
                    interrupted = true;
                    break;
                }
                ps.setLong(1, lastMaxId + 1L);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) break;
                do {
                    if (lastMaxId < (id = Long.valueOf(rs.getLong("ID")))) {
                        lastMaxId = id;
                    }
                    if (minIdOfCurrentFile == -1L) {
                        minIdOfCurrentFile = id;
                    } else if (minIdOfCurrentFile > id) {
                        minIdOfCurrentFile = id;
                    }
                    if (maxIdOfCurrentFile == -1L) {
                        maxIdOfCurrentFile = id;
                    } else if (maxIdOfCurrentFile < id) {
                        maxIdOfCurrentFile = id;
                    }
                    if (DbPorter.CaDbEntryType.CERT == type) {
                        long fpReqSubject;
                        byte[] certBytes = Base64.decodeFast((String)rs.getString("CERT"));
                        String privateKey = null;
                        if (this.dbSchemaVersion >= 7) {
                            privateKey = rs.getString("PRIVATE_KEY");
                        }
                        String sha1 = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{certBytes});
                        String certFileName = sha1 + ".der";
                        currentEntriesZip.putNextEntry(new ZipEntry(certFileName));
                        try {
                            currentEntriesZip.write(certBytes);
                        }
                        finally {
                            currentEntriesZip.closeEntry();
                        }
                        String privateKeyFileName = sha1 + "-key.bin";
                        if (privateKey != null) {
                            currentEntriesZip.putNextEntry(new ZipEntry(privateKeyFileName));
                            try {
                                currentEntriesZip.write(privateKey.getBytes(StandardCharsets.UTF_8));
                            }
                            finally {
                                currentEntriesZip.closeEntry();
                            }
                        }
                        CaCertstore.Cert cert = new CaCertstore.Cert();
                        cert.setId(id);
                        cert.setCaId(rs.getInt("CA_ID"));
                        cert.setEe(rs.getBoolean("EE"));
                        cert.setFile(certFileName);
                        if (privateKey != null) {
                            cert.setPrivateKeyFile(privateKeyFileName);
                        }
                        if ((fpReqSubject = rs.getLong("FP_RS")) != 0L) {
                            cert.setFpRs(fpReqSubject);
                            cert.setRs(rs.getString("REQ_SUBJECT"));
                        }
                        cert.setPid(rs.getInt("PID"));
                        cert.setRid(rs.getInt("RID"));
                        cert.setSn(rs.getString("SN"));
                        String str = rs.getString("TID");
                        if (StringUtil.isNotBlank((String)str)) {
                            cert.setTid(str);
                        }
                        cert.setUpdate(rs.getLong("LUPDATE"));
                        int revoked = rs.getInt("REV");
                        cert.setRev(revoked);
                        if (revoked == 1) {
                            cert.setRr(rs.getInt("RR"));
                            cert.setRt(rs.getLong("RT"));
                            long revInvTime = rs.getLong("RIT");
                            if (revInvTime != 0L) {
                                cert.setRit(revInvTime);
                            }
                        }
                        cert.setCrlScope(rs.getInt("CRL_SCOPE"));
                        cert.validate();
                        ((CaCertstore.Certs)((Object)entriesInCurrentFile)).add(cert);
                    } else if (DbPorter.CaDbEntryType.CRL == type) {
                        X509CRLHolder x509Crl;
                        byte[] crlBytes = Base64.decodeFast((String)rs.getString("CRL"));
                        try {
                            x509Crl = X509Util.parseCrl((byte[])crlBytes);
                        }
                        catch (Exception ex) {
                            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse CRL with id " + id));
                            throw ex instanceof CRLException ? (CRLException)ex : new CRLException(ex.getMessage(), ex);
                        }
                        byte[] extnValue = X509Util.getCoreExtValue((Extensions)x509Crl.getExtensions(), (ASN1ObjectIdentifier)Extension.cRLNumber);
                        if (extnValue == null) {
                            LOG.warn("CRL without CRL number, ignore it");
                            continue;
                        }
                        String sha1 = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{crlBytes});
                        String crlFilename = sha1 + ".crl";
                        ZipEntry certZipEntry = new ZipEntry(crlFilename);
                        currentEntriesZip.putNextEntry(certZipEntry);
                        try {
                            currentEntriesZip.write(crlBytes);
                        }
                        finally {
                            currentEntriesZip.closeEntry();
                        }
                        CaCertstore.Crl crl = new CaCertstore.Crl();
                        crl.setId(id);
                        crl.setCaId(rs.getInt("CA_ID"));
                        BigInteger crlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                        crl.setCrlNo(crlNumber.toString());
                        crl.setCrlScope(rs.getInt("CRL_SCOPE"));
                        crl.setFile(crlFilename);
                        crl.validate();
                        ((CaCertstore.Crls)((Object)entriesInCurrentFile)).add(crl);
                    } else {
                        throw new IllegalStateException("unknown CaDbEntryType " + type);
                    }
                    ++sum;
                    if (++numEntriesInCurrentFile != numEntriesPerZip) continue;
                    String currentEntriesFilename = CaCertstoreDbExporter.buildFilename(type.getDirName() + "_", ".zip", minIdOfCurrentFile, maxIdOfCurrentFile, maxId);
                    this.finalizeZip(currentEntriesZip, "overview.json", entriesInCurrentFile);
                    IoUtil.renameTo((File)currentEntriesZipFile, (File)new File(entriesDir, currentEntriesFilename));
                    CaCertstoreDbExporter.writeLine(filenameListOs, currentEntriesFilename);
                    CaCertstoreDbExporter.setCount(type, certstore, numProcessedBefore + sum);
                    CaCertstoreDbExporter.echoToFile(tableName + ":" + id, processLogFile);
                    processLog.addNumProcessed((long)numEntriesInCurrentFile);
                    processLog.printStatus();
                    entriesInCurrentFile = CaCertstoreDbExporter.createContainer(type);
                    numEntriesInCurrentFile = 0;
                    minIdOfCurrentFile = -1L;
                    maxIdOfCurrentFile = -1L;
                    currentEntriesZipFile = new File(this.baseDir, "tmp-" + type.getDirName() + "-" + Clock.systemUTC().millis() + ".zip");
                    currentEntriesZip = CaCertstoreDbExporter.getZipOutputStream(currentEntriesZipFile);
                } while (rs.next());
                rs.close();
            }
            if (interrupted) {
                currentEntriesZip.close();
                throw new InterruptedException("interrupted by the user");
            }
            if (numEntriesInCurrentFile > 0) {
                this.finalizeZip(currentEntriesZip, "overview.json", entriesInCurrentFile);
                String currentEntriesFilename = CaCertstoreDbExporter.buildFilename(type.getDirName() + "_", ".zip", minIdOfCurrentFile, maxIdOfCurrentFile, maxId);
                IoUtil.renameTo((File)currentEntriesZipFile, (File)new File(entriesDir, currentEntriesFilename));
                CaCertstoreDbExporter.writeLine(filenameListOs, currentEntriesFilename);
                CaCertstoreDbExporter.setCount(type, certstore, numProcessedBefore + sum);
                CaCertstoreDbExporter.echoToFile(Long.toString(id), processLogFile);
                processLog.addNumProcessed((long)numEntriesInCurrentFile);
            } else {
                currentEntriesZip.close();
                IoUtil.deleteFile0((File)currentEntriesZipFile);
            }
        }
        catch (SQLException ex) {
            throw this.translate(null, ex);
        }
        finally {
            this.releaseResources(ps, null);
        }
        processLog.printTrailer();
        IoUtil.deleteFile0((File)processLogFile);
        System.out.println(" exported " + sum + " entries from " + tablesText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeZip(ZipOutputStream zipOutStream, String filename, Object container) throws IOException {
        ZipEntry certZipEntry = new ZipEntry(filename);
        zipOutStream.putNextEntry(certZipEntry);
        try {
            JSON.writeJSON((Object)container, (OutputStream)zipOutStream);
        }
        finally {
            zipOutStream.closeEntry();
        }
        zipOutStream.close();
    }

    private static Object createContainer(DbPorter.CaDbEntryType type) {
        if (type == DbPorter.CaDbEntryType.CERT) {
            return new CaCertstore.Certs();
        }
        if (type == DbPorter.CaDbEntryType.CRL) {
            return new CaCertstore.Crls();
        }
        throw new IllegalStateException("unknown CaDbEntryType " + type);
    }

    private static void setCount(DbPorter.CaDbEntryType type, CaCertstore certstore, int num) {
        if (type == DbPorter.CaDbEntryType.CERT) {
            certstore.setCountCerts(num);
        } else if (type == DbPorter.CaDbEntryType.CRL) {
            certstore.setCountCrls(num);
        } else {
            throw new IllegalStateException("unknown CaDbEntryType " + type);
        }
    }
}

