/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.entry.CaConfColumn;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.util.JSON;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

class CaconfDbExporter
extends DbPorter {
    CaconfDbExporter(DataSourceWrapper datasource, String destDir, AtomicBoolean stopMe) throws DataAccessException {
        super(datasource, destDir, stopMe);
    }

    public void export() throws Exception {
        CaCertstore.Caconf caconf = new CaCertstore.Caconf();
        caconf.setVersion(2);
        System.out.println("exporting CA configuration from database");
        this.exportDbSchema(caconf);
        this.exportSigner(caconf);
        this.exportRequestor(caconf);
        this.exportPublisher(caconf);
        this.exportCa(caconf);
        this.exportProfile(caconf);
        this.exportCaalias(caconf);
        this.exportCaHasRequestor(caconf);
        this.exportCaHasPublisher(caconf);
        this.exportCaHasProfile(caconf);
        if (this.dbSchemaVersion >= 7) {
            this.exportKeypairGen(caconf);
        }
        caconf.validate();
        try (OutputStream os = Files.newOutputStream(Paths.get(this.baseDir, "ca-configuration.json"), new OpenOption[0]);){
            JSON.writePrettyJSON((Object)((Object)caconf), (OutputStream)os);
        }
        System.out.println(" exported CA configuration from database");
    }

    private void exportCaalias(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.print("    exporting table CAALIAS ... ");
        LinkedList<CaCertstore.Caalias> caaliases = new LinkedList<CaCertstore.Caalias>();
        String sql = "SELECT NAME,CA_ID FROM CAALIAS";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean succ = false;
        try {
            stmt = this.prepareStatement("SELECT NAME,CA_ID FROM CAALIAS");
            rs = stmt.executeQuery();
            while (rs.next()) {
                CaCertstore.Caalias caalias = new CaCertstore.Caalias();
                caalias.setName(rs.getString("NAME"));
                caalias.setCaId(rs.getInt("CA_ID"));
                caalias.validate();
                caaliases.add(caalias);
            }
            caconf.setCaaliases(caaliases);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,CA_ID FROM CAALIAS", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportRequestor(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table REQUESTOR ... ");
        boolean succ = false;
        LinkedList<CaCertstore.IdNameTypeConf> requestors = new LinkedList<CaCertstore.IdNameTypeConf>();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM REQUESTOR";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT ID,NAME,TYPE,CONF FROM REQUESTOR");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.IdNameTypeConf requestor = new CaCertstore.IdNameTypeConf();
                requestor.setId(rs.getInt("ID"));
                requestor.setName(name);
                requestor.setType(rs.getString("TYPE"));
                requestor.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/cert-requestor-" + name + ".conf"));
                requestor.validate();
                requestors.add(requestor);
            }
            caconf.setRequestors(requestors);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM REQUESTOR", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportDbSchema(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.print("    exporting table DBSCHEMA ... ");
        boolean succ = false;
        LinkedList<CaCertstore.DbSchemaEntry> entries = new LinkedList<CaCertstore.DbSchemaEntry>();
        String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT NAME,VALUE2 FROM DBSCHEMA");
            rs = stmt.executeQuery();
            while (rs.next()) {
                CaCertstore.DbSchemaEntry entry = new CaCertstore.DbSchemaEntry();
                entry.setName(rs.getString("NAME"));
                entry.setValue(rs.getString("VALUE2"));
                entry.validate();
                entries.add(entry);
            }
            caconf.setDbSchemas(entries);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportSigner(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table SIGNER ... ");
        boolean succ = false;
        LinkedList<CaCertstore.Signer> signers = new LinkedList<CaCertstore.Signer>();
        String sql = "SELECT NAME,TYPE,CONF,CERT FROM SIGNER";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT NAME,TYPE,CONF,CERT FROM SIGNER");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.Signer signer = new CaCertstore.Signer();
                signer.setName(name);
                signer.setType(rs.getString("TYPE"));
                signer.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-signer-" + name));
                signer.setCert(this.buildFileOrBase64Binary(rs.getString("CERT"), "ca-conf/cert-signer-" + name + ".der"));
                signer.validate();
                signers.add(signer);
            }
            caconf.setSigners(signers);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,TYPE,CONF,CERT FROM SIGNER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportKeypairGen(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table KEYPAIR_GEN ... ");
        boolean succ = false;
        LinkedList<CaCertstore.NameTypeConf> keypairGens = new LinkedList<CaCertstore.NameTypeConf>();
        String sql = "SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.NameTypeConf entry = new CaCertstore.NameTypeConf();
                entry.setName(name);
                entry.setType(rs.getString("TYPE"));
                entry.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-publisher-" + name));
                entry.validate();
                keypairGens.add(entry);
            }
            caconf.setKeypairGens(keypairGens);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportPublisher(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table PUBLISHER ... ");
        boolean succ = false;
        LinkedList<CaCertstore.IdNameTypeConf> publishers = new LinkedList<CaCertstore.IdNameTypeConf>();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM PUBLISHER";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT ID,NAME,TYPE,CONF FROM PUBLISHER");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.IdNameTypeConf publisher = new CaCertstore.IdNameTypeConf();
                publisher.setId(rs.getInt("ID"));
                publisher.setName(name);
                publisher.setType(rs.getString("TYPE"));
                publisher.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-publisher-" + name));
                publisher.validate();
                publishers.add(publisher);
            }
            caconf.setPublishers(publishers);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM PUBLISHER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportProfile(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table PROFILE ... ");
        boolean succ = false;
        LinkedList<CaCertstore.IdNameTypeConf> profiles = new LinkedList<CaCertstore.IdNameTypeConf>();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM PROFILE";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT ID,NAME,TYPE,CONF FROM PROFILE");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaCertstore.IdNameTypeConf profile = new CaCertstore.IdNameTypeConf();
                profile.setId(rs.getInt("ID"));
                profile.setName(name);
                profile.setType(rs.getString("TYPE"));
                profile.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/certprofile-" + name));
                profile.validate();
                profiles.add(profile);
            }
            caconf.setProfiles(profiles);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM PROFILE", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportCa(CaCertstore.Caconf caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table CA ... ");
        boolean succ = false;
        LinkedList<CaCertstore.Ca> cas = new LinkedList<CaCertstore.Ca>();
        Object columns = "SELECT ID,NAME,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,REV_INFO,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN";
        columns = this.dbSchemaVersion >= 7 ? (String)columns + ",CONF" : (String)columns + ",SN_SIZE,CA_URIS,MAX_VALIDITY,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,VALIDITY_MODE,CRL_CONTROL,CTLOG_CONTROL,REVOKE_SUSPENDED_CONTROL,KEEP_EXPIRED_CERT_DAYS,EXTRA_CONTROL";
        String sql = (String)columns + " FROM CA";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String confColumn;
                CaCertstore.Ca ca = new CaCertstore.Ca();
                ca.setId(rs.getInt("ID"));
                String name = rs.getString("NAME");
                ca.setName(name);
                ca.setNextCrlNo(rs.getLong("NEXT_CRLNO"));
                ca.setStatus(rs.getString("STATUS"));
                ca.setCert(this.buildFileOrBase64Binary(rs.getString("CERT"), "ca-conf/cert-ca-" + name + ".der"));
                ca.setCertchain(this.buildFileOrValue(rs.getString("CERTCHAIN"), "ca-conf/certchain-ca-" + name + ".pem"));
                ca.setSignerType(rs.getString("SIGNER_TYPE"));
                ca.setSignerConf(this.buildFileOrValue(rs.getString("SIGNER_CONF"), "ca-conf/signerconf-ca-" + name));
                ca.setRevInfo(rs.getString("REV_INFO"));
                ca.setCrlSignerName(rs.getString("CRL_SIGNER_NAME"));
                if (this.dbSchemaVersion >= 7) {
                    confColumn = rs.getString("CONF");
                    CaConfColumn.decode((String)confColumn);
                } else {
                    CaConfColumn ccc = new CaConfColumn();
                    ccc.setSnSize(rs.getInt("SN_SIZE"));
                    String str = rs.getString("CA_URIS");
                    if (StringUtil.isNotBlank((String)str)) {
                        CaUris caUris = CaUris.decode((String)str);
                        ccc.setCacertUris(caUris.getCacertUris());
                        ccc.setCrlUris(caUris.getCrlUris());
                        ccc.setDeltaCrlUris(caUris.getDeltaCrlUris());
                        ccc.setOcspUris(caUris.getOcspUris());
                    }
                    ccc.setMaxValidity(rs.getString("MAX_VALIDITY"));
                    str = rs.getString("CRL_CONTROL");
                    if (StringUtil.isNotBlank((String)str)) {
                        ccc.setCrlControl(new ConfPairs(str).asMap());
                    }
                    if (StringUtil.isNotBlank((String)(str = rs.getString("CTLOG_CONTROL")))) {
                        ccc.setCtlogControl(new ConfPairs(str).asMap());
                    }
                    ccc.setPermission(rs.getInt("PERMISSION"));
                    ccc.setExpirationPeriod(rs.getInt("EXPIRATION_PERIOD"));
                    ccc.setKeepExpiredCertDays(rs.getInt("KEEP_EXPIRED_CERT_DAYS"));
                    ccc.setValidityMode(rs.getString("VALIDITY_MODE"));
                    str = rs.getString("EXTRA_CONTROL");
                    if (StringUtil.isNotBlank((String)str)) {
                        ccc.setExtraControl(new ConfPairs(str).asMap());
                    }
                    ccc.setNumCrls(rs.getInt("NUM_CRLS"));
                    str = rs.getString("REVOKE_SUSPENDED_CONTROL");
                    if (StringUtil.isNotBlank((String)str)) {
                        ccc.setRevokeSuspendedControl(new ConfPairs(str).asMap());
                    }
                    ccc.setKeypairGenNames(Collections.singletonList("software"));
                    ccc.setSaveCert(true);
                    ccc.setSaveKeypair(false);
                    confColumn = ccc.encode();
                }
                ca.validate();
                ca.setConfColumn(this.buildFileOrValue(confColumn, "ca-conf/" + name + ".conf"));
                cas.add(ca);
            }
            caconf.setCas(cas);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportCaHasRequestor(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.print("    exporting table CA_HAS_REQUESTOR ... ");
        boolean succ = false;
        LinkedList<CaCertstore.CaHasRequestor> caHasRequestors = new LinkedList<CaCertstore.CaHasRequestor>();
        String sql = "SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR");
            rs = stmt.executeQuery();
            while (rs.next()) {
                CaCertstore.CaHasRequestor caHasRequestor = new CaCertstore.CaHasRequestor();
                caHasRequestor.setCaId(rs.getInt("CA_ID"));
                caHasRequestor.setRequestorId(rs.getInt("REQUESTOR_ID"));
                caHasRequestor.setPermission(rs.getInt("PERMISSION"));
                caHasRequestor.setProfiles(rs.getString("PROFILES"));
                caHasRequestor.validate();
                caHasRequestors.add(caHasRequestor);
            }
            caconf.setCaHasRequestors(caHasRequestors);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportCaHasPublisher(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.print("    exporting table CA_HAS_PUBLISHER ... ");
        boolean succ = false;
        LinkedList<CaCertstore.CaHasPublisher> caHasPublishers = new LinkedList<CaCertstore.CaHasPublisher>();
        String sql = "SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER");
            rs = stmt.executeQuery();
            while (rs.next()) {
                CaCertstore.CaHasPublisher caHasPublisher = new CaCertstore.CaHasPublisher();
                caHasPublisher.setCaId(rs.getInt("CA_ID"));
                caHasPublisher.setPublisherId(rs.getInt("PUBLISHER_ID"));
                caHasPublisher.validate();
                caHasPublishers.add(caHasPublisher);
            }
            caconf.setCaHasPublishers(caHasPublishers);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportCaHasProfile(CaCertstore.Caconf caconf) throws DataAccessException, InvalidConfException {
        System.out.print("    exporting table CA_HAS_PROFILE ... ");
        boolean succ = false;
        LinkedList<CaCertstore.CaHasProfile> caHasProfiles = new LinkedList<CaCertstore.CaHasProfile>();
        Object sql = "SELECT CA_ID,PROFILE_ID";
        if (this.dbSchemaVersion > 8) {
            sql = (String)sql + ",ALIASES";
        }
        sql = (String)sql + " FROM CA_HAS_PROFILE";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement((String)sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                CaCertstore.CaHasProfile caHasProfile = new CaCertstore.CaHasProfile();
                caHasProfile.setCaId(rs.getInt("CA_ID"));
                caHasProfile.setProfileId(rs.getInt("PROFILE_ID"));
                if (this.dbSchemaVersion > 8) {
                    caHasProfile.setAliases(rs.getString("ALIASES"));
                }
                caHasProfile.validate();
                caHasProfiles.add(caHasProfile);
            }
            caconf.setCaHasProfiles(caHasProfiles);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate((String)sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }
}

