/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.mgmt.db.DbSchemaInfo;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.X509Cert;
import org.xipki.security.util.JSON;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.SqlUtil;
import org.xipki.util.exception.InvalidConfException;

class CaconfDbImporter
extends DbPorter {
    private final CaCertstore.Caconf caconf;

    CaconfDbImporter(DataSourceWrapper datasource, String srcDir, AtomicBoolean stopMe) throws DataAccessException, IOException, InvalidConfException {
        super(datasource, srcDir, stopMe);
        this.caconf = (CaCertstore.Caconf)((Object)JSON.parseObject((Path)Paths.get(this.baseDir, "ca-configuration.json"), CaCertstore.Caconf.class));
        this.caconf.validate();
    }

    public CaCertstore.Caconf getCaConf() {
        return this.caconf;
    }

    public void importToDb() throws Exception {
        if (this.caconf.getVersion() > 2) {
            throw new Exception("could not import CA configuration greater than 2: " + this.caconf.getVersion());
        }
        System.out.println("importing CA configuration to database");
        try {
            this.importDbSchema(this.caconf.getDbSchemas());
            this.importSigner(this.caconf.getSigners());
            this.importRequestor(this.caconf.getRequestors());
            this.importPublisher(this.caconf.getPublishers());
            this.importProfile(this.caconf.getProfiles());
            this.importCa(this.caconf.getCas());
            this.importCaalias(this.caconf.getCaaliases());
            this.importCaHasRequestor(this.caconf.getCaHasRequestors());
            this.importCaHasPublisher(this.caconf.getCaHasPublishers());
            this.importCaHasCertprofile(this.caconf.getCaHasProfiles());
            this.importKeypairGen(this.caconf.getKeypairGens());
        }
        catch (Exception ex) {
            System.err.println("could not import CA configuration to database. message: " + ex.getMessage());
            throw ex;
        }
        System.out.println(" imported CA configuration to database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDbSchema(List<CaCertstore.DbSchemaEntry> entries) throws DataAccessException {
        System.out.print("    importing table DBSCHEMA ... ");
        if (entries == null) {
            System.out.println("nothing to import");
            return;
        }
        DbSchemaInfo dbSchemaInfo = new DbSchemaInfo(this.datasource);
        Set<String> dbSchemaNames = dbSchemaInfo.getVariableNames();
        String sql = SqlUtil.buildInsertSql((String)"DBSCHEMA", (String)"NAME,VALUE2");
        PreparedStatement ps = null;
        boolean succ = false;
        try {
            ps = this.prepareStatement(sql);
            for (CaCertstore.DbSchemaEntry entry : entries) {
                String name = entry.getName();
                if (dbSchemaNames.contains(name)) continue;
                try {
                    ps.setString(1, name);
                    ps.setString(2, entry.getValue());
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import DBSCHEMA with NAME=" + name);
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importSigner(List<CaCertstore.Signer> signers) throws DataAccessException, IOException {
        System.out.print("    importing table SIGNER ... ");
        if (signers == null) {
            System.out.println("nothing to import");
            return;
        }
        String sql = SqlUtil.buildInsertSql((String)"SIGNER", (String)"NAME,TYPE,CERT,CONF");
        boolean succ = false;
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaCertstore.Signer signer : signers) {
                String b64Cert = signer.getCert() == null ? null : Base64.encodeToString((byte[])this.readContent(signer.getCert()));
                try {
                    int idx = 1;
                    ps.setString(idx++, signer.getName());
                    ps.setString(idx++, signer.getType());
                    ps.setString(idx++, b64Cert);
                    ps.setString(idx, this.readContent(signer.getConf()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import SIGNER with NAME=" + signer.getName());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importRequestor(List<CaCertstore.IdNameTypeConf> requestors) throws DataAccessException, IOException {
        System.out.print("    importing table REQUESTOR ... ");
        String sql = SqlUtil.buildInsertSql((String)"REQUESTOR", (String)"ID,NAME,TYPE,CONF");
        boolean succ = false;
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaCertstore.IdNameTypeConf requestor : requestors) {
                try {
                    ps.setInt(1, requestor.getId());
                    ps.setString(2, requestor.getName());
                    ps.setString(3, requestor.getType());
                    ps.setString(4, this.readContent(requestor.getConf()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import REQUESTOR with NAME=" + requestor.getName());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPublisher(List<CaCertstore.IdNameTypeConf> publishers) throws DataAccessException, IOException {
        System.out.print("    importing table PUBLISHER ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"PUBLISHER", (String)"ID,NAME,TYPE,CONF");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaCertstore.IdNameTypeConf publisher : publishers) {
                try {
                    int idx = 1;
                    ps.setInt(idx++, publisher.getId());
                    ps.setString(idx++, publisher.getName());
                    ps.setString(idx++, publisher.getType());
                    ps.setString(idx, this.readContent(publisher.getConf()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import PUBLISHER with NAME=" + publisher.getName());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importProfile(List<CaCertstore.IdNameTypeConf> profiles) throws DataAccessException, IOException {
        System.out.print("    importing table PROFILE ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"PROFILE", (String)"ID,NAME,TYPE,CONF");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaCertstore.IdNameTypeConf certprofile : profiles) {
                try {
                    int idx = 1;
                    ps.setInt(idx++, certprofile.getId());
                    ps.setString(idx++, certprofile.getName());
                    ps.setString(idx++, certprofile.getType());
                    ps.setString(idx, this.readContent(certprofile.getConf()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import PROFILE with NAME=" + certprofile.getName());
                    throw this.translate(sql, ex);
                }
                catch (IOException ex) {
                    System.err.println("could not import PROFILE with NAME=" + certprofile.getName());
                    throw ex;
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * Exception decompiling
     */
    private void importKeypairGen(List<CaCertstore.NameTypeConf> keypairGens) throws DataAccessException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCa(List<CaCertstore.Ca> cas) throws DataAccessException, CertificateException, IOException {
        System.out.print("    importing table CA ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CA", (String)"ID,NAME,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,SUBJECT,REV_INFO,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN,CONF");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaCertstore.Ca ca : cas) {
                try {
                    byte[] certBytes = this.readContent(ca.getCert());
                    X509Cert cert = X509Util.parseCert((byte[])certBytes);
                    int idx = 1;
                    ps.setInt(idx++, ca.getId());
                    ps.setString(idx++, ca.getName().toLowerCase());
                    ps.setString(idx++, ca.getStatus());
                    ps.setLong(idx++, ca.getNextCrlNo());
                    ps.setString(idx++, ca.getCrlSignerName());
                    ps.setString(idx++, X509Util.cutX500Name((X500Name)cert.getSubject(), (int)this.maxX500nameLen));
                    ps.setString(idx++, ca.getRevInfo());
                    ps.setString(idx++, ca.getSignerType());
                    ps.setString(idx++, this.readContent(ca.getSignerConf()));
                    ps.setString(idx++, Base64.encodeToString((byte[])certBytes));
                    ps.setString(idx++, this.readContent(ca.getCertchain()));
                    ps.setString(idx, this.readContent(ca.getConfColumn()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CA with NAME=" + ca.getName());
                    throw this.translate(sql, ex);
                }
                catch (IOException | CertificateException ex) {
                    System.err.println("could not import CA with NAME=" + ca.getName());
                    throw ex;
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCaalias(List<CaCertstore.Caalias> caaliases) throws DataAccessException {
        System.out.print("    importing table CAALIAS ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CAALIAS", (String)"NAME,CA_ID");
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            for (CaCertstore.Caalias caalias : caaliases) {
                try {
                    ps.setString(1, caalias.getName());
                    ps.setInt(2, caalias.getCaId());
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CAALIAS with NAME=" + caalias.getName());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCaHasRequestor(List<CaCertstore.CaHasRequestor> caHasRequestors) throws DataAccessException {
        System.out.print("    importing table CA_HAS_REQUESTOR ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_REQUESTOR", (String)"CA_ID,REQUESTOR_ID,PERMISSION,PROFILES");
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            for (CaCertstore.CaHasRequestor entry : caHasRequestors) {
                try {
                    int idx = 1;
                    ps.setInt(idx++, entry.getCaId());
                    ps.setInt(idx++, entry.getRequestorId());
                    ps.setInt(idx++, entry.getPermission());
                    ps.setString(idx, entry.getProfiles());
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CA_HAS_REQUESTOR with CA_ID=" + entry.getCaId() + " and REQUESTOR_ID=" + entry.getRequestorId());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCaHasPublisher(List<CaCertstore.CaHasPublisher> caHasPublishers) throws Exception {
        System.out.print("    importing table CA_HAS_PUBLISHER ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_PUBLISHER", (String)"CA_ID,PUBLISHER_ID");
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            for (CaCertstore.CaHasPublisher entry : caHasPublishers) {
                try {
                    ps.setInt(1, entry.getCaId());
                    ps.setInt(2, entry.getPublisherId());
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CA_HAS_PUBLISHER with CA_ID=" + entry.getCaId() + " and PUBLISHER_ID=" + entry.getPublisherId());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCaHasCertprofile(List<CaCertstore.CaHasProfile> caHasCertprofiles) throws DataAccessException {
        System.out.print("    importing table CA_HAS_PROFILE ... ");
        boolean succ = false;
        Object columns = "CA_ID,PROFILE_ID";
        if (this.dbSchemaVersion > 8) {
            columns = (String)columns + ",ALIASES";
        }
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_PROFILE", (String)columns);
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            for (CaCertstore.CaHasProfile entry : caHasCertprofiles) {
                try {
                    ps.setInt(1, entry.getCaId());
                    ps.setInt(2, entry.getProfileId());
                    if (this.dbSchemaVersion > 8) {
                        ps.setString(3, entry.getAliases());
                    }
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CA_HAS_PROFILE with CA_ID=" + entry.getCaId() + " and PROFILE_ID=" + entry.getProfileId());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }
}

