/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.util.LinkedList;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ExcludeFileFilter;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.DbWorker;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.ca.mgmt.db.port.CaCertstoreDbExporter;
import org.xipki.ca.mgmt.db.port.CaCertstoreDbImporter;
import org.xipki.ca.mgmt.db.port.CaconfDbExporter;
import org.xipki.ca.mgmt.db.port.CaconfDbImporter;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.ca.mgmt.db.port.OcspCertStoreFromCaDbImporter;
import org.xipki.ca.mgmt.db.port.OcspCertstoreDbExporter;
import org.xipki.ca.mgmt.db.port.OcspCertstoreDbImporter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.ConfigurableProperties;
import org.xipki.util.FileUtils;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public abstract class DbPortWorker
extends DbWorker {
    private static final Logger LOG = LoggerFactory.getLogger(DbPortWorker.class);
    protected char[] password;

    public DbPortWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, char[] password) throws PasswordResolverException, IOException {
        super(datasourceFactory, passwordResolver, dbConfFile);
        this.password = password;
    }

    private static ZipParameters getZipParameters() {
        ExcludeFileFilter excludeFileFilter = file -> file.isDirectory() && file.getName().equals("encrypted");
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setEncryptFiles(true);
        zipParameters.setIncludeRootFolder(false);
        zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        zipParameters.setExcludeFileFilter(excludeFileFilter);
        return zipParameters;
    }

    protected void encrypt(File dir) throws IOException {
        File zipDir = new File(dir, "encrypted");
        if (zipDir.exists()) {
            FileUtils.deleteDirectory((File)zipDir);
        }
        IoUtil.mkdirs((File)zipDir);
        try (ZipFile zipFile = new ZipFile(new File(zipDir, "main.zip"), this.password);){
            zipFile.createSplitZipFileFromFolder(dir, DbPortWorker.getZipParameters(), true, 0x4000000L);
        }
        this.deleteDecryptedFiles(dir.getPath());
    }

    protected void decrypt(String dir) throws IOException {
        File mainFile = new File(dir, "encrypted/main.zip");
        try (ZipFile zipFile = new ZipFile(mainFile, this.password);){
            boolean alreadyUnzipped = false;
            for (FileHeader fh : zipFile.getFileHeaders()) {
                if (fh.isDirectory()) continue;
                alreadyUnzipped = new File(dir, fh.getFileName()).exists();
                break;
            }
            if (!alreadyUnzipped) {
                zipFile.extractAll(dir);
            }
        }
    }

    protected void deleteDecryptedFiles(String dir) throws IOException {
        File[] files = new File(dir).listFiles();
        if (files == null) {
            return;
        }
        File mainFile = new File(dir, "encrypted");
        if (!mainFile.exists()) {
            return;
        }
        for (File f : files) {
            if (f.getName().equals("encrypted")) continue;
            LinkedList<File> failedList = new LinkedList<File>();
            BasicFileAttributes basicFileAttributes = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (basicFileAttributes.isRegularFile()) {
                if (!IoUtil.deleteFile((File)f)) {
                    failedList.add(f);
                }
            } else if (basicFileAttributes.isDirectory() && !IoUtil.deleteDir((File)f)) {
                failedList.add(f);
            }
            if (failedList.isEmpty()) continue;
            LOG.error("error deleting files & folders: {}", failedList);
        }
    }

    private static void printFinishedIn(long startMs) {
        long duration = (Clock.systemUTC().millis() - startMs) / 1000L;
        System.out.println("Finished in " + StringUtil.formatTime((long)duration, (boolean)false));
    }

    public static class ImportOcspFromCaDb
    extends DbPortWorker {
        private final String publisherName;
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;

        public ImportOcspFromCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String publisherName, boolean resume, String srcFolder, int batchEntriesPerCommit, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile, password);
            this.publisherName = publisherName;
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
        }

        @Override
        protected void close0() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = Clock.systemUTC().millis();
            if (this.password != null) {
                this.decrypt(this.srcFolder);
            }
            try {
                OcspCertStoreFromCaDbImporter certStoreImporter = new OcspCertStoreFromCaDbImporter(this.datasource, this.srcFolder, this.publisherName, this.batchEntriesPerCommit, this.resume, this.stopMe);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                this.deleteDecryptedFiles(this.srcFolder);
                DbPortWorker.printFinishedIn(start);
            }
        }
    }

    public static class ImportOcspDb
    extends DbPortWorker {
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;

        public ImportOcspDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, boolean resume, String srcFolder, int batchEntriesPerCommit, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile, password);
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
        }

        @Override
        protected void close0() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = Clock.systemUTC().millis();
            if (this.password != null) {
                this.decrypt(this.srcFolder);
            }
            try {
                OcspCertstoreDbImporter certStoreImporter = new OcspCertstoreDbImporter(this.datasource, this.srcFolder, this.batchEntriesPerCommit, this.resume, this.stopMe);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                this.deleteDecryptedFiles(this.srcFolder);
                DbPortWorker.printFinishedIn(start);
            }
        }
    }

    public static class ExportOcspDb
    extends DbPortWorker {
        private final String destFolder;
        private final boolean resume;
        private final int numCertsInBundle;
        private final int numCertsPerSelect;

        public ExportOcspDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String destFolder, boolean resume, int numCertsInBundle, int numCertsPerSelect, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile, password);
            String[] children;
            this.destFolder = Args.notBlank((String)destFolder, (String)destFolder);
            File file = new File(destFolder);
            if (!file.exists()) {
                IoUtil.mkdirs((File)file);
            } else {
                if (!file.isDirectory()) {
                    throw new IOException(destFolder + " is not a folder");
                }
                if (!file.canWrite()) {
                    throw new IOException(destFolder + " is not writable");
                }
            }
            if (!resume && (children = file.list()) != null && children.length > 0) {
                throw new IOException(destFolder + " is not empty");
            }
            this.resume = resume;
            this.numCertsInBundle = numCertsInBundle;
            this.numCertsPerSelect = numCertsPerSelect;
        }

        @Override
        protected void close0() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = Clock.systemUTC().millis();
            try {
                OcspCertstoreDbExporter certStoreExporter = new OcspCertstoreDbExporter(this.datasource, this.destFolder, this.numCertsInBundle, this.numCertsPerSelect, this.resume, this.stopMe);
                certStoreExporter.export();
                certStoreExporter.close();
                if (this.password != null) {
                    this.encrypt(new File(this.destFolder));
                }
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                DbPortWorker.printFinishedIn(start);
            }
        }
    }

    public static class ExportCaDb
    extends DbPortWorker {
        private final String destFolder;
        private final boolean resume;
        private final int numCertsInBundle;
        private final int numCertsPerSelect;
        private final DataSourceWrapper caDataSource;

        public ExportCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String caConfDbFile, String caDbFile, String destFolder, boolean resume, int numCertsInBundle, int numCertsPerSelect, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, caConfDbFile != null ? caConfDbFile : caDbFile, password);
            this.destFolder = IoUtil.expandFilepath((String)destFolder);
            this.resume = resume;
            this.numCertsInBundle = numCertsInBundle;
            this.numCertsPerSelect = numCertsPerSelect;
            this.checkDestFolder();
            ConfigurableProperties props = DbPorter.getDbConfProperties(Paths.get(IoUtil.expandFilepath((String)caDbFile), new String[0]));
            this.caDataSource = datasourceFactory.createDataSource("ds-" + caDbFile, props, passwordResolver);
        }

        @Override
        protected void close0() {
            this.caDataSource.close();
        }

        private void checkDestFolder() throws IOException {
            File file = new File(this.destFolder);
            if (!file.exists()) {
                IoUtil.mkdirs((File)file);
            } else {
                if (!file.isDirectory()) {
                    throw new IOException(this.destFolder + " is not a folder");
                }
                if (!file.canWrite()) {
                    throw new IOException(this.destFolder + " is not writable");
                }
            }
            File processLogFile = new File(this.destFolder, "export.process");
            if (this.resume) {
                if (!processLogFile.exists()) {
                    throw new IOException("could not process with '--resume' option");
                }
            } else {
                String[] children = file.list();
                if (children != null && children.length > 0) {
                    throw new IOException(this.destFolder + " is not empty");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = Clock.systemUTC().millis();
            try {
                if (!this.resume) {
                    CaconfDbExporter caConfExporter = new CaconfDbExporter(this.datasource, this.destFolder, this.stopMe);
                    caConfExporter.export();
                    caConfExporter.close();
                }
                CaCertstoreDbExporter certStoreExporter = new CaCertstoreDbExporter(this.caDataSource, this.destFolder, this.numCertsInBundle, this.numCertsPerSelect, this.resume, this.stopMe);
                certStoreExporter.export();
                certStoreExporter.close();
                if (this.password != null) {
                    this.encrypt(new File(this.destFolder));
                }
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                DbPortWorker.printFinishedIn(start);
            }
        }
    }

    public static class ImportCaDb
    extends DbPortWorker {
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;
        private final DataSourceWrapper caDataSource;

        public ImportCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String caConfDbFile, String caDbFile, boolean resume, String srcFolder, int batchEntriesPerCommit, char[] password) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, caConfDbFile == null ? caDbFile : caConfDbFile, password);
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
            ConfigurableProperties props = DbPorter.getDbConfProperties(Paths.get(IoUtil.expandFilepath((String)caDbFile), new String[0]));
            this.caDataSource = datasourceFactory.createDataSource("ds-" + caDbFile, props, passwordResolver);
        }

        @Override
        protected void close0() {
            this.caDataSource.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            File processLogFile = new File(this.srcFolder, "import.process");
            if (this.resume) {
                if (!processLogFile.exists()) {
                    throw new Exception("could not process with '--resume' option");
                }
            } else if (processLogFile.exists()) {
                throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
            }
            long start = Clock.systemUTC().millis();
            try {
                if (this.password != null) {
                    this.decrypt(this.srcFolder);
                }
                CaconfDbImporter caConfImporter = new CaconfDbImporter(this.datasource, this.srcFolder, this.stopMe);
                if (!this.resume) {
                    caConfImporter.importToDb();
                    caConfImporter.close();
                }
                CaCertstore.Caconf caconf = caConfImporter.getCaConf();
                CaCertstoreDbImporter certStoreImporter = new CaCertstoreDbImporter(this.caDataSource, this.srcFolder, this.batchEntriesPerCommit, this.resume, this.stopMe, caconf);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                try {
                    this.caDataSource.close();
                }
                catch (Throwable th) {
                    LOG.error("certStoreDataSource.close()", th);
                }
                this.deleteDecryptedFiles(this.srcFolder);
                DbPortWorker.printFinishedIn(start);
            }
        }
    }
}

