/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.AbstractOcspCertstoreDbImporter;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.JSON;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ProcessLog;

class OcspCertStoreFromCaDbImporter
extends AbstractOcspCertstoreDbImporter {
    private static final Logger LOG = LoggerFactory.getLogger(OcspCertStoreFromCaDbImporter.class);
    private final String publisherName;
    private final boolean resume;
    private final int numCertsPerCommit;

    OcspCertStoreFromCaDbImporter(DataSourceWrapper datasource, String srcDir, String publisherName, int numCertsPerCommit, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
        this.publisherName = Args.toNonBlankLower((String)publisherName, (String)"publisherName");
        this.numCertsPerCommit = Args.positive((int)numCertsPerCommit, (String)"numCertsPerCommit");
        File processLogFile = new File(this.baseDir, "import-to-ocsp.process");
        if (resume) {
            if (!processLogFile.exists()) {
                throw new Exception("could not process with '--resume' option");
            }
        } else if (processLogFile.exists()) {
            throw new Exception("please either specify '--resume' or delete the file " + processLogFile.getPath() + " first");
        }
        this.resume = resume;
    }

    public void importToDb() throws Exception {
        CaCertstore certstore = (CaCertstore)((Object)JSON.parseObject((Path)Paths.get(this.baseDir, "ca-certstore.json"), CaCertstore.class));
        certstore.validate();
        if (certstore.getVersion() > 2) {
            throw new Exception("could not import CertStore greater than 2: " + certstore.getVersion());
        }
        CaCertstore.Caconf caconf = (CaCertstore.Caconf)((Object)JSON.parseObject((Path)Paths.get(this.baseDir, "ca-configuration.json"), CaCertstore.Caconf.class));
        caconf.validate();
        if (caconf.getVersion() > 2) {
            throw new Exception("could not import CA configuration greater than 2: " + certstore.getVersion());
        }
        System.out.println("importing CA certstore to OCSP database");
        try {
            CaCertstore.NameTypeConf publisherType = null;
            for (CaCertstore.IdNameTypeConf type : caconf.getPublishers()) {
                if (!this.publisherName.equals(type.getName())) continue;
                publisherType = type;
                break;
            }
            if (publisherType == null) {
                throw new Exception("unknown publisher " + this.publisherName);
            }
            String type = publisherType.getType();
            if (!"ocsp".equalsIgnoreCase(type)) {
                throw new Exception("Unkwown publisher type " + type);
            }
            ConfPairs confPairs = new ConfPairs(this.readContent(publisherType.getConf()));
            String str = confPairs.value("publish.goodcerts");
            boolean revokedOnly = false;
            if (str != null) {
                revokedOnly = !Boolean.parseBoolean(str);
            }
            HashSet<Integer> relatedCaIds = new HashSet<Integer>();
            for (Object ctype : caconf.getCaHasPublishers()) {
                if (ctype.getPublisherId() != ((CaCertstore.IdNameTypeConf)publisherType).getId()) continue;
                relatedCaIds.add(ctype.getCaId());
            }
            LinkedList<CaCertstore.Ca> relatedCas = new LinkedList<CaCertstore.Ca>();
            for (CaCertstore.Ca m : caconf.getCas()) {
                if (!relatedCaIds.contains(m.getId())) continue;
                relatedCas.add(m);
            }
            if (relatedCas.isEmpty()) {
                System.out.println("No CA has publisher " + this.publisherName);
                return;
            }
            List<Integer> relatedCertStoreCaIds = this.resume ? this.getIssuerIds(relatedCas) : this.importIssuer(relatedCas);
            File processLogFile = new File(this.baseDir, "import-to-ocsp.process");
            this.importCert(certstore, revokedOnly, relatedCertStoreCaIds, processLogFile);
            IoUtil.deleteFile0((File)processLogFile);
        }
        catch (Exception ex) {
            System.err.println("could not import OCSP certstore to database");
            throw ex;
        }
        System.out.println(" imported OCSP certstore to database");
    }

    private List<Integer> getIssuerIds(List<CaCertstore.Ca> cas) throws IOException {
        LinkedList<Integer> relatedCaIds = new LinkedList<Integer>();
        for (CaCertstore.Ca issuer : cas) {
            byte[] encodedCert = issuer.getCert() == null ? null : this.readContent(issuer.getCert());
            CaCertstore.Ca ca = null;
            for (CaCertstore.Ca caType : cas) {
                byte[] certBytes = caType.getCert() == null ? null : this.readContent(caType.getCert());
                if (!Arrays.equals(encodedCert, certBytes)) continue;
                ca = caType;
                break;
            }
            if (ca == null) continue;
            relatedCaIds.add(issuer.getId());
        }
        return relatedCaIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> importIssuer(List<CaCertstore.Ca> cas) throws DataAccessException, CertificateException, IOException {
        System.out.print("    importing table ISSUER ... ");
        boolean succ = false;
        String sql = SQL_ADD_ISSUER;
        PreparedStatement ps = this.prepareStatement(sql);
        LinkedList<Integer> relatedCaIds = new LinkedList<Integer>();
        try {
            for (CaCertstore.Ca issuer : cas) {
                this.importIssuer0(issuer, sql, ps, relatedCaIds);
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
        return relatedCaIds;
    }

    private void importIssuer0(CaCertstore.Ca issuer, String sql, PreparedStatement ps, List<Integer> relatedCaIds) throws IOException, DataAccessException, CertificateException {
        try {
            Certificate cert;
            byte[] encodedCert = this.readContent(issuer.getCert());
            relatedCaIds.add(issuer.getId());
            try {
                cert = Certificate.getInstance((Object)encodedCert);
            }
            catch (RuntimeException ex) {
                String msg = "could not parse certificate of issuer " + issuer.getId();
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CertificateException(ex.getMessage(), ex);
            }
            int idx = 1;
            ps.setInt(idx++, issuer.getId());
            ps.setString(idx++, X509Util.cutX500Name((X500Name)cert.getSubject(), (int)this.maxX500nameLen));
            ps.setLong(idx++, DateUtil.toEpochSecond((Date)cert.getTBSCertificate().getStartDate().getDate()));
            ps.setLong(idx++, DateUtil.toEpochSecond((Date)cert.getTBSCertificate().getEndDate().getDate()));
            ps.setString(idx++, HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encodedCert}));
            ps.setString(idx++, issuer.getRevInfo());
            ps.setString(idx++, Base64.encodeToString((byte[])encodedCert));
            ps.setNull(idx, 4);
            ps.execute();
        }
        catch (SQLException ex) {
            System.err.println("could not import issuer with id=" + issuer.getId());
            throw this.translate(sql, ex);
        }
        catch (CertificateException ex) {
            System.err.println("could not import issuer with id=" + issuer.getId());
            throw ex;
        }
    }

    /*
     * Exception decompiling
     */
    private void importCert(CaCertstore certstore, boolean revokedOnly, List<Integer> caIds, File processLogFile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importCert0(HashAlgo certhashAlgo, PreparedStatement psCert, String certsZipFile, boolean revokedOnly, List<Integer> caIds, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess, ProcessLog importLog) throws Exception {
        CaCertstore.Certs certs;
        ZipFile zipFile = new ZipFile(new File(certsZipFile));
        ZipEntry certsEntry = zipFile.getEntry("overview.json");
        try {
            certs = (CaCertstore.Certs)((Object)JSON.parseObjectAndClose((InputStream)zipFile.getInputStream(certsEntry), CaCertstore.Certs.class));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)certsZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + certsZipFile, (Throwable)e2);
            }
            throw ex;
        }
        certs.validate();
        this.disableAutoCommit();
        try {
            int numProcessedEntriesInBatch = 0;
            int numImportedEntriesInBatch = 0;
            long lastSuccessfulCertId = 0L;
            List<CaCertstore.Cert> list = certs.getCerts();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                Object filename;
                int caId;
                long id;
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                CaCertstore.Cert cert = list.get(i);
                lastSuccessfulCertId = id = cert.getId().longValue();
                if (id < minId) continue;
                ++numProcessedEntriesInBatch;
                if ((!revokedOnly || cert.getRev() != null && cert.getRev() == 1) && caIds.contains(caId = cert.getCaId().intValue())) {
                    TBSCertificate tbsCert;
                    ++numImportedEntriesInBatch;
                    filename = cert.getFile();
                    byte[] encodedCert = IoUtil.readAllBytesAndClose((InputStream)zipFile.getInputStream(zipFile.getEntry((String)filename)));
                    String certhash = certhashAlgo.base64Hash((byte[][])new byte[][]{encodedCert});
                    try {
                        tbsCert = Certificate.getInstance((Object)encodedCert).getTBSCertificate();
                    }
                    catch (RuntimeException ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse certificate in file " + (String)filename));
                        throw new CertificateException(ex.getMessage(), ex);
                    }
                    String subject = X509Util.cutX500Name((X500Name)tbsCert.getSubject(), (int)this.maxX500nameLen);
                    try {
                        int idx = 1;
                        psCert.setLong(idx++, id);
                        psCert.setInt(idx++, caId);
                        psCert.setString(idx++, tbsCert.getSerialNumber().getPositiveValue().toString(16));
                        psCert.setLong(idx++, cert.getUpdate());
                        psCert.setLong(idx++, DateUtil.toEpochSecond((Date)tbsCert.getStartDate().getDate()));
                        psCert.setLong(idx++, DateUtil.toEpochSecond((Date)tbsCert.getEndDate().getDate()));
                        OcspCertStoreFromCaDbImporter.setInt(psCert, idx++, cert.getRev());
                        OcspCertStoreFromCaDbImporter.setInt(psCert, idx++, cert.getRr());
                        OcspCertStoreFromCaDbImporter.setLong(psCert, idx++, cert.getRt());
                        OcspCertStoreFromCaDbImporter.setLong(psCert, idx++, cert.getRit());
                        psCert.setString(idx++, certhash);
                        psCert.setString(idx++, subject);
                        psCert.setNull(idx, 4);
                        psCert.addBatch();
                    }
                    catch (SQLException ex) {
                        throw this.translate(SQL_ADD_CERT, ex);
                    }
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numImportedEntriesInBatch > 0 && (numImportedEntriesInBatch % this.numCertsPerCommit == 0 || isLastBlock)) {
                    try {
                        psCert.executeBatch();
                        this.commit("(commit import cert to OCSP)");
                    }
                    catch (Throwable th) {
                        this.rollback();
                        this.deleteCertGreaterThan(lastSuccessfulCertId, LOG);
                        if (th instanceof SQLException) {
                            throw this.translate(SQL_ADD_CERT, (SQLException)th);
                        }
                        if (th instanceof Exception) {
                            throw (Exception)th;
                        }
                        throw new Exception(th);
                    }
                    processLog.addNumProcessed((long)numProcessedEntriesInBatch);
                    importLog.addNumProcessed((long)numImportedEntriesInBatch);
                    numProcessedEntriesInBatch = 0;
                    numImportedEntriesInBatch = 0;
                    filename = (long)numProcessedInLastProcess + processLog.numProcessed() + ":" + lastSuccessfulCertId;
                    OcspCertStoreFromCaDbImporter.echoToFile((String)filename, processLogFile);
                    processLog.printStatus();
                    continue;
                }
                if (!isLastBlock) continue;
                processLog.addNumProcessed((long)numProcessedEntriesInBatch);
                importLog.addNumProcessed((long)numImportedEntriesInBatch);
                numProcessedEntriesInBatch = 0;
                numImportedEntriesInBatch = 0;
                filename = (long)numProcessedInLastProcess + processLog.numProcessed() + ":" + lastSuccessfulCertId;
                OcspCertStoreFromCaDbImporter.echoToFile((String)filename, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulCertId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }

    private HashAlgo getCertHashAlgo() throws DataAccessException {
        String certHashAlgoStr = this.dbSchemaInfo.getVariableValue("CERTHASH_ALGO");
        if (certHashAlgoStr == null) {
            throw new DataAccessException("Column with NAME='CERTHASH_ALGO' is not defined in table DBSCHEMA");
        }
        try {
            return HashAlgo.getInstance((String)certHashAlgoStr);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

