/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.mgmt.db.port.IdentifiedDbObject;
import org.xipki.util.ValidatableConf;
import org.xipki.util.exception.InvalidConfException;

public class OcspCertstore
extends ValidatableConf {
    private int version;
    private int countCerts;
    private String certhashAlgo;
    private List<Issuer> issuers;
    private List<CrlInfo> crlInfos;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCountCerts() {
        return this.countCerts;
    }

    public void setCountCerts(int countCerts) {
        this.countCerts = countCerts;
    }

    public String getCerthashAlgo() {
        return this.certhashAlgo;
    }

    public void setCerthashAlgo(String certhashAlgo) {
        this.certhashAlgo = certhashAlgo;
    }

    public List<Issuer> getIssuers() {
        if (this.issuers == null) {
            this.issuers = new LinkedList<Issuer>();
        }
        return this.issuers;
    }

    public void setIssuers(List<Issuer> issuers) {
        this.issuers = issuers;
    }

    public List<CrlInfo> getCrlInfos() {
        return this.crlInfos;
    }

    public void setCrlInfos(List<CrlInfo> crlInfos) {
        this.crlInfos = crlInfos;
    }

    public void validate() throws InvalidConfException {
        OcspCertstore.notBlank((String)this.certhashAlgo, (String)"certhashAlgo");
        OcspCertstore.validate(this.issuers, (Collection[])new Collection[]{this.crlInfos});
    }

    public static class CrlInfo
    extends ValidatableConf {
        private int id;
        private String name;
        private String info;

        public void validate() throws InvalidConfException {
            CrlInfo.notBlank((String)this.name, (String)"name");
            CrlInfo.notBlank((String)this.info, (String)"info");
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getInfo() {
            return this.info;
        }

        public void setInfo(String info) {
            this.info = info;
        }
    }

    public static class Issuer
    extends ValidatableConf {
        private int id;
        private Integer crlId;
        private String certFile;
        private String revInfo;

        public void validate() throws InvalidConfException {
            Issuer.notBlank((String)this.certFile, (String)"certFile");
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getCertFile() {
            return this.certFile;
        }

        public void setCertFile(String certFile) {
            this.certFile = certFile;
        }

        public String getRevInfo() {
            return this.revInfo;
        }

        public void setRevInfo(String revInfo) {
            this.revInfo = revInfo;
        }

        public Integer getCrlId() {
            return this.crlId;
        }

        public void setCrlId(Integer crlId) {
            this.crlId = crlId;
        }
    }

    public static class Certs
    extends ValidatableConf {
        private List<Cert> certs;

        public List<Cert> getCerts() {
            if (this.certs == null) {
                this.certs = new LinkedList<Cert>();
            }
            return this.certs;
        }

        public void setCerts(List<Cert> certs) {
            this.certs = certs;
        }

        public void add(Cert cert) {
            this.getCerts().add(cert);
        }

        public void validate() throws InvalidConfException {
            Certs.validate(this.certs, (Collection[])new Collection[0]);
        }
    }

    public static class Cert
    extends IdentifiedDbObject {
        private String hash;
        private Integer iid;
        private Long nafter;
        private Long nbefore;
        private Boolean rev;
        private Long rit;
        private Integer rr;
        private Long rt;
        private String sn;
        private String subject;
        private Long update;
        private Integer crlId;

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public Integer getIid() {
            return this.iid;
        }

        public void setIid(Integer iid) {
            this.iid = iid;
        }

        public Long getNafter() {
            return this.nafter;
        }

        public void setNafter(Long nafter) {
            this.nafter = nafter;
        }

        public Long getNbefore() {
            return this.nbefore;
        }

        public void setNbefore(Long nbefore) {
            this.nbefore = nbefore;
        }

        public Boolean getRev() {
            return this.rev;
        }

        public void setRev(Boolean rev) {
            this.rev = rev;
        }

        public Long getRit() {
            return this.rit;
        }

        public void setRit(Long rit) {
            this.rit = rit;
        }

        public Integer getRr() {
            return this.rr;
        }

        public void setRr(Integer rr) {
            this.rr = rr;
        }

        public Long getRt() {
            return this.rt;
        }

        public void setRt(Long rt) {
            this.rt = rt;
        }

        public String getSn() {
            return this.sn;
        }

        public void setSn(String sn) {
            this.sn = sn;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public Long getUpdate() {
            return this.update;
        }

        public void setUpdate(Long update) {
            this.update = update;
        }

        public Integer getCrlId() {
            return this.crlId;
        }

        public void setCrlId(Integer crlId) {
            this.crlId = crlId;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Cert.notNull((Object)this.iid, (String)"iid");
            Cert.notBlank((String)this.sn, (String)"sn");
            Cert.notNull((Object)this.rev, (String)"rev");
            if (this.rev.booleanValue()) {
                Cert.notNull((Object)this.rr, (String)"rr");
                Cert.notNull((Object)this.rt, (String)"rt");
            }
            Cert.notNull((Object)this.update, (String)"update");
        }
    }
}

