/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.AbstractOcspCertstoreDbImporter;
import org.xipki.ca.mgmt.db.port.OcspCertstore;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.util.JSON;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;

class OcspCertstoreDbImporter
extends AbstractOcspCertstoreDbImporter {
    private static final Logger LOG = LoggerFactory.getLogger(OcspCertstoreDbImporter.class);
    private final boolean resume;
    private final int numCertsPerCommit;

    OcspCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, int numCertsPerCommit, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
        this.numCertsPerCommit = Args.positive((int)numCertsPerCommit, (String)"numCertsPerCommit");
        File processLogFile = new File(this.baseDir, "import.process");
        if (resume) {
            if (!processLogFile.exists()) {
                throw new Exception("could not process with '--resume' option");
            }
        } else if (processLogFile.exists()) {
            throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
        }
        this.resume = resume;
    }

    public void importToDb() throws Exception {
        OcspCertstore certstore = (OcspCertstore)((Object)JSON.parseObject((Path)Paths.get(this.baseDir, "ocsp-certstore.json"), OcspCertstore.class));
        certstore.validate();
        if (certstore.getVersion() > 2) {
            throw new Exception("could not import Certstore greater than 2: " + certstore.getVersion());
        }
        File processLogFile = new File(this.baseDir, "import.process");
        System.out.println("importing OCSP certstore to database");
        try {
            if (!this.resume) {
                this.importCertHashAlgo(certstore.getCerthashAlgo());
                this.importCrlInfo(certstore.getCrlInfos());
                this.importIssuer(certstore.getIssuers());
            }
            this.importCert(certstore, processLogFile);
            IoUtil.deleteFile0((File)processLogFile);
        }
        catch (Exception ex) {
            System.err.println("could not import OCSP certstore to database");
            throw ex;
        }
        System.out.println(" imported OCSP certstore to database");
    }

    private void importCertHashAlgo(String certHashAlgo) throws DataAccessException {
        String sql = "UPDATE DBSCHEMA SET VALUE2=? WHERE NAME='CERTHASH_ALGO'";
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            ps.setString(1, certHashAlgo);
            ps.executeUpdate();
            this.dbSchemaInfo.setVariable("CERTHASH_ALGO", certHashAlgo);
        }
        catch (SQLException ex) {
            System.err.println("could not import DBSCHEMA");
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importIssuer(List<OcspCertstore.Issuer> issuers) throws DataAccessException, CertificateException, IOException {
        if (CollectionUtil.isEmpty(issuers)) {
            return;
        }
        System.out.print("    importing table ISSUER ... ");
        boolean succ = false;
        PreparedStatement ps = this.prepareStatement(SQL_ADD_ISSUER);
        try {
            for (OcspCertstore.Issuer issuer : issuers) {
                try {
                    Certificate cert;
                    String b64Cert = StringUtil.toUtf8String((byte[])IoUtil.read((File)new File(this.baseDir, issuer.getCertFile())));
                    byte[] encodedCert = Base64.decode((String)b64Cert);
                    try {
                        cert = Certificate.getInstance((Object)encodedCert);
                    }
                    catch (RuntimeException ex) {
                        LOG.error("could not parse certificate of issuer {}", (Object)issuer.getId());
                        LOG.debug("could not parse certificate of issuer " + issuer.getId(), (Throwable)ex);
                        throw new CertificateException(ex.getMessage(), ex);
                    }
                    int idx = 1;
                    ps.setInt(idx++, issuer.getId());
                    ps.setString(idx++, X509Util.cutX500Name((X500Name)cert.getSubject(), (int)this.maxX500nameLen));
                    ps.setLong(idx++, DateUtil.toEpochSecond((Date)cert.getTBSCertificate().getStartDate().getDate()));
                    ps.setLong(idx++, DateUtil.toEpochSecond((Date)cert.getTBSCertificate().getEndDate().getDate()));
                    ps.setString(idx++, this.sha1(encodedCert));
                    ps.setString(idx++, issuer.getRevInfo());
                    ps.setString(idx++, b64Cert);
                    if (issuer.getCrlId() == null) {
                        ps.setNull(idx, 4);
                    } else {
                        ps.setInt(idx, issuer.getCrlId());
                    }
                    ps.execute();
                }
                catch (SQLException ex) {
                    System.err.println("could not import issuer with id=" + issuer.getId());
                    throw this.translate(SQL_ADD_ISSUER, ex);
                }
                catch (CertificateException ex) {
                    System.err.println("could not import issuer with id=" + issuer.getId());
                    throw ex;
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCrlInfo(List<OcspCertstore.CrlInfo> crlInfos) throws DataAccessException {
        if (CollectionUtil.isEmpty(crlInfos)) {
            return;
        }
        System.out.print("    importing table CRL_INFO ... ");
        boolean succ = false;
        PreparedStatement ps = this.prepareStatement(SQL_ADD_CRLINFO);
        try {
            for (OcspCertstore.CrlInfo crlInfo : crlInfos) {
                try {
                    int idx = 1;
                    ps.setInt(idx++, crlInfo.getId());
                    ps.setString(idx++, crlInfo.getName());
                    ps.setString(idx, crlInfo.getInfo());
                    ps.execute();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CRL_INFO with id=" + crlInfo.getId());
                    throw this.translate(SQL_ADD_CRLINFO, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * Exception decompiling
     */
    private void importCert(OcspCertstore certstore, File processLogFile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importCert0(PreparedStatement psCert, String certsZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess) throws Exception {
        OcspCertstore.Certs certs;
        ZipFile zipFile = new ZipFile(new File(certsZipFile));
        ZipEntry certsEntry = zipFile.getEntry("certs.json");
        try {
            certs = (OcspCertstore.Certs)((Object)JSON.parseObjectAndClose((InputStream)zipFile.getInputStream(certsEntry), OcspCertstore.Certs.class));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)certsZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + certsZipFile, (Throwable)e2);
            }
            throw ex;
        }
        certs.validate();
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulCertId = 0L;
            List<OcspCertstore.Cert> list = certs.getCerts();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                OcspCertstore.Cert cert = list.get(i);
                long id = cert.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                try {
                    int idx = 1;
                    psCert.setLong(idx++, id);
                    psCert.setInt(idx++, cert.getIid());
                    psCert.setString(idx++, cert.getSn());
                    psCert.setLong(idx++, cert.getUpdate());
                    psCert.setLong(idx++, cert.getNbefore());
                    psCert.setLong(idx++, cert.getNafter());
                    OcspCertstoreDbImporter.setBoolean(psCert, idx++, cert.getRev());
                    OcspCertstoreDbImporter.setInt(psCert, idx++, cert.getRr());
                    OcspCertstoreDbImporter.setLong(psCert, idx++, cert.getRt());
                    OcspCertstoreDbImporter.setLong(psCert, idx++, cert.getRit());
                    psCert.setString(idx++, cert.getHash());
                    psCert.setString(idx++, cert.getSubject());
                    if (cert.getCrlId() == null) {
                        psCert.setNull(idx, 4);
                    } else {
                        psCert.setInt(idx, cert.getCrlId());
                    }
                    psCert.addBatch();
                }
                catch (SQLException ex) {
                    throw this.translate(SQL_ADD_CERT, ex);
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numEntriesInBatch <= 0 || numEntriesInBatch % this.numCertsPerCommit != 0 && !isLastBlock) continue;
                try {
                    psCert.executeBatch();
                    this.commit("(commit import cert to OCSP)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteCertGreaterThan(lastSuccessfulCertId, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate(SQL_ADD_CERT, (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulCertId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                OcspCertstoreDbImporter.echoToFile((long)numProcessedInLastProcess + processLog.numProcessed() + ":" + lastSuccessfulCertId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulCertId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }
}

