/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.diffdb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.DbWorker;
import org.xipki.ca.mgmt.db.diffdb.DigestDiff;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Args;
import org.xipki.util.ConfigurableProperties;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class DigestDiffWorker
extends DbWorker {
    private static final Logger LOG = LoggerFactory.getLogger(DigestDiffWorker.class);
    private final boolean revokedOnly;
    private final Set<byte[]> includeCaCerts;
    private final DataSourceWrapper targetDatasource;
    private final String reportDir;
    private final int numCertsPerSelect;
    private final int numThreads;

    public DigestDiffWorker(DataSourceFactory datasourceFactory, boolean revokedOnly, String refDbConfFile, String targetDbConfFile, String reportDirName, int numCertsPerSelect, int numThreads, Set<byte[]> includeCaCerts) throws InvalidConfException, IOException {
        super(datasourceFactory, refDbConfFile);
        this.reportDir = reportDirName;
        this.numThreads = Args.positive((int)numThreads, (String)"numThreads");
        this.numCertsPerSelect = numCertsPerSelect;
        this.includeCaCerts = includeCaCerts;
        this.revokedOnly = revokedOnly;
        File file = new File(reportDirName);
        if (!file.exists()) {
            IoUtil.mkdirs((File)file);
        } else {
            if (!file.isDirectory()) {
                throw new IOException(reportDirName + " is not a folder");
            }
            if (!file.canWrite()) {
                throw new IOException(reportDirName + " is not writable");
            }
        }
        String[] children = file.list();
        if (children != null && children.length > 0) {
            throw new IOException(reportDirName + " is not empty");
        }
        ConfigurableProperties props = DbPorter.getDbConfProperties(Paths.get(IoUtil.expandFilepath((String)targetDbConfFile), new String[0]));
        this.targetDatasource = datasourceFactory.createDataSource("ds-" + targetDbConfFile, props);
    }

    @Override
    protected void close0() {
        this.targetDatasource.close();
    }

    @Override
    protected void run0() throws Exception {
        long start = Clock.systemUTC().millis();
        DigestDiff diff = new DigestDiff(this.datasource, this.targetDatasource, this.reportDir, this.revokedOnly, this.stopMe, this.numCertsPerSelect, this.numThreads);
        diff.setIncludeCaCerts(this.includeCaCerts);
        diff.diff();
        long end = Clock.systemUTC().millis();
        System.out.println("finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
    }
}

