/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.sdk.CertChainResponse;
import org.xipki.ca.sdk.CertprofileInfoRequest;
import org.xipki.ca.sdk.CertprofileInfoResponse;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.ConfirmCertsRequest;
import org.xipki.ca.sdk.CrlResponse;
import org.xipki.ca.sdk.EnrollCertRequestEntry;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.EnrollOrPullCertResponseEntry;
import org.xipki.ca.sdk.ErrorResponse;
import org.xipki.ca.sdk.GenCRLRequest;
import org.xipki.ca.sdk.GetCRLRequest;
import org.xipki.ca.sdk.GetCertRequest;
import org.xipki.ca.sdk.OldCertInfoByIssuerAndSerial;
import org.xipki.ca.sdk.PayloadResponse;
import org.xipki.ca.sdk.PollCertRequest;
import org.xipki.ca.sdk.RevokeCertsRequest;
import org.xipki.ca.sdk.RevokeCertsResponse;
import org.xipki.ca.sdk.SdkClientConf;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.ca.sdk.SdkRequest;
import org.xipki.ca.sdk.TransactionIdRequest;
import org.xipki.ca.sdk.UnSuspendOrRemoveCertsResponse;
import org.xipki.ca.sdk.UnsuspendOrRemoveRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.security.KeyCertBytesPair;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.HttpRespContent;
import org.xipki.util.http.SslConf;
import org.xipki.util.http.SslContextConf;
import org.xipki.util.http.XiHttpClient;

public class SdkClient {
    private static final String CONTENT_TYPE_JSON = "application/json";
    private final String serverUrl;
    private final XiHttpClient client;

    public SdkClient(SdkClientConf conf) throws ObjectCreationException {
        this.serverUrl = conf.getServerUrl();
        SslContextConf sdkSslConf = SslContextConf.ofSslConf((SslConf)conf.getSsl());
        this.client = new XiHttpClient(sdkSslConf.getSslSocketFactory(), sdkSslConf.buildHostnameVerifier());
    }

    public SdkClient(String serverUrl, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        this.serverUrl = serverUrl;
        this.client = new XiHttpClient(sslSocketFactory, hostnameVerifier);
    }

    public byte[] send(String ca, String command, SdkRequest request) throws IOException, SdkErrorResponseException {
        String ct = request == null ? null : CONTENT_TYPE_JSON;
        HttpRespContent resp = request == null ? this.client.httpGet(this.serverUrl + ca + "/" + command) : this.client.httpPost(this.serverUrl + ca + "/" + command, ct, request.encode(), CONTENT_TYPE_JSON);
        if (resp.isOK()) {
            return resp.getContent();
        }
        byte[] errorContent = resp.getContent();
        if (errorContent == null) {
            throw new SdkErrorResponseException(ErrorCode.SYSTEM_FAILURE, null);
        }
        throw new SdkErrorResponseException(ErrorResponse.decode(errorContent));
    }

    public boolean healthy(String ca) {
        try {
            this.send(ca, "health", null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte[] cacert(String ca) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "cacert", null);
        CertChainResponse resp = CertChainResponse.decode(respBytes);
        byte[][] certs = resp.getCertificates();
        return certs == null || certs.length == 0 ? null : certs[0];
    }

    public byte[][] cacerts(String ca) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "cacerts", null);
        CertChainResponse resp = CertChainResponse.decode(respBytes);
        return resp.getCertificates();
    }

    public CertprofileInfoResponse profileInfo(String ca, String profileName) throws IOException, SdkErrorResponseException {
        CertprofileInfoRequest req = new CertprofileInfoRequest();
        req.setProfile(profileName);
        byte[] respBytes = this.send(ca, "profileinfo", req);
        return CertprofileInfoResponse.decode(respBytes);
    }

    public byte[] generateCrl(String ca, String crldp) throws IOException, SdkErrorResponseException {
        GenCRLRequest req = new GenCRLRequest();
        req.setCrlDp(crldp);
        byte[] respBytes = this.send(ca, "gen_crl", req);
        CrlResponse resp = CrlResponse.decode(respBytes);
        return resp.getCrl();
    }

    public byte[] currentCrl(String ca) throws IOException, SdkErrorResponseException {
        return this.currentCrl(ca, null, null, null);
    }

    public byte[] currentCrl(String ca, BigInteger crlNumber, Instant thisUpdate, String crlDp) throws IOException, SdkErrorResponseException {
        GetCRLRequest req = new GetCRLRequest();
        req.setCrlNumber(crlNumber);
        req.setCrlDp(crlDp);
        req.setThisUpdate(thisUpdate == null ? null : Long.valueOf(thisUpdate.getEpochSecond()));
        byte[] respBytes = this.send(ca, "crl", req);
        CrlResponse resp = CrlResponse.decode(respBytes);
        return resp.getCrl();
    }

    private byte[] enrollCert0(String func, String cmd, String ca, EnrollCertRequestEntry reqEntry) throws IOException, SdkErrorResponseException {
        EnrollCertsRequest req = new EnrollCertsRequest();
        req.setCaCertMode(CertsMode.NONE);
        req.setEntries(Collections.singletonList(reqEntry));
        byte[] respBytes = this.send(ca, cmd, req);
        EnrollOrPollCertsResponse resp = EnrollOrPollCertsResponse.decode(respBytes);
        EnrollOrPullCertResponseEntry rEntry = resp.getEntries().get(0);
        byte[] cert = rEntry.getCert();
        if (cert == null) {
            throw new SdkErrorResponseException(ErrorCode.SYSTEM_FAILURE, "error " + func);
        }
        return cert;
    }

    private KeyCertBytesPair enrollCertCaGenKeypair0(String func, String cmd, String ca, EnrollCertRequestEntry reqEntry) throws IOException, SdkErrorResponseException {
        EnrollCertsRequest req = new EnrollCertsRequest();
        req.setCaCertMode(CertsMode.NONE);
        req.setEntries(Collections.singletonList(reqEntry));
        byte[] respBytes = this.send(ca, cmd, req);
        EnrollOrPollCertsResponse resp = EnrollOrPollCertsResponse.decode(respBytes);
        EnrollOrPullCertResponseEntry rEntry = resp.getEntries().get(0);
        if (rEntry.getCert() == null || rEntry.getPrivateKey() == null) {
            throw new SdkErrorResponseException(ErrorCode.SYSTEM_FAILURE, "error " + func);
        }
        return new KeyCertBytesPair(rEntry.getPrivateKey(), rEntry.getCert());
    }

    public byte[] enrollCert(String ca, String certprofile, byte[] p10Req) throws IOException, SdkErrorResponseException {
        EnrollCertRequestEntry reqEntry = new EnrollCertRequestEntry();
        reqEntry.setP10req(p10Req);
        reqEntry.setCertprofile(certprofile);
        return this.enrollCert0("enrollCert", "enroll", ca, reqEntry);
    }

    public KeyCertBytesPair enrollCertCaGenKeypair(String ca, String certprofile, String subject) throws IOException, SdkErrorResponseException {
        EnrollCertRequestEntry reqEntry = new EnrollCertRequestEntry();
        reqEntry.setSubject(new X500NameType(subject));
        reqEntry.setCertprofile(certprofile);
        return this.enrollCertCaGenKeypair0("enrollCertCaGenKeypair", "enroll", ca, reqEntry);
    }

    public byte[] reenrollCert(String ca, String certprofile, byte[] p10Req, X500Name oldCertIssuer, BigInteger oldCertSerialNumber) throws IOException, SdkErrorResponseException {
        EnrollCertRequestEntry reqEntry = new EnrollCertRequestEntry();
        reqEntry.setCertprofile(certprofile);
        reqEntry.setP10req(p10Req);
        OldCertInfoByIssuerAndSerial oldCertInfo = new OldCertInfoByIssuerAndSerial();
        oldCertInfo.setReusePublicKey(false);
        oldCertInfo.setSerialNumber(oldCertSerialNumber);
        oldCertInfo.setIssuer(new X500NameType(oldCertIssuer));
        reqEntry.setOldCertIsn(oldCertInfo);
        return this.enrollCert0("reenrollCert", "reenroll", ca, reqEntry);
    }

    public KeyCertBytesPair reenrollCertCaGenKeypair(String ca, String certprofile, X500Name subject, String oldCertIssuer, BigInteger oldCertSerialNumber) throws IOException, SdkErrorResponseException {
        EnrollCertRequestEntry reqEntry = new EnrollCertRequestEntry();
        reqEntry.setCertprofile(certprofile);
        reqEntry.setSubject(new X500NameType(subject));
        OldCertInfoByIssuerAndSerial oldCertInfo = new OldCertInfoByIssuerAndSerial();
        oldCertInfo.setReusePublicKey(false);
        oldCertInfo.setSerialNumber(oldCertSerialNumber);
        oldCertInfo.setIssuer(new X500NameType(oldCertIssuer));
        reqEntry.setOldCertIsn(oldCertInfo);
        return this.enrollCertCaGenKeypair0("reenrollCertCaGenKeypair", "reenroll", ca, reqEntry);
    }

    public EnrollOrPollCertsResponse enrollCerts(String ca, EnrollCertsRequest req) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "enroll", req);
        return this.checkEnrollResp(respBytes, req);
    }

    public EnrollOrPollCertsResponse enrollCrossCerts(String ca, EnrollCertsRequest req) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "enroll_cross", req);
        return this.checkEnrollResp(respBytes, req);
    }

    public EnrollOrPollCertsResponse reenrollCerts(String ca, EnrollCertsRequest req) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "reenroll", req);
        return this.checkEnrollResp(respBytes, req);
    }

    private EnrollOrPollCertsResponse checkEnrollResp(byte[] respBytes, EnrollCertsRequest req) throws IOException {
        int size;
        EnrollOrPollCertsResponse resp = EnrollOrPollCertsResponse.decode(respBytes);
        List<EnrollOrPullCertResponseEntry> entries = resp.getEntries();
        int expectedSize = req.getEntries().size();
        int n = size = entries == null ? 0 : entries.size();
        if (expectedSize != size) {
            throw new IOException("expected " + expectedSize + " entries, but received " + size);
        }
        return resp;
    }

    public void confirmCerts(String ca, ConfirmCertsRequest req) throws IOException, SdkErrorResponseException {
        this.send(ca, "confirm_enroll", req);
    }

    public void revokePendingCerts(String ca, String tid) throws IOException, SdkErrorResponseException {
        TransactionIdRequest req = new TransactionIdRequest();
        req.setTid(tid);
        this.send(ca, "revoke_pending_cert", req);
    }

    public EnrollOrPollCertsResponse pollCerts(String ca, PollCertRequest req) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "poll_cert", req);
        return EnrollOrPollCertsResponse.decode(respBytes);
    }

    public RevokeCertsResponse revokeCerts(String ca, RevokeCertsRequest req) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "revoke_cert", req);
        return RevokeCertsResponse.decode(respBytes);
    }

    public UnSuspendOrRemoveCertsResponse unsuspendCerts(String ca, UnsuspendOrRemoveRequest req) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "unsuspend_cert", req);
        return UnSuspendOrRemoveCertsResponse.decode(respBytes);
    }

    public UnSuspendOrRemoveCertsResponse removeCerts(String ca, UnsuspendOrRemoveRequest req) throws IOException, SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "remove_cert", req);
        return UnSuspendOrRemoveCertsResponse.decode(respBytes);
    }

    public byte[] getCert(String caName, X500Name issuer, BigInteger serialNumber) throws IOException, SdkErrorResponseException {
        GetCertRequest req = new GetCertRequest();
        req.setIssuer(new X500NameType(issuer));
        req.setSerialNumber(serialNumber);
        byte[] respBytes = this.send(caName, "get_cert", req);
        PayloadResponse resp = PayloadResponse.decode(respBytes);
        return resp.getPayload();
    }
}

