/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.util.Hex;

public class X500NameType {
    private transient X500Name name;
    private String text;
    private byte[] encoded;

    public X500NameType() {
    }

    public X500NameType(String text) {
        this.text = text;
    }

    public X500NameType(X500Name name) {
        try {
            this.encoded = name.getEncoded();
            this.name = name;
        }
        catch (IOException ex) {
            throw new IllegalStateException("error encoding X500Name " + name);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public void setEncoded(byte[] encoded) {
        this.encoded = encoded;
    }

    public X500Name toX500Name() throws IOException {
        if (this.name != null) {
            return this.name;
        }
        if (this.text == null && this.encoded == null) {
            return null;
        }
        try {
            this.name = this.encoded != null ? X500Name.getInstance((Object)this.encoded) : new X500Name(this.text);
            return this.name;
        }
        catch (Exception e) {
            throw new IOException("error parsing X500Name " + (this.text != null ? this.text : "0x" + Hex.encode((byte[])this.encoded)));
        }
    }
}

