/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.EOFException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.server.api.CmpResponder;
import org.xipki.ca.server.api.ResponderManager;
import org.xipki.ca.server.servlet.ServletHelper;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class HealthCheckServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckServlet.class);
    private static final String CT_RESPONSE = "application/json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Access-Control-Allow-Origin", "*");
        ResponderManager responderManager = ServletHelper.getResponderManager();
        if (responderManager == null) {
            LOG.error("ServletHelper.responderManager not configured");
            HealthCheckServlet.sendError(resp, 500);
            return;
        }
        try {
            String caName = null;
            CmpResponder responder = null;
            String path = StringUtil.getRelativeRequestUri((String)req.getServletPath(), (String)req.getRequestURI());
            if (path.length() > 1) {
                String caAlias = path.substring(1);
                caName = responderManager.getCaNameForAlias(caAlias);
                if (caName == null) {
                    caName = caAlias.toLowerCase();
                }
                responder = responderManager.getX509CaResponder(caName);
            }
            if (caName == null || responder == null || !responder.isOnService()) {
                String auditMessage = caName == null ? "no CA is specified" : (responder == null ? "unknown CA '" + caName + "'" : "CA '" + caName + "' is out of service");
                LOG.warn(auditMessage);
                HealthCheckServlet.sendError(resp, 404);
                return;
            }
            HealthCheckResult healthResult = responder.healthCheck();
            int status = healthResult.isHealthy() ? 200 : 500;
            byte[] respBytes = healthResult.toJsonMessage(true).getBytes();
            resp.setStatus(status);
            resp.setContentLength(respBytes.length);
            resp.setContentType(CT_RESPONSE);
            resp.getOutputStream().write(respBytes);
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen!", th);
            }
            HealthCheckServlet.sendError(resp, 500);
        }
        finally {
            resp.flushBuffer();
        }
    }

    private static void sendError(HttpServletResponse resp, int status) {
        resp.setStatus(status);
        resp.setContentLength(0);
    }
}

