/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.server.api.ResponderManager;
import org.xipki.ca.server.servlet.ServletHelper;
import org.xipki.security.X509Cert;
import org.xipki.util.StringUtil;

public class HttpCaCertServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HttpCaCertServlet.class);
    private static final String CT_RESPONSE = "application/pkix-cert";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ResponderManager responderManager = ServletHelper.getResponderManager();
        if (responderManager == null) {
            LOG.error("ServletHelper.responderManager not configured");
            HttpCaCertServlet.sendError(resp, 500);
            return;
        }
        try {
            String caAlias;
            String caName = null;
            String path = StringUtil.getRelativeRequestUri((String)req.getServletPath(), (String)req.getRequestURI());
            if (path.length() > 1 && (caName = responderManager.getCaNameForAlias(caAlias = path.substring(1))) == null) {
                caName = caAlias.toLowerCase();
            }
            X509Cert cacert = null;
            if (caName != null) {
                cacert = responderManager.getCaCert(caName);
            }
            if (cacert == null) {
                resp.sendError(404);
                return;
            }
            byte[] encoded = cacert.getEncodedCert();
            resp.setContentType(CT_RESPONSE);
            resp.setContentLength(encoded.length);
            resp.getOutputStream().write(encoded);
        }
        catch (Throwable th) {
            LOG.error("Throwable thrown, this should not happen!", th);
            HttpCaCertServlet.sendError(resp, 500);
        }
        finally {
            resp.flushBuffer();
        }
    }

    private static void sendError(HttpServletResponse resp, int status) {
        resp.setStatus(status);
        resp.setContentLength(0);
    }
}

