/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditServiceRegister;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.server.api.CmpResponder;
import org.xipki.ca.server.api.ResponderManager;
import org.xipki.ca.server.servlet.HttpRespAuditException;
import org.xipki.ca.server.servlet.ServletHelper;
import org.xipki.ca.server.servlet.TlsHelper;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class HttpCmpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HttpCmpServlet.class);
    private static final String CT_REQUEST = "application/pkixcmp";
    private static final String CT_RESPONSE = "application/pkixcmp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AuditServiceRegister auditServiceRegister = ServletHelper.getAuditServiceRegister();
        if (auditServiceRegister == null) {
            LOG.error("ServletHelper.auditServiceRegister not configured");
            HttpCmpServlet.sendError(resp, 500);
            return;
        }
        ResponderManager responderManager = ServletHelper.getResponderManager();
        if (responderManager == null) {
            LOG.error("ServletHelper.responderManager not configured");
            HttpCmpServlet.sendError(resp, 500);
            return;
        }
        X509Certificate clientCert = TlsHelper.getTlsClientCert(req);
        AuditService auditService = auditServiceRegister.getAuditService();
        AuditEvent event = new AuditEvent(new Date());
        event.setApplicationName("ca");
        event.setName("perf");
        event.addEventData("req_type", (Object)RequestType.CMP.name());
        try {
            PKIMessage pkiReq;
            String reqContentType = req.getHeader("Content-Type");
            if (!"application/pkixcmp".equalsIgnoreCase(reqContentType)) {
                String message = "unsupported media type " + reqContentType;
                throw new HttpRespAuditException(415, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            String caName = null;
            CmpResponder responder = null;
            String path = StringUtil.getRelativeRequestUri((String)req.getServletPath(), (String)req.getRequestURI());
            if (path.length() > 1) {
                String caAlias = path.substring(1);
                caName = responderManager.getCaNameForAlias(caAlias);
                if (caName == null) {
                    caName = caAlias.toLowerCase();
                }
                responder = responderManager.getX509CaResponder(caName);
            }
            if (caName == null || responder == null || !responder.isOnService()) {
                String message = caName == null ? "no CA is specified" : (responder == null ? "unknown CA '" + caName + "'" : "CA '" + caName + "' is out of service");
                LOG.warn(message);
                throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            event.addEventData("ca", (Object)responder.getCaName());
            byte[] reqContent = IoUtil.read((InputStream)req.getInputStream());
            try {
                pkiReq = PKIMessage.getInstance((Object)reqContent);
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not parse the request (PKIMessage)");
                throw new HttpRespAuditException(400, "bad request", AuditLevel.INFO, AuditStatus.FAILED);
            }
            Map map = req.getParameterMap();
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (String name : map.keySet()) {
                parameters.put(name, ((String[])map.get(name))[0]);
            }
            PKIMessage pkiResp = responder.processPkiMessage(pkiReq, clientCert, parameters, event);
            byte[] encodedPkiResp = pkiResp.getEncoded();
            resp.setContentType("application/pkixcmp");
            resp.setContentLength(encodedPkiResp.length);
            resp.getOutputStream().write(encodedPkiResp);
        }
        catch (Throwable th) {
            String auditMessage;
            AuditLevel auditLevel;
            AuditStatus auditStatus;
            if (th instanceof HttpRespAuditException) {
                HttpRespAuditException hae = (HttpRespAuditException)th;
                auditStatus = hae.getAuditStatus();
                auditLevel = hae.getAuditLevel();
                auditMessage = hae.getAuditMessage();
            } else {
                auditLevel = AuditLevel.ERROR;
                auditStatus = AuditStatus.FAILED;
                auditMessage = "internal error";
                if (th instanceof EOFException) {
                    LogUtil.warn((Logger)LOG, (Throwable)th, (String)"connection reset by peer");
                } else {
                    LOG.error("Throwable thrown, this should not happen!", th);
                }
            }
            event.setStatus(auditStatus);
            event.setLevel(auditLevel);
            if (auditMessage != null) {
                event.addEventData("message", (Object)auditMessage);
            }
        }
        finally {
            resp.flushBuffer();
            event.finish();
            auditService.logEvent(event);
        }
    }

    private static void sendError(HttpServletResponse resp, int status) {
        resp.setStatus(status);
        resp.setContentLength(0);
    }
}

