/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditServiceRegister;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.server.api.HttpRequestMetadataRetriever;
import org.xipki.ca.server.api.ResponderManager;
import org.xipki.ca.server.api.RestResponder;
import org.xipki.ca.server.api.RestResponse;
import org.xipki.ca.server.servlet.HttpRequestMetadataRetrieverImpl;
import org.xipki.ca.server.servlet.ServletHelper;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class HttpRestServlet
extends HttpServlet {
    private static Logger LOG = LoggerFactory.getLogger(HttpRestServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service0(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service0(req, resp, true);
    }

    private void service0(HttpServletRequest req, HttpServletResponse resp, boolean viaPost) throws IOException {
        AuditServiceRegister auditServiceRegister = ServletHelper.getAuditServiceRegister();
        if (auditServiceRegister == null) {
            LOG.error("ServletHelper.auditServiceRegister not configured");
            HttpRestServlet.sendError(resp, 500);
            return;
        }
        ResponderManager responderManager = ServletHelper.getResponderManager();
        if (responderManager == null) {
            LOG.error("ServletHelper.responderManager not configured");
            HttpRestServlet.sendError(resp, 500);
            return;
        }
        AuditService auditService = auditServiceRegister.getAuditService();
        AuditEvent event = new AuditEvent(new Date());
        try {
            RestResponder rest = responderManager.getRestResponder();
            String path = StringUtil.getRelativeRequestUri((String)req.getServletPath(), (String)req.getRequestURI());
            HttpRequestMetadataRetrieverImpl httpRetriever = new HttpRequestMetadataRetrieverImpl(req);
            byte[] requestBytes = IoUtil.read((InputStream)req.getInputStream());
            RestResponse response = rest.service(path, event, requestBytes, (HttpRequestMetadataRetriever)httpRetriever);
            resp.setStatus(response.getStatusCode());
            if (resp.getContentType() != null) {
                resp.setContentType(resp.getContentType());
            }
            for (String headerName : response.getHeaders().keySet()) {
                resp.setHeader(headerName, (String)response.getHeaders().get(headerName));
            }
            byte[] respBody = response.getBody();
            if (respBody == null) {
                resp.setContentLength(0);
            } else {
                resp.setContentLength(respBody.length);
                resp.getOutputStream().write(respBody);
            }
            if (event.getStatus() == null) {
                event.setStatus(AuditStatus.SUCCESSFUL);
            }
        }
        catch (RuntimeException ex) {
            event.setStatus(AuditStatus.FAILED);
            event.setLevel(AuditLevel.ERROR);
            LOG.error("RuntimeException thrown, this should not happen!", (Throwable)ex);
            throw ex;
        }
        finally {
            event.finish();
            auditService.logEvent(event);
        }
    }

    private static void sendError(HttpServletResponse resp, int status) {
        resp.setStatus(status);
        resp.setContentLength(0);
    }
}

