/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.cms.CMSSignedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.server.servlet.ServletHelper;
import org.xipki.scep.exception.MessageDecodingException;
import org.xipki.scep.transaction.Operation;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.RandomUtil;
import org.xipki.util.StringUtil;

public class HttpScepServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HttpScepServlet.class);
    private static final String CGI_PROGRAM = "/pkiclient.exe";
    private static final int CGI_PROGRAM_LEN = "/pkiclient.exe".length();
    private static final String CT_RESPONSE = "application/x-pki-message";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service0(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service0(req, resp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void service0(HttpServletRequest req, HttpServletResponse resp, boolean viaPost) throws ServletException, IOException {
        auditServiceRegister = ServletHelper.getAuditServiceRegister();
        if (auditServiceRegister == null) {
            HttpScepServlet.LOG.error("ServletHelper.auditServiceRegister not configured");
            HttpScepServlet.sendError(resp, 500);
            return;
        }
        responderManager = ServletHelper.getResponderManager();
        if (responderManager == null) {
            HttpScepServlet.LOG.error("ServletHelper.responderManager not configured");
            HttpScepServlet.sendError(resp, 500);
            return;
        }
        path = StringUtil.getRelativeRequestUri((String)req.getServletPath(), (String)req.getRequestURI());
        caAlias = null;
        certprofileName = null;
        if (path.length() > 1 && (scepPath = path).endsWith("/pkiclient.exe") && (tokens = (tpath = scepPath.substring(1, scepPath.length() - HttpScepServlet.CGI_PROGRAM_LEN)).split("/")).length == 2) {
            caAlias = tokens[0];
            certprofileName = tokens[1].toLowerCase();
        }
        if (caAlias == null || certprofileName == null) {
            HttpScepServlet.sendError(resp, 404);
            return;
        }
        auditService = auditServiceRegister.getAuditService();
        event = new AuditEvent(new Date());
        event.setApplicationName("SCEP");
        event.setName("perf");
        event.addEventData("name", (Object)(caAlias + "/" + certprofileName));
        event.addEventData("req_type", (Object)RequestType.SCEP.name());
        msgId = RandomUtil.nextHexLong();
        event.addEventData("mid", (Object)msgId);
        auditLevel = AuditLevel.INFO;
        auditStatus = AuditStatus.SUCCESSFUL;
        auditMessage = null;
        caName = responderManager.getCaNameForAlias(caAlias);
        if (caName == null) {
            caName = caAlias.toLowerCase();
        }
        if ((responder = responderManager.getScepResponder(caName)) != null && responder.isOnService()) ** GOTO lbl-1000
        auditMessage = "unknown SCEP '" + caAlias + "/" + certprofileName + "'";
        HttpScepServlet.LOG.warn(auditMessage);
        auditStatus = AuditStatus.FAILED;
        HttpScepServlet.sendError(resp, 404);
        ** GOTO lbl61
        {
            catch (Throwable th) {
                block33: {
                    try {
                        if (th instanceof EOFException) {
                            msg = "connection reset by peer";
                            if (HttpScepServlet.LOG.isWarnEnabled()) {
                                LogUtil.warn((Logger)HttpScepServlet.LOG, (Throwable)th, (String)"connection reset by peer");
                            }
                            HttpScepServlet.LOG.debug("connection reset by peer", th);
                        } else {
                            HttpScepServlet.LOG.error("Throwable thrown, this should not happen!", th);
                        }
                        auditLevel = AuditLevel.ERROR;
                        auditStatus = AuditStatus.FAILED;
                        auditMessage = "internal error";
                        HttpScepServlet.sendError(resp, 500);
                    }
                    catch (Throwable var23_31) {
                        HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                        throw var23_31;
                    }
lbl61:
                    // 1 sources

                    HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        operation = req.getParameter("operation");
                        event.addEventData("operation", (Object)operation);
                        if (!"PKIOperation".equalsIgnoreCase(operation)) ** GOTO lbl123
                        try {
                            if (viaPost) {
                                content = IoUtil.read((InputStream)req.getInputStream());
                            } else {
                                b64 = req.getParameter("message");
                                content = Base64.decode((String)b64);
                            }
                            reqMessage = new CMSSignedData(content);
                        }
                        catch (Exception ex) {
                            msg = "invalid request";
                            LogUtil.error((Logger)HttpScepServlet.LOG, (Throwable)ex, (String)"invalid request");
                            auditMessage = "invalid request";
                            auditStatus = AuditStatus.FAILED;
                            HttpScepServlet.sendError(resp, 400);
                            HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                            return;
                        }
                    }
                    try {
                        ci = responder.servicePkiOperation(reqMessage, certprofileName, msgId, event);
                        ** GOTO lbl-1000
                    }
                    catch (MessageDecodingException ex) {
                        msg = "could not decrypt and/or verify the request";
                        LogUtil.error((Logger)HttpScepServlet.LOG, (Throwable)ex, (String)"could not decrypt and/or verify the request");
                        auditMessage = "could not decrypt and/or verify the request";
                        auditStatus = AuditStatus.FAILED;
                        HttpScepServlet.sendError(resp, 400);
                        HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                        return;
                    }
                    catch (OperationException ex) {}
                    {
                        code = ex.getErrorCode();
                        switch (1.$SwitchMap$org$xipki$ca$api$OperationException$ErrorCode[code.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                httpCode = 403;
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                httpCode = 400;
                                break;
                            }
                            case 10: {
                                httpCode = 401;
                                break;
                            }
                            case 11: {
                                httpCode = 503;
                                break;
                            }
                            case 12: 
                            case 13: 
                            case 14: {
                                httpCode = 500;
                                break;
                            }
                            default: {
                                httpCode = 500;
                            }
                        }
                        auditMessage = ex.getMessage();
                        LogUtil.error((Logger)HttpScepServlet.LOG, (Throwable)ex, (String)auditMessage);
                        auditStatus = AuditStatus.FAILED;
                        HttpScepServlet.sendError(resp, httpCode);
                    }
                    HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        bodyBytes = ci.getEncoded();
                        HttpScepServlet.sendOKResponse(resp, "application/x-pki-message", bodyBytes);
                        break block33;
lbl123:
                        // 1 sources

                        if (Operation.GetCACaps.getCode().equalsIgnoreCase(operation)) {
                            caCapsBytes = responder.getCaCaps().getBytes();
                            HttpScepServlet.sendOKResponse(resp, "text/plain", caCapsBytes);
                            break block33;
                        }
                        if (Operation.GetCACert.getCode().equalsIgnoreCase(operation)) {
                            respBytes = responder.getCaCertResp().getBytes();
                            HttpScepServlet.sendOKResponse(resp, "application/x-x509-ca-ra-cert", respBytes);
                            break block33;
                        }
                        if (!Operation.GetNextCACert.getCode().equalsIgnoreCase(operation)) ** GOTO lbl-1000
                        auditMessage = "SCEP operation '" + operation + "' is not permitted";
                        auditStatus = AuditStatus.FAILED;
                        HttpScepServlet.sendError(resp, 403);
                    }
                    HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        auditMessage = "unknown SCEP operation '" + operation + "'";
                        auditStatus = AuditStatus.FAILED;
                        HttpScepServlet.sendError(resp, 400);
                    }
                    HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                    return;
                }
                HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                return;
                HttpScepServlet.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PKIMessage generatePkiMessage(InputStream is) throws IOException {
        ASN1InputStream asn1Stream = new ASN1InputStream(is);
        try {
            PKIMessage pKIMessage = PKIMessage.getInstance((Object)asn1Stream.readObject());
            return pKIMessage;
        }
        finally {
            try {
                asn1Stream.close();
            }
            catch (Exception ex) {
                LOG.error("could not close ASN1 stream: {}", (Object)asn1Stream);
            }
        }
    }

    private static void audit(AuditService auditService, AuditEvent event, AuditLevel auditLevel, AuditStatus auditStatus, String auditMessage) {
        AuditLevel curLevel = event.getLevel();
        if (curLevel == null) {
            event.setLevel(auditLevel);
        } else if (curLevel.getValue() > auditLevel.getValue()) {
            event.setLevel(auditLevel);
        }
        if (auditStatus != null) {
            event.setStatus(auditStatus);
        }
        if (auditMessage != null) {
            event.addEventData("message", (Object)auditMessage);
        }
        event.finish();
        auditService.logEvent(event);
    }

    private static void sendError(HttpServletResponse resp, int status) {
        resp.setStatus(status);
        resp.setContentLength(0);
    }

    private static void sendOKResponse(HttpServletResponse resp, String contentType, byte[] content) throws IOException {
        resp.setStatus(200);
        resp.setContentType(contentType);
        resp.setContentLength(content.length);
        resp.getOutputStream().write(content);
    }
}

