/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.util.X509Util;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;

public class TlsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TlsHelper.class);
    private static final LruCache<String, X509Certificate> clientCerts = new LruCache(50);
    private static String reverseProxyMode = null;

    public static X509Certificate getTlsClientCert(HttpServletRequest request) throws IOException {
        if (reverseProxyMode == null) {
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            return certs == null || certs.length < 1 ? null : certs[0];
        }
        if ("APACHE".equals(reverseProxyMode)) {
            String clientVerify = request.getHeader("SSL_CLIENT_VERIFY");
            if (StringUtil.isBlank((String)clientVerify)) {
                return null;
            }
            if ("SUCCESS".equalsIgnoreCase(clientVerify.trim())) {
                return null;
            }
            String pemClientCert = request.getHeader("SSL_CLIENT_CERT");
            if (StringUtil.isBlank((String)pemClientCert)) {
                return null;
            }
            X509Certificate clientCert = (X509Certificate)clientCerts.get((Object)pemClientCert);
            if (clientCert != null) {
                return clientCert;
            }
            try {
                clientCert = X509Util.parseCert((byte[])pemClientCert.getBytes());
            }
            catch (CertificateException ex) {
                throw new IOException("could not parse Certificate", ex);
            }
            clientCerts.put((Object)pemClientCert, (Object)clientCert);
            return clientCert;
        }
        throw new RuntimeException("unknown reverseProxyMode " + reverseProxyMode);
    }

    static {
        String propName = "org.xipki.reverseproxy.mode";
        String mode = System.getProperty(propName);
        if (mode != null && !mode.trim().isEmpty()) {
            mode = mode.trim().toUpperCase();
        }
        if (mode == null || "NO".equals(mode)) {
            reverseProxyMode = null;
        } else if ("APACHE".equals(mode)) {
            reverseProxyMode = "APACHE";
        } else {
            LOG.error("invalid value of property {}: {} is not one of [NO, APACHE]", (Object)propName, (Object)mode);
            reverseProxyMode = null;
        }
        LOG.info("set reverseProxyMode to {}", (Object)reverseProxyMode);
    }
}

