/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl;

import java.util.Collection;
import java.util.Set;
import org.xipki.ca.api.InsuffientPermissionException;
import org.xipki.ca.api.NameId;
import org.xipki.ca.server.mgmt.api.CaHasUserEntry;
import org.xipki.ca.server.mgmt.api.PermissionConstants;
import org.xipki.ca.server.mgmt.api.RequestorInfo;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ParamUtil;

public class ByUserRequestorInfo
implements RequestorInfo {
    private final NameId ident;
    private final CaHasUserEntry caHasUser;

    public ByUserRequestorInfo(NameId ident, CaHasUserEntry caHasUser) {
        this.ident = (NameId)ParamUtil.requireNonNull((String)"ident", (Object)ident);
        this.caHasUser = (CaHasUserEntry)ParamUtil.requireNonNull((String)"caHasUser", (Object)caHasUser);
    }

    public NameId getIdent() {
        return this.ident;
    }

    public boolean isRa() {
        return false;
    }

    public int getUserId() {
        return this.caHasUser.getUserIdent().getId();
    }

    public CaHasUserEntry getCaHasUser() {
        return this.caHasUser;
    }

    public boolean isCertprofilePermitted(String certprofile) {
        Set profiles = this.caHasUser.getProfiles();
        if (CollectionUtil.isEmpty((Collection)profiles)) {
            return false;
        }
        return profiles.contains("all") || profiles.contains(certprofile.toLowerCase());
    }

    public boolean isPermitted(int permission) {
        return PermissionConstants.contains((int)this.caHasUser.getPermission(), (int)permission);
    }

    public void assertCertprofilePermitted(String certprofile) throws InsuffientPermissionException {
        if (!this.isCertprofilePermitted(certprofile)) {
            throw new InsuffientPermissionException("Certprofile " + certprofile + " is not permitted");
        }
    }

    public void assertPermitted(int permission) throws InsuffientPermissionException {
        if (!this.isPermitted(permission)) {
            throw new InsuffientPermissionException("Permission " + PermissionConstants.getTextForCode((int)permission) + " is not permitted");
        }
    }
}

