/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl;

import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.profile.CertValidity;
import org.xipki.ca.server.impl.RandomSerialNumberGenerator;
import org.xipki.ca.server.impl.store.CertStore;
import org.xipki.ca.server.mgmt.api.CaEntry;
import org.xipki.ca.server.mgmt.api.CaStatus;
import org.xipki.ca.server.mgmt.api.CmpControl;
import org.xipki.ca.server.mgmt.api.CrlControl;
import org.xipki.ca.server.mgmt.api.PermissionConstants;
import org.xipki.ca.server.mgmt.api.ProtocolSupport;
import org.xipki.ca.server.mgmt.api.RevokeSuspendedCertsControl;
import org.xipki.ca.server.mgmt.api.ScepControl;
import org.xipki.ca.server.mgmt.api.ValidityMode;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ParamUtil;

public class CaInfo {
    private static final long MS_PER_DAY = 86400000L;
    private final CaEntry caEntry;
    private long noNewCertificateAfter;
    private BigInteger serialNumber;
    private Date notBefore;
    private Date notAfter;
    private boolean selfSigned;
    private CMPCertificate certInCmpFormat;
    private PublicCaInfo publicCaInfo;
    private CertStore certStore;
    private RandomSerialNumberGenerator randomSnGenerator;
    private Map<String, ConcurrentContentSigner> signers;
    private ConcurrentContentSigner dfltSigner;
    private RevokeSuspendedCertsControl revokeSuspendedCertsControl;

    public CaInfo(CaEntry caEntry, CertStore certStore) throws OperationException {
        Certificate bcCert;
        this.caEntry = (CaEntry)ParamUtil.requireNonNull((String)"caEntry", (Object)caEntry);
        this.certStore = (CertStore)ParamUtil.requireNonNull((String)"certStore", (Object)certStore);
        X509Certificate cert = caEntry.getCert();
        this.notBefore = cert.getNotBefore();
        this.notAfter = cert.getNotAfter();
        this.serialNumber = cert.getSerialNumber();
        this.selfSigned = cert.getIssuerX500Principal().equals(cert.getSubjectX500Principal());
        try {
            byte[] encodedCert = cert.getEncoded();
            bcCert = Certificate.getInstance((Object)encodedCert);
        }
        catch (CertificateEncodingException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "could not encode the CA certificate");
        }
        this.certInCmpFormat = new CMPCertificate(bcCert);
        this.publicCaInfo = new PublicCaInfo(cert, caEntry.getCaUris(), caEntry.getExtraControl());
        this.noNewCertificateAfter = this.notAfter.getTime() - 86400000L * (long)caEntry.getExpirationPeriod();
        this.randomSnGenerator = RandomSerialNumberGenerator.getInstance();
    }

    public PublicCaInfo getPublicCaInfo() {
        return this.publicCaInfo;
    }

    public String getSubject() {
        return this.caEntry.getSubject();
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isSelfSigned() {
        return this.selfSigned;
    }

    public CMPCertificate getCertInCmpFormat() {
        return this.certInCmpFormat;
    }

    public long getNoNewCertificateAfter() {
        return this.noNewCertificateAfter;
    }

    public CaEntry getCaEntry() {
        return this.caEntry;
    }

    public NameId getIdent() {
        return this.caEntry.getIdent();
    }

    public CaUris getCaUris() {
        return this.caEntry.getCaUris();
    }

    public CertValidity getMaxValidity() {
        return this.caEntry.getMaxValidity();
    }

    public void setMaxValidity(CertValidity maxValidity) {
        this.caEntry.setMaxValidity(maxValidity);
    }

    public X509Cert getCert() {
        return this.publicCaInfo.getCaCert();
    }

    public String getSignerConf() {
        return this.caEntry.getSignerConf();
    }

    public String getCrlSignerName() {
        return this.caEntry.getCrlSignerName();
    }

    public void setCrlSignerName(String crlSignerName) {
        this.caEntry.setCrlSignerName(crlSignerName);
    }

    public CrlControl getCrlControl() {
        return this.caEntry.getCrlControl();
    }

    public void setCrlControl(CrlControl crlControl) {
        this.caEntry.setCrlControl(crlControl);
    }

    public String getCmpResponderName() {
        return this.caEntry.getCmpResponderName();
    }

    public void setCmpResponderName(String name) {
        this.caEntry.setCmpResponderName(name);
    }

    public CmpControl getCmpControl() {
        return this.caEntry.getCmpControl();
    }

    public void setCmpControl(CmpControl cmpControl) {
        this.caEntry.setCmpControl(cmpControl);
    }

    public String getScepResponderName() {
        return this.caEntry.getScepResponderName();
    }

    public void setScepResponderName(String name) {
        this.caEntry.setScepResponderName(name);
    }

    public ScepControl getSCepControl() {
        return this.caEntry.getScepControl();
    }

    public void setScepControl(ScepControl control) {
        this.caEntry.setScepControl(control);
    }

    public int getNumCrls() {
        return this.caEntry.getNumCrls();
    }

    public CaStatus getStatus() {
        return this.caEntry.getStatus();
    }

    public void setStatus(CaStatus status) {
        this.caEntry.setStatus(status);
    }

    public String getSignerType() {
        return this.caEntry.getSignerType();
    }

    public String toString() {
        return this.caEntry.toString(false);
    }

    public String toString(boolean verbose) {
        return this.caEntry.toString(verbose);
    }

    public boolean isDuplicateKeyPermitted() {
        return this.caEntry.isDuplicateKeyPermitted();
    }

    public void setDuplicateKeyPermitted(boolean permitted) {
        this.caEntry.setDuplicateKeyPermitted(permitted);
    }

    public boolean isDuplicateSubjectPermitted() {
        return this.caEntry.isDuplicateSubjectPermitted();
    }

    public void setDuplicateSubjectPermitted(boolean permitted) {
        this.caEntry.setDuplicateSubjectPermitted(permitted);
    }

    public boolean supportCmp() {
        return this.caEntry.getProtocoSupport().supportsCmp();
    }

    public boolean supportsRest() {
        return this.caEntry.getProtocoSupport().supportsRest();
    }

    public boolean supportsScep() {
        return this.caEntry.getProtocoSupport().supportsScep();
    }

    public void setProtocolSupport(ProtocolSupport protocolSupport) {
        this.caEntry.setProtocolSupport(protocolSupport);
    }

    public boolean isSaveRequest() {
        return this.caEntry.isSaveRequest();
    }

    public void setSaveRequest(boolean saveRequest) {
        this.caEntry.setSaveRequest(saveRequest);
    }

    public ValidityMode getValidityMode() {
        return this.caEntry.getValidityMode();
    }

    public void setValidityMode(ValidityMode mode) {
        this.caEntry.setValidityMode(mode);
    }

    public int getPermission() {
        return this.caEntry.getPermission();
    }

    public void setPermission(int permission) {
        this.caEntry.setPermission(permission);
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.caEntry.getRevocationInfo();
    }

    public void setRevocationInfo(CertRevocationInfo revocationInfo) {
        this.caEntry.setRevocationInfo(revocationInfo);
    }

    public int getExpirationPeriod() {
        return this.caEntry.getExpirationPeriod();
    }

    public void setKeepExpiredCertInDays(int days) {
        this.caEntry.setKeepExpiredCertInDays(days);
    }

    public int getKeepExpiredCertInDays() {
        return this.caEntry.getKeepExpiredCertInDays();
    }

    public Date getCrlBaseTime() {
        return this.caEntry.getCrlBaseTime();
    }

    public BigInteger nextSerial() throws OperationException {
        return this.randomSnGenerator.nextSerialNumber(this.caEntry.getSerialNoBitLen());
    }

    public BigInteger nextCrlNumber() throws OperationException {
        long currentMaxNo;
        long crlNo = this.caEntry.getNextCrlNumber();
        if (crlNo <= (currentMaxNo = this.certStore.getMaxCrlNumber(this.caEntry.getIdent()))) {
            crlNo = currentMaxNo + 1L;
        }
        this.caEntry.setNextCrlNumber(crlNo + 1L);
        return BigInteger.valueOf(crlNo);
    }

    public ConcurrentContentSigner getSigner(List<String> algoNames) {
        if (CollectionUtil.isEmpty(algoNames)) {
            return this.dfltSigner;
        }
        for (String name : algoNames) {
            if (!this.signers.containsKey(name)) continue;
            return this.signers.get(name);
        }
        return null;
    }

    public boolean initSigner(SecurityFactory securityFactory) throws XiSecurityException {
        if (this.signers != null) {
            return true;
        }
        this.dfltSigner = null;
        List signerConfs = CaEntry.splitCaSignerConfs((String)this.caEntry.getSignerConf());
        HashMap<String, ConcurrentContentSigner> tmpSigners = new HashMap<String, ConcurrentContentSigner>();
        for (String[] m : signerConfs) {
            String algo = m[0];
            SignerConf signerConf = new SignerConf(m[1]);
            try {
                ConcurrentContentSigner signer = securityFactory.createSigner(this.caEntry.getSignerType(), signerConf, this.caEntry.getCert());
                if (this.dfltSigner == null) {
                    this.dfltSigner = signer;
                }
                tmpSigners.put(algo, signer);
            }
            catch (Throwable th) {
                for (ConcurrentContentSigner ccs : tmpSigners.values()) {
                    ccs.shutdown();
                }
                tmpSigners.clear();
                throw new XiSecurityException("could not initialize the CA signer");
            }
        }
        this.signers = Collections.unmodifiableMap(tmpSigners);
        return true;
    }

    public boolean isSignerRequired() {
        int permission = this.caEntry.getPermission();
        return PermissionConstants.contains((int)permission, (int)128) || PermissionConstants.contains((int)permission, (int)1) || PermissionConstants.contains((int)permission, (int)32) || PermissionConstants.contains((int)permission, (int)16);
    }

    public RevokeSuspendedCertsControl revokeSuspendedCertsControl() {
        return this.revokeSuspendedCertsControl;
    }

    public void setRevokeSuspendedCertsControl(RevokeSuspendedCertsControl revokeSuspendedCertsControl) {
        this.revokeSuspendedCertsControl = revokeSuspendedCertsControl;
    }
}

