/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditServiceRegister;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.PciAuditEvent;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.profile.CertValidity;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.CertprofileFactoryRegister;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherException;
import org.xipki.ca.api.publisher.CertPublisherFactoryRegister;
import org.xipki.ca.server.api.CmpResponder;
import org.xipki.ca.server.api.ResponderManager;
import org.xipki.ca.server.api.RestResponder;
import org.xipki.ca.server.api.ScepResponder;
import org.xipki.ca.server.impl.ByCaRequestorInfo;
import org.xipki.ca.server.impl.ByUserRequestorInfo;
import org.xipki.ca.server.impl.CaIdNameMap;
import org.xipki.ca.server.impl.CaInfo;
import org.xipki.ca.server.impl.CaManagerQueryExecutor;
import org.xipki.ca.server.impl.CertTemplateData;
import org.xipki.ca.server.impl.IdentifiedCertPublisher;
import org.xipki.ca.server.impl.IdentifiedCertprofile;
import org.xipki.ca.server.impl.RandomSerialNumberGenerator;
import org.xipki.ca.server.impl.RequestorEntryWrapper;
import org.xipki.ca.server.impl.SelfSignedCertBuilder;
import org.xipki.ca.server.impl.SignerEntryWrapper;
import org.xipki.ca.server.impl.SystemEvent;
import org.xipki.ca.server.impl.UniqueIdGenerator;
import org.xipki.ca.server.impl.X509Ca;
import org.xipki.ca.server.impl.cmp.CmpResponderImpl;
import org.xipki.ca.server.impl.rest.RestResponderImpl;
import org.xipki.ca.server.impl.scep.ScepResponderImpl;
import org.xipki.ca.server.impl.store.CertStore;
import org.xipki.ca.server.impl.util.PasswordHash;
import org.xipki.ca.server.mgmt.api.AddUserEntry;
import org.xipki.ca.server.mgmt.api.CaEntry;
import org.xipki.ca.server.mgmt.api.CaHasRequestorEntry;
import org.xipki.ca.server.mgmt.api.CaHasUserEntry;
import org.xipki.ca.server.mgmt.api.CaManager;
import org.xipki.ca.server.mgmt.api.CaMgmtException;
import org.xipki.ca.server.mgmt.api.CaStatus;
import org.xipki.ca.server.mgmt.api.CaSystemStatus;
import org.xipki.ca.server.mgmt.api.CertListInfo;
import org.xipki.ca.server.mgmt.api.CertListOrderBy;
import org.xipki.ca.server.mgmt.api.CertWithRevocationInfo;
import org.xipki.ca.server.mgmt.api.CertprofileEntry;
import org.xipki.ca.server.mgmt.api.ChangeCaEntry;
import org.xipki.ca.server.mgmt.api.ChangeUserEntry;
import org.xipki.ca.server.mgmt.api.CmpControl;
import org.xipki.ca.server.mgmt.api.PermissionConstants;
import org.xipki.ca.server.mgmt.api.PublisherEntry;
import org.xipki.ca.server.mgmt.api.RequestorEntry;
import org.xipki.ca.server.mgmt.api.RequestorInfo;
import org.xipki.ca.server.mgmt.api.RevokeSuspendedCertsControl;
import org.xipki.ca.server.mgmt.api.SignerEntry;
import org.xipki.ca.server.mgmt.api.UserEntry;
import org.xipki.ca.server.mgmt.api.conf.CaConf;
import org.xipki.ca.server.mgmt.api.conf.GenSelfIssued;
import org.xipki.ca.server.mgmt.api.conf.SingleCaConf;
import org.xipki.ca.server.mgmt.api.conf.jaxb.AliasesType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaHasRequestorType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaHasUserType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaInfoType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaUrisType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaconfType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.FileOrBinaryType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.FileOrValueType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.PermissionsType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.ProfileType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.ProfilesType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.PublisherType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.PublishersType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.RequestorType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.SignerType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.UrisType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.UserType;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.ParamUtil;
import org.xipki.util.PemEncoder;
import org.xipki.util.StringUtil;
import org.xml.sax.SAXException;

public class CaManagerImpl
implements CaManager,
ResponderManager {
    public static final String ENV_EPOCH = "EPOCH";
    private static final Logger LOG = LoggerFactory.getLogger(CaManagerImpl.class);
    private static final String EVENT_LOCK = "LOCK";
    private static final String EVENT_CACHAGNE = "CA_CHANGE";
    private final String lockInstanceId;
    private final CaIdNameMap idNameMap = new CaIdNameMap();
    private ByCaRequestorInfo byCaRequestor;
    private NameId byUserRequestorId;
    private boolean caLockedByMe;
    private boolean masterMode;
    private Map<String, DataSourceWrapper> datasources;
    private final Map<String, CaInfo> caInfos = new ConcurrentHashMap<String, CaInfo>();
    private Map<String, SignerEntryWrapper> signers = new ConcurrentHashMap<String, SignerEntryWrapper>();
    private Map<String, SignerEntry> signerDbEntries = new ConcurrentHashMap<String, SignerEntry>();
    private final Map<String, IdentifiedCertprofile> certprofiles = new ConcurrentHashMap<String, IdentifiedCertprofile>();
    private final Map<String, CertprofileEntry> certprofileDbEntries = new ConcurrentHashMap<String, CertprofileEntry>();
    private final Map<String, IdentifiedCertPublisher> publishers = new ConcurrentHashMap<String, IdentifiedCertPublisher>();
    private final Map<String, PublisherEntry> publisherDbEntries = new ConcurrentHashMap<String, PublisherEntry>();
    private final Map<String, RequestorEntryWrapper> requestors = new ConcurrentHashMap<String, RequestorEntryWrapper>();
    private final Map<String, RequestorEntry> requestorDbEntries = new ConcurrentHashMap<String, RequestorEntry>();
    private final Map<String, Set<String>> caHasProfiles = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> caHasPublishers = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<CaHasRequestorEntry>> caHasRequestors = new ConcurrentHashMap<String, Set<CaHasRequestorEntry>>();
    private final Map<String, Integer> caAliases = new ConcurrentHashMap<String, Integer>();
    private ScheduledThreadPoolExecutor persistentScheduledThreadPoolExecutor;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final Map<String, CmpResponderImpl> cmpResponders = new ConcurrentHashMap<String, CmpResponderImpl>();
    private final Map<String, ScepResponderImpl> scepResponders = new ConcurrentHashMap<String, ScepResponderImpl>();
    private final Map<String, X509Ca> x509cas = new ConcurrentHashMap<String, X509Ca>();
    private final DataSourceFactory datasourceFactory = new DataSourceFactory();
    private final RestResponderImpl restResponder;
    private Properties caConfProperties;
    private boolean caSystemSetuped;
    private boolean signerInitialized;
    private boolean requestorsInitialized;
    private boolean caAliasesInitialized;
    private boolean certprofilesInitialized;
    private boolean publishersInitialized;
    private boolean casInitialized;
    private Date lastStartTime;
    private AuditServiceRegister auditServiceRegister;
    private CertprofileFactoryRegister certprofileFactoryRegister;
    private CertPublisherFactoryRegister certPublisherFactoryRegister;
    private DataSourceWrapper datasource;
    private CertStore certstore;
    private SecurityFactory securityFactory;
    private CaManagerQueryExecutor queryExecutor;
    private boolean initializing;

    public CaManagerImpl() throws InvalidConfException {
        String calockId = null;
        File caLockFile = new File("calock");
        if (caLockFile.exists()) {
            try {
                calockId = new String(IoUtil.read((File)caLockFile));
            }
            catch (IOException ex) {
                LOG.error("could not read {}: {}", (Object)caLockFile.getName(), (Object)ex.getMessage());
            }
        }
        if (calockId == null) {
            calockId = UUID.randomUUID().toString();
            try {
                IoUtil.save((File)caLockFile, (byte[])calockId.getBytes());
            }
            catch (IOException ex) {
                LOG.error("could not save {}: {}", (Object)caLockFile.getName(), (Object)ex.getMessage());
            }
        }
        String hostAddress = null;
        try {
            hostAddress = IoUtil.getHostAddress();
        }
        catch (SocketException ex) {
            LOG.warn("could not get host address: {}", (Object)ex.getMessage());
        }
        this.lockInstanceId = hostAddress == null ? calockId : hostAddress + "/" + calockId;
        this.restResponder = new RestResponderImpl(this);
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.datasourceFactory;
    }

    public boolean isMasterMode() {
        return this.masterMode;
    }

    public Set<String> getSupportedSignerTypes() {
        return this.securityFactory.getSupportedSignerTypes();
    }

    public Set<String> getSupportedCertprofileTypes() {
        return this.certprofileFactoryRegister.getSupportedTypes();
    }

    public Set<String> getSupportedPublisherTypes() {
        return this.certPublisherFactoryRegister.getSupportedTypes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws CaMgmtException {
        int shardId;
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        if (this.datasourceFactory == null) {
            throw new IllegalStateException("datasourceFactory is not set");
        }
        if (this.certprofileFactoryRegister == null) {
            throw new IllegalStateException("certprofileFactoryRegister is not set");
        }
        if (this.certPublisherFactoryRegister == null) {
            throw new IllegalStateException("certPublisherFactoryRegister is not set");
        }
        if (this.caConfProperties == null) {
            throw new IllegalStateException("caConfProperties is not set");
        }
        String caModeStr = this.caConfProperties.getProperty("ca.mode");
        if (caModeStr != null) {
            if ("slave".equalsIgnoreCase(caModeStr)) {
                this.masterMode = false;
            } else {
                if (!"master".equalsIgnoreCase(caModeStr)) throw new CaMgmtException(CaManagerImpl.concat("invalid ca.mode '", caModeStr, "'"));
                this.masterMode = true;
            }
        } else {
            this.masterMode = true;
        }
        LOG.info("ca.mode: {}", (Object)caModeStr);
        String shardIdStr = this.caConfProperties.getProperty("ca.shardId");
        if (StringUtil.isBlank((String)shardIdStr)) {
            throw new CaMgmtException("ca.shardId is not set");
        }
        LOG.info("ca.shardId: {}", (Object)shardIdStr);
        try {
            shardId = Integer.parseInt(shardIdStr);
        }
        catch (NumberFormatException ex) {
            throw new CaMgmtException(CaManagerImpl.concat("invalid ca.shardId '", shardIdStr, "'"));
        }
        if (shardId < 0 || shardId > 127) {
            throw new CaMgmtException("ca.shardId is not in [0, 127]");
        }
        if (this.datasources == null) {
            this.datasources = new ConcurrentHashMap<String, DataSourceWrapper>();
            for (Object objKey : this.caConfProperties.keySet()) {
                String key = (String)objKey;
                if (!StringUtil.startsWithIgnoreCase((String)key, (String)"datasource.")) continue;
                String datasourceFile = this.caConfProperties.getProperty(key);
                try {
                    String datasourceName = key.substring("datasource.".length());
                    DataSourceWrapper datasource = this.datasourceFactory.createDataSourceForFile(datasourceName, datasourceFile, this.securityFactory.getPasswordResolver());
                    Connection conn = datasource.getConnection();
                    datasource.returnConnection(conn);
                    LOG.info("datasource.{}: {}", (Object)datasourceName, (Object)datasourceFile);
                    this.datasources.put(datasourceName, datasource);
                }
                catch (IOException | RuntimeException | DataAccessException | PasswordResolverException ex) {
                    throw new CaMgmtException(CaManagerImpl.concat(ex.getClass().getName(), " while parsing datasource ", datasourceFile, ": ", ex.getMessage()), ex);
                }
            }
            this.datasource = this.datasources.get("ca");
        }
        if (this.datasource == null) {
            throw new CaMgmtException("no datasource named 'ca' configured");
        }
        this.queryExecutor = new CaManagerQueryExecutor(this.datasource);
        if (this.masterMode) {
            this.lockCa(true);
            this.queryExecutor.addRequestorIfNeeded("BY-CA");
            this.queryExecutor.addRequestorIfNeeded("BY-USER");
        }
        long epoch = DateUtil.parseUtcTimeyyyyMMdd((String)"20100101").getTime();
        UniqueIdGenerator idGen = new UniqueIdGenerator(epoch, shardId);
        try {
            this.certstore = new CertStore(this.datasource, idGen);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        this.initCaAliases();
        this.initCertprofiles();
        this.initPublishers();
        this.initRequestors();
        this.initSigners();
        this.initCas();
    }

    public CaSystemStatus getCaSystemStatus() {
        if (this.caSystemSetuped) {
            return this.masterMode ? CaSystemStatus.STARTED_AS_MASTER : CaSystemStatus.STARTED_AS_SLAVE;
        }
        if (this.initializing) {
            return CaSystemStatus.INITIALIZING;
        }
        if (!this.caLockedByMe) {
            return CaSystemStatus.LOCK_FAILED;
        }
        return CaSystemStatus.ERROR;
    }

    private void lockCa(boolean forceRelock) throws CaMgmtException {
        SystemEvent lockInfo = this.queryExecutor.getSystemEvent(EVENT_LOCK);
        if (lockInfo != null) {
            String lockedBy = lockInfo.getOwner();
            Date lockedAt = new Date(lockInfo.getEventTime() * 1000L);
            if (!this.lockInstanceId.equals(lockedBy)) {
                String msg = CaManagerImpl.concat("could not lock CA, it has been locked by ", lockedBy, " since ", lockedAt.toString(), ". In general this indicates that another CA software in active mode is accessing the database or the last shutdown of CA software in active mode is abnormal.");
                throw CaManagerImpl.logAndCreateException(msg);
            }
            if (forceRelock) {
                LOG.info("CA has been locked by me since {}, re-lock it", (Object)lockedAt);
            }
        }
        SystemEvent newLockInfo = new SystemEvent(EVENT_LOCK, this.lockInstanceId, System.currentTimeMillis() / 1000L);
        this.queryExecutor.changeSystemEvent(newLockInfo);
        this.caLockedByMe = true;
    }

    public void unlockCa() throws CaMgmtException {
        if (!this.masterMode) {
            throw CaManagerImpl.logAndCreateException("could not unlock CA in slave mode");
        }
        boolean succ = false;
        try {
            this.queryExecutor.unlockCa();
            LOG.info("unlocked CA");
            succ = true;
        }
        finally {
            this.auditLogPciEvent(succ, "UNLOCK");
        }
    }

    private void reset() {
        this.caSystemSetuped = false;
        this.signerInitialized = false;
        this.requestorsInitialized = false;
        this.caAliasesInitialized = false;
        this.certprofilesInitialized = false;
        this.publishersInitialized = false;
        this.casInitialized = false;
        this.shutdownScheduledThreadPoolExecutor();
    }

    public void restartCaSystem() throws CaMgmtException {
        this.reset();
        boolean caSystemStarted = this.startCaSystem0();
        this.auditLogPciEvent(caSystemStarted, EVENT_CACHAGNE);
        if (!caSystemStarted) {
            throw CaManagerImpl.logAndCreateException("could not restart CA system");
        }
    }

    public void notifyCaChange() throws CaMgmtException {
        try {
            SystemEvent systemEvent = new SystemEvent(EVENT_CACHAGNE, this.lockInstanceId, System.currentTimeMillis() / 1000L);
            this.queryExecutor.changeSystemEvent(systemEvent);
            LOG.info("notified the change of CA system");
        }
        catch (CaMgmtException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not notify slave CAs to restart");
            throw ex;
        }
    }

    public void startCaSystem() {
        boolean caSystemStarted = false;
        try {
            caSystemStarted = this.startCaSystem0();
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not start CA system");
        }
        if (!caSystemStarted) {
            LOG.error("could not start CA system");
        }
        this.auditLogPciEvent(caSystemStarted, "START");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startCaSystem0() {
        if (this.caSystemSetuped) {
            return true;
        }
        this.initializing = true;
        this.shutdownScheduledThreadPoolExecutor();
        try {
            String name;
            LOG.info("starting CA system");
            try {
                this.init();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                boolean bl = false;
                this.initializing = false;
                if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                    this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                    this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                    this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
                }
                return bl;
            }
            this.lastStartTime = new Date();
            this.x509cas.clear();
            this.cmpResponders.clear();
            this.scepResponders.clear();
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(10);
            this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            LinkedList<String> startedCaNames = new LinkedList<String>();
            LinkedList<String> failedCaNames = new LinkedList<String>();
            for (String caName : this.caInfos.keySet()) {
                CaStatus status = this.caInfos.get(caName).getCaEntry().getStatus();
                if (CaStatus.ACTIVE != status) continue;
                if (this.startCa(caName)) {
                    startedCaNames.add(caName);
                    LOG.info("started CA {}", (Object)caName);
                    continue;
                }
                failedCaNames.add(caName);
                LOG.error("could not start CA {}", (Object)caName);
            }
            this.caSystemSetuped = true;
            StringBuilder sb = new StringBuilder();
            sb.append("started CA system");
            Set<String> caAliasNames = this.getCaAliasNames();
            HashSet<String> names = new HashSet<String>(this.getCaNames());
            if (names.size() > 0) {
                sb.append(" with following CAs: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    names.remove(name);
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : names) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new CertsInQueuePublisher(), 120L, 120L, TimeUnit.SECONDS);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new UnreferencedRequstCleaner(), 60L, 86400L, TimeUnit.SECONDS);
            } else {
                sb.append(": no CA is configured");
            }
            if (!failedCaNames.isEmpty()) {
                sb.append(", and following CAs could not be started: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    if (!failedCaNames.remove(name)) continue;
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : failedCaNames) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
            }
            LOG.info("{}", (Object)sb);
        }
        finally {
            this.initializing = false;
            if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
            }
        }
        return true;
    }

    private boolean startCa(String caName) {
        CmpResponderImpl caResponder;
        X509Ca ca;
        CaInfo caEntry = this.caInfos.get(caName);
        ConfPairs extraControl = caEntry.getCaEntry().getExtraControl();
        if (extraControl != null) {
            String str = extraControl.value("revokeSuspendedCerts.enabled");
            boolean enabled = false;
            if (str != null) {
                enabled = Boolean.parseBoolean(str);
            }
            if (enabled) {
                str = extraControl.value("revokeSuspendedCerts.targetReason");
                CrlReason reason = str == null ? CrlReason.CESSATION_OF_OPERATION : CrlReason.forNameOrText((String)str);
                str = extraControl.value("revokeSuspendedCerts.unchangedSince");
                CertValidity unchangedSince = str == null ? new CertValidity(15, CertValidity.Unit.DAY) : CertValidity.getInstance((String)str);
                RevokeSuspendedCertsControl control = new RevokeSuspendedCertsControl(reason, unchangedSince);
                caEntry.setRevokeSuspendedCertsControl(control);
            }
        }
        try {
            ca = new X509Ca(this, caEntry, this.certstore);
            ca.setAuditServiceRegister(this.auditServiceRegister);
        }
        catch (OperationException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("X509CA.<init> (ca=", caName, ")"));
            return false;
        }
        this.x509cas.put(caName, ca);
        try {
            caResponder = new CmpResponderImpl(this, caName);
        }
        catch (NoSuchAlgorithmException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("CmpResponderImpl.<init> (ca=", caName, ")"));
            return false;
        }
        this.cmpResponders.put(caName, caResponder);
        if (caEntry.supportsScep() && caEntry.getScepResponderName() != null) {
            try {
                this.scepResponders.put(caName, new ScepResponderImpl(this, caEntry.getCaEntry()));
            }
            catch (CaMgmtException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("X509CA.<init> (scep=", caName, ")"));
                return false;
            }
        }
        return true;
    }

    public void shutdown() {
        File caLockFile;
        LOG.info("stopping CA system");
        this.shutdownScheduledThreadPoolExecutor();
        if (this.persistentScheduledThreadPoolExecutor != null) {
            this.persistentScheduledThreadPoolExecutor.shutdown();
            while (!this.persistentScheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.persistentScheduledThreadPoolExecutor = null;
        }
        for (String caName : this.x509cas.keySet()) {
            X509Ca ca = this.x509cas.get(caName);
            try {
                ca.shutdown();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)CaManagerImpl.concat("could not call ca.shutdown() for CA ", caName));
            }
        }
        if (this.caLockedByMe) {
            try {
                this.unlockCa();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not unlock CA system");
            }
        }
        if ((caLockFile = new File("calock")).exists()) {
            caLockFile.delete();
        }
        for (String dsName : this.datasources.keySet()) {
            DataSourceWrapper ds = this.datasources.get(dsName);
            try {
                ds.close();
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("could not close datasource ", dsName));
            }
        }
        this.auditLogPciEvent(true, "SHUTDOWN");
        LOG.info("stopped CA system");
    }

    public CmpResponder getX509CaResponder(String name) {
        return this.cmpResponders.get(ParamUtil.requireNonBlankLower((String)"name", (String)name));
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public Set<String> getCertprofileNames() {
        return this.certprofileDbEntries.keySet();
    }

    public Set<String> getPublisherNames() {
        return this.publisherDbEntries.keySet();
    }

    public Set<String> getRequestorNames() {
        return this.requestorDbEntries.keySet();
    }

    public Set<String> getSignerNames() {
        return this.signerDbEntries.keySet();
    }

    public Set<String> getCaNames() {
        return this.caInfos.keySet();
    }

    public Set<String> getSuccessfulCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.x509cas.keySet()) {
            if (CaStatus.ACTIVE != this.caInfos.get(name).getStatus()) continue;
            ret.add(name);
        }
        return ret;
    }

    public Set<String> getFailedCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.caInfos.keySet()) {
            if (CaStatus.ACTIVE != this.caInfos.get(name).getStatus() || this.x509cas.containsKey(name)) continue;
            ret.add(name);
        }
        return ret;
    }

    public Set<String> getInactiveCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.caInfos.keySet()) {
            if (CaStatus.INACTIVE != this.caInfos.get(name).getStatus()) continue;
            ret.add(name);
        }
        return ret;
    }

    private void initRequestors() throws CaMgmtException {
        if (this.requestorsInitialized) {
            return;
        }
        this.idNameMap.clearRequestor();
        this.requestorDbEntries.clear();
        this.requestors.clear();
        List<String> names = this.queryExecutor.namesFromTable("REQUESTOR");
        for (String name : names) {
            Integer id;
            if ("BY-CA".equals(name)) {
                id = this.queryExecutor.getRequestorId(name);
                NameId ident = new NameId(id, name);
                this.byCaRequestor = new ByCaRequestorInfo(ident);
                this.idNameMap.addRequestor(ident);
            } else if ("BY-USER".equals(name)) {
                id = this.queryExecutor.getRequestorId(name);
                this.byUserRequestorId = new NameId(id, name);
                this.idNameMap.addRequestor(this.byUserRequestorId);
            } else {
                RequestorEntry requestorDbEntry = this.queryExecutor.createRequestor(name);
                if (requestorDbEntry == null) {
                    LOG.error("could not load requestor {}", (Object)name);
                    continue;
                }
                this.idNameMap.addRequestor(requestorDbEntry.getIdent());
                this.requestorDbEntries.put(name, requestorDbEntry);
                RequestorEntryWrapper requestor = new RequestorEntryWrapper();
                requestor.setDbEntry(requestorDbEntry, this.securityFactory.getPasswordResolver());
                this.requestors.put(name, requestor);
            }
            LOG.info("loaded requestor {}", (Object)name);
        }
        this.requestorsInitialized = true;
    }

    private void initSigners() throws CaMgmtException {
        if (this.signerInitialized) {
            return;
        }
        this.signerDbEntries.clear();
        this.signers.clear();
        List<String> names = this.queryExecutor.namesFromTable("SIGNER");
        for (String name : names) {
            SignerEntry dbEntry = this.queryExecutor.createSigner(name);
            if (dbEntry == null) {
                LOG.error("could not initialize signer '{}'", (Object)name);
                continue;
            }
            dbEntry.setConfFaulty(true);
            this.signerDbEntries.put(name, dbEntry);
            SignerEntryWrapper signer = this.createSigner(dbEntry);
            if (signer != null) {
                dbEntry.setConfFaulty(false);
                this.signers.put(name, signer);
                LOG.info("loaded signer {}", (Object)name);
                continue;
            }
            LOG.error("could not load signer {}", (Object)name);
        }
        this.signerInitialized = true;
    }

    private void initCaAliases() throws CaMgmtException {
        if (this.caAliasesInitialized) {
            return;
        }
        Map<String, Integer> map = this.queryExecutor.createCaAliases();
        this.caAliases.clear();
        for (String aliasName : map.keySet()) {
            this.caAliases.put(aliasName, map.get(aliasName));
        }
        LOG.info("caAliases: {}", this.caAliases);
        this.caAliasesInitialized = true;
    }

    private void initCertprofiles() throws CaMgmtException {
        if (this.certprofilesInitialized) {
            return;
        }
        for (String name : this.certprofiles.keySet()) {
            this.shutdownCertprofile(this.certprofiles.get(name));
        }
        this.certprofileDbEntries.clear();
        this.idNameMap.clearCertprofile();
        this.certprofiles.clear();
        List<String> names = this.queryExecutor.namesFromTable("PROFILE");
        for (String name : names) {
            CertprofileEntry dbEntry = this.queryExecutor.createCertprofile(name);
            if (dbEntry == null) {
                LOG.error("could not initialize Certprofile '{}'", (Object)name);
                continue;
            }
            this.idNameMap.addCertprofile(dbEntry.getIdent());
            dbEntry.setFaulty(true);
            this.certprofileDbEntries.put(name, dbEntry);
            IdentifiedCertprofile profile = this.createCertprofile(dbEntry);
            if (profile != null) {
                dbEntry.setFaulty(false);
                this.certprofiles.put(name, profile);
                LOG.info("loaded certprofile {}", (Object)name);
                continue;
            }
            LOG.error("could not load certprofile {}", (Object)name);
        }
        this.certprofilesInitialized = true;
    }

    private void initPublishers() throws CaMgmtException {
        if (this.publishersInitialized) {
            return;
        }
        for (String name : this.publishers.keySet()) {
            this.shutdownPublisher(this.publishers.get(name));
        }
        this.publishers.clear();
        this.publisherDbEntries.clear();
        this.idNameMap.clearPublisher();
        List<String> names = this.queryExecutor.namesFromTable("PUBLISHER");
        for (String name : names) {
            PublisherEntry dbEntry = this.queryExecutor.createPublisher(name);
            if (dbEntry == null) {
                LOG.error("could not initialize publisher '{}'", (Object)name);
                continue;
            }
            this.idNameMap.addPublisher(dbEntry.getIdent());
            dbEntry.setFaulty(true);
            this.publisherDbEntries.put(name, dbEntry);
            IdentifiedCertPublisher publisher = this.createPublisher(dbEntry);
            if (publisher != null) {
                dbEntry.setFaulty(false);
                this.publishers.put(name, publisher);
                LOG.info("loaded publisher {}", (Object)name);
                continue;
            }
            LOG.error("could not load publisher {}", (Object)name);
        }
        this.publishersInitialized = true;
    }

    private void initCas() throws CaMgmtException {
        if (this.casInitialized) {
            return;
        }
        this.caInfos.clear();
        this.caHasRequestors.clear();
        this.caHasPublishers.clear();
        this.caHasProfiles.clear();
        this.idNameMap.clearCa();
        List<String> names = this.queryExecutor.namesFromTable("CA");
        for (String name : names) {
            this.createCa(name);
        }
        this.casInitialized = true;
    }

    private boolean createCa(String name) throws CaMgmtException {
        this.caInfos.remove(name);
        this.idNameMap.removeCa(name);
        this.caHasProfiles.remove(name);
        this.caHasPublishers.remove(name);
        this.caHasRequestors.remove(name);
        X509Ca oldCa = this.x509cas.remove(name);
        this.cmpResponders.remove(name);
        this.scepResponders.remove(name);
        if (oldCa != null) {
            oldCa.shutdown();
        }
        CaInfo ca = this.queryExecutor.createCaInfo(name, this.masterMode, this.certstore);
        LOG.info("created CA {}: {}", (Object)name, (Object)ca.toString(false));
        this.caInfos.put(name, ca);
        this.idNameMap.addCa(ca.getIdent());
        Set<CaHasRequestorEntry> caReqEntries = this.queryExecutor.createCaHasRequestors(ca.getIdent());
        this.caHasRequestors.put(name, caReqEntries);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (CaHasRequestorEntry entry : caReqEntries) {
                sb.append("\n    ").append(entry);
            }
            LOG.info("CA {} is associated with following requestors:{}", (Object)name, (Object)sb);
        }
        Set<Integer> profileIds = this.queryExecutor.createCaHasProfiles(ca.getIdent());
        HashSet<String> profileNames = new HashSet<String>();
        for (Integer id : profileIds) {
            profileNames.add(this.idNameMap.getCertprofileName(id));
        }
        this.caHasProfiles.put(name, profileNames);
        LOG.info("CA {} is associated with following profiles: {}", (Object)name, profileNames);
        Set<Integer> publisherIds = this.queryExecutor.createCaHasPublishers(ca.getIdent());
        HashSet<String> publisherNames = new HashSet<String>();
        for (Integer id : publisherIds) {
            publisherNames.add(this.idNameMap.getPublisherName(id));
        }
        this.caHasPublishers.put(name, publisherNames);
        LOG.info("CA {} is associated with following publishers: {}", (Object)name, publisherNames);
        return true;
    }

    public void commitNextCrlNo(NameId ca, long nextCrlNo) throws OperationException {
        try {
            this.queryExecutor.commitNextCrlNoIfLess(ca, nextCrlNo);
        }
        catch (CaMgmtException ex) {
            if (ex.getCause() instanceof DataAccessException) {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, ex.getMessage());
            }
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        catch (RuntimeException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
    }

    public ByUserRequestorInfo createByUserRequestor(CaHasUserEntry caHasUser) {
        return new ByUserRequestorInfo(this.byUserRequestorId, caHasUser);
    }

    public void addCa(CaEntry caEntry) throws CaMgmtException {
        String newSignerConf;
        ParamUtil.requireNonNull((String)"caEntry", (Object)caEntry);
        this.asssertMasterMode();
        NameId ident = caEntry.getIdent();
        String name = ident.getName();
        if (this.caInfos.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("CA named ", name, " exists"));
        }
        String origSignerConf = caEntry.getSignerConf();
        if (!origSignerConf.equals(newSignerConf = CaManagerImpl.canonicalizeSignerConf(caEntry.getSignerType(), origSignerConf, null, this.securityFactory))) {
            caEntry.setSignerConf(newSignerConf);
        }
        try {
            List signerConfs = CaEntry.splitCaSignerConfs((String)caEntry.getSignerConf());
            for (String[] m : signerConfs) {
                SignerConf signerConf = new SignerConf(m[1]);
                ConcurrentContentSigner signer = this.securityFactory.createSigner(caEntry.getSignerType(), signerConf, caEntry.getCert());
                if (caEntry.getCert() != null) continue;
                if (signer.getCertificate() == null) {
                    throw new CaMgmtException("CA signer without certificate is not allowed");
                }
                caEntry.setCert(signer.getCertificate());
            }
        }
        catch (XiSecurityException | ObjectCreationException ex) {
            throw new CaMgmtException(CaManagerImpl.concat("could not create signer for new CA ", name, ": ", ex.getMessage()), ex);
        }
        this.queryExecutor.addCa(caEntry);
        if (this.createCa(name)) {
            if (this.startCa(name)) {
                LOG.info("started CA {}", (Object)name);
            } else {
                LOG.error("could not start CA {}", (Object)name);
            }
        } else {
            LOG.error("could not create CA {}", (Object)name);
        }
    }

    public CaEntry getCa(String name) {
        CaInfo caInfo = this.caInfos.get(ParamUtil.requireNonBlankLower((String)"name", (String)name));
        return caInfo == null ? null : caInfo.getCaEntry();
    }

    public void changeCa(ChangeCaEntry entry) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"entry", (Object)entry);
        this.asssertMasterMode();
        String name = entry.getIdent().getName();
        NameId ident = this.idNameMap.getCa(name);
        if (ident == null) {
            throw new CaMgmtException("Unknown CA " + name);
        }
        entry.getIdent().setId(ident.getId());
        this.queryExecutor.changeCa(entry, this.caInfos.get(name).getCaEntry(), this.securityFactory);
        if (this.createCa(name)) {
            CaInfo caInfo = this.caInfos.get(name);
            if (CaStatus.ACTIVE != caInfo.getCaEntry().getStatus()) {
                return;
            }
            if (this.startCa(name)) {
                LOG.info("started CA {}", (Object)name);
            } else {
                LOG.error("could not start CA {}", (Object)name);
            }
        } else {
            LOG.error("could not create CA {}", (Object)name);
        }
    }

    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        Set<String> set;
        profileName = ParamUtil.requireNonBlankLower((String)"profileName", (String)profileName);
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        this.queryExecutor.removeCertprofileFromCa(profileName, caName);
        if (this.caHasProfiles.containsKey(caName) && (set = this.caHasProfiles.get(caName)) != null) {
            set.remove(profileName);
        }
    }

    public void addCertprofileToCa(String profileName, String caName) throws CaMgmtException {
        profileName = ParamUtil.requireNonBlankLower((String)"profileName", (String)profileName);
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        NameId ident = this.idNameMap.getCertprofile(profileName);
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown Certprofile ", profileName));
        }
        NameId caIdent = this.idNameMap.getCa(caName);
        if (caIdent == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown CA ", caName));
        }
        Set<String> set = this.caHasProfiles.get(caName);
        if (set == null) {
            set = new HashSet<String>();
            this.caHasProfiles.put(caName, set);
        } else if (set.contains(profileName)) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("Certprofile ", profileName, " already associated with CA ", caName));
        }
        if (!this.certprofiles.containsKey(profileName)) {
            throw new CaMgmtException(CaManagerImpl.concat("certprofile '", profileName, "' is faulty"));
        }
        this.queryExecutor.addCertprofileToCa(ident, caIdent);
        set.add(profileName);
    }

    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        publisherName = ParamUtil.requireNonBlankLower((String)"publisherName", (String)publisherName);
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        this.queryExecutor.removePublisherFromCa(publisherName, caName);
        Set<String> publisherNames = this.caHasPublishers.get(caName);
        if (publisherNames != null) {
            publisherNames.remove(publisherName);
        }
    }

    public void addPublisherToCa(String publisherName, String caName) throws CaMgmtException {
        publisherName = ParamUtil.requireNonBlankLower((String)"publisherName", (String)publisherName);
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        NameId ident = this.idNameMap.getPublisher(publisherName);
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown publisher ", publisherName));
        }
        NameId caIdent = this.idNameMap.getCa(caName);
        if (caIdent == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown CA ", caName));
        }
        Set<String> publisherNames = this.caHasPublishers.get(caName);
        if (publisherNames == null) {
            publisherNames = new HashSet<String>();
            this.caHasPublishers.put(caName, publisherNames);
        } else if (publisherNames.contains(publisherName)) {
            String msg = CaManagerImpl.concat("publisher ", publisherName, " already associated with CA ", caName);
            throw CaManagerImpl.logAndCreateException(msg);
        }
        IdentifiedCertPublisher publisher = this.publishers.get(publisherName);
        if (publisher == null) {
            throw new CaMgmtException(CaManagerImpl.concat("publisher '", publisherName, "' is faulty"));
        }
        this.queryExecutor.addPublisherToCa(this.idNameMap.getPublisher(publisherName), caIdent);
        publisherNames.add(publisherName);
        this.caHasPublishers.get(caName).add(publisherName);
        publisher.caAdded(this.caInfos.get(caName).getCert());
    }

    public Set<String> getCertprofilesForCa(String caName) {
        return this.caHasProfiles.get(ParamUtil.requireNonBlankLower((String)"caName", (String)caName));
    }

    public Set<CaHasRequestorEntry> getRequestorsForCa(String caName) {
        return this.caHasRequestors.get(ParamUtil.requireNonBlankLower((String)"caName", (String)caName));
    }

    public RequestorEntry getRequestor(String name) {
        return this.requestorDbEntries.get(ParamUtil.requireNonBlankLower((String)"name", (String)name));
    }

    public RequestorEntryWrapper getRequestorWrapper(String name) {
        return this.requestors.get(ParamUtil.requireNonBlankLower((String)"name", (String)name));
    }

    public void addRequestor(RequestorEntry dbEntry) throws CaMgmtException {
        String conf;
        ParamUtil.requireNonNull((String)"dbEntry", (Object)dbEntry);
        this.asssertMasterMode();
        String name = dbEntry.getIdent().getName();
        if (this.requestorDbEntries.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("Requestor named ", name, " exists"));
        }
        PasswordResolver pwdResolver = this.securityFactory.getPasswordResolver();
        if ("pbm".equalsIgnoreCase(dbEntry.getType()) && !StringUtil.startsWithIgnoreCase((String)(conf = dbEntry.getConf()), (String)"PBE:")) {
            String encryptedPassword;
            try {
                encryptedPassword = pwdResolver.protectPassword("PBE", conf.toCharArray());
            }
            catch (PasswordResolverException ex) {
                throw new CaMgmtException("could not encrypt requestor " + name, (Throwable)ex);
            }
            dbEntry = new RequestorEntry(dbEntry.getIdent(), dbEntry.getType(), encryptedPassword);
        }
        RequestorEntryWrapper requestor = new RequestorEntryWrapper();
        requestor.setDbEntry(dbEntry, pwdResolver);
        this.queryExecutor.addRequestor(dbEntry);
        this.idNameMap.addRequestor(dbEntry.getIdent());
        this.requestorDbEntries.put(name, dbEntry);
        this.requestors.put(name, requestor);
    }

    public void removeRequestor(String name) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"requestorName", (String)name);
        this.asssertMasterMode();
        for (String caName : this.caHasRequestors.keySet()) {
            boolean removeMe = false;
            for (CaHasRequestorEntry caHasRequestor : this.caHasRequestors.get(caName)) {
                if (!caHasRequestor.getRequestorIdent().getName().equals(name)) continue;
                removeMe = true;
                break;
            }
            if (!removeMe) continue;
            this.removeRequestorFromCa(name, caName);
        }
        if (!this.queryExecutor.deleteRowWithName(name, "REQUESTOR")) {
            throw new CaMgmtException("unknown requestor " + name);
        }
        this.idNameMap.removeRequestor(this.requestorDbEntries.get(name).getIdent().getId());
        this.requestorDbEntries.remove(name);
        this.requestors.remove(name);
        LOG.info("removed requestor '{}'", (Object)name);
    }

    public void changeRequestor(String name, String type, String conf) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        ParamUtil.requireNonBlank((String)"type", (String)type);
        ParamUtil.requireNonBlank((String)"conf", (String)conf);
        this.asssertMasterMode();
        NameId ident = this.idNameMap.getRequestor(name);
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown requestor ", name));
        }
        RequestorEntryWrapper requestor = this.queryExecutor.changeRequestor(ident, type, conf, this.securityFactory.getPasswordResolver());
        this.requestorDbEntries.remove(name);
        this.requestors.remove(name);
        this.requestorDbEntries.put(name, requestor.getDbEntry());
        this.requestors.put(name, requestor);
    }

    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        requestorName = ParamUtil.requireNonBlankLower((String)"requestorName", (String)requestorName);
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        if (requestorName.equals("BY-CA") || requestorName.equals("BY-USER")) {
            throw new CaMgmtException(CaManagerImpl.concat("removing requestor ", requestorName, " is not permitted"));
        }
        this.queryExecutor.removeRequestorFromCa(requestorName, caName);
        if (this.caHasRequestors.containsKey(caName)) {
            Set<CaHasRequestorEntry> entries = this.caHasRequestors.get(caName);
            CaHasRequestorEntry entry = null;
            for (CaHasRequestorEntry m : entries) {
                if (!m.getRequestorIdent().getName().equals(requestorName)) continue;
                entry = m;
            }
            entries.remove(entry);
        }
    }

    public void addRequestorToCa(CaHasRequestorEntry requestor, String caName) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"requestor", (Object)requestor);
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        NameId requestorIdent = requestor.getRequestorIdent();
        NameId ident = this.idNameMap.getRequestor(requestorIdent.getName());
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown requestor ", requestorIdent.getName()));
        }
        NameId caIdent = this.idNameMap.getCa(caName);
        if (caIdent == null) {
            String msg = CaManagerImpl.concat("unknown CA ", caName);
            LOG.warn(msg);
            throw new CaMgmtException(msg);
        }
        requestorIdent.setId(ident.getId());
        Set<CaHasRequestorEntry> cmpRequestors = this.caHasRequestors.get(caName);
        if (cmpRequestors == null) {
            cmpRequestors = new HashSet<CaHasRequestorEntry>();
            this.caHasRequestors.put(caName, cmpRequestors);
        } else {
            for (CaHasRequestorEntry entry : cmpRequestors) {
                String requestorName = requestorIdent.getName();
                if (!entry.getRequestorIdent().getName().equals(requestorName)) continue;
                String msg = CaManagerImpl.concat("Requestor ", requestorName, " already associated with CA ", caName);
                throw CaManagerImpl.logAndCreateException(msg);
            }
        }
        cmpRequestors.add(requestor);
        this.queryExecutor.addRequestorToCa(requestor, caIdent);
        this.caHasRequestors.get(caName).add(requestor);
    }

    public void removeUserFromCa(String userName, String caName) throws CaMgmtException {
        userName = ParamUtil.requireNonBlankLower((String)"userName", (String)userName);
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        this.queryExecutor.removeUserFromCa(userName, caName);
    }

    public void addUserToCa(CaHasUserEntry user, String caName) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        X509Ca ca = this.getX509Ca(caName);
        if (ca == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown CA ", caName));
        }
        this.queryExecutor.addUserToCa(user, ca.getCaIdent());
    }

    public Map<String, CaHasUserEntry> getCaHasUsersForUser(String user) throws CaMgmtException {
        ParamUtil.requireNonBlank((String)"user", (String)user);
        return this.queryExecutor.getCaHasUsersForUser(user, this.idNameMap);
    }

    public CertprofileEntry getCertprofile(String name) {
        return this.certprofileDbEntries.get(name.toLowerCase());
    }

    public void removeCertprofile(String name) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        this.asssertMasterMode();
        for (String caName : this.caHasProfiles.keySet()) {
            if (!this.caHasProfiles.get(caName).contains(name)) continue;
            this.removeCertprofileFromCa(name, caName);
        }
        boolean bo = this.queryExecutor.deleteRowWithName(name, "PROFILE");
        if (!bo) {
            throw new CaMgmtException("unknown profile " + name);
        }
        LOG.info("removed profile '{}'", (Object)name);
        this.idNameMap.removeCertprofile(this.certprofileDbEntries.get(name).getIdent().getId());
        this.certprofileDbEntries.remove(name);
        IdentifiedCertprofile profile = this.certprofiles.remove(name);
        this.shutdownCertprofile(profile);
    }

    public void changeCertprofile(String name, String type, String conf) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        if (type == null && conf == null) {
            throw new IllegalArgumentException("type and conf cannot be both null");
        }
        NameId ident = this.idNameMap.getCertprofile(name);
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown Certprofile ", name));
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        this.asssertMasterMode();
        IdentifiedCertprofile profile = this.queryExecutor.changeCertprofile(ident, type, conf, this);
        this.certprofileDbEntries.remove(name);
        IdentifiedCertprofile oldProfile = this.certprofiles.remove(name);
        this.certprofileDbEntries.put(name, profile.getDbEntry());
        this.certprofiles.put(name, profile);
        if (oldProfile != null) {
            this.shutdownCertprofile(oldProfile);
        }
    }

    public void addCertprofile(CertprofileEntry dbEntry) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"dbEntry", (Object)dbEntry);
        this.asssertMasterMode();
        String name = dbEntry.getIdent().getName();
        if (this.certprofileDbEntries.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("Certprofile named ", name, " exists"));
        }
        dbEntry.setFaulty(true);
        IdentifiedCertprofile profile = this.createCertprofile(dbEntry);
        if (profile == null) {
            throw new CaMgmtException("could not create Certprofile object");
        }
        dbEntry.setFaulty(false);
        this.certprofiles.put(name, profile);
        this.queryExecutor.addCertprofile(dbEntry);
        this.idNameMap.addCertprofile(dbEntry.getIdent());
        this.certprofileDbEntries.put(name, dbEntry);
    }

    public void addSigner(SignerEntry dbEntry) throws CaMgmtException {
        String newConf;
        ParamUtil.requireNonNull((String)"dbEntry", (Object)dbEntry);
        this.asssertMasterMode();
        String name = dbEntry.getName();
        if (this.signerDbEntries.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("Signer named ", name, " exists"));
        }
        String conf = dbEntry.getConf();
        if (conf != null && !conf.equals(newConf = CaManagerImpl.canonicalizeSignerConf(dbEntry.getType(), conf, null, this.securityFactory))) {
            dbEntry.setConf(newConf);
        }
        SignerEntryWrapper signer = this.createSigner(dbEntry);
        this.queryExecutor.addSigner(dbEntry);
        this.signers.put(name, signer);
        this.signerDbEntries.put(name, dbEntry);
    }

    public void removeSigner(String name) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        this.asssertMasterMode();
        boolean bo = this.queryExecutor.deleteRowWithName(name, "SIGNER");
        if (!bo) {
            throw new CaMgmtException("unknown signer " + name);
        }
        for (String caName : this.caInfos.keySet()) {
            CaInfo caInfo = this.caInfos.get(caName);
            if (name.equals(caInfo.getCmpResponderName())) {
                caInfo.setCmpResponderName(null);
            }
            if (name.equals(caInfo.getScepResponderName())) {
                caInfo.setScepResponderName(null);
            }
            if (!name.equals(caInfo.getCrlSignerName())) continue;
            caInfo.setCrlSignerName(null);
        }
        this.signerDbEntries.remove(name);
        this.signers.remove(name);
        LOG.info("removed signer '{}'", (Object)name);
    }

    public void changeSigner(String name, String type, String conf, String base64Cert) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        this.asssertMasterMode();
        if (type == null && conf == null && base64Cert == null) {
            throw new IllegalArgumentException("nothing to change");
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        SignerEntryWrapper newResponder = this.queryExecutor.changeSigner(name, type, conf, base64Cert, this, this.securityFactory);
        this.signers.remove(name);
        this.signerDbEntries.remove(name);
        this.signerDbEntries.put(name, newResponder.getDbEntry());
        this.signers.put(name, newResponder);
        for (String caName : this.scepResponders.keySet()) {
            if (!this.getCa(caName).getScepResponderName().equals(name)) continue;
            this.scepResponders.get(caName).setResponder(newResponder);
        }
    }

    public SignerEntry getSigner(String name) {
        return this.signerDbEntries.get(ParamUtil.requireNonBlankLower((String)"name", (String)name));
    }

    public SignerEntryWrapper getSignerWrapper(String name) {
        return this.signers.get(ParamUtil.requireNonBlankLower((String)"name", (String)name));
    }

    public void addPublisher(PublisherEntry dbEntry) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"dbEntry", (Object)dbEntry);
        this.asssertMasterMode();
        String name = dbEntry.getIdent().getName();
        if (this.publisherDbEntries.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("Publisher named ", name, " exists"));
        }
        dbEntry.setFaulty(true);
        IdentifiedCertPublisher publisher = this.createPublisher(dbEntry);
        dbEntry.setFaulty(false);
        this.queryExecutor.addPublisher(dbEntry);
        this.publishers.put(name, publisher);
        this.idNameMap.addPublisher(dbEntry.getIdent());
        this.publisherDbEntries.put(name, dbEntry);
    }

    public List<PublisherEntry> getPublishersForCa(String caName) {
        Set<String> publisherNames = this.caHasPublishers.get(caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName));
        if (publisherNames == null) {
            return Collections.emptyList();
        }
        ArrayList<PublisherEntry> ret = new ArrayList<PublisherEntry>(publisherNames.size());
        for (String publisherName : publisherNames) {
            ret.add(this.publisherDbEntries.get(publisherName));
        }
        return ret;
    }

    public PublisherEntry getPublisher(String name) {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        return this.publisherDbEntries.get(name);
    }

    public void removePublisher(String name) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        this.asssertMasterMode();
        for (String caName : this.caHasPublishers.keySet()) {
            if (!this.caHasPublishers.get(caName).contains(name)) continue;
            this.removePublisherFromCa(name, caName);
        }
        boolean bo = this.queryExecutor.deleteRowWithName(name, "PUBLISHER");
        if (!bo) {
            throw new CaMgmtException("unknown publisher " + name);
        }
        LOG.info("removed publisher '{}'", (Object)name);
        this.publisherDbEntries.remove(name);
        IdentifiedCertPublisher publisher = this.publishers.remove(name);
        this.shutdownPublisher(publisher);
    }

    public void changePublisher(String name, String type, String conf) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        this.asssertMasterMode();
        if (type == null && conf == null) {
            throw new IllegalArgumentException("nothing to change");
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        IdentifiedCertPublisher publisher = this.queryExecutor.changePublisher(name, type, conf, this);
        IdentifiedCertPublisher oldPublisher = this.publishers.remove(name);
        this.shutdownPublisher(oldPublisher);
        this.publisherDbEntries.put(name, publisher.getDbEntry());
        this.publishers.put(name, publisher);
    }

    public Properties getCaConfProperties() {
        return this.caConfProperties;
    }

    public void setCaConfProperties(Properties caConfProperties) {
        this.caConfProperties = (Properties)ParamUtil.requireNonNull((String)"caConfProperties", (Object)caConfProperties);
    }

    public void setCaConfFile(String caConfFile) {
        ParamUtil.requireNonBlank((String)"caConfFile", (String)caConfFile);
        Properties caConfProps = new Properties();
        try {
            caConfProps.load(new FileInputStream(IoUtil.expandFilepath((String)caConfFile)));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("could not parse CA configuration file " + caConfFile, ex);
        }
        this.caConfProperties = caConfProps;
    }

    public void addCaAlias(String aliasName, String caName) throws CaMgmtException {
        aliasName = ParamUtil.requireNonBlankLower((String)"aliasName", (String)aliasName);
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        X509Ca ca = this.x509cas.get(caName);
        if (ca == null) {
            throw new CaMgmtException("unknown CA " + caName);
        }
        if (this.caAliases.get(aliasName) != null) {
            throw new CaMgmtException("unknown CA alias " + aliasName);
        }
        this.queryExecutor.addCaAlias(aliasName, ca.getCaIdent());
        this.caAliases.put(aliasName, ca.getCaIdent().getId());
    }

    public void removeCaAlias(String name) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        this.asssertMasterMode();
        this.queryExecutor.removeCaAlias(name);
        this.caAliases.remove(name);
    }

    public String getCaNameForAlias(String aliasName) {
        aliasName = ParamUtil.requireNonBlankLower((String)"aliasName", (String)aliasName);
        Integer caId = this.caAliases.get(aliasName);
        for (String name : this.x509cas.keySet()) {
            X509Ca ca = this.x509cas.get(name);
            if (!ca.getCaIdent().getId().equals(caId)) continue;
            return ca.getCaIdent().getName();
        }
        return null;
    }

    public Set<String> getAliasesForCa(String caName) {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        HashSet<String> aliases = new HashSet<String>();
        X509Ca ca = this.x509cas.get(caName);
        if (ca == null) {
            return aliases;
        }
        NameId caIdent = ca.getCaIdent();
        for (String alias : this.caAliases.keySet()) {
            Integer thisCaId = this.caAliases.get(alias);
            if (!caIdent.getId().equals(thisCaId)) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public Set<String> getCaAliasNames() {
        return this.caAliases.keySet();
    }

    public X509Cert getCaCert(String caName) {
        X509Ca ca = this.x509cas.get(caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName));
        return ca == null ? null : ca.getCaInfo().getCert();
    }

    public void removeCa(String name) throws CaMgmtException {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        this.asssertMasterMode();
        this.queryExecutor.removeCa(name);
        LOG.info("removed CA '{}'", (Object)name);
        this.caInfos.remove(name);
        this.idNameMap.removeCa(name);
        this.idNameMap.removeCa(name);
        this.caHasProfiles.remove(name);
        this.caHasPublishers.remove(name);
        this.caHasRequestors.remove(name);
        X509Ca ca = this.x509cas.remove(name);
        this.cmpResponders.remove(name);
        this.scepResponders.remove(name);
        if (ca != null) {
            ca.shutdown();
        }
    }

    public void republishCertificates(String caName, List<String> publisherNames, int numThreads) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireMin((String)"numThreads", (int)numThreads, (int)1);
        this.asssertMasterMode();
        X509Ca ca = this.x509cas.get(caName);
        if (ca == null) {
            throw new CaMgmtException(CaManagerImpl.concat("could not find CA named ", caName));
        }
        if (!ca.republishCerts(publisherNames = CollectionUtil.toLowerCaseList(publisherNames), numThreads)) {
            throw new CaMgmtException(CaManagerImpl.concat("republishing certificates of CA ", caName, " failed"));
        }
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        CrlReason currentReason;
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireNonNull((String)"revocationInfo", (Object)revocationInfo);
        this.asssertMasterMode();
        if (!this.x509cas.containsKey(caName)) {
            throw new CaMgmtException(CaManagerImpl.concat("unkown CA ", caName));
        }
        LOG.info("revoking CA '{}'", (Object)caName);
        X509Ca ca = this.x509cas.get(caName);
        CertRevocationInfo currentRevInfo = ca.getCaInfo().getRevocationInfo();
        if (currentRevInfo != null && (currentReason = currentRevInfo.getReason()) != CrlReason.CERTIFICATE_HOLD) {
            throw new CaMgmtException(CaManagerImpl.concat("CA ", caName, " has been revoked with reason ", currentReason.name()));
        }
        this.queryExecutor.revokeCa(caName, revocationInfo);
        try {
            ca.revokeCa(revocationInfo, "ca_mgmt");
        }
        catch (OperationException ex) {
            throw new CaMgmtException(CaManagerImpl.concat("could not revoke CA ", ex.getMessage()), (Throwable)ex);
        }
        LOG.info("revoked CA '{}'", (Object)caName);
        this.auditLogPciEvent(true, CaManagerImpl.concat("REVOKE CA ", caName));
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        this.asssertMasterMode();
        if (!this.x509cas.containsKey(caName)) {
            throw new CaMgmtException(CaManagerImpl.concat("could not find CA named ", caName));
        }
        LOG.info("unrevoking of CA '{}'", (Object)caName);
        this.queryExecutor.unrevokeCa(caName);
        X509Ca ca = this.x509cas.get(caName);
        try {
            ca.unrevokeCa("ca_mgmt");
        }
        catch (OperationException ex) {
            throw new CaMgmtException(CaManagerImpl.concat("could not unrevoke CA " + caName + ": ", ex.getMessage()), (Throwable)ex);
        }
        LOG.info("unrevoked CA '{}'", (Object)caName);
        this.auditLogPciEvent(true, CaManagerImpl.concat("UNREVOKE CA ", caName));
    }

    public void setCertprofileFactoryRegister(CertprofileFactoryRegister register) {
        this.certprofileFactoryRegister = register;
    }

    public void setCertPublisherFactoryRegister(CertPublisherFactoryRegister register) {
        this.certPublisherFactoryRegister = register;
    }

    public void setAuditServiceRegister(AuditServiceRegister register) {
        this.auditServiceRegister = (AuditServiceRegister)ParamUtil.requireNonNull((String)"serviceRegister", (Object)register);
        for (String name : this.publishers.keySet()) {
            IdentifiedCertPublisher publisherEntry = this.publishers.get(name);
            publisherEntry.setAuditServiceRegister(register);
        }
        for (String name : this.x509cas.keySet()) {
            X509Ca ca = this.x509cas.get(name);
            ca.setAuditServiceRegister(register);
        }
    }

    private void auditLogPciEvent(boolean successful, String eventType) {
        PciAuditEvent event = new PciAuditEvent(new Date());
        event.setUserId("CA-SYSTEM");
        event.setEventType(eventType);
        event.setAffectedResource("CORE");
        if (successful) {
            event.setStatus(AuditStatus.SUCCESSFUL.name());
            event.setLevel(AuditLevel.INFO);
        } else {
            event.setStatus(AuditStatus.FAILED.name());
            event.setLevel(AuditLevel.ERROR);
        }
        this.auditServiceRegister.getAuditService().logEvent(event);
    }

    public void clearPublishQueue(String caName, List<String> publisherNames) throws CaMgmtException {
        this.asssertMasterMode();
        publisherNames = CollectionUtil.toLowerCaseList(publisherNames);
        if (caName == null) {
            if (CollectionUtil.isNonEmpty((Collection)publisherNames)) {
                throw new IllegalArgumentException("non-empty publisherNames is not allowed");
            }
            try {
                this.certstore.clearPublishQueue(null, null);
            }
            catch (OperationException ex) {
                throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        X509Ca ca = this.x509cas.get(caName = caName.toLowerCase());
        if (ca == null) {
            throw new CaMgmtException(CaManagerImpl.concat("could not find CA named ", caName));
        }
        ca.clearPublishQueue(publisherNames);
    }

    private void shutdownScheduledThreadPoolExecutor() {
        if (this.scheduledThreadPoolExecutor == null) {
            return;
        }
        this.scheduledThreadPoolExecutor.shutdown();
        while (!this.scheduledThreadPoolExecutor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOG.error("interrupted: {}", (Object)ex.getMessage());
            }
        }
        this.scheduledThreadPoolExecutor = null;
    }

    public void revokeCertificate(String caName, BigInteger serialNumber, CrlReason reason, Date invalidityTime) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireNonNull((String)"serialNumber", (Object)serialNumber);
        this.asssertMasterMode();
        X509Ca ca = this.getX509Ca(caName);
        try {
            if (ca.revokeCert(serialNumber, reason, invalidityTime, "ca_mgmt") == null) {
                throw new CaMgmtException("could not revoke non-existing certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void unrevokeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireNonNull((String)"serialNumber", (Object)serialNumber);
        X509Ca ca = this.getX509Ca(caName);
        try {
            if (ca.unrevokeCert(serialNumber, "ca_mgmt") == null) {
                throw new CaMgmtException("could not unrevoke non-existing certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void removeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireNonNull((String)"serialNumber", (Object)serialNumber);
        this.asssertMasterMode();
        X509Ca ca = this.getX509Ca(caName);
        if (ca == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown CA ", caName));
        }
        try {
            if (ca.removeCert(serialNumber, "ca_mgmt") == null) {
                throw new CaMgmtException("could not remove certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public X509Certificate generateCertificate(String caName, String profileName, byte[] encodedCsr, Date notBefore, Date notAfter) throws CaMgmtException {
        CertificateInfo certInfo;
        CertificationRequest csr;
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        profileName = ParamUtil.requireNonBlankLower((String)"profileName", (String)profileName);
        ParamUtil.requireNonNull((String)"encodedCsr", (Object)encodedCsr);
        AuditEvent event = new AuditEvent(new Date());
        event.setApplicationName("ca");
        event.setName("perf");
        event.addEventType("CAMGMT_CRL_GEN_ONDEMAND");
        X509Ca ca = this.getX509Ca(caName);
        try {
            csr = X509Util.parseCsr((byte[])encodedCsr);
        }
        catch (Exception ex) {
            throw new CaMgmtException(CaManagerImpl.concat("invalid CSR request. ERROR: ", ex.getMessage()));
        }
        CmpControl cmpControl = ca.getCaInfo().getCmpControl();
        if (!this.securityFactory.verifyPopo(csr, cmpControl.getPopoAlgoValidator())) {
            throw new CaMgmtException("could not validate POP for the CSR");
        }
        CertificationRequestInfo certTemp = csr.getCertificationRequestInfo();
        Extensions extensions = null;
        ASN1Set attrs = certTemp.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((Object)attr.getAttrType())) continue;
            extensions = Extensions.getInstance((Object)attr.getAttributeValues()[0]);
        }
        X500Name subject = certTemp.getSubject();
        SubjectPublicKeyInfo publicKeyInfo = certTemp.getSubjectPublicKeyInfo();
        CertTemplateData certTemplateData = new CertTemplateData(subject, publicKeyInfo, notBefore, notAfter, extensions, profileName);
        try {
            certInfo = ca.generateCert(certTemplateData, (RequestorInfo)this.byCaRequestor, RequestType.CA, (byte[])null, "ca_mgmt");
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        if (ca.getCaInfo().isSaveRequest()) {
            try {
                long dbId = ca.addRequest(encodedCsr);
                ca.addRequestCert(dbId, certInfo.getCert().getCertId());
            }
            catch (OperationException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not save request");
            }
        }
        return certInfo.getCert().getCert();
    }

    public X509Ca getX509Ca(String name) throws CaMgmtException {
        X509Ca ca = this.x509cas.get(name = ParamUtil.requireNonBlankLower((String)"name", (String)name));
        if (ca == null) {
            throw new CaMgmtException("unknown CA " + name);
        }
        return ca;
    }

    public X509Ca getX509Ca(NameId ident) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"ident", (Object)ident);
        X509Ca ca = this.x509cas.get(ident.getName());
        if (ca == null) {
            throw new CaMgmtException("unknown CA " + ident);
        }
        return ca;
    }

    public IdentifiedCertprofile getIdentifiedCertprofile(String profileName) {
        profileName = ParamUtil.requireNonBlankLower((String)"profileName", (String)profileName);
        return this.certprofiles.get(profileName);
    }

    public List<IdentifiedCertPublisher> getIdentifiedPublishersForCa(String caName) {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        LinkedList<IdentifiedCertPublisher> ret = new LinkedList<IdentifiedCertPublisher>();
        Set<String> publisherNames = this.caHasPublishers.get(caName);
        if (publisherNames == null) {
            return ret;
        }
        for (String publisherName : publisherNames) {
            IdentifiedCertPublisher publisher = this.publishers.get(publisherName);
            ret.add(publisher);
        }
        return ret;
    }

    public X509Certificate generateRootCa(CaEntry caEntry, String profileName, byte[] encodedCsr, BigInteger serialNumber) throws CaMgmtException {
        SelfSignedCertBuilder.GenerateSelfSignedResult result;
        CertificationRequest csr;
        ParamUtil.requireNonNull((String)"caEntry", (Object)caEntry);
        profileName = ParamUtil.requireNonBlankLower((String)"profileName", (String)profileName);
        ParamUtil.requireNonNull((String)"encodedCsr", (Object)encodedCsr);
        int numCrls = caEntry.getNumCrls();
        String signerType = caEntry.getSignerType();
        this.asssertMasterMode();
        if (numCrls < 0) {
            System.err.println("invalid numCrls: " + numCrls);
            return null;
        }
        int expirationPeriod = caEntry.getExpirationPeriod();
        if (expirationPeriod < 0) {
            System.err.println("invalid expirationPeriod: " + expirationPeriod);
            return null;
        }
        try {
            csr = X509Util.parseCsr((byte[])encodedCsr);
        }
        catch (Exception ex) {
            System.err.println("invalid encodedCsr");
            return null;
        }
        IdentifiedCertprofile certprofile = this.getIdentifiedCertprofile(profileName);
        if (certprofile == null) {
            throw new CaMgmtException(CaManagerImpl.concat("unknown certprofile ", profileName));
        }
        BigInteger serialOfThisCert = serialNumber != null ? serialNumber : RandomSerialNumberGenerator.getInstance().nextSerialNumber(caEntry.getSerialNoBitLen());
        try {
            result = SelfSignedCertBuilder.generateSelfSigned(this.securityFactory, signerType, caEntry.getSignerConf(), certprofile, csr, serialOfThisCert, caEntry.getCaUris(), caEntry.getExtraControl());
        }
        catch (OperationException | InvalidConfException ex) {
            throw new CaMgmtException(CaManagerImpl.concat(ex.getClass().getName(), ": ", ex.getMessage()), ex);
        }
        String signerConf = result.getSignerConf();
        X509Certificate caCert = result.getCert();
        if ("PKCS12".equalsIgnoreCase(signerType) || "JKS".equalsIgnoreCase(signerType)) {
            try {
                signerConf = CaManagerImpl.canonicalizeSignerConf(signerType, signerConf, new X509Certificate[]{caCert}, this.securityFactory);
            }
            catch (Exception ex) {
                throw new CaMgmtException(CaManagerImpl.concat(ex.getClass().getName(), ": ", ex.getMessage()), (Throwable)ex);
            }
        }
        String name = caEntry.getIdent().getName();
        long nextCrlNumber = caEntry.getNextCrlNumber();
        CaEntry entry = new CaEntry(new NameId(null, name), caEntry.getSerialNoBitLen(), nextCrlNumber, signerType, signerConf, caEntry.getCaUris(), numCrls, expirationPeriod);
        entry.setCert(caCert);
        entry.setCmpControl(caEntry.getCmpControl());
        entry.setCrlControl(caEntry.getCrlControl());
        entry.setScepControl(caEntry.getScepControl());
        entry.setCmpResponderName(caEntry.getCmpResponderName());
        entry.setScepResponderName(caEntry.getScepResponderName());
        entry.setCrlSignerName(caEntry.getCrlSignerName());
        entry.setDuplicateKeyPermitted(caEntry.isDuplicateKeyPermitted());
        entry.setDuplicateSubjectPermitted(caEntry.isDuplicateSubjectPermitted());
        entry.setExtraControl(caEntry.getExtraControl());
        entry.setKeepExpiredCertInDays(caEntry.getKeepExpiredCertInDays());
        entry.setMaxValidity(caEntry.getMaxValidity());
        entry.setPermission(caEntry.getPermission());
        entry.setProtocolSupport(caEntry.getProtocoSupport());
        entry.setSaveRequest(caEntry.isSaveRequest());
        entry.setStatus(caEntry.getStatus());
        entry.setValidityMode(caEntry.getValidityMode());
        this.addCa(entry);
        return caCert;
    }

    private void asssertMasterMode() throws CaMgmtException {
        if (!this.masterMode) {
            throw new CaMgmtException("operation not allowed in slave mode");
        }
    }

    void shutdownCertprofile(IdentifiedCertprofile profile) {
        if (profile == null) {
            return;
        }
        try {
            profile.shutdown();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not shutdown Certprofile " + profile.getIdent()));
        }
    }

    void shutdownPublisher(IdentifiedCertPublisher publisher) {
        if (publisher == null) {
            return;
        }
        try {
            publisher.shutdown();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not shutdown CertPublisher " + publisher.getIdent()));
        }
    }

    SignerEntryWrapper createSigner(SignerEntry dbEntry) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"dbEntry", (Object)dbEntry);
        SignerEntryWrapper ret = new SignerEntryWrapper();
        ret.setDbEntry(dbEntry);
        try {
            ret.initSigner(this.securityFactory);
        }
        catch (ObjectCreationException ex) {
            String message = "createSigner";
            LOG.debug("createSigner", (Throwable)ex);
            throw new CaMgmtException(ex.getMessage());
        }
        return ret;
    }

    IdentifiedCertprofile createCertprofile(CertprofileEntry dbEntry) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"dbEntry", (Object)dbEntry);
        String type = dbEntry.getType();
        if (!this.certprofileFactoryRegister.canCreateProfile(type)) {
            throw new CaMgmtException("unsupported cert profile type " + type);
        }
        try {
            Certprofile profile = this.certprofileFactoryRegister.newCertprofile(type);
            IdentifiedCertprofile ret = new IdentifiedCertprofile(dbEntry, profile);
            ret.validate();
            return ret;
        }
        catch (CertprofileException | ObjectCreationException ex) {
            String msg = "could not initialize Certprofile " + dbEntry.getIdent();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new CaMgmtException(msg, ex);
        }
    }

    IdentifiedCertPublisher createPublisher(PublisherEntry dbEntry) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"dbEntry", (Object)dbEntry);
        String type = dbEntry.getType();
        try {
            if (!this.certPublisherFactoryRegister.canCreatePublisher(type)) {
                throw new CaMgmtException("unsupported publisher type " + type);
            }
            CertPublisher publisher = this.certPublisherFactoryRegister.newPublisher(type);
            IdentifiedCertPublisher ret = new IdentifiedCertPublisher(dbEntry, publisher);
            ret.initialize(this.securityFactory.getPasswordResolver(), this.datasources);
            return ret;
        }
        catch (RuntimeException | CertPublisherException | ObjectCreationException ex) {
            String msg = "invalid configuration for the publisher " + dbEntry.getIdent();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new CaMgmtException(msg, ex);
        }
    }

    public void addUser(AddUserEntry userEntry) throws CaMgmtException {
        this.asssertMasterMode();
        this.queryExecutor.addUser(userEntry);
    }

    public void changeUser(ChangeUserEntry userEntry) throws CaMgmtException {
        this.asssertMasterMode();
        this.queryExecutor.changeUser(userEntry);
    }

    public void removeUser(String username) throws CaMgmtException {
        username = ParamUtil.requireNonBlankLower((String)"username", (String)username);
        this.asssertMasterMode();
        if (!this.queryExecutor.deleteRowWithName(username, "TUSER")) {
            throw new CaMgmtException("unknown user " + username);
        }
    }

    public UserEntry getUser(String username) throws CaMgmtException {
        return this.queryExecutor.getUser(username.toLowerCase());
    }

    CaIdNameMap idNameMap() {
        return this.idNameMap;
    }

    public X509CRL generateCrlOnDemand(String caName) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.generateCrlOnDemand("ca_mgmt");
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public X509CRL getCrl(String caName, BigInteger crlNumber) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireNonNull((String)"crlNumber", (Object)crlNumber);
        X509Ca ca = this.getX509Ca(caName);
        try {
            X509CRL crl = ca.getCrl(crlNumber);
            if (crl == null) {
                LOG.warn("found no CRL for CA {} and crlNumber {}", (Object)caName, (Object)crlNumber);
            }
            return crl;
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public X509CRL getCurrentCrl(String caName) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        X509Ca ca = this.getX509Ca(caName);
        try {
            X509CRL crl = ca.getCurrentCrl();
            if (crl == null) {
                LOG.warn("found no CRL for CA {}", (Object)caName);
            }
            return crl;
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public ScepResponder getScepResponder(String name) {
        name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        return this.scepResponders == null ? null : (ScepResponder)this.scepResponders.get(name);
    }

    static String canonicalizeSignerConf(String keystoreType, String signerConf, X509Certificate[] certChain, SecurityFactory securityFactory) throws CaMgmtException {
        byte[] ksBytes;
        if (!signerConf.contains("file:") && !signerConf.contains("base64:")) {
            return signerConf;
        }
        ConfPairs pairs = new ConfPairs(signerConf);
        String algo = pairs.value("algo");
        if (algo != null) {
            try {
                algo = AlgorithmUtil.canonicalizeSignatureAlgo((String)algo);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CaMgmtException("Unknown signature algo: " + ex.getMessage(), (Throwable)ex);
            }
            pairs.putPair("algo", algo);
        }
        String keystoreConf = pairs.value("keystore");
        String passwordHint = pairs.value("password");
        String keyLabel = pairs.value("key-label");
        if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"file:")) {
            String keystoreFile = keystoreConf.substring("file:".length());
            try {
                ksBytes = IoUtil.read((String)keystoreFile);
            }
            catch (IOException ex) {
                throw new CaMgmtException("IOException: " + ex.getMessage(), (Throwable)ex);
            }
        } else if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"base64:")) {
            ksBytes = Base64.decode((String)keystoreConf.substring("base64:".length()));
        } else {
            return signerConf;
        }
        try {
            char[] password = securityFactory.getPasswordResolver().resolvePassword(passwordHint);
            ksBytes = securityFactory.extractMinimalKeyStore(keystoreType, ksBytes, keyLabel, password, certChain);
        }
        catch (KeyStoreException ex) {
            throw new CaMgmtException("KeyStoreException: " + ex.getMessage(), (Throwable)ex);
        }
        catch (PasswordResolverException ex) {
            throw new CaMgmtException("PasswordResolverException: " + ex.getMessage(), (Throwable)ex);
        }
        pairs.putPair("keystore", "base64:" + Base64.encodeToString((byte[])ksBytes));
        return pairs.getEncoded();
    }

    public CertWithRevocationInfo getCert(String caName, BigInteger serialNumber) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireNonNull((String)"serialNumber", (Object)serialNumber);
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.getCertWithRevocationInfo(serialNumber);
        }
        catch (CertificateException | OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), ex);
        }
    }

    public CertWithRevocationInfo getCert(X500Name issuer, BigInteger serialNumber) throws CaMgmtException {
        ParamUtil.requireNonNull((String)"issuer", (Object)issuer);
        ParamUtil.requireNonNull((String)"serialNumber", (Object)serialNumber);
        NameId caId = null;
        for (String name : this.caInfos.keySet()) {
            CaInfo ca = this.caInfos.get(name);
            if (!issuer.equals((Object)this.caInfos.get(name).getCert().getSubjectAsX500Name())) continue;
            caId = ca.getIdent();
            break;
        }
        if (caId == null) {
            return null;
        }
        try {
            return this.certstore.getCertWithRevocationInfo(caId.getId(), serialNumber, this.idNameMap);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public byte[] getCertRequest(String caName, BigInteger serialNumber) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireNonNull((String)"serialNumber", (Object)serialNumber);
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.getCertRequest(serialNumber);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<CertListInfo> listCertificates(String caName, X500Name subjectPattern, Date validFrom, Date validTo, CertListOrderBy orderBy, int numEntries) throws CaMgmtException {
        caName = ParamUtil.requireNonBlankLower((String)"caName", (String)caName);
        ParamUtil.requireRange((String)"numEntries", (int)numEntries, (int)1, (int)1000);
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.listCerts(subjectPattern, validFrom, validTo, orderBy, numEntries);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadConf(CaConf conf) throws CaMgmtException {
        RequestorEntry entryB;
        RequestorEntry entry;
        ParamUtil.requireNonNull((String)"conf", (Object)conf);
        if (!this.caSystemSetuped) {
            throw new CaMgmtException("CA system is not initialized yet.");
        }
        for (String name : conf.getSignerNames()) {
            SignerEntry entry2 = conf.getSigner(name);
            SignerEntry entryB2 = this.signerDbEntries.get(name);
            if (entryB2 != null) {
                if (!entry2.equals((Object)entryB2)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("signer ", name, " existed, could not re-added it"));
                LOG.info("ignore existed signer {}", (Object)name);
                continue;
            }
            try {
                this.addSigner(entry2);
                LOG.info("added signer {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = CaManagerImpl.concat("could not add signer ", name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        boolean ignoreId = true;
        for (String name : conf.getRequestorNames()) {
            entry = conf.getRequestor(name);
            entryB = this.requestorDbEntries.get(name);
            if (entryB != null) {
                if (!entry.equals(entryB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("CMP requestor ", name, " existed, could not re-added it"));
                LOG.info("ignore existed CMP requestor {}", (Object)name);
                continue;
            }
            try {
                this.addRequestor(entry);
                LOG.info("added CMP requestor {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = CaManagerImpl.concat("could not add CMP requestor ", name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getPublisherNames()) {
            entry = conf.getPublisher(name);
            entryB = this.publisherDbEntries.get(name);
            if (entryB != null) {
                if (!entry.equals((PublisherEntry)entryB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("publisher ", name, " existed, could not re-added it"));
                LOG.info("ignore existed publisher {}", (Object)name);
                continue;
            }
            try {
                this.addPublisher((PublisherEntry)entry);
                LOG.info("added publisher {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = "could not add publisher " + name;
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getCertprofileNames()) {
            entry = conf.getCertprofile(name);
            entryB = this.certprofileDbEntries.get(name);
            if (entryB != null) {
                if (!entry.equals((CertprofileEntry)entryB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("certprofile ", name, " existed, could not re-added it"));
                LOG.info("ignore existed certprofile {}", (Object)name);
                continue;
            }
            try {
                this.addCertprofile((CertprofileEntry)entry);
                LOG.info("added certprofile {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = CaManagerImpl.concat("could not add certprofile ", name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getUserNames()) {
            Object obj = conf.getUser(name);
            entryB = this.queryExecutor.getUser(name, true);
            if (entryB != null) {
                UserEntry entry3;
                boolean equals = false;
                if (obj instanceof UserEntry) {
                    entry3 = (UserEntry)obj;
                    equals = entry3.equals((UserEntry)entryB, true);
                } else {
                    entry3 = (AddUserEntry)obj;
                    equals = PasswordHash.validatePassword(entry3.getPassword(), entryB.getHashedPassword());
                }
                if (!equals) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("user ", name, " existed, could not re-added it"));
                LOG.info("ignore existed user {}", (Object)name);
                continue;
            }
            try {
                if (obj instanceof UserEntry) {
                    this.queryExecutor.addUser((UserEntry)obj);
                } else {
                    this.queryExecutor.addUser((AddUserEntry)obj);
                }
                LOG.info("added user {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = CaManagerImpl.concat("could not add user ", name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String caName : conf.getCaNames()) {
            String msg;
            SingleCaConf scc = conf.getCa(caName);
            GenSelfIssued genSelfIssued = scc.getGenSelfIssued();
            CaEntry caEntry = scc.getCaEntry();
            if (caEntry != null) {
                if (this.caInfos.containsKey(caName)) {
                    CaEntry entryB3 = this.caInfos.get(caName).getCaEntry();
                    if (caEntry.getCert() == null && genSelfIssued != null) {
                        ConcurrentContentSigner signer;
                        SignerConf signerConf = new SignerConf(caEntry.getSignerConf());
                        try {
                            signer = this.securityFactory.createSigner(caEntry.getSignerType(), signerConf, (X509Certificate)null);
                        }
                        catch (ObjectCreationException ex) {
                            throw new CaMgmtException(CaManagerImpl.concat("could not create signer for CA ", caName), (Throwable)ex);
                        }
                        caEntry.setCert(signer.getCertificate());
                    }
                    if (!caEntry.equals(entryB3, true, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("CA ", caName, " existed, could not re-added it"));
                    LOG.info("ignore existed CA {}", (Object)caName);
                } else if (genSelfIssued != null) {
                    X509Certificate cert = this.generateRootCa(caEntry, genSelfIssued.getProfile(), genSelfIssued.getCsr(), genSelfIssued.getSerialNumber());
                    LOG.info("generated root CA {}", (Object)caName);
                    String fn = genSelfIssued.getCertFilename();
                    if (fn != null) {
                        try {
                            byte[] encodedCert = cert.getEncoded();
                            if ("pem".equalsIgnoreCase(genSelfIssued.getCertOutputFormat())) {
                                encodedCert = PemEncoder.encode((byte[])encodedCert, (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE);
                            }
                            IoUtil.save((String)fn, (byte[])encodedCert);
                            LOG.info("saved generated certificate of root CA {} to {}", (Object)caName, (Object)fn);
                        }
                        catch (CertificateEncodingException ex) {
                            LogUtil.error((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("could not encode certificate of CA ", caName));
                        }
                        catch (IOException ex) {
                            LogUtil.error((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("error while saving certificate of root CA ", caName, " to ", fn));
                        }
                    }
                } else {
                    try {
                        this.addCa(caEntry);
                        LOG.info("added CA {}", (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        String msg2 = CaManagerImpl.concat("could not add CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg2);
                        throw new CaMgmtException(msg2);
                    }
                }
            }
            if (scc.getAliases() != null) {
                Set<String> aliasesB = this.getAliasesForCa(caName);
                for (String aliasName : scc.getAliases()) {
                    if (aliasesB != null && aliasesB.contains(aliasName)) {
                        LOG.info("ignored adding existing CA alias {} to CA {}", (Object)aliasName, (Object)caName);
                        continue;
                    }
                    try {
                        this.addCaAlias(aliasName, caName);
                        LOG.info("associated alias {} to CA {}", (Object)aliasName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = CaManagerImpl.concat("could not associate alias ", aliasName, " to CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getProfileNames() != null) {
                Set<String> profilesB = this.caHasProfiles.get(caName);
                for (String profileName : scc.getProfileNames()) {
                    if (profilesB != null && profilesB.contains(profileName)) {
                        LOG.info("ignored adding certprofile {} to CA {}", (Object)profileName, (Object)caName);
                        continue;
                    }
                    try {
                        this.addCertprofileToCa(profileName, caName);
                        LOG.info("added certprofile {} to CA {}", (Object)profileName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = CaManagerImpl.concat("could not add certprofile ", profileName, " to CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getPublisherNames() != null) {
                Set<String> publishersB = this.caHasPublishers.get(caName);
                for (String publisherName : scc.getPublisherNames()) {
                    if (publishersB != null && publishersB.contains(publisherName)) {
                        LOG.info("ignored adding publisher {} to CA {}", (Object)publisherName, (Object)caName);
                        continue;
                    }
                    try {
                        this.addPublisherToCa(publisherName, caName);
                        LOG.info("added publisher {} to CA {}", (Object)publisherName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = CaManagerImpl.concat("could not add publisher ", publisherName, " to CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getRequestors() != null) {
                Set<CaHasRequestorEntry> requestorsB = this.caHasRequestors.get(caName);
                for (CaHasRequestorEntry requestor : scc.getRequestors()) {
                    String requestorName = requestor.getRequestorIdent().getName();
                    CaHasRequestorEntry requestorB = null;
                    if (requestorsB != null) {
                        for (CaHasRequestorEntry caHasRequestorEntry : requestorsB) {
                            if (!caHasRequestorEntry.getRequestorIdent().getName().equals(requestorName)) continue;
                            requestorB = caHasRequestorEntry;
                            break;
                        }
                    }
                    if (requestorB != null) {
                        if (!requestor.equals(requestorB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("could not add requestor ", requestorName, " to CA", caName));
                        LOG.info("ignored adding requestor {} to CA {}", (Object)requestorName, (Object)caName);
                        continue;
                    }
                    try {
                        this.addRequestorToCa(requestor, caName);
                        LOG.info("added publisher {} to CA {}", (Object)requestorName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        String string = CaManagerImpl.concat("could not add requestor ", requestorName, " to CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)string);
                        throw new CaMgmtException(string);
                    }
                }
            }
            if (scc.getUsers() == null) continue;
            List<CaHasUserEntry> usersB = this.queryExecutor.getCaHasUsersForCa(caName, this.idNameMap);
            for (CaHasUserEntry user : scc.getUsers()) {
                String userName = user.getUserIdent().getName();
                CaHasUserEntry userB = null;
                if (usersB != null) {
                    for (CaHasUserEntry caHasUserEntry : usersB) {
                        if (!caHasUserEntry.getUserIdent().getName().equals(userName)) continue;
                        userB = caHasUserEntry;
                        break;
                    }
                }
                if (userB != null) {
                    if (!user.equals(userB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("could not add user ", userName, " to CA", caName));
                    LOG.info("ignored adding user {} to CA {}", (Object)userName, (Object)caName);
                    continue;
                }
                try {
                    this.addUserToCa(user, caName);
                    LOG.info("added user {} to CA {}", (Object)userName, (Object)caName);
                }
                catch (CaMgmtException ex) {
                    String string = CaManagerImpl.concat("could not add user ", userName, " to CA ", caName);
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)string);
                    throw new CaMgmtException(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportConf(String zipFilename, List<String> caNames) throws CaMgmtException, IOException {
        ArrayList<String> tmpCaNames;
        ParamUtil.requireNonBlank((String)"zipFilename", (String)zipFilename);
        if (!this.caSystemSetuped) {
            throw new CaMgmtException("CA system is not initialized yet.");
        }
        zipFilename = IoUtil.expandFilepath((String)zipFilename);
        if (caNames != null) {
            tmpCaNames = new ArrayList<String>(caNames.size());
            for (String name : caNames) {
                if (!this.x509cas.containsKey(name = name.toLowerCase())) continue;
                tmpCaNames.add(name);
            }
            caNames = tmpCaNames;
        } else {
            tmpCaNames = new ArrayList(this.x509cas.size());
            for (String name : this.x509cas.keySet()) {
                tmpCaNames.add(name);
            }
            caNames = tmpCaNames;
        }
        File zipFile = new File(zipFilename);
        if (zipFile.exists()) {
            throw new IOException(CaManagerImpl.concat("File ", zipFilename, " exists."));
        }
        File parentFile = zipFile.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        CaconfType root = new CaconfType();
        try (ZipOutputStream zipStream = CaManagerImpl.getZipOutputStream(zipFile);){
            RequestorType jaxb;
            RequestorEntry entry;
            LinkedList<Object> list;
            HashSet<String> includeSignerNames = new HashSet<String>();
            HashSet<String> includeRequestorNames = new HashSet<String>();
            HashSet<String> includeProfileNames = new HashSet<String>();
            HashSet<String> includePublisherNames = new HashSet<String>();
            HashSet<String> includeCrlSignerNames = new HashSet<String>();
            HashSet<String> includeUserNames = new HashSet<String>();
            root.setUsers(new CaconfType.Users());
            List users = root.getUsers().getUser();
            if (CollectionUtil.isNonEmpty(caNames)) {
                list = new LinkedList<Object>();
                for (String name : this.x509cas.keySet()) {
                    CaUris caUris;
                    byte[] certBytes;
                    List<CaHasUserEntry> caHasUsers;
                    Set<CaHasRequestorEntry> requestors;
                    AliasesType type;
                    if (!caNames.contains(name)) continue;
                    CaType jaxb2 = new CaType();
                    jaxb2.setName(name);
                    Set<String> strs = this.getAliasesForCa(name);
                    if (CollectionUtil.isNonEmpty(strs)) {
                        type = new AliasesType();
                        for (String str : strs) {
                            type.getAlias().add(str);
                        }
                        jaxb2.setAliases(type);
                    }
                    if (CollectionUtil.isNonEmpty(strs = this.caHasProfiles.get(name))) {
                        includeProfileNames.addAll(strs);
                        jaxb2.setProfiles(CaManagerImpl.createProfiles(strs));
                    }
                    if (CollectionUtil.isNonEmpty(strs = this.caHasPublishers.get(name))) {
                        includePublisherNames.addAll(strs);
                        type = new PublishersType();
                        for (String str : strs) {
                            type.getPublisher().add(str);
                        }
                        jaxb2.setPublishers((PublishersType)type);
                    }
                    if (CollectionUtil.isNonEmpty(requestors = this.caHasRequestors.get(name))) {
                        jaxb2.setRequestors(new CaType.Requestors());
                        for (CaHasRequestorEntry m : requestors) {
                            String requestorName = m.getRequestorIdent().getName();
                            includeRequestorNames.add(requestorName);
                            CaHasRequestorType jaxb22 = new CaHasRequestorType();
                            jaxb22.setRequestorName(requestorName);
                            jaxb22.setRa(m.isRa());
                            jaxb22.setProfiles(CaManagerImpl.createProfiles(m.getProfiles()));
                            jaxb22.setPermissions(CaManagerImpl.getPermissions(m.getPermission()));
                            jaxb2.getRequestors().getRequestor().add(jaxb22);
                        }
                    }
                    if (CollectionUtil.isNonEmpty(caHasUsers = this.queryExecutor.getCaHasUsersForCa(name, this.idNameMap))) {
                        jaxb2.setUsers(new CaType.Users());
                        List list2 = jaxb2.getUsers().getUser();
                        for (CaHasUserEntry m : caHasUsers) {
                            String username = m.getUserIdent().getName();
                            CaHasUserType jaxb23 = new CaHasUserType();
                            jaxb23.setUserName(username);
                            jaxb23.setPermissions(CaManagerImpl.getPermissions(m.getPermission()));
                            jaxb23.setProfiles(CaManagerImpl.createProfiles(m.getProfiles()));
                            list2.add(jaxb23);
                            if (includeUserNames.contains(username)) continue;
                            UserEntry userEntry = this.queryExecutor.getUser(username);
                            UserType jaxb3 = new UserType();
                            if (!userEntry.isActive()) {
                                jaxb3.setActive(Boolean.FALSE);
                            }
                            jaxb3.setName(username);
                            jaxb3.setHashedPassword(userEntry.getHashedPassword());
                            users.add(jaxb3);
                            includeUserNames.add(username);
                        }
                    }
                    CaEntry entry2 = this.x509cas.get(name).getCaInfo().getCaEntry();
                    CaInfoType ciJaxb = new CaInfoType();
                    try {
                        certBytes = entry2.getCert().getEncoded();
                    }
                    catch (CertificateEncodingException ex) {
                        throw new CaMgmtException(CaManagerImpl.concat("could not encode CA certificate ", name));
                    }
                    ciJaxb.setCert(CaManagerImpl.createFileOrBinary(zipStream, certBytes, CaManagerImpl.concat("files/ca-", name, "-cert.der")));
                    if (entry2.getCrlSignerName() != null) {
                        includeCrlSignerNames.add(entry2.getCrlSignerName());
                        ciJaxb.setCrlSignerName(entry2.getCrlSignerName());
                    }
                    if (entry2.getCmpResponderName() != null) {
                        includeSignerNames.add(entry2.getCmpResponderName());
                        ciJaxb.setCmpResponderName(entry2.getCmpResponderName());
                    }
                    if (entry2.getScepResponderName() != null) {
                        includeSignerNames.add(entry2.getScepResponderName());
                        ciJaxb.setScepResponderName(entry2.getScepResponderName());
                    }
                    if (entry2.getCmpControl() != null) {
                        ciJaxb.setCmpControl(entry2.getCmpControl().getConf());
                    }
                    if (entry2.getCrlControl() != null) {
                        ciJaxb.setCrlControl(entry2.getCrlControl().getConf());
                    }
                    if (entry2.getScepControl() != null) {
                        ciJaxb.setScepControl(entry2.getScepControl().getConf());
                    }
                    if ((caUris = entry2.getCaUris()) != null) {
                        CaUrisType caUrisType = new CaUrisType();
                        caUrisType.setCacertUris(CaManagerImpl.createUris(caUris.getCacertUris()));
                        caUrisType.setOcspUris(CaManagerImpl.createUris(caUris.getOcspUris()));
                        caUrisType.setCrlUris(CaManagerImpl.createUris(caUris.getCrlUris()));
                        caUrisType.setDeltacrlUris(CaManagerImpl.createUris(caUris.getDeltaCrlUris()));
                        ciJaxb.setCaUris(caUrisType);
                    }
                    ciJaxb.setDuplicateKey(entry2.isDuplicateKeyPermitted());
                    ciJaxb.setDuplicateSubject(entry2.isDuplicateSubjectPermitted());
                    ciJaxb.setExpirationPeriod(Integer.valueOf(entry2.getExpirationPeriod()));
                    if (entry2.getExtraControl() != null) {
                        ciJaxb.setExtraControl(CaManagerImpl.createFileOrValue(zipStream, entry2.getExtraControl().getEncoded(), CaManagerImpl.concat("files/ca-", name, "-extracontrol.conf")));
                    }
                    ciJaxb.setKeepExpiredCertDays(Integer.valueOf(entry2.getKeepExpiredCertInDays()));
                    ciJaxb.setMaxValidity(entry2.getMaxValidity().toString());
                    ciJaxb.setNextCrlNo(entry2.getNextCrlNumber());
                    ciJaxb.setNumCrls(Integer.valueOf(entry2.getNumCrls()));
                    ciJaxb.setPermissions(CaManagerImpl.getPermissions(entry2.getPermission()));
                    ciJaxb.setSaveReq(entry2.isSaveRequest());
                    ciJaxb.setSignerConf(CaManagerImpl.createFileOrValue(zipStream, entry2.getSignerConf(), CaManagerImpl.concat("files/ca-", name, "-signerconf.conf")));
                    ciJaxb.setSignerType(entry2.getSignerType());
                    ciJaxb.setSnSize(entry2.getSerialNoBitLen());
                    ciJaxb.setStatus(entry2.getStatus().getStatus());
                    ciJaxb.setValidityMode(entry2.getValidityMode().name());
                    ciJaxb.setProtocolSupport(entry2.getProtocoSupport().getEncoded());
                    jaxb2.setCaInfo(ciJaxb);
                    list.add(jaxb2);
                }
                if (!list.isEmpty()) {
                    root.setCas(new CaconfType.Cas());
                    root.getCas().getCa().addAll(list);
                }
            }
            if (users.isEmpty()) {
                root.setUsers(null);
            }
            if (CollectionUtil.isNonEmpty(this.requestorDbEntries)) {
                list = new LinkedList();
                for (String name : this.requestorDbEntries.keySet()) {
                    if (!includeRequestorNames.contains(name)) continue;
                    entry = this.requestorDbEntries.get(name);
                    jaxb = new RequestorType();
                    jaxb.setName(name);
                    jaxb.setType(entry.getType());
                    if ("cert".equalsIgnoreCase(entry.getType())) {
                        FileOrBinaryType fob = CaManagerImpl.createFileOrBinary(zipStream, Base64.decode((String)entry.getConf()), CaManagerImpl.concat("files/requestor-", name, ".der"));
                        jaxb.setBinaryConf(fob);
                    } else {
                        FileOrValueType fov = CaManagerImpl.createFileOrValue(zipStream, entry.getConf(), CaManagerImpl.concat("files/requestor-", name, ".conf"));
                        jaxb.setConf(fov);
                    }
                    list.add(jaxb);
                }
                if (!list.isEmpty()) {
                    root.setRequestors(new CaconfType.Requestors());
                    root.getRequestors().getRequestor().addAll(list);
                }
            }
            if (CollectionUtil.isNonEmpty(this.publisherDbEntries)) {
                list = new LinkedList();
                for (String name : this.publisherDbEntries.keySet()) {
                    if (!includePublisherNames.contains(name)) continue;
                    entry = this.publisherDbEntries.get(name);
                    jaxb = new PublisherType();
                    jaxb.setName(name);
                    jaxb.setType(entry.getType());
                    jaxb.setConf(CaManagerImpl.createFileOrValue(zipStream, entry.getConf(), CaManagerImpl.concat("files/publisher-", name, ".conf")));
                    list.add(jaxb);
                }
                if (!list.isEmpty()) {
                    root.setPublishers(new CaconfType.Publishers());
                    root.getPublishers().getPublisher().addAll(list);
                }
            }
            if (CollectionUtil.isNonEmpty(this.certprofileDbEntries)) {
                list = new LinkedList();
                for (String name : this.certprofileDbEntries.keySet()) {
                    if (!includeProfileNames.contains(name)) continue;
                    entry = this.certprofileDbEntries.get(name);
                    jaxb = new ProfileType();
                    jaxb.setName(name);
                    jaxb.setType(entry.getType());
                    jaxb.setConf(CaManagerImpl.createFileOrValue(zipStream, entry.getConf(), CaManagerImpl.concat("files/certprofile-", name, ".conf")));
                    list.add(jaxb);
                }
                if (!list.isEmpty()) {
                    root.setProfiles(new CaconfType.Profiles());
                    root.getProfiles().getProfile().addAll(list);
                }
            }
            if (CollectionUtil.isNonEmpty(this.signerDbEntries)) {
                list = new LinkedList();
                for (String name : this.signerDbEntries.keySet()) {
                    if (!includeSignerNames.contains(name)) continue;
                    entry = this.signerDbEntries.get(name);
                    jaxb = new SignerType();
                    jaxb.setName(name);
                    jaxb.setType(entry.getType());
                    jaxb.setConf(CaManagerImpl.createFileOrValue(zipStream, entry.getConf(), CaManagerImpl.concat("files/responder-", name, ".conf")));
                    jaxb.setCert(CaManagerImpl.createFileOrBase64Value(zipStream, entry.getBase64Cert(), CaManagerImpl.concat("files/responder-", name, ".der")));
                    list.add(jaxb);
                }
                if (!list.isEmpty()) {
                    root.setSigners(new CaconfType.Signers());
                    root.getSigners().getSigner().addAll(list);
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                CaConf.marshal((CaconfType)root, (OutputStream)bout);
            }
            catch (JAXBException | SAXException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not marshal CAConf");
                throw new CaMgmtException(CaManagerImpl.concat("could not marshal CAConf: ", ex.getMessage()), ex);
            }
            finally {
                bout.flush();
            }
            zipStream.putNextEntry(new ZipEntry("caconf.xml"));
            try {
                zipStream.write(bout.toByteArray());
            }
            finally {
                zipStream.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileOrValueType createFileOrValue(ZipOutputStream zipStream, String content, String fileName) throws IOException {
        if (StringUtil.isBlank((String)content)) {
            return null;
        }
        FileOrValueType ret = new FileOrValueType();
        if (content.length() < 256) {
            ret.setValue(content);
        } else {
            ret.setFile(fileName);
            ZipEntry certZipEntry = new ZipEntry(fileName);
            zipStream.putNextEntry(certZipEntry);
            try {
                zipStream.write(content.getBytes("UTF-8"));
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return ret;
    }

    private static FileOrBinaryType createFileOrBase64Value(ZipOutputStream zipStream, String b64Content, String fileName) throws IOException {
        if (StringUtil.isBlank((String)b64Content)) {
            return null;
        }
        return CaManagerImpl.createFileOrBinary(zipStream, Base64.decode((String)b64Content), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileOrBinaryType createFileOrBinary(ZipOutputStream zipStream, byte[] content, String fileName) throws IOException {
        if (content == null || content.length == 0) {
            return null;
        }
        FileOrBinaryType ret = new FileOrBinaryType();
        if (content.length < 256) {
            ret.setBinary(content);
        } else {
            ret.setFile(fileName);
            ZipEntry certZipEntry = new ZipEntry(fileName);
            zipStream.putNextEntry(certZipEntry);
            try {
                zipStream.write(content);
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return ret;
    }

    private static ZipOutputStream getZipOutputStream(File zipFile) throws FileNotFoundException {
        ParamUtil.requireNonNull((String)"zipFile", (Object)zipFile);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000);
        ZipOutputStream zipOutStream = new ZipOutputStream(out);
        zipOutStream.setLevel(1);
        return zipOutStream;
    }

    private static UrisType createUris(Collection<String> uris) {
        if (CollectionUtil.isEmpty(uris)) {
            return null;
        }
        UrisType ret = new UrisType();
        for (String uri : uris) {
            ret.getUri().add(uri);
        }
        return ret;
    }

    private static ProfilesType createProfiles(Collection<String> profiles) {
        if (CollectionUtil.isEmpty(profiles)) {
            return null;
        }
        ProfilesType ret = new ProfilesType();
        for (String profile : profiles) {
            ret.getProfile().add(profile);
        }
        return ret;
    }

    public RestResponder getRestResponder() {
        return this.restResponder;
    }

    private static String concat(String s1, String ... strs) {
        return StringUtil.concat((String)s1, (String[])strs);
    }

    private static CaMgmtException logAndCreateException(String msg) {
        LOG.error(msg);
        return new CaMgmtException(msg);
    }

    private static PermissionsType getPermissions(int permission) {
        LinkedList<String> list = new LinkedList<String>();
        if (511 == permission) {
            list.add(PermissionConstants.getTextForCode((int)permission));
        } else {
            for (Integer code : PermissionConstants.getPermissions()) {
                if ((permission & code) == 0) continue;
                list.add(PermissionConstants.getTextForCode((int)code));
            }
        }
        PermissionsType ret = new PermissionsType();
        ret.getPermission().addAll(list);
        return ret;
    }

    private class CaRestarter
    implements Runnable {
        private boolean inProcess;

        private CaRestarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                SystemEvent event = CaManagerImpl.this.queryExecutor.getSystemEvent(CaManagerImpl.EVENT_CACHAGNE);
                long caChangedTime = event == null ? 0L : event.getEventTime();
                LOG.info("check the restart CA system event: changed at={}, lastStartTime={}", (Object)new Date(caChangedTime * 1000L), (Object)CaManagerImpl.this.lastStartTime);
                if (caChangedTime > CaManagerImpl.this.lastStartTime.getTime() / 1000L) {
                    LOG.info("received event to restart CA");
                    CaManagerImpl.this.restartCaSystem();
                } else {
                    LOG.debug("received no event to restart CA");
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"ScheduledCaRestarter");
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class UnreferencedRequstCleaner
    implements Runnable {
        private boolean inProcess;

        private UnreferencedRequstCleaner() {
        }

        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                try {
                    CaManagerImpl.this.certstore.deleteUnreferencedRequests();
                    LOG.info("deleted unreferenced requests");
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not delete unreferenced requests");
                }
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class CertsInQueuePublisher
    implements Runnable {
        private boolean inProcess;

        private CertsInQueuePublisher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess || !CaManagerImpl.this.caSystemSetuped) {
                return;
            }
            this.inProcess = true;
            try {
                LOG.debug("publishing certificates in PUBLISHQUEUE");
                for (String name : CaManagerImpl.this.x509cas.keySet()) {
                    X509Ca ca = (X509Ca)CaManagerImpl.this.x509cas.get(name);
                    boolean bo = ca.publishCertsInQueue();
                    if (bo) {
                        LOG.info(" published certificates of CA {} in PUBLISHQUEUE", (Object)name);
                        continue;
                    }
                    LOG.error("publishing certificates of CA {} in PUBLISHQUEUE failed", (Object)name);
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not publish CertsInQueue");
            }
            finally {
                this.inProcess = false;
            }
        }
    }
}

