/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl;

import java.util.Date;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.util.ParamUtil;

public class CertTemplateData {
    private final X500Name subject;
    private final SubjectPublicKeyInfo publicKeyInfo;
    private final Date notBefore;
    private final Date notAfter;
    private final String certprofileName;
    private final boolean caGenerateKeypair;
    private final Extensions extensions;
    private final ASN1Integer certReqId;

    public CertTemplateData(X500Name subject, SubjectPublicKeyInfo publicKeyInfo, Date notBefore, Date notAfter, Extensions extensions, String certprofileName) {
        this(subject, publicKeyInfo, notBefore, notAfter, extensions, certprofileName, null, false);
    }

    public CertTemplateData(X500Name subject, SubjectPublicKeyInfo publicKeyInfo, Date notBefore, Date notAfter, Extensions extensions, String certprofileName, ASN1Integer certReqId, boolean caGenerateKeypair) {
        this.publicKeyInfo = publicKeyInfo;
        this.subject = (X500Name)ParamUtil.requireNonNull((String)"subject", (Object)subject);
        this.certprofileName = ParamUtil.requireNonBlank((String)"certprofileName", (String)certprofileName).toLowerCase();
        this.extensions = extensions;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.certReqId = certReqId;
        this.caGenerateKeypair = caGenerateKeypair;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public boolean isCaGenerateKeypair() {
        return this.caGenerateKeypair;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public String getCertprofileName() {
        return this.certprofileName;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public ASN1Integer getCertReqId() {
        return this.certReqId;
    }
}

