/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl;

import java.security.cert.X509CRL;
import java.util.Map;
import org.xipki.audit.AuditServiceRegister;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherException;
import org.xipki.ca.server.mgmt.api.PublisherEntry;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.ParamUtil;

class IdentifiedCertPublisher {
    private final PublisherEntry entry;
    private final CertPublisher certPublisher;

    IdentifiedCertPublisher(PublisherEntry entry, CertPublisher certPublisher) {
        this.entry = (PublisherEntry)ParamUtil.requireNonNull((String)"entry", (Object)entry);
        this.certPublisher = (CertPublisher)ParamUtil.requireNonNull((String)"certPublisher", (Object)certPublisher);
    }

    public void initialize(PasswordResolver passwordResolver, Map<String, DataSourceWrapper> datasources) throws CertPublisherException {
        this.certPublisher.initialize(this.entry.getConf(), passwordResolver, datasources);
    }

    public boolean caAdded(X509Cert caCert) {
        return this.certPublisher.caAdded(caCert);
    }

    public boolean certificateAdded(CertificateInfo certInfo) {
        return this.certPublisher.certificateAdded(certInfo);
    }

    public boolean certificateRevoked(X509Cert caCert, CertWithDbId cert, String certprofile, CertRevocationInfo revInfo) {
        return this.certPublisher.certificateRevoked(caCert, cert, certprofile, revInfo);
    }

    public boolean crlAdded(X509Cert caCert, X509CRL crl) {
        return this.certPublisher.crlAdded(caCert, crl);
    }

    public PublisherEntry getDbEntry() {
        return this.entry;
    }

    public NameId getIdent() {
        return this.entry.getIdent();
    }

    public boolean isHealthy() {
        return this.certPublisher.isHealthy();
    }

    public void setAuditServiceRegister(AuditServiceRegister auditServiceRegister) {
        this.certPublisher.setAuditServiceRegister(auditServiceRegister);
    }

    public boolean caRevoked(X509Cert caCert, CertRevocationInfo revocationInfo) {
        return this.certPublisher.caRevoked(caCert, revocationInfo);
    }

    public boolean caUnrevoked(X509Cert caCert) {
        return this.certPublisher.caUnrevoked(caCert);
    }

    public boolean certificateUnrevoked(X509Cert caCert, CertWithDbId cert) {
        return this.certPublisher.certificateUnrevoked(caCert, cert);
    }

    public boolean certificateRemoved(X509Cert caCert, CertWithDbId cert) {
        return this.certPublisher.certificateRemoved(caCert, cert);
    }

    public boolean isAsyn() {
        return this.certPublisher.isAsyn();
    }

    public void shutdown() {
        this.certPublisher.shutdown();
    }

    public boolean publishsGoodCert() {
        return this.certPublisher.publishsGoodCert();
    }
}

