/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl;

import java.math.BigInteger;
import java.security.SecureRandom;

class RandomSerialNumberGenerator {
    private static int MASK_1 = 1;
    private static int MASK_2 = 3;
    private static int MASK_3 = 7;
    private static int MASK_4 = 15;
    private static int MASK_5 = 31;
    private static int MASK_6 = 63;
    private static int MASK_7 = 127;
    private static RandomSerialNumberGenerator instance;
    private final SecureRandom random = new SecureRandom();

    private RandomSerialNumberGenerator() {
    }

    public BigInteger nextSerialNumber(int bitLen) {
        byte[] rdnBytes = new byte[(bitLen + 7) / 8];
        this.random.nextBytes(rdnBytes);
        int ci = bitLen % 8;
        switch (ci) {
            case 1: {
                rdnBytes[0] = (byte)(rdnBytes[0] & MASK_1);
                break;
            }
            case 2: {
                rdnBytes[0] = (byte)(rdnBytes[0] & MASK_2);
                break;
            }
            case 3: {
                rdnBytes[0] = (byte)(rdnBytes[0] & MASK_3);
                break;
            }
            case 4: {
                rdnBytes[0] = (byte)(rdnBytes[0] & MASK_4);
                break;
            }
            case 5: {
                rdnBytes[0] = (byte)(rdnBytes[0] & MASK_5);
                break;
            }
            case 6: {
                rdnBytes[0] = (byte)(rdnBytes[0] & MASK_6);
                break;
            }
            case 7: {
                rdnBytes[0] = (byte)(rdnBytes[0] & MASK_7);
                break;
            }
        }
        return new BigInteger(1, rdnBytes);
    }

    public static synchronized RandomSerialNumberGenerator getInstance() {
        if (instance == null) {
            instance = new RandomSerialNumberGenerator();
        }
        return instance;
    }
}

