/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;
import org.xipki.util.ParamUtil;

public class UniqueIdGenerator {
    private static final int MAX_OFFSET = 1023;
    private final long epoch;
    private final int shardId;
    private final AtomicInteger offset = new AtomicInteger(0);
    private final IntBinaryOperator accumulatorFunction;

    public UniqueIdGenerator(long epoch, int shardId) {
        this.epoch = ParamUtil.requireMin((String)"epoch", (long)epoch, (long)0L);
        this.shardId = ParamUtil.requireRange((String)"shardId", (int)shardId, (int)0, (int)127);
        this.accumulatorFunction = new OffsetIncrement();
    }

    public long nextId() {
        long now = System.currentTimeMillis();
        long ret = now - this.epoch;
        ret <<= 10;
        ret += (long)this.offset.getAndAccumulate(1023, this.accumulatorFunction);
        ret <<= 7;
        return ret += (long)this.shardId;
    }

    private static class OffsetIncrement
    implements IntBinaryOperator {
        private OffsetIncrement() {
        }

        @Override
        public int applyAsInt(int left, int right) {
            return left >= right ? 0 : left + 1;
        }
    }
}

