/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl.cmp;

import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.server.api.CmpResponder;
import org.xipki.ca.server.impl.cmp.CmpRequestorInfo;
import org.xipki.ca.server.mgmt.api.CmpControl;
import org.xipki.ca.server.mgmt.api.RequestorInfo;
import org.xipki.cmp.CmpUtil;
import org.xipki.cmp.ProtectionResult;
import org.xipki.cmp.ProtectionVerificationResult;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.RandomUtil;

abstract class BaseCmpResponder
implements CmpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCmpResponder.class);
    private static final int PVNO_CMP2000 = 2;
    protected final SecurityFactory securityFactory;
    private final SecureRandom random = new SecureRandom();

    protected BaseCmpResponder(SecurityFactory securityFactory) {
        this.securityFactory = (SecurityFactory)ParamUtil.requireNonNull((String)"securityFactory", (Object)securityFactory);
    }

    protected abstract ConcurrentContentSigner getSigner();

    protected abstract GeneralName getSender();

    protected abstract boolean intendsMe(GeneralName var1);

    public boolean isOnService() {
        try {
            return this.getSigner() != null;
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not get responder signer");
            return false;
        }
    }

    protected abstract CmpControl getCmpControl();

    public abstract CmpRequestorInfo getMacRequestor(X500Name var1, byte[] var2);

    public abstract CmpRequestorInfo getRequestor(X500Name var1);

    public abstract CmpRequestorInfo getRequestor(X509Certificate var1);

    private static X500Name getX500Sender(PKIHeader reqHeader) {
        GeneralName requestSender = reqHeader.getSender();
        if (requestSender.getTagNo() != 4) {
            return null;
        }
        return (X500Name)requestSender.getName();
    }

    protected abstract PKIMessage processPkiMessage0(PKIMessage var1, RequestorInfo var2, ASN1OctetString var3, GeneralPKIMessage var4, String var5, Map<String, String> var6, AuditEvent var7);

    public PKIMessage processPkiMessage(PKIMessage pkiMessage, X509Certificate tlsClientCert, Map<String, String> parameters, AuditEvent event) {
        CmpRequestorInfo requestor;
        String errorStatus;
        GeneralName recipient;
        boolean intentMe;
        int reqPvno;
        ParamUtil.requireNonNull((String)"pkiMessage", (Object)pkiMessage);
        ParamUtil.requireNonNull((String)"event", (Object)event);
        GeneralPKIMessage message = new GeneralPKIMessage(pkiMessage);
        PKIHeader reqHeader = message.getHeader();
        ASN1OctetString tid = reqHeader.getTransactionID();
        String msgId = null;
        if (event != null) {
            msgId = RandomUtil.nextHexLong();
            event.addEventData("mid", (Object)msgId);
        }
        if (tid == null) {
            byte[] randomBytes = this.randomTransactionId();
            tid = new DEROctetString(randomBytes);
        }
        String tidStr = Base64.encodeToString((byte[])tid.getOctets());
        if (event != null) {
            event.addEventData("tid", (Object)tidStr);
        }
        if ((reqPvno = reqHeader.getPvno().getValue().intValue()) != 2) {
            if (event != null) {
                event.setLevel(AuditLevel.INFO);
                event.setStatus(AuditStatus.FAILED);
                event.addEventData("message", (Object)("unsupproted version " + reqPvno));
            }
            return this.buildErrorPkiMessage(tid, reqHeader, 131072, null);
        }
        CmpControl cmpControl = this.getCmpControl();
        Integer failureCode = null;
        String statusText = null;
        Date messageTime = null;
        if (reqHeader.getMessageTime() != null) {
            try {
                messageTime = reqHeader.getMessageTime().getDate();
            }
            catch (ParseException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("tid=" + tidStr + ": could not parse messageTime"));
            }
        }
        boolean bl = intentMe = (recipient = reqHeader.getRecipient()) == null ? true : this.intendsMe(recipient);
        if (!intentMe) {
            LOG.warn("tid={}: I am not the intended recipient, but '{}'", (Object)tid, (Object)reqHeader.getRecipient());
            failureCode = 32;
            statusText = "I am not the intended recipient";
        } else if (messageTime == null) {
            if (cmpControl.isMessageTimeRequired()) {
                failureCode = 32768;
                statusText = "missing time-stamp";
            }
        } else {
            long currentTimeMs;
            long msgTimeMs;
            long bias;
            long messageTimeBias = cmpControl.getMessageTimeBias();
            if (messageTimeBias < 0L) {
                messageTimeBias *= -1L;
            }
            if ((bias = ((msgTimeMs = messageTime.getTime()) - (currentTimeMs = System.currentTimeMillis())) / 1000L) > messageTimeBias) {
                failureCode = 16;
                statusText = "message time is in the future";
            } else if (bias * -1L > messageTimeBias) {
                failureCode = 16;
                statusText = "message too old";
            }
        }
        if (failureCode != null) {
            if (event != null) {
                event.setLevel(AuditLevel.INFO);
                event.setStatus(AuditStatus.FAILED);
                event.addEventData("message", (Object)statusText);
            }
            return this.buildErrorPkiMessage(tid, reqHeader, failureCode, statusText);
        }
        boolean isProtected = message.hasProtection();
        if (isProtected) {
            try {
                ProtectionVerificationResult verificationResult = this.verifyProtection(tidStr, message, cmpControl);
                ProtectionResult pr = verificationResult.getProtectionResult();
                switch (pr) {
                    case SIGNATURE_VALID: 
                    case MAC_VALID: {
                        errorStatus = null;
                        break;
                    }
                    case SIGNATURE_INVALID: {
                        errorStatus = "request is protected by signature but invalid";
                        break;
                    }
                    case MAC_INVALID: {
                        errorStatus = "request is protected by MAC but invalid";
                        break;
                    }
                    case SENDER_NOT_AUTHORIZED: {
                        errorStatus = "request is protected but the requestor is not authorized";
                        break;
                    }
                    case SIGNATURE_ALGO_FORBIDDEN: {
                        errorStatus = "request is protected by signature but the algorithm is forbidden";
                        break;
                    }
                    case MAC_ALGO_FORBIDDEN: {
                        errorStatus = "request is protected by MAC but the algorithm is forbidden";
                        break;
                    }
                    default: {
                        throw new RuntimeException("should not reach here, unknown ProtectionResult " + pr);
                    }
                }
                requestor = (CmpRequestorInfo)verificationResult.getRequestor();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("tid=" + tidStr + ": could not verify the signature"));
                errorStatus = "request has invalid signature based protection";
                requestor = null;
            }
        } else if (tlsClientCert != null) {
            boolean authorized = false;
            X500Name x500Sender = BaseCmpResponder.getX500Sender(reqHeader);
            CmpRequestorInfo cmpRequestorInfo = requestor = x500Sender == null ? null : this.getRequestor(x500Sender);
            if (requestor != null && tlsClientCert.equals(requestor.getCert().getCert())) {
                authorized = true;
            }
            if (authorized) {
                errorStatus = null;
            } else {
                LOG.warn("tid={}: not authorized requestor (TLS client '{}')", (Object)tid, (Object)X509Util.getRfc4519Name((X500Principal)tlsClientCert.getSubjectX500Principal()));
                errorStatus = "requestor (TLS client certificate) is not authorized";
            }
        } else {
            errorStatus = "request has no protection";
            requestor = null;
        }
        if (errorStatus != null) {
            if (event != null) {
                event.setLevel(AuditLevel.INFO);
                event.setStatus(AuditStatus.FAILED);
                event.addEventData("message", (Object)errorStatus);
            }
            return this.buildErrorPkiMessage(tid, reqHeader, 64, errorStatus);
        }
        PKIMessage resp = this.processPkiMessage0(pkiMessage, requestor, tid, message, msgId, parameters, event);
        if (isProtected) {
            resp = this.addProtection(resp, event, requestor);
        }
        return resp;
    }

    protected byte[] randomTransactionId() {
        return this.randomBytes(10);
    }

    protected byte[] randomSalt() {
        return this.randomBytes(64);
    }

    protected byte[] randomBytes(int len) {
        byte[] bytes = new byte[len];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private ProtectionVerificationResult verifyProtection(String tid, GeneralPKIMessage pkiMessage, CmpControl cmpControl) throws CMPException, InvalidKeyException, OperatorCreationException {
        CmpRequestorInfo requestor;
        ProtectedPKIMessage protectedMsg = new ProtectedPKIMessage(pkiMessage);
        PKIHeader header = protectedMsg.getHeader();
        X500Name sender = BaseCmpResponder.getX500Sender(header);
        if (sender == null) {
            LOG.warn("tid={}: not authorized requestor 'null'", (Object)tid);
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        AlgorithmIdentifier protectionAlg = header.getProtectionAlg();
        if (protectedMsg.hasPasswordBasedMacProtection()) {
            PBMParameter parameter = PBMParameter.getInstance((Object)pkiMessage.getHeader().getProtectionAlg().getParameters());
            AlgorithmIdentifier algId = parameter.getOwf();
            if (!cmpControl.isRequestPbmOwfPermitted(algId)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.owf: {})", (Object)algId.getAlgorithm().getId());
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            algId = parameter.getMac();
            if (!cmpControl.isRequestPbmMacPermitted(algId)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.mac: {})", (Object)algId.getAlgorithm().getId());
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            int iterationCount = parameter.getIterationCount().getValue().intValue();
            if (iterationCount < 1000) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.iterationCount: {} < 1000)", (Object)iterationCount);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            ASN1OctetString asn1 = header.getSenderKID();
            byte[] senderKID = asn1 == null ? null : asn1.getOctets();
            PKMACBuilder pkMacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator());
            CmpRequestorInfo requestor2 = this.getMacRequestor(sender, senderKID);
            if (requestor2 == null) {
                LOG.warn("tid={}: not authorized requestor '{}' with senderKID '{}", new Object[]{tid, sender, senderKID == null ? "null" : Hex.toHexString((byte[])senderKID)});
                return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
            }
            boolean macValid = protectedMsg.verify(pkMacBuilder, requestor2.getPassword());
            return new ProtectionVerificationResult((Object)requestor2, macValid ? ProtectionResult.MAC_VALID : ProtectionResult.MAC_INVALID);
        }
        if (!cmpControl.getSigAlgoValidator().isAlgorithmPermitted(protectionAlg)) {
            LOG.warn("SIG_ALGO_FORBIDDEN: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
            return new ProtectionVerificationResult(null, ProtectionResult.SIGNATURE_ALGO_FORBIDDEN);
        }
        X500Name x500Sender = BaseCmpResponder.getX500Sender(header);
        CmpRequestorInfo cmpRequestorInfo = requestor = x500Sender == null ? null : this.getRequestor(x500Sender);
        if (requestor == null) {
            LOG.warn("tid={}: not authorized requestor '{}'", (Object)tid, (Object)header.getSender());
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        ContentVerifierProvider verifierProvider = this.securityFactory.getContentVerifierProvider(requestor.getCert().getCert());
        if (verifierProvider == null) {
            LOG.warn("tid={}: not authorized requestor '{}'", (Object)tid, (Object)sender);
            return new ProtectionVerificationResult((Object)requestor, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        boolean signatureValid = protectedMsg.verify(verifierProvider);
        return new ProtectionVerificationResult((Object)requestor, signatureValid ? ProtectionResult.SIGNATURE_VALID : ProtectionResult.SIGNATURE_INVALID);
    }

    private PKIMessage addProtection(PKIMessage pkiMessage, AuditEvent event, CmpRequestorInfo requestor) {
        CmpControl control = this.getCmpControl();
        try {
            if (requestor.getCert() != null) {
                return CmpUtil.addProtection((PKIMessage)pkiMessage, (ConcurrentContentSigner)this.getSigner(), (GeneralName)this.getSender(), (boolean)control.isSendResponderCert());
            }
            PBMParameter parameter = new PBMParameter(this.randomSalt(), control.getResponsePbmOwf(), control.getResponsePbmIterationCount(), control.getResponsePbmMac());
            return CmpUtil.addProtection((PKIMessage)pkiMessage, (char[])requestor.getPassword(), (PBMParameter)parameter, (GeneralName)this.getSender(), (byte[])requestor.getKeyId());
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not add protection to the PKI message");
            PKIStatusInfo status = this.generateRejectionStatus(0x40000000, "could not sign the PKIMessage");
            event.setLevel(AuditLevel.ERROR);
            event.setStatus(AuditStatus.FAILED);
            event.addEventData("message", (Object)"could not sign the PKIMessage");
            PKIBody body = new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(status));
            return new PKIMessage(pkiMessage.getHeader(), body);
        }
    }

    protected PKIMessage buildErrorPkiMessage(ASN1OctetString tid, PKIHeader requestHeader, int failureCode, String statusText) {
        ASN1OctetString senderNonce;
        GeneralName respRecipient = requestHeader.getSender();
        PKIHeaderBuilder respHeader = new PKIHeaderBuilder(requestHeader.getPvno().getValue().intValue(), this.getSender(), respRecipient);
        respHeader.setMessageTime(new ASN1GeneralizedTime(new Date()));
        if (tid != null) {
            respHeader.setTransactionID(tid);
        }
        if ((senderNonce = requestHeader.getSenderNonce()) != null) {
            respHeader.setRecipNonce(senderNonce);
        }
        PKIStatusInfo status = this.generateRejectionStatus(failureCode, statusText);
        ErrorMsgContent error = new ErrorMsgContent(status);
        PKIBody body = new PKIBody(23, (ASN1Encodable)error);
        return new PKIMessage(respHeader.build(), body);
    }

    protected PKIStatusInfo generateRejectionStatus(Integer info, String errorMessage) {
        return this.generateRejectionStatus(PKIStatus.rejection, info, errorMessage);
    }

    protected PKIStatusInfo generateRejectionStatus(PKIStatus status, Integer info, String errorMessage) {
        PKIFreeText statusMessage = errorMessage == null ? null : new PKIFreeText(errorMessage);
        PKIFailureInfo failureInfo = info == null ? null : new PKIFailureInfo(info.intValue());
        return new PKIStatusInfo(status, statusMessage, failureInfo);
    }

    public X500Name getResponderSubject() {
        GeneralName sender = this.getSender();
        return sender == null ? null : (X500Name)sender.getName();
    }

    public X509Certificate getResponderCert() {
        ConcurrentContentSigner signer = this.getSigner();
        return signer == null ? null : signer.getCertificate();
    }
}

