/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl.cmp;

import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.InsuffientPermissionException;
import org.xipki.ca.api.NameId;
import org.xipki.ca.server.mgmt.api.CaHasRequestorEntry;
import org.xipki.ca.server.mgmt.api.PermissionConstants;
import org.xipki.ca.server.mgmt.api.RequestorInfo;
import org.xipki.util.ParamUtil;

public class CmpRequestorInfo
implements RequestorInfo {
    private final CaHasRequestorEntry caHasRequestor;
    private final CertWithDbId cert;
    private final char[] password;
    private final byte[] keyId;

    public CmpRequestorInfo(CaHasRequestorEntry caHasRequestor, CertWithDbId cert) {
        this.caHasRequestor = (CaHasRequestorEntry)ParamUtil.requireNonNull((String)"caHasRequestor", (Object)caHasRequestor);
        this.cert = (CertWithDbId)ParamUtil.requireNonNull((String)"cert", (Object)cert);
        this.password = null;
        this.keyId = null;
    }

    public CmpRequestorInfo(CaHasRequestorEntry caHasRequestor, char[] password, byte[] keyId) {
        this.caHasRequestor = (CaHasRequestorEntry)ParamUtil.requireNonNull((String)"caHasRequestor", (Object)caHasRequestor);
        this.cert = null;
        this.password = (char[])ParamUtil.requireNonNull((String)"password", (Object)password);
        this.keyId = (byte[])ParamUtil.requireNonNull((String)"keyId", (Object)keyId);
    }

    public CaHasRequestorEntry getCaHasRequestor() {
        return this.caHasRequestor;
    }

    public CertWithDbId getCert() {
        return this.cert;
    }

    public char[] getPassword() {
        return this.password;
    }

    public byte[] getKeyId() {
        return this.keyId;
    }

    public NameId getIdent() {
        return this.caHasRequestor.getRequestorIdent();
    }

    public boolean isRa() {
        return this.caHasRequestor.isRa();
    }

    public boolean isCertprofilePermitted(String certprofile) {
        return this.caHasRequestor.isCertprofilePermitted(certprofile);
    }

    public boolean isPermitted(int permission) {
        return this.caHasRequestor.isPermitted(permission);
    }

    public void assertCertprofilePermitted(String certprofile) throws InsuffientPermissionException {
        if (!this.isCertprofilePermitted(certprofile)) {
            throw new InsuffientPermissionException("Certprofile " + certprofile + " is not permitted");
        }
    }

    public void assertPermitted(int permission) throws InsuffientPermissionException {
        if (!this.isPermitted(permission)) {
            throw new InsuffientPermissionException("Permission " + PermissionConstants.getTextForCode((int)permission) + " is not permitted");
        }
    }
}

