/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl.store;

import java.util.Arrays;
import org.xipki.util.Base64;
import org.xipki.util.ParamUtil;

class CertBasedIdentityEntry {
    private final int id;
    private final String subject;
    private final byte[] sha1Fp;
    private final byte[] cert;

    CertBasedIdentityEntry(int id, String subject, String b64Sha1Fp, String b64Cert) {
        ParamUtil.requireNonBlank((String)"b64Sha1Fp", (String)b64Sha1Fp);
        ParamUtil.requireNonBlank((String)"b64Cert", (String)b64Cert);
        this.id = id;
        this.subject = subject;
        this.sha1Fp = Base64.decode((String)b64Sha1Fp);
        this.cert = Base64.decode((String)b64Cert);
    }

    int getId() {
        return this.id;
    }

    String getSubject() {
        return this.subject;
    }

    boolean matchSha1Fp(byte[] sha1HashValue) {
        return Arrays.equals(this.sha1Fp, sha1HashValue);
    }

    boolean matchCert(byte[] encodedCert) {
        return Arrays.equals(this.cert, encodedCert);
    }
}

