/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl.store;

import java.util.ArrayList;
import java.util.List;
import org.xipki.ca.server.impl.store.CertBasedIdentityEntry;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

class CertBasedIdentityStore {
    private final String table;
    private final List<CertBasedIdentityEntry> entries;

    CertBasedIdentityStore(String table, List<CertBasedIdentityEntry> entries) {
        this.table = (String)ParamUtil.requireNonNull((String)"table", (Object)table);
        ParamUtil.requireNonNull((String)"entries", entries);
        this.entries = new ArrayList<CertBasedIdentityEntry>(entries.size());
        for (CertBasedIdentityEntry entry : entries) {
            this.addIdentityEntry(entry);
        }
    }

    void addIdentityEntry(CertBasedIdentityEntry entry) {
        ParamUtil.requireNonNull((String)"entry", (Object)entry);
        for (CertBasedIdentityEntry existingEntry : this.entries) {
            if (existingEntry.getId() != entry.getId()) continue;
            throw new IllegalArgumentException(StringUtil.concatObjects((Object)this.table, (Object[])new Object[]{" with the same id ", entry.getId(), " already available"}));
        }
        this.entries.add(entry);
    }

    Integer getCaIdForSubject(String subject) {
        for (CertBasedIdentityEntry entry : this.entries) {
            if (!entry.getSubject().equals(subject)) continue;
            return entry.getId();
        }
        return null;
    }

    Integer getCaIdForSha1Fp(byte[] sha1FpCert) {
        for (CertBasedIdentityEntry entry : this.entries) {
            if (!entry.matchSha1Fp(sha1FpCert)) continue;
            return entry.getId();
        }
        return null;
    }

    Integer getCaIdForCert(byte[] encodedCert) {
        for (CertBasedIdentityEntry entry : this.entries) {
            if (!entry.matchCert(encodedCert)) continue;
            return entry.getId();
        }
        return null;
    }

    String getTable() {
        return this.table;
    }

    int size() {
        return this.entries.size();
    }
}

