/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl.store;

import java.util.HashMap;
import java.util.Map;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ParamUtil;

class NameIdStore {
    private final String table;
    private final Map<String, Integer> entries;

    NameIdStore(String table, Map<String, Integer> entries) {
        this.table = (String)ParamUtil.requireNonNull((String)"table", (Object)table);
        this.entries = new HashMap<String, Integer>();
        if (CollectionUtil.isNonEmpty(entries)) {
            for (String name : entries.keySet()) {
                this.addEntry(name, entries.get(name));
            }
        }
    }

    void addEntry(String name, Integer id) {
        ParamUtil.requireNonBlank((String)"name", (String)name);
        ParamUtil.requireNonNull((String)"id", (Object)id);
        if (this.entries.containsKey(name)) {
            throw new IllegalArgumentException("entry with the same name " + name + " already available");
        }
        if (this.entries.containsValue(id)) {
            throw new IllegalArgumentException("entry with the same id " + id + " already available");
        }
        this.entries.put(name, id);
    }

    String getName(Integer id) {
        for (String name : this.entries.keySet()) {
            if (!CompareUtil.equalsObject((Object)id, (Object)this.entries.get(name))) continue;
            return name;
        }
        return null;
    }

    Integer getId(String name) {
        return this.entries.get(name);
    }

    public String getTable() {
        return this.table;
    }
}

