/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.xipki.ca.api.profile.CertLevel;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ParamUtil;

public class CaUtil {
    private CaUtil() {
    }

    public static Extensions getExtensions(CertificationRequestInfo csr) {
        ParamUtil.requireNonNull((String)"csr", (Object)csr);
        ASN1Set attrs = csr.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((Object)attr.getAttrType())) continue;
            return Extensions.getInstance((Object)attr.getAttributeValues()[0]);
        }
        return null;
    }

    public static String getChallengePassword(CertificationRequestInfo csr) {
        ParamUtil.requireNonNull((String)"csr", (Object)csr);
        ASN1Set attrs = csr.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_challengePassword.equals((Object)attr.getAttrType())) continue;
            ASN1String str = (ASN1String)attr.getAttributeValues()[0];
            return str.getString();
        }
        return null;
    }

    public static BasicConstraints createBasicConstraints(CertLevel level, Integer pathLen) {
        BasicConstraints basicConstraints;
        if (level == CertLevel.RootCA || level == CertLevel.SubCA) {
            basicConstraints = pathLen != null ? new BasicConstraints(pathLen.intValue()) : new BasicConstraints(true);
        } else if (level == CertLevel.EndEntity) {
            basicConstraints = new BasicConstraints(false);
        } else {
            throw new RuntimeException("unknown CertLevel " + level);
        }
        return basicConstraints;
    }

    public static AuthorityInformationAccess createAuthorityInformationAccess(List<String> caIssuerUris, List<String> ocspUris) {
        GeneralName gn;
        if (CollectionUtil.isEmpty(caIssuerUris) && CollectionUtil.isEmpty(ocspUris)) {
            throw new IllegalArgumentException("caIssuerUris and ospUris must not be both empty");
        }
        ArrayList<AccessDescription> accessDescriptions = new ArrayList<AccessDescription>(ocspUris.size());
        if (CollectionUtil.isNonEmpty(caIssuerUris)) {
            for (String uri : caIssuerUris) {
                gn = new GeneralName(6, uri);
                accessDescriptions.add(new AccessDescription(X509ObjectIdentifiers.id_ad_caIssuers, gn));
            }
        }
        if (CollectionUtil.isNonEmpty(ocspUris)) {
            for (String uri : ocspUris) {
                gn = new GeneralName(6, uri);
                accessDescriptions.add(new AccessDescription(X509ObjectIdentifiers.id_ad_ocsp, gn));
            }
        }
        DERSequence seq = new DERSequence((ASN1Encodable[])accessDescriptions.toArray(new AccessDescription[0]));
        return AuthorityInformationAccess.getInstance((Object)seq);
    }

    public static CRLDistPoint createCrlDistributionPoints(List<String> crlUris, X500Name caSubject, X500Name crlSignerSubject) {
        ParamUtil.requireNonEmpty((String)"crlUris", crlUris);
        int size = crlUris.size();
        DistributionPoint[] points = new DistributionPoint[1];
        GeneralName[] names = new GeneralName[size];
        for (int i = 0; i < size; ++i) {
            names[i] = new GeneralName(6, crlUris.get(i));
        }
        GeneralNames gns = new GeneralNames(names);
        DistributionPointName pointName = new DistributionPointName(gns);
        GeneralNames crlIssuer = null;
        if (crlSignerSubject != null && !crlSignerSubject.equals((Object)caSubject)) {
            GeneralName crlIssuerName = new GeneralName(crlSignerSubject);
            crlIssuer = new GeneralNames(crlIssuerName);
        }
        points[0] = new DistributionPoint(pointName, null, crlIssuer);
        return new CRLDistPoint(points);
    }

    public static X500Name sortX509Name(X500Name name) {
        ParamUtil.requireNonNull((String)"name", (Object)name);
        RDN[] requstedRdns = name.getRDNs();
        LinkedList<RDN> rdns = new LinkedList<RDN>();
        List sortedDNs = SubjectDnSpec.getForwardDNs();
        int size = sortedDNs.size();
        for (int i = 0; i < size; ++i) {
            ASN1ObjectIdentifier type = (ASN1ObjectIdentifier)sortedDNs.get(i);
            RDN[] thisRdns = CaUtil.getRdns(requstedRdns, type);
            if (thisRdns == null || thisRdns.length == 0) continue;
            for (RDN m : thisRdns) {
                rdns.add(m);
            }
        }
        return new X500Name(rdns.toArray(new RDN[0]));
    }

    private static RDN[] getRdns(RDN[] rdns, ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"rdns", (Object)rdns);
        ParamUtil.requireNonNull((String)"type", (Object)type);
        ArrayList<RDN> ret = new ArrayList<RDN>(1);
        for (int i = 0; i < rdns.length; ++i) {
            RDN rdn = rdns[i];
            if (!rdn.getFirst().getType().equals((Object)type)) continue;
            ret.add(rdn);
        }
        return CollectionUtil.isEmpty(ret) ? null : ret.toArray(new RDN[0]);
    }
}

