/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.impl.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.xipki.util.ParamUtil;

public class PasswordHash {
    public static final int SALT_BYTE_SIZE = 24;
    public static final int DERIVED_KEY_SIZE = 32;
    public static final int PBKDF2_ITERATIONS = 1000;
    public static final int ITERATION_INDEX = 0;
    public static final int SALT_INDEX = 1;
    public static final int PBKDF2_INDEX = 2;
    private static final PKCS5S2ParametersGenerator GEN = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());

    private PasswordHash() {
    }

    public static String createHash(String password) {
        ParamUtil.requireNonBlank((String)"password", (String)password);
        return PasswordHash.createHash(password.getBytes());
    }

    public static String createHash(byte[] password) {
        return PasswordHash.createHash(password, 24, 1000, 32);
    }

    public static String createHash(byte[] password, int saltSize, int iterations, int dkSize) {
        ParamUtil.requireNonNull((String)"password", (Object)password);
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[saltSize];
        random.nextBytes(salt);
        byte[] hash = PasswordHash.pbkdf2(password, salt, iterations, dkSize);
        return iterations + ":" + PasswordHash.toHex(salt) + ":" + PasswordHash.toHex(hash);
    }

    public static boolean validatePassword(String password, String correctHash) {
        ParamUtil.requireNonBlank((String)"password", (String)password);
        return PasswordHash.validatePassword(password.getBytes(), correctHash);
    }

    public static boolean validatePassword(byte[] password, String correctHash) {
        ParamUtil.requireNonNull((String)"password", (Object)password);
        String[] params = correctHash.split(":");
        int iterations = Integer.parseInt(params[0]);
        byte[] salt = PasswordHash.fromHex(params[1]);
        byte[] hash = PasswordHash.fromHex(params[2]);
        byte[] testHash = PasswordHash.pbkdf2(password, salt, iterations, hash.length);
        return PasswordHash.slowEquals(hash, testHash);
    }

    private static boolean slowEquals(byte[] arrayA, byte[] arrayB) {
        int diff = arrayA.length ^ arrayB.length;
        for (int i = 0; i < arrayA.length && i < arrayB.length; ++i) {
            diff |= arrayA[i] ^ arrayB[i];
        }
        return diff == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] pbkdf2(byte[] password, byte[] salt, int iterations, int bytes) {
        byte[] pwdBytes;
        try {
            pwdBytes = new String(password).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("no charset UTF-8");
        }
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = GEN;
        synchronized (pKCS5S2ParametersGenerator) {
            GEN.init(pwdBytes, salt, iterations);
            byte[] dk = ((KeyParameter)GEN.generateDerivedParameters(bytes * 8)).getKey();
            return dk;
        }
    }

    private static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    private static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        return paddingLength > 0 ? String.format("%0" + paddingLength + "d", 0) + hex : hex;
    }
}

