/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.util.Collection;
import java.util.Set;
import org.xipki.ca.api.InsuffientPermissionException;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class ByUserRequestorInfo
implements RequestorInfo {
    private final NameId ident;
    private final MgmtEntry.CaHasUser caHasUser;

    public ByUserRequestorInfo(NameId ident, MgmtEntry.CaHasUser caHasUser) {
        this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        this.caHasUser = (MgmtEntry.CaHasUser)Args.notNull((Object)caHasUser, (String)"caHasUser");
    }

    public NameId getIdent() {
        return this.ident;
    }

    public boolean isRa() {
        return false;
    }

    public int getUserId() {
        return this.caHasUser.getUserIdent().getId();
    }

    public MgmtEntry.CaHasUser getCaHasUser() {
        return this.caHasUser;
    }

    public boolean isCertprofilePermitted(String certprofile) {
        Set profiles = this.caHasUser.getProfiles();
        if (CollectionUtil.isEmpty((Collection)profiles)) {
            return false;
        }
        return profiles.contains("all") || profiles.contains(certprofile.toLowerCase());
    }

    public boolean isPermitted(int permission) {
        return PermissionConstants.contains((int)this.caHasUser.getPermission(), (int)permission);
    }

    public void assertCertprofilePermitted(String certprofile) throws InsuffientPermissionException {
        if (!this.isCertprofilePermitted(certprofile)) {
            throw new InsuffientPermissionException("Certprofile " + certprofile + " is not permitted");
        }
    }

    public void assertPermitted(int permission) throws InsuffientPermissionException {
        if (!this.isPermitted(permission)) {
            throw new InsuffientPermissionException("Permission " + PermissionConstants.getTextForCode((int)permission) + " is not permitted");
        }
    }
}

