/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public class RequestorEntryWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RequestorEntryWrapper.class);
    private MgmtEntry.Requestor dbEntry;
    private CertWithDbId cert;
    private byte[] keyId;
    private char[] password;

    public void setDbEntry(MgmtEntry.Requestor dbEntry, PasswordResolver passwordResolver) {
        this.dbEntry = (MgmtEntry.Requestor)Args.notNull((Object)dbEntry, (String)"dbEntry");
        String type = dbEntry.getType();
        String conf = dbEntry.getConf();
        dbEntry.setFaulty(true);
        if ("cert".equalsIgnoreCase(type)) {
            try {
                X509Certificate x509Cert = X509Util.parseCert((byte[])conf.getBytes());
                dbEntry.setFaulty(false);
                this.cert = new CertWithDbId(x509Cert);
            }
            catch (CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("error while parsing certificate of requestor" + dbEntry.getIdent()));
            }
        } else if ("pbm".equalsIgnoreCase(type)) {
            try {
                this.keyId = HashAlgo.SHA1.hash(dbEntry.getIdent().getName().getBytes("UTF-8"));
                this.password = passwordResolver.resolvePassword(conf);
                dbEntry.setFaulty(false);
            }
            catch (UnsupportedEncodingException | PasswordResolverException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("error while resolve password of requestor" + dbEntry.getIdent()));
            }
        }
    }

    public CertWithDbId getCert() {
        return this.cert;
    }

    public MgmtEntry.Requestor getDbEntry() {
        return this.dbEntry;
    }

    public boolean matchKeyId(byte[] keyId) {
        return Arrays.equals(keyId, this.keyId);
    }

    public char[] getPassword() {
        return this.password;
    }
}

