/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.xipki.util.Args;

public class ScepCaCertRespBytes {
    private final byte[] bytes;

    public ScepCaCertRespBytes(X509Certificate caCert, X509Certificate responderCert) throws CMSException, CertificateException {
        Args.notNull((Object)caCert, (String)"caCert");
        Args.notNull((Object)responderCert, (String)"responderCert");
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        try {
            cmsSignedDataGen.addCertificate(new X509CertificateHolder(caCert.getEncoded()));
            cmsSignedDataGen.addCertificate(new X509CertificateHolder(responderCert.getEncoded()));
            CMSSignedData degenerateSignedData = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
            this.bytes = degenerateSignedData.getEncoded();
        }
        catch (IOException ex) {
            throw new CMSException("could not build CMS SignedDta");
        }
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }
}

