/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.publisher;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509CRL;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherException;
import org.xipki.ca.server.publisher.OcspStoreQueryExecutor;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.LogUtil;

public class OcspCertPublisher
extends CertPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(OcspCertPublisher.class);
    private OcspStoreQueryExecutor queryExecutor;
    private boolean asyn;
    private boolean publishsGoodCert = true;
    private DataSourceWrapper datasource;

    public void initialize(String conf, PasswordResolver passwordResolver, Map<String, String> datasourceConfFiles) throws CertPublisherException {
        Args.notNull((Object)conf, (String)"conf");
        ConfPairs pairs = new ConfPairs(conf);
        String str = pairs.value("publish.goodcerts");
        this.publishsGoodCert = str == null ? true : Boolean.parseBoolean(str);
        str = pairs.value("asyn");
        this.asyn = str == null ? false : Boolean.parseBoolean(str);
        ConfPairs confPairs = new ConfPairs(conf);
        String datasourceName = confPairs.value("datasource");
        String datasourceConfFile = null;
        if (datasourceName != null) {
            datasourceConfFile = datasourceConfFiles.get(datasourceName);
        }
        if (datasourceConfFile == null) {
            throw new CertPublisherException("no datasource named '" + datasourceName + "' is specified");
        }
        this.datasource = this.loadDatasource(datasourceName, datasourceConfFile, passwordResolver);
        try {
            this.queryExecutor = new OcspStoreQueryExecutor(this.datasource, this.publishsGoodCert);
        }
        catch (NoSuchAlgorithmException | DataAccessException ex) {
            throw new CertPublisherException(ex.getMessage(), ex);
        }
    }

    private DataSourceWrapper loadDatasource(String datasourceName, String datasourceFile, PasswordResolver passwordResolver) throws CertPublisherException {
        try {
            DataSourceWrapper datasource = new DataSourceFactory().createDataSourceForFile(datasourceName, datasourceFile, passwordResolver);
            Connection conn = datasource.getConnection();
            datasource.returnConnection(conn);
            LOG.info("datasource.{}: {}", (Object)datasourceName, (Object)datasourceFile);
            return datasource;
        }
        catch (IOException | RuntimeException | DataAccessException | PasswordResolverException ex) {
            throw new CertPublisherException(ex.getClass().getName() + " while parsing datasource " + datasourceFile + ": " + ex.getMessage(), ex);
        }
    }

    public boolean caAdded(X509Cert issuer) {
        try {
            this.queryExecutor.addIssuer(issuer);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(issuer.getSubject(), issuer, ex, "could not publish issuer");
            return false;
        }
    }

    public boolean certificateAdded(CertificateInfo certInfo) {
        X509Cert caCert = certInfo.getIssuerCert();
        CertWithDbId cert = certInfo.getCert();
        try {
            this.queryExecutor.addCert(caCert, cert, certInfo.getRevocationInfo());
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(caCert.getSubject(), (X509Cert)cert, ex, "could not save certificate");
            return false;
        }
    }

    public boolean certificateRevoked(X509Cert caCert, CertWithDbId cert, String certprofile, CertRevocationInfo revInfo) {
        try {
            this.queryExecutor.revokeCert(caCert, cert, revInfo);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(caCert.getSubject(), (X509Cert)cert, ex, "could not publish revoked certificate");
            return false;
        }
    }

    public boolean certificateUnrevoked(X509Cert caCert, CertWithDbId cert) {
        try {
            this.queryExecutor.unrevokeCert(caCert, cert);
            return true;
        }
        catch (Exception ex) {
            this.logAndAudit(caCert.getSubject(), (X509Cert)cert, ex, "could not publish unrevocation of certificate");
            return false;
        }
    }

    private void logAndAudit(String issuer, X509Cert cert, Exception ex, String messagePrefix) {
        Long certId;
        String subjectText = cert.getSubject();
        String serialText = LogUtil.formatCsn((BigInteger)cert.getCert().getSerialNumber());
        LOG.error("{} (issuser='{}': subject='{}', serialNumber={}). Message: {}", new Object[]{messagePrefix, issuer, subjectText, serialText, ex.getMessage()});
        LOG.debug("error", (Throwable)ex);
        AuditEvent event = new AuditEvent(new Date());
        event.setApplicationName("CAPublisher");
        event.setName("SYSTEM");
        event.setLevel(AuditLevel.ERROR);
        event.setStatus(AuditStatus.FAILED);
        if (cert instanceof CertWithDbId && (certId = ((CertWithDbId)cert).getCertId()) != null) {
            event.addEventData("id", (Object)certId);
        }
        event.addEventData("issuer", (Object)issuer);
        event.addEventData("subject", (Object)subjectText);
        event.addEventData("serial", (Object)serialText);
        event.addEventData("message", (Object)messagePrefix);
        Audits.getAuditService().logEvent(event);
    }

    public boolean crlAdded(X509Cert caCert, X509CRL crl) {
        return true;
    }

    public boolean isHealthy() {
        return this.queryExecutor.isHealthy();
    }

    public boolean caRevoked(X509Cert caCert, CertRevocationInfo revInfo) {
        try {
            this.queryExecutor.revokeCa(caCert, revInfo);
            return true;
        }
        catch (Exception ex) {
            String issuerText = X509Util.getRfc4519Name((X500Principal)caCert.getCert().getIssuerX500Principal());
            this.logAndAudit(issuerText, caCert, ex, "could not publish revocation of CA");
            return false;
        }
    }

    public boolean caUnrevoked(X509Cert caCert) {
        try {
            this.queryExecutor.unrevokeCa(caCert);
            return true;
        }
        catch (Exception ex) {
            String issuerText = X509Util.getRfc4519Name((X500Principal)caCert.getCert().getIssuerX500Principal());
            this.logAndAudit(issuerText, caCert, ex, "could not publish unrevocation of CA");
            return false;
        }
    }

    public boolean certificateRemoved(X509Cert issuerCert, CertWithDbId cert) {
        try {
            this.queryExecutor.removeCert(issuerCert, cert);
            return true;
        }
        catch (Exception ex) {
            String issuerText = X509Util.getRfc4519Name((X500Principal)issuerCert.getCert().getIssuerX500Principal());
            this.logAndAudit(issuerText, issuerCert, ex, "could not publish removal of certificate");
            return false;
        }
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public boolean publishsGoodCert() {
        return this.publishsGoodCert;
    }

    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }
}

