/*
 *
 * Copyright (c) 2013 - 2018 Lijun Liao
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.xipki.ca.server.store;

import java.util.Arrays;

import org.xipki.util.Base64;
import org.xipki.util.Args;

/**
 * TODO.
 * @author Lijun Liao
 * @since 2.0.0
 */

class CertBasedIdentityEntry {

  private final int id;

  private final String subject;

  private final byte[] sha1Fp;

  private final byte[] cert;

  CertBasedIdentityEntry(int id, String subject, String b64Sha1Fp, String b64Cert) {
    this.id = id;
    this.subject = subject;
    this.sha1Fp = Base64.decode(Args.notBlank(b64Sha1Fp, "b64Sha1Fp"));
    this.cert = Base64.decode(Args.notBlank(b64Cert, "b64Cert"));
  }

  int getId() {
    return id;
  }

  String getSubject() {
    return subject;
  }

  boolean matchSha1Fp(byte[] sha1HashValue) {
    return Arrays.equals(this.sha1Fp, sha1HashValue);
  }

  boolean matchCert(byte[] encodedCert) {
    return Arrays.equals(this.cert, encodedCert);
  }

}
