/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.BadFormatException;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.profile.BaseCertprofile;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.server.CaUtil;
import org.xipki.security.ExtensionExistence;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

class IdentifiedCertprofile
implements Closeable {
    private static final Set<ASN1ObjectIdentifier> CRITICAL_ONLY_EXTENSION_TYPES = new HashSet<ASN1ObjectIdentifier>();
    private static final Set<ASN1ObjectIdentifier> CA_CRITICAL_ONLY_EXTENSION_TYPES;
    private static final Set<ASN1ObjectIdentifier> NONCRITICAL_ONLY_EXTENSION_TYPES;
    private static final Set<ASN1ObjectIdentifier> CA_ONLY_EXTENSION_TYPES;
    private static final Set<ASN1ObjectIdentifier> NONE_REQUEST_EXTENSION_TYPES;
    private static final Set<ASN1ObjectIdentifier> REQUIRED_CA_EXTENSION_TYPES;
    private static final Set<ASN1ObjectIdentifier> REQUIRED_EE_EXTENSION_TYPES;
    private final MgmtEntry.Certprofile dbEntry;
    private final Certprofile certprofile;

    IdentifiedCertprofile(MgmtEntry.Certprofile dbEntry, Certprofile certprofile) throws CertprofileException {
        this.dbEntry = (MgmtEntry.Certprofile)Args.notNull((Object)dbEntry, (String)"dbEntry");
        this.certprofile = (Certprofile)Args.notNull((Object)certprofile, (String)"certprofile");
        this.certprofile.initialize(dbEntry.getConf());
    }

    public NameId getIdent() {
        return this.dbEntry.getIdent();
    }

    public MgmtEntry.Certprofile getDbEntry() {
        return this.dbEntry;
    }

    public Certprofile.X509CertVersion getVersion() {
        return this.certprofile.getVersion();
    }

    public List<String> getSignatureAlgorithms() {
        return this.certprofile.getSignatureAlgorithms();
    }

    public Date getNotBefore(Date notBefore) {
        return this.certprofile.getNotBefore(notBefore);
    }

    public Certprofile.CertValidity getValidity() {
        return this.certprofile.getValidity();
    }

    public Certprofile.SubjectInfo getSubject(X500Name requestedSubject) throws CertprofileException, BadCertTemplateException {
        Certprofile.SubjectInfo subjectInfo = this.certprofile.getSubject(requestedSubject);
        RDN[] countryRdns = subjectInfo.getGrantedSubject().getRDNs(ObjectIdentifiers.DN_C);
        if (countryRdns != null) {
            for (RDN rdn : countryRdns) {
                String textValue = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                if (SubjectDnSpec.isValidCountryAreaCode((String)textValue)) continue;
                throw new BadCertTemplateException("invalid country/area code '" + textValue + "'");
            }
        }
        return subjectInfo;
    }

    public ExtensionValues getExtensions(X500Name requestedSubject, X500Name grantedSubject, Extensions requestedExtensions, SubjectPublicKeyInfo publicKeyInfo, PublicCaInfo publicCaInfo, X509Certificate crlSignerCert, Date notBefore, Date notAfter) throws CertprofileException, BadCertTemplateException {
        Certprofile.KeyUsageControl k;
        Iterator usageOccs;
        HashSet<KeyUsage> usages;
        Object value;
        AuthorityKeyIdentifier value2;
        ASN1ObjectIdentifier extType;
        Certprofile.ExtensionControl extControl;
        Args.notNull((Object)publicKeyInfo, (String)"publicKeyInfo");
        ExtensionValues values = new ExtensionValues();
        HashMap controls = new HashMap(this.certprofile.getExtensionControls());
        HashSet<ASN1ObjectIdentifier> neededExtTypes = new HashSet<ASN1ObjectIdentifier>(2);
        HashSet<ASN1ObjectIdentifier> wantedExtTypes = new HashSet<ASN1ObjectIdentifier>(2);
        if (requestedExtensions != null) {
            Extension reqExtension = requestedExtensions.getExtension(ObjectIdentifiers.id_xipki_ext_cmpRequestExtensions);
            if (reqExtension != null) {
                ExtensionExistence ee = ExtensionExistence.getInstance((Object)reqExtension.getParsedValue());
                neededExtTypes.addAll(ee.getNeedExtensions());
                wantedExtTypes.addAll(ee.getWantExtensions());
            }
            for (ASN1ObjectIdentifier oid : neededExtTypes) {
                if (wantedExtTypes.contains(oid)) {
                    wantedExtTypes.remove(oid);
                }
                if (controls.containsKey(oid)) continue;
                throw new BadCertTemplateException("could not add needed extension " + oid.getId());
            }
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.subjectKeyIdentifier)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            byte[] encodedSpki = publicKeyInfo.getPublicKeyData().getBytes();
            byte[] skiValue = HashAlgo.SHA1.hash(encodedSpki);
            SubjectKeyIdentifier value3 = new SubjectKeyIdentifier(skiValue);
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value3, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.authorityKeyIdentifier)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            byte[] ikiValue = publicCaInfo.getSubjectKeyIdentifer();
            value2 = null;
            if (ikiValue != null) {
                if (this.certprofile.includesIssuerAndSerialInAki()) {
                    GeneralNames x509CaSubject = new GeneralNames(new GeneralName(publicCaInfo.getX500Subject()));
                    value2 = new AuthorityKeyIdentifier(ikiValue, x509CaSubject, publicCaInfo.getSerialNumber());
                } else {
                    value2 = new AuthorityKeyIdentifier(ikiValue);
                }
            }
            IdentifiedCertprofile.addExtension(values, extType, value2, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.issuerAlternativeName)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            GeneralNames value4 = publicCaInfo.getSubjectAltName();
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value4, extControl, neededExtTypes, wantedExtTypes);
        }
        extType = Extension.authorityInfoAccess;
        extControl = (Certprofile.ExtensionControl)controls.remove(extType);
        CaUris caUris = publicCaInfo.getCaUris();
        if (extControl != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            Certprofile.AuthorityInfoAccessControl aiaControl = this.certprofile.getAiaControl();
            List caIssuers = null;
            if (aiaControl == null || aiaControl.isIncludesCaIssuers()) {
                caIssuers = caUris.getCacertUris();
            }
            List ocspUris = null;
            if (aiaControl == null || aiaControl.isIncludesOcsp()) {
                ocspUris = caUris.getOcspUris();
            }
            AuthorityInformationAccess value5 = null;
            if (CollectionUtil.isNonEmpty((Collection)caIssuers) || CollectionUtil.isNonEmpty((Collection)ocspUris)) {
                value5 = CaUtil.createAuthorityInformationAccess(caIssuers, ocspUris);
            }
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value5, extControl, neededExtTypes, wantedExtTypes);
        }
        if (controls.containsKey(Extension.cRLDistributionPoints) || controls.containsKey(Extension.freshestCRL)) {
            X500Name crlSignerSubject = crlSignerCert == null ? null : X500Name.getInstance((Object)crlSignerCert.getSubjectX500Principal().getEncoded());
            X500Name x500CaPrincipal = publicCaInfo.getX500Subject();
            extType = Extension.cRLDistributionPoints;
            extControl = (Certprofile.ExtensionControl)controls.remove(extType);
            if (extControl != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
                value = null;
                if (CollectionUtil.isNonEmpty((Collection)caUris.getCrlUris())) {
                    value = CaUtil.createCrlDistributionPoints(caUris.getCrlUris(), x500CaPrincipal, crlSignerSubject);
                }
                IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value, extControl, neededExtTypes, wantedExtTypes);
            }
            if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.freshestCRL)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
                value = null;
                if (CollectionUtil.isNonEmpty((Collection)caUris.getDeltaCrlUris())) {
                    value = CaUtil.createCrlDistributionPoints(caUris.getDeltaCrlUris(), x500CaPrincipal, crlSignerSubject);
                }
                IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value, extControl, neededExtTypes, wantedExtTypes);
            }
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.basicConstraints)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            value2 = CaUtil.createBasicConstraints(this.certprofile.getCertLevel(), this.certprofile.getPathLenBasicConstraint());
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value2, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.keyUsage)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            usages = new HashSet();
            usageOccs = this.certprofile.getKeyUsage();
            value = usageOccs.iterator();
            while (value.hasNext()) {
                k = (Certprofile.KeyUsageControl)value.next();
                if (!k.isRequired()) continue;
                usages.add(k.getKeyUsage());
            }
            if (requestedExtensions != null && extControl.isRequest()) {
                IdentifiedCertprofile.addRequestedKeyusage(usages, requestedExtensions, (Set<Certprofile.KeyUsageControl>)((Object)usageOccs));
            }
            value = X509Util.createKeyUsage(usages);
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.extendedKeyUsage)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            usages = new LinkedList();
            usageOccs = this.certprofile.getExtendedKeyUsages();
            value = usageOccs.iterator();
            while (value.hasNext()) {
                k = (Certprofile.ExtKeyUsageControl)value.next();
                if (!k.isRequired()) continue;
                usages.add((KeyUsage)k.getExtKeyUsage());
            }
            if (requestedExtensions != null && extControl.isRequest()) {
                IdentifiedCertprofile.addRequestedExtKeyusage(usages, requestedExtensions, (Set<Certprofile.ExtKeyUsageControl>)((Object)usageOccs));
            }
            if (extControl.isCritical() && usages.contains(ObjectIdentifiers.id_anyExtendedKeyUsage)) {
                extControl = new Certprofile.ExtensionControl(false, extControl.isRequired(), extControl.isRequest());
            }
            value = X509Util.createExtendedUsage(usages);
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = ObjectIdentifiers.id_extension_pkix_ocsp_nocheck)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)DERNull.INSTANCE, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.subjectInfoAccess)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            value2 = null;
            if (requestedExtensions != null && extControl.isRequest()) {
                value2 = IdentifiedCertprofile.createSubjectInfoAccess(requestedExtensions, this.certprofile.getSubjectInfoAccessModes());
            }
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value2, extControl, neededExtTypes, wantedExtTypes);
        }
        LinkedList<ASN1ObjectIdentifier> listToRm = null;
        for (ASN1ObjectIdentifier extnType : controls.keySet()) {
            Certprofile.ExtensionControl ctrl = (Certprofile.ExtensionControl)controls.get(extnType);
            if (ctrl.isRequired() || neededExtTypes.contains(extnType) || wantedExtTypes.contains(extnType)) continue;
            if (listToRm == null) {
                listToRm = new LinkedList<ASN1ObjectIdentifier>();
            }
            listToRm.add(extnType);
        }
        if (listToRm != null) {
            for (ASN1ObjectIdentifier extnType : listToRm) {
                controls.remove(extnType);
            }
        }
        ExtensionValues subvalues = this.certprofile.getExtensions(Collections.unmodifiableMap(controls), requestedSubject, grantedSubject, requestedExtensions, notBefore, notAfter, publicCaInfo);
        HashSet extTypes = new HashSet(controls.keySet());
        for (ASN1ObjectIdentifier type : extTypes) {
            Extension reqExt;
            boolean addMe = IdentifiedCertprofile.addMe(type, extControl = (Certprofile.ExtensionControl)controls.remove(type), neededExtTypes, wantedExtTypes);
            if (!addMe) continue;
            ExtensionValue value6 = null;
            if (requestedExtensions != null && extControl.isRequest() && (reqExt = requestedExtensions.getExtension(type)) != null) {
                value6 = new ExtensionValue(extControl.isCritical(), reqExt.getParsedValue());
            }
            if (value6 == null) {
                value6 = subvalues.getExtensionValue(type);
            }
            IdentifiedCertprofile.addExtension(values, type, value6, extControl, neededExtTypes, wantedExtTypes);
        }
        HashSet<ASN1ObjectIdentifier> unprocessedExtTypes = new HashSet<ASN1ObjectIdentifier>();
        for (ASN1ObjectIdentifier type : controls.keySet()) {
            if (!((Certprofile.ExtensionControl)controls.get(type)).isRequired()) continue;
            unprocessedExtTypes.add(type);
        }
        if (CollectionUtil.isNonEmpty(unprocessedExtTypes)) {
            throw new CertprofileException("could not add required extensions " + IdentifiedCertprofile.toString(unprocessedExtTypes));
        }
        if (CollectionUtil.isNonEmpty(neededExtTypes)) {
            throw new BadCertTemplateException("could not add requested extensions " + IdentifiedCertprofile.toString(neededExtTypes));
        }
        return values;
    }

    public Certprofile.CertLevel getCertLevel() {
        return this.certprofile.getCertLevel();
    }

    public KeypairGenControl getKeypairGenControl() {
        return this.certprofile.getKeypairGenControl();
    }

    public boolean isOnlyForRa() {
        return this.certprofile.isOnlyForRa();
    }

    public SubjectPublicKeyInfo checkPublicKey(SubjectPublicKeyInfo publicKey) throws CertprofileException, BadCertTemplateException {
        return this.certprofile.checkPublicKey((SubjectPublicKeyInfo)Args.notNull((Object)publicKey, (String)"publicKey"));
    }

    public boolean incSerialNumberIfSubjectExists() {
        return this.certprofile.incSerialNumberIfSubjectExists();
    }

    @Override
    public void close() {
        if (this.certprofile != null) {
            this.certprofile.close();
        }
    }

    public boolean includeIssuerAndSerialInAki() {
        return this.certprofile.includesIssuerAndSerialInAki();
    }

    public String incSerialNumber(String currentSerialNumber) throws BadFormatException {
        return this.certprofile.incSerialNumber(currentSerialNumber);
    }

    public boolean isSerialNumberInReqPermitted() {
        return this.certprofile.isSerialNumberInReqPermitted();
    }

    public Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> getExtensionControls() {
        return this.certprofile.getExtensionControls();
    }

    public Set<Certprofile.KeyUsageControl> getKeyUsage() {
        return this.certprofile.getKeyUsage();
    }

    public Integer getPathLenBasicConstraint() {
        return this.certprofile.getPathLenBasicConstraint();
    }

    public Set<Certprofile.ExtKeyUsageControl> getExtendedKeyUsages() {
        return this.certprofile.getExtendedKeyUsages();
    }

    public int getMaxCertSize() {
        return this.certprofile.getMaxCertSize();
    }

    public void validate() throws CertprofileException {
        int len;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        Certprofile.ExtensionControl extCtrl;
        Certprofile.ExtensionControl control;
        Certprofile.CertLevel level;
        StringBuilder msg = new StringBuilder();
        Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> controls = this.getExtensionControls();
        HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
        for (ASN1ObjectIdentifier type2 : NONE_REQUEST_EXTENSION_TYPES) {
            Certprofile.ExtensionControl control2 = controls.get(type2);
            if (control2 == null || !control2.isRequest()) continue;
            set.add(type2);
        }
        if (CollectionUtil.isNonEmpty(set)) {
            msg.append("extensions ").append(IdentifiedCertprofile.toString(set)).append(" may not be contained in request, ");
        }
        boolean ca = (level = this.getCertLevel()) == Certprofile.CertLevel.RootCA || level == Certprofile.CertLevel.SubCA;
        set.clear();
        if (!ca) {
            set.clear();
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier2 : CA_ONLY_EXTENSION_TYPES) {
                if (!controls.containsKey(aSN1ObjectIdentifier2)) continue;
                set.add(aSN1ObjectIdentifier2);
            }
            if (CollectionUtil.isNonEmpty(set)) {
                msg.append("EE profile contains CA-only extensions ").append(IdentifiedCertprofile.toString(set)).append(", ");
            }
        }
        set.clear();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier3 : controls.keySet()) {
            control = controls.get(aSN1ObjectIdentifier3);
            if (CRITICAL_ONLY_EXTENSION_TYPES.contains(aSN1ObjectIdentifier3) && !control.isCritical()) {
                set.add(aSN1ObjectIdentifier3);
            }
            if (!ca || !CA_CRITICAL_ONLY_EXTENSION_TYPES.contains(aSN1ObjectIdentifier3) || control.isCritical()) continue;
            set.add(aSN1ObjectIdentifier3);
        }
        if (CollectionUtil.isNonEmpty(set)) {
            msg.append("critical only extensions are marked as non-critical ").append(IdentifiedCertprofile.toString(set)).append(", ");
        }
        set.clear();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier4 : controls.keySet()) {
            control = controls.get(aSN1ObjectIdentifier4);
            if (!NONCRITICAL_ONLY_EXTENSION_TYPES.contains(aSN1ObjectIdentifier4) || !control.isCritical()) continue;
            set.add(aSN1ObjectIdentifier4);
        }
        if (CollectionUtil.isNonEmpty(set)) {
            msg.append("non-critical extensions are marked as critical ").append(IdentifiedCertprofile.toString(set)).append(", ");
        }
        set.clear();
        Set<ASN1ObjectIdentifier> requiredTypes = ca ? REQUIRED_CA_EXTENSION_TYPES : REQUIRED_EE_EXTENSION_TYPES;
        for (ASN1ObjectIdentifier type4 : requiredTypes) {
            Certprofile.ExtensionControl extCtrl2 = controls.get(type4);
            if (extCtrl2 != null && extCtrl2.isRequired()) continue;
            set.add(type4);
        }
        if (!(level != Certprofile.CertLevel.SubCA || (extCtrl = controls.get(aSN1ObjectIdentifier = Extension.authorityKeyIdentifier)) != null && extCtrl.isRequired())) {
            set.add(aSN1ObjectIdentifier);
        }
        if (!set.isEmpty()) {
            msg.append("required extensions are not marked as required ").append(IdentifiedCertprofile.toString(set)).append(", ");
        }
        Set<Certprofile.KeyUsageControl> set2 = this.getKeyUsage();
        if (ca) {
            if (!IdentifiedCertprofile.containsKeyusage(set2, KeyUsage.keyCertSign)) {
                msg.append("CA profile does not contain keyUsage ").append(KeyUsage.keyCertSign).append(", ");
            }
        } else {
            KeyUsage[] caOnlyUsages = new KeyUsage[]{KeyUsage.keyCertSign, KeyUsage.cRLSign};
            HashSet<KeyUsage> setUsages = new HashSet<KeyUsage>();
            for (KeyUsage caOnlyUsage : caOnlyUsages) {
                if (!IdentifiedCertprofile.containsKeyusage(set2, caOnlyUsage)) continue;
                setUsages.add(caOnlyUsage);
            }
            if (CollectionUtil.isNonEmpty(set)) {
                msg.append("EE profile contains CA-only keyUsage ").append(setUsages).append(", ");
            }
        }
        if ((len = msg.length()) > 2) {
            msg.delete(len - 2, len);
            throw new CertprofileException(msg.toString());
        }
    }

    private static String toString(Set<ASN1ObjectIdentifier> oids) {
        if (oids == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ASN1ObjectIdentifier oid : oids) {
            String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
            if (name != null) {
                sb.append(name);
                sb.append(" (").append(oid.getId()).append(")");
            } else {
                sb.append(oid.getId());
            }
            sb.append(", ");
        }
        if (CollectionUtil.isNonEmpty(oids)) {
            int len = sb.length();
            sb.delete(len - 2, len);
        }
        sb.append("]");
        return sb.toString();
    }

    private static boolean containsKeyusage(Set<Certprofile.KeyUsageControl> usageControls, KeyUsage usage) {
        for (Certprofile.KeyUsageControl entry : usageControls) {
            if (usage != entry.getKeyUsage()) continue;
            return true;
        }
        return false;
    }

    private static boolean addMe(ASN1ObjectIdentifier extType, Certprofile.ExtensionControl extControl, Set<ASN1ObjectIdentifier> neededExtTypes, Set<ASN1ObjectIdentifier> wantedExtTypes) {
        boolean addMe = extControl.isRequired();
        if (addMe) {
            return true;
        }
        return neededExtTypes.contains(extType) || wantedExtTypes.contains(extType);
    }

    private static void addRequestedKeyusage(Set<KeyUsage> usages, Extensions requestedExtensions, Set<Certprofile.KeyUsageControl> usageOccs) {
        Extension extension = requestedExtensions.getExtension(Extension.keyUsage);
        if (extension == null) {
            return;
        }
        org.bouncycastle.asn1.x509.KeyUsage reqKeyUsage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extension.getParsedValue());
        for (Certprofile.KeyUsageControl k : usageOccs) {
            if (k.isRequired() || !reqKeyUsage.hasUsages(k.getKeyUsage().getBcUsage())) continue;
            usages.add(k.getKeyUsage());
        }
    }

    private static void addRequestedExtKeyusage(List<ASN1ObjectIdentifier> usages, Extensions requestedExtensions, Set<Certprofile.ExtKeyUsageControl> usageOccs) {
        Extension extension = requestedExtensions.getExtension(Extension.extendedKeyUsage);
        if (extension == null) {
            return;
        }
        ExtendedKeyUsage reqKeyUsage = ExtendedKeyUsage.getInstance((Object)extension.getParsedValue());
        for (Certprofile.ExtKeyUsageControl k : usageOccs) {
            if (k.isRequired() || !reqKeyUsage.hasKeyPurposeId(KeyPurposeId.getInstance((Object)k.getExtKeyUsage()))) continue;
            usages.add(k.getExtKeyUsage());
        }
    }

    private static ASN1Sequence createSubjectInfoAccess(Extensions requestedExtensions, Map<ASN1ObjectIdentifier, Set<Certprofile.GeneralNameMode>> modes) throws BadCertTemplateException {
        if (modes == null) {
            return null;
        }
        ASN1Encodable extValue = requestedExtensions.getExtensionParsedValue(Extension.subjectInfoAccess);
        if (extValue == null) {
            return null;
        }
        ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)extValue);
        int size = reqSeq.size();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i < size; ++i) {
            AccessDescription ad = AccessDescription.getInstance((Object)reqSeq.getObjectAt(i));
            ASN1ObjectIdentifier accessMethod = ad.getAccessMethod();
            Set<Certprofile.GeneralNameMode> generalNameModes = modes.get(accessMethod);
            if (generalNameModes == null) {
                throw new BadCertTemplateException("subjectInfoAccess.accessMethod " + accessMethod.getId() + " is not allowed");
            }
            GeneralName accessLocation = BaseCertprofile.createGeneralName((GeneralName)ad.getAccessLocation(), generalNameModes);
            vec.add((ASN1Encodable)new AccessDescription(accessMethod, accessLocation));
        }
        return vec.size() > 0 ? new DERSequence(vec) : null;
    }

    private static void addExtension(ExtensionValues values, ASN1ObjectIdentifier extType, ExtensionValue extValue, Certprofile.ExtensionControl extControl, Set<ASN1ObjectIdentifier> neededExtensionTypes, Set<ASN1ObjectIdentifier> wantedExtensionTypes) throws CertprofileException {
        if (extValue != null) {
            values.addExtension(extType, extValue);
            neededExtensionTypes.remove(extType);
            wantedExtensionTypes.remove(extType);
        } else if (extControl.isRequired()) {
            String description = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extType);
            if (description == null) {
                description = extType.getId();
            }
            throw new CertprofileException("could not add required extension " + description);
        }
    }

    private static void addExtension(ExtensionValues values, ASN1ObjectIdentifier extType, ASN1Encodable extValue, Certprofile.ExtensionControl extControl, Set<ASN1ObjectIdentifier> neededExtensionTypes, Set<ASN1ObjectIdentifier> wantedExtensionTypes) throws CertprofileException {
        if (extValue != null) {
            values.addExtension(extType, extControl.isCritical(), extValue);
            neededExtensionTypes.remove(extType);
            wantedExtensionTypes.remove(extType);
        } else if (extControl.isRequired()) {
            String description = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extType);
            if (description == null) {
                description = extType.getId();
            }
            throw new CertprofileException("could not add required extension " + description);
        }
    }

    static {
        CRITICAL_ONLY_EXTENSION_TYPES.add(Extension.keyUsage);
        CRITICAL_ONLY_EXTENSION_TYPES.add(Extension.policyMappings);
        CRITICAL_ONLY_EXTENSION_TYPES.add(Extension.nameConstraints);
        CRITICAL_ONLY_EXTENSION_TYPES.add(Extension.policyConstraints);
        CRITICAL_ONLY_EXTENSION_TYPES.add(Extension.inhibitAnyPolicy);
        CRITICAL_ONLY_EXTENSION_TYPES.add(ObjectIdentifiers.id_pe_tlsfeature);
        CA_CRITICAL_ONLY_EXTENSION_TYPES = new HashSet<ASN1ObjectIdentifier>();
        CA_CRITICAL_ONLY_EXTENSION_TYPES.add(Extension.basicConstraints);
        NONCRITICAL_ONLY_EXTENSION_TYPES = new HashSet<ASN1ObjectIdentifier>();
        NONCRITICAL_ONLY_EXTENSION_TYPES.add(Extension.authorityKeyIdentifier);
        NONCRITICAL_ONLY_EXTENSION_TYPES.add(Extension.subjectKeyIdentifier);
        NONCRITICAL_ONLY_EXTENSION_TYPES.add(Extension.issuerAlternativeName);
        NONCRITICAL_ONLY_EXTENSION_TYPES.add(Extension.subjectDirectoryAttributes);
        NONCRITICAL_ONLY_EXTENSION_TYPES.add(Extension.freshestCRL);
        NONCRITICAL_ONLY_EXTENSION_TYPES.add(Extension.authorityInfoAccess);
        NONCRITICAL_ONLY_EXTENSION_TYPES.add(Extension.subjectInfoAccess);
        CA_ONLY_EXTENSION_TYPES = new HashSet<ASN1ObjectIdentifier>();
        CA_ONLY_EXTENSION_TYPES.add(Extension.policyMappings);
        CA_ONLY_EXTENSION_TYPES.add(Extension.nameConstraints);
        CA_ONLY_EXTENSION_TYPES.add(Extension.policyConstraints);
        CA_ONLY_EXTENSION_TYPES.add(Extension.inhibitAnyPolicy);
        NONE_REQUEST_EXTENSION_TYPES = new HashSet<ASN1ObjectIdentifier>();
        NONE_REQUEST_EXTENSION_TYPES.add(Extension.subjectKeyIdentifier);
        NONE_REQUEST_EXTENSION_TYPES.add(Extension.authorityKeyIdentifier);
        NONE_REQUEST_EXTENSION_TYPES.add(Extension.issuerAlternativeName);
        NONE_REQUEST_EXTENSION_TYPES.add(Extension.cRLDistributionPoints);
        NONE_REQUEST_EXTENSION_TYPES.add(Extension.freshestCRL);
        NONE_REQUEST_EXTENSION_TYPES.add(Extension.basicConstraints);
        NONE_REQUEST_EXTENSION_TYPES.add(Extension.inhibitAnyPolicy);
        REQUIRED_CA_EXTENSION_TYPES = new HashSet<ASN1ObjectIdentifier>();
        REQUIRED_CA_EXTENSION_TYPES.add(Extension.basicConstraints);
        REQUIRED_CA_EXTENSION_TYPES.add(Extension.subjectKeyIdentifier);
        REQUIRED_CA_EXTENSION_TYPES.add(Extension.keyUsage);
        REQUIRED_EE_EXTENSION_TYPES = new HashSet<ASN1ObjectIdentifier>();
        REQUIRED_EE_EXTENSION_TYPES.add(Extension.authorityKeyIdentifier);
        REQUIRED_EE_EXTENSION_TYPES.add(Extension.subjectKeyIdentifier);
    }
}

