/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.security.SecureRandom;

class RandomSerialNumberGenerator {
    private static int[] MASKS = new int[]{-1, 1, 3, 7, 15, 31, 63, 127};
    private static RandomSerialNumberGenerator instance;
    private final SecureRandom random = new SecureRandom();

    private RandomSerialNumberGenerator() {
    }

    public BigInteger nextSerialNumber(int bitLen) {
        byte[] rdnBytes = new byte[(bitLen + 7) / 8];
        this.random.nextBytes(rdnBytes);
        int ci = bitLen % 8;
        if (ci != 0) {
            rdnBytes[0] = (byte)(rdnBytes[0] & MASKS[ci]);
        }
        return new BigInteger(1, rdnBytes);
    }

    public static synchronized RandomSerialNumberGenerator getInstance() {
        if (instance == null) {
            instance = new RandomSerialNumberGenerator();
        }
        return instance;
    }
}

