/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.publisher;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherFactory;
import org.xipki.ca.server.publisher.OcspCertPublisher;
import org.xipki.util.ObjectCreationException;

public class OcspCertPublisherFactory
implements CertPublisherFactory {
    private static final String TYPE = "ocsp";
    private static final Set<String> types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ocsp")));

    public Set<String> getSupportedTypes() {
        return types;
    }

    public boolean canCreatePublisher(String type) {
        return types.contains(type.toLowerCase());
    }

    public CertPublisher newPublisher(String type) throws ObjectCreationException {
        if (TYPE.equalsIgnoreCase(type)) {
            return new OcspCertPublisher();
        }
        throw new ObjectCreationException("unknown publisher type " + type);
    }
}

