/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.server.DhpocControl;
import org.xipki.ca.server.RandomSerialNumberGenerator;
import org.xipki.ca.server.store.CertStore;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.Validity;

public class CaInfo {
    private static final Logger LOG = LoggerFactory.getLogger(CaInfo.class);
    private static final long MS_PER_DAY = 86400000L;
    private final MgmtEntry.Ca caEntry;
    private final long noNewCertificateAfter;
    private final BigInteger serialNumber;
    private final Date notBefore;
    private final Date notAfter;
    private final boolean selfSigned;
    private final CMPCertificate certInCmpFormat;
    private final PublicCaInfo publicCaInfo;
    private final List<X509Cert> certchain;
    private final CertStore certStore;
    private final RandomSerialNumberGenerator randomSnGenerator;
    private DhpocControl dhpocControl;
    private Map<String, ConcurrentContentSigner> signers;
    private ConcurrentContentSigner dfltSigner;
    private RevokeSuspendedControl revokeSuspendedCertsControl;

    public CaInfo(MgmtEntry.Ca caEntry, CertStore certStore) throws OperationException {
        Certificate bcCert;
        this.caEntry = (MgmtEntry.Ca)Args.notNull((Object)caEntry, (String)"caEntry");
        this.certStore = (CertStore)Args.notNull((Object)certStore, (String)"certStore");
        X509Certificate cert = caEntry.getCert();
        this.notBefore = cert.getNotBefore();
        this.notAfter = cert.getNotAfter();
        this.serialNumber = cert.getSerialNumber();
        this.selfSigned = cert.getIssuerX500Principal().equals(cert.getSubjectX500Principal());
        try {
            byte[] encodedCert = cert.getEncoded();
            bcCert = Certificate.getInstance((Object)encodedCert);
        }
        catch (CertificateEncodingException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "could not encode the CA certificate");
        }
        this.certInCmpFormat = new CMPCertificate(bcCert);
        this.publicCaInfo = new PublicCaInfo(cert, caEntry.getCaUris(), caEntry.getExtraControl());
        List certs = caEntry.getCertchain();
        this.certchain = new LinkedList<X509Cert>();
        if (CollectionUtil.isNonEmpty((Collection)certs)) {
            for (X509Certificate m : certs) {
                this.certchain.add(new X509Cert(m));
            }
        }
        this.noNewCertificateAfter = this.notAfter.getTime() - 86400000L * (long)caEntry.getExpirationPeriod();
        this.randomSnGenerator = RandomSerialNumberGenerator.getInstance();
    }

    public PublicCaInfo getPublicCaInfo() {
        return this.publicCaInfo;
    }

    public String getSubject() {
        return this.caEntry.getSubject();
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isSelfSigned() {
        return this.selfSigned;
    }

    public CMPCertificate getCertInCmpFormat() {
        return this.certInCmpFormat;
    }

    public long getNoNewCertificateAfter() {
        return this.noNewCertificateAfter;
    }

    public MgmtEntry.Ca getCaEntry() {
        return this.caEntry;
    }

    public NameId getIdent() {
        return this.caEntry.getIdent();
    }

    public CaUris getCaUris() {
        return this.caEntry.getCaUris();
    }

    public Validity getMaxValidity() {
        return this.caEntry.getMaxValidity();
    }

    public void setMaxValidity(Validity maxValidity) {
        this.caEntry.setMaxValidity(maxValidity);
    }

    public X509Cert getCert() {
        return this.publicCaInfo.getCaCert();
    }

    public List<X509Cert> getCertchain() {
        return this.certchain;
    }

    public String getSignerConf() {
        return this.caEntry.getSignerConf();
    }

    public String getCrlSignerName() {
        return this.caEntry.getCrlSignerName();
    }

    public void setCrlSignerName(String crlSignerName) {
        this.caEntry.setCrlSignerName(crlSignerName);
    }

    public CrlControl getCrlControl() {
        return this.caEntry.getCrlControl();
    }

    public void setCrlControl(CrlControl crlControl) {
        this.caEntry.setCrlControl(crlControl);
    }

    public String getCmpResponderName() {
        return this.caEntry.getCmpResponderName();
    }

    public void setCmpResponderName(String name) {
        this.caEntry.setCmpResponderName(name);
    }

    public CmpControl getCmpControl() {
        return this.caEntry.getCmpControl();
    }

    public void setCmpControl(CmpControl cmpControl) {
        this.caEntry.setCmpControl(cmpControl);
    }

    public CtlogControl getCtlogControl() {
        return this.caEntry.getCtlogControl();
    }

    public DhpocControl getDhpocControl() {
        return this.dhpocControl;
    }

    public String getScepResponderName() {
        return this.caEntry.getScepResponderName();
    }

    public void setScepResponderName(String name) {
        this.caEntry.setScepResponderName(name);
    }

    public ScepControl getSCepControl() {
        return this.caEntry.getScepControl();
    }

    public void setScepControl(ScepControl control) {
        this.caEntry.setScepControl(control);
    }

    public int getNumCrls() {
        return this.caEntry.getNumCrls();
    }

    public CaStatus getStatus() {
        return this.caEntry.getStatus();
    }

    public void setStatus(CaStatus status) {
        this.caEntry.setStatus(status);
    }

    public String getSignerType() {
        return this.caEntry.getSignerType();
    }

    public String toString() {
        return this.caEntry.toString(false);
    }

    public String toString(boolean verbose) {
        return this.caEntry.toString(verbose);
    }

    public boolean isDuplicateKeyPermitted() {
        return this.caEntry.isDuplicateKeyPermitted();
    }

    public void setDuplicateKeyPermitted(boolean permitted) {
        this.caEntry.setDuplicateKeyPermitted(permitted);
    }

    public boolean isDuplicateSubjectPermitted() {
        return this.caEntry.isDuplicateSubjectPermitted();
    }

    public void setDuplicateSubjectPermitted(boolean permitted) {
        this.caEntry.setDuplicateSubjectPermitted(permitted);
    }

    public boolean supportsCmp() {
        return this.caEntry.getProtocoSupport().isCmp();
    }

    public boolean supportsRest() {
        return this.caEntry.getProtocoSupport().isRest();
    }

    public boolean supportsScep() {
        return this.caEntry.getProtocoSupport().isScep();
    }

    public void setProtocolSupport(ProtocolSupport protocolSupport) {
        this.caEntry.setProtocolSupport(protocolSupport);
    }

    public boolean isSaveRequest() {
        return this.caEntry.isSaveRequest();
    }

    public void setSaveRequest(boolean saveRequest) {
        this.caEntry.setSaveRequest(saveRequest);
    }

    public ValidityMode getValidityMode() {
        return this.caEntry.getValidityMode();
    }

    public void setValidityMode(ValidityMode mode) {
        this.caEntry.setValidityMode(mode);
    }

    public int getPermission() {
        return this.caEntry.getPermission();
    }

    public void setPermission(int permission) {
        this.caEntry.setPermission(permission);
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.caEntry.getRevocationInfo();
    }

    public void setRevocationInfo(CertRevocationInfo revocationInfo) {
        this.caEntry.setRevocationInfo(revocationInfo);
    }

    public int getExpirationPeriod() {
        return this.caEntry.getExpirationPeriod();
    }

    public void setKeepExpiredCertInDays(int days) {
        this.caEntry.setKeepExpiredCertInDays(days);
    }

    public int getKeepExpiredCertInDays() {
        return this.caEntry.getKeepExpiredCertInDays();
    }

    public BigInteger nextSerial() throws OperationException {
        return this.randomSnGenerator.nextSerialNumber(this.caEntry.getSerialNoBitLen());
    }

    public BigInteger nextCrlNumber() throws OperationException {
        long currentMaxNo;
        long crlNo = this.caEntry.getNextCrlNumber();
        if (crlNo <= (currentMaxNo = this.certStore.getMaxCrlNumber(this.caEntry.getIdent()))) {
            crlNo = currentMaxNo + 1L;
        }
        this.caEntry.setNextCrlNumber(crlNo + 1L);
        return BigInteger.valueOf(crlNo);
    }

    public ConcurrentContentSigner getSigner(List<String> algoNames) {
        if (CollectionUtil.isEmpty(algoNames)) {
            return this.dfltSigner;
        }
        for (String name : algoNames) {
            if (!this.signers.containsKey(name)) continue;
            return this.signers.get(name);
        }
        return null;
    }

    public boolean initSigner(SecurityFactory securityFactory) throws XiSecurityException {
        if (this.signers != null) {
            return true;
        }
        this.dfltSigner = null;
        List signerConfs = MgmtEntry.Ca.splitCaSignerConfs((String)this.caEntry.getSignerConf());
        HashMap<String, ConcurrentContentSigner> tmpSigners = new HashMap<String, ConcurrentContentSigner>();
        for (String[] m : signerConfs) {
            String algo = m[0];
            SignerConf signerConf = new SignerConf(m[1]);
            try {
                ConcurrentContentSigner signer = securityFactory.createSigner(this.caEntry.getSignerType(), signerConf, this.caEntry.getCert());
                if (this.dfltSigner == null) {
                    this.dfltSigner = signer;
                }
                tmpSigners.put(algo, signer);
            }
            catch (Throwable th) {
                for (ConcurrentContentSigner ccs : tmpSigners.values()) {
                    try {
                        ccs.close();
                    }
                    catch (IOException ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not close ConcurrentContentSigner " + ccs.getName()));
                    }
                }
                tmpSigners.clear();
                throw new XiSecurityException("could not initialize the CA signer");
            }
        }
        this.signers = Collections.unmodifiableMap(tmpSigners);
        return true;
    }

    public boolean initDhpocControl(SecurityFactory securityFactory) throws XiSecurityException {
        if (this.dhpocControl != null) {
            return true;
        }
        this.dhpocControl = this.caEntry.getDhpocControl() != null ? new DhpocControl(this.caEntry.getDhpocControl(), securityFactory) : null;
        return true;
    }

    public boolean isSignerRequired() {
        int permission = this.caEntry.getPermission();
        return PermissionConstants.contains((int)permission, (int)128) || PermissionConstants.contains((int)permission, (int)1) || PermissionConstants.contains((int)permission, (int)32) || PermissionConstants.contains((int)permission, (int)16);
    }

    public RevokeSuspendedControl revokeSuspendedCertsControl() {
        return this.revokeSuspendedCertsControl;
    }

    public void setRevokeSuspendedCertsControl(RevokeSuspendedControl revokeSuspendedCertsControl) {
        this.revokeSuspendedCertsControl = revokeSuspendedCertsControl;
    }
}

