/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.util.encoders.Base64;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.SecurityFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;

public class DhpocControl {
    private final List<DHSigStaticKeyCertPair> keyAndCerts = new ArrayList<DHSigStaticKeyCertPair>(1);
    private final X509Cert[] certs;

    public DhpocControl(String conf, SecurityFactory securityFactory) throws XiSecurityException {
        ConfPairs pairs = new ConfPairs(conf);
        String type = pairs.value("type");
        String passwordStr = pairs.value("password");
        String keystoreStr = pairs.value("keystore");
        if (StringUtil.isBlank((String)type)) {
            throw new IllegalArgumentException("no type is definied in conf");
        }
        if (StringUtil.isBlank((String)keystoreStr)) {
            throw new IllegalArgumentException("no keystore is definied in conf");
        }
        if (StringUtil.isBlank((String)passwordStr)) {
            throw new IllegalArgumentException("no password is definied in conf");
        }
        if (!keystoreStr.startsWith("base64:")) {
            throw new IllegalArgumentException("keystore not start with 'base64:'");
        }
        byte[] bytes = Base64.decode((String)keystoreStr.substring("base64:".length()));
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            char[] password = passwordStr.toCharArray();
            KeyStore ks = KeyUtil.getKeyStore((String)type);
            ks.load(is, password);
            Enumeration<String> aliases = ks.aliases();
            LinkedList<X509Cert> certs = new LinkedList<X509Cert>();
            while (aliases.hasMoreElements()) {
                PrivateKey key;
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias) || !((key = (PrivateKey)ks.getKey(alias, password)) instanceof XDHKey)) continue;
                X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                this.keyAndCerts.add(new DHSigStaticKeyCertPair(key, cert));
                certs.add(new X509Cert(cert));
            }
            this.certs = certs.toArray(new X509Cert[0]);
        }
        catch (IOException | ClassCastException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
    }

    public X509Cert[] getCertificates() {
        if (this.certs == null || this.certs.length == 0) {
            return null;
        }
        return Arrays.copyOf(this.certs, this.certs.length);
    }

    public DHSigStaticKeyCertPair getKeyCertPair(X500Name issuer, BigInteger serial, String keyAlgorithm) {
        for (DHSigStaticKeyCertPair m : this.keyAndCerts) {
            if (!m.getIssuer().equals((Object)issuer) || !m.getSerialNumber().equals(serial) || !m.getPrivateKey().getAlgorithm().equalsIgnoreCase(keyAlgorithm)) continue;
            return m;
        }
        return null;
    }
}

