/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.BadFormatException;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.profile.BaseCertprofile;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionSpec;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.server.CaUtil;
import org.xipki.security.EdECConstants;
import org.xipki.security.ExtensionExistence;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Validity;

class IdentifiedCertprofile
implements Closeable {
    private static Validity maxCabEeValidity = new Validity(825, Validity.Unit.DAY);
    private final MgmtEntry.Certprofile dbEntry;
    private final Certprofile certprofile;

    IdentifiedCertprofile(MgmtEntry.Certprofile dbEntry, Certprofile certprofile) throws CertprofileException {
        this.dbEntry = (MgmtEntry.Certprofile)Args.notNull((Object)dbEntry, (String)"dbEntry");
        this.certprofile = (Certprofile)Args.notNull((Object)certprofile, (String)"certprofile");
        this.certprofile.initialize(dbEntry.getConf());
    }

    public NameId getIdent() {
        return this.dbEntry.getIdent();
    }

    public MgmtEntry.Certprofile getDbEntry() {
        return this.dbEntry;
    }

    public Certprofile.X509CertVersion getVersion() {
        return this.certprofile.getVersion();
    }

    public List<String> getSignatureAlgorithms() {
        return this.certprofile.getSignatureAlgorithms();
    }

    public Date getNotBefore(Date notBefore) {
        return this.certprofile.getNotBefore(notBefore);
    }

    public Validity getValidity() {
        return this.certprofile.getValidity();
    }

    public Certprofile.SubjectInfo getSubject(X500Name requestedSubject) throws CertprofileException, BadCertTemplateException {
        ASN1ObjectIdentifier[] countryOids;
        Certprofile.SubjectInfo subjectInfo = this.certprofile.getSubject(requestedSubject);
        if (this.certprofile.getCertDomain() == Certprofile.CertDomain.CABForumBR) {
            X500Name subject = subjectInfo.getGrantedSubject();
            if (this.getCertLevel() == Certprofile.CertLevel.EndEntity) {
                ASN1ObjectIdentifier[] includeSubjectFields;
                CertificatePolicies policies = this.certprofile.getCertificatePolicies();
                ASN1ObjectIdentifier policyId = null;
                if (policies != null) {
                    for (PolicyInformation m : policies.getPolicyInformation()) {
                        ASN1ObjectIdentifier pid = m.getPolicyIdentifier();
                        if (!ObjectIdentifiers.BaseRequirements.id_domain_validated.equals((Object)pid) && !ObjectIdentifiers.BaseRequirements.id_organization_validated.equals((Object)pid) && !ObjectIdentifiers.BaseRequirements.id_individual_validated.equals((Object)pid)) continue;
                        policyId = pid;
                        break;
                    }
                }
                if (IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.street) && !IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.O) && !IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.givenName) && !IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.surname)) {
                    throw new BadCertTemplateException("subject:street is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                }
                if (IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.localityName)) {
                    if (!(IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.O) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.givenName) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("subject:localityName is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                    }
                } else if (!IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.ST) && (IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.O) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.givenName) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:localityName is required if the subject:organizationName field, subject:givenName field, or subject:surname field are present and the subject:stateOrProvinceName field is absent.");
                }
                if (IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                    if (!(IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.O) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.givenName) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("subject:stateOrProvinceName is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                    }
                } else if (!IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.localityName) && (IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.O) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.givenName) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:stateOrProvinceName is required if the subject:organizationName field, subject:givenName field, or subject:surname field are present and the subject:localityName field is absent.");
                }
                if (IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.postalCode) && !IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.O) && !IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.givenName) && !IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.surname)) {
                    throw new BadCertTemplateException("subject:postalCode is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                }
                if (!IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.C) && (IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.O) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.givenName) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:countryCode is required if the subject:organizationName field, subject:givenName, and subject:surname field are present");
                }
                if (ObjectIdentifiers.BaseRequirements.id_domain_validated.equals((Object)policyId)) {
                    ASN1ObjectIdentifier[] excludeSubjectFields;
                    for (ASN1ObjectIdentifier m : excludeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.givenName, ObjectIdentifiers.DN.surname, ObjectIdentifiers.DN.street, ObjectIdentifiers.DN.localityName, ObjectIdentifiers.DN.ST, ObjectIdentifiers.DN.postalCode}) {
                        if (!IdentifiedCertprofile.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is prohibited in domain validated certificate");
                    }
                } else if (ObjectIdentifiers.BaseRequirements.id_organization_validated.equals((Object)policyId)) {
                    for (ASN1ObjectIdentifier m : includeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.C}) {
                        if (IdentifiedCertprofile.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is required in organization validated certificate");
                    }
                    if (!IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.localityName) && !IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                        throw new BadCertTemplateException("at least one of subject:localityName and subject:stateOrProvinceName is required in organization validated certificate");
                    }
                } else if (ObjectIdentifiers.BaseRequirements.id_individual_validated.equals((Object)policyId)) {
                    for (ASN1ObjectIdentifier m : includeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C}) {
                        if (IdentifiedCertprofile.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is required in individual validated certificate");
                    }
                    if (!(IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.O) || IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.givenName) && IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("at least one of subject:organizationName and (subject:givenName, subject:surName) is required in individual validated certificate");
                    }
                    if (!IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.localityName) && !IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                        throw new BadCertTemplateException("at least one of subject:localityName and subject:stateOrProvinceName is required in individual validated certificate");
                    }
                }
            } else {
                ASN1ObjectIdentifier[] requiredTypes;
                for (ASN1ObjectIdentifier m : requiredTypes = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.CN, ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.C}) {
                    if (IdentifiedCertprofile.containsRdn(subject, ObjectIdentifiers.DN.CN)) continue;
                    throw new BadCertTemplateException("missing " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " in subject");
                }
            }
        }
        for (ASN1ObjectIdentifier oid : countryOids = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C, ObjectIdentifiers.DN.countryOfCitizenship, ObjectIdentifiers.DN.countryOfResidence, ObjectIdentifiers.DN.jurisdictionOfIncorporationCountryName}) {
            RDN[] countryRdns = subjectInfo.getGrantedSubject().getRDNs(oid);
            if (countryRdns == null) continue;
            for (RDN rdn : countryRdns) {
                String textValue = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                if (SubjectDnSpec.isValidCountryAreaCode((String)textValue)) continue;
                String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
                if (name == null) {
                    name = oid.getId();
                }
                throw new BadCertTemplateException("invalid country/area code '" + textValue + "' in subject attribute " + name);
            }
        }
        return subjectInfo;
    }

    public ExtensionValues getExtensions(X500Name requestedSubject, X500Name grantedSubject, Extensions requestedExtensions, SubjectPublicKeyInfo publicKeyInfo, PublicCaInfo publicCaInfo, X509Certificate crlSignerCert, Date notBefore, Date notAfter) throws CertprofileException, BadCertTemplateException {
        Certprofile.KeyUsageControl k;
        Iterator usageOccs;
        Object value;
        ASN1ObjectIdentifier extType;
        Certprofile.ExtensionControl extControl;
        Args.notNull((Object)publicKeyInfo, (String)"publicKeyInfo");
        ExtensionValues values = new ExtensionValues();
        HashMap controls = new HashMap(this.certprofile.getExtensionControls());
        controls.remove(ObjectIdentifiers.Extn.id_SCTs);
        HashSet<ASN1ObjectIdentifier> neededExtTypes = new HashSet<ASN1ObjectIdentifier>(2);
        HashSet<ASN1ObjectIdentifier> wantedExtTypes = new HashSet<ASN1ObjectIdentifier>(2);
        if (requestedExtensions != null) {
            Extension reqExtension = requestedExtensions.getExtension(ObjectIdentifiers.Xipki.id_xipki_ext_cmpRequestExtensions);
            if (reqExtension != null) {
                ExtensionExistence ee = ExtensionExistence.getInstance((Object)reqExtension.getParsedValue());
                neededExtTypes.addAll(ee.getNeedExtensions());
                wantedExtTypes.addAll(ee.getWantExtensions());
            }
            for (ASN1ObjectIdentifier oid : neededExtTypes) {
                if (wantedExtTypes.contains(oid)) {
                    wantedExtTypes.remove(oid);
                }
                if (controls.containsKey(oid)) continue;
                throw new BadCertTemplateException("could not add needed extension " + oid.getId());
            }
        }
        HashMap<ASN1ObjectIdentifier, Extension> requestedExtns = new HashMap<ASN1ObjectIdentifier, Extension>();
        if (requestedExtensions != null) {
            ASN1ObjectIdentifier oids;
            for (ASN1ObjectIdentifier m : oids = requestedExtensions.getExtensionOIDs()) {
                Certprofile.ExtensionControl control = (Certprofile.ExtensionControl)controls.get(m);
                if (control != null && !control.isRequest()) continue;
                requestedExtns.put(m, requestedExtensions.getExtension(m));
            }
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.subjectKeyIdentifier)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            byte[] encodedSpki = publicKeyInfo.getPublicKeyData().getBytes();
            byte[] skiValue = HashAlgo.SHA1.hash((byte[][])new byte[][]{encodedSpki});
            SubjectKeyIdentifier value2 = new SubjectKeyIdentifier(skiValue);
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value2, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.authorityKeyIdentifier)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            AuthorityKeyIdentifier value3 = null;
            if (this.certprofile.useIssuerAndSerialInAki()) {
                GeneralNames x509CaSubject = new GeneralNames(new GeneralName(publicCaInfo.getX500Subject()));
                value3 = new AuthorityKeyIdentifier(x509CaSubject, publicCaInfo.getSerialNumber());
            } else {
                byte[] ikiValue = publicCaInfo.getSubjectKeyIdentifer();
                if (ikiValue != null) {
                    value3 = new AuthorityKeyIdentifier(ikiValue);
                }
            }
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value3, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.issuerAlternativeName)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            GeneralNames value4 = publicCaInfo.getSubjectAltName();
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value4, extControl, neededExtTypes, wantedExtTypes);
        }
        extType = Extension.authorityInfoAccess;
        extControl = (Certprofile.ExtensionControl)controls.remove(extType);
        CaUris caUris = publicCaInfo.getCaUris();
        if (extControl != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            Certprofile.AuthorityInfoAccessControl aiaControl = this.certprofile.getAiaControl();
            List caIssuers = null;
            if (aiaControl == null || aiaControl.isIncludesCaIssuers()) {
                caIssuers = caUris.getCacertUris();
            }
            List ocspUris = null;
            if (aiaControl == null || aiaControl.isIncludesOcsp()) {
                ocspUris = caUris.getOcspUris();
            }
            AuthorityInformationAccess value5 = null;
            if (CollectionUtil.isNonEmpty((Collection)caIssuers) || CollectionUtil.isNonEmpty((Collection)ocspUris)) {
                value5 = CaUtil.createAuthorityInformationAccess(caIssuers, ocspUris);
            }
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value5, extControl, neededExtTypes, wantedExtTypes);
        }
        if (controls.containsKey(Extension.cRLDistributionPoints) || controls.containsKey(Extension.freshestCRL)) {
            X500Name crlSignerSubject = crlSignerCert == null ? null : X500Name.getInstance((Object)crlSignerCert.getSubjectX500Principal().getEncoded());
            X500Name x500CaPrincipal = publicCaInfo.getX500Subject();
            extType = Extension.cRLDistributionPoints;
            extControl = (Certprofile.ExtensionControl)controls.remove(extType);
            if (extControl != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
                value = null;
                if (CollectionUtil.isNonEmpty((Collection)caUris.getCrlUris())) {
                    value = CaUtil.createCrlDistributionPoints(caUris.getCrlUris(), x500CaPrincipal, crlSignerSubject);
                }
                IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value, extControl, neededExtTypes, wantedExtTypes);
            }
            if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.freshestCRL)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
                value = null;
                if (CollectionUtil.isNonEmpty((Collection)caUris.getDeltaCrlUris())) {
                    value = CaUtil.createCrlDistributionPoints(caUris.getDeltaCrlUris(), x500CaPrincipal, crlSignerSubject);
                }
                IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value, extControl, neededExtTypes, wantedExtTypes);
            }
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.basicConstraints)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            BasicConstraints value6 = CaUtil.createBasicConstraints(this.certprofile.getCertLevel(), this.certprofile.getPathLenBasicConstraint());
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value6, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.keyUsage)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            HashSet<KeyUsage> usages = new HashSet<KeyUsage>();
            usageOccs = this.certprofile.getKeyUsage();
            value = usageOccs.iterator();
            while (value.hasNext()) {
                k = (Certprofile.KeyUsageControl)value.next();
                if (!k.isRequired()) continue;
                usages.add(k.getKeyUsage());
            }
            IdentifiedCertprofile.addRequestedKeyusage(usages, requestedExtns, (Set<Certprofile.KeyUsageControl>)((Object)usageOccs));
            value = X509Util.createKeyUsage(usages);
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.extendedKeyUsage)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            LinkedList<ASN1ObjectIdentifier> usages = new LinkedList<ASN1ObjectIdentifier>();
            usageOccs = this.certprofile.getExtendedKeyUsages();
            value = usageOccs.iterator();
            while (value.hasNext()) {
                k = (Certprofile.ExtKeyUsageControl)value.next();
                if (!k.isRequired()) continue;
                usages.add(k.getExtKeyUsage());
            }
            IdentifiedCertprofile.addRequestedExtKeyusage(usages, requestedExtns, (Set<Certprofile.ExtKeyUsageControl>)((Object)usageOccs));
            if (extControl.isCritical() && usages.contains(ObjectIdentifiers.XKU.id_kp_anyExtendedKeyUsage)) {
                extControl = new Certprofile.ExtensionControl(false, extControl.isRequired(), extControl.isRequest());
            }
            value = X509Util.createExtendedUsage(usages);
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = ObjectIdentifiers.Extn.id_extension_pkix_ocsp_nocheck)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)DERNull.INSTANCE, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.subjectInfoAccess)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            ASN1Sequence value7 = IdentifiedCertprofile.createSubjectInfoAccess(requestedExtns, this.certprofile.getSubjectInfoAccessModes());
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value7, extControl, neededExtTypes, wantedExtTypes);
        }
        if ((extControl = (Certprofile.ExtensionControl)controls.remove(extType = Extension.certificatePolicies)) != null && IdentifiedCertprofile.addMe(extType, extControl, neededExtTypes, wantedExtTypes)) {
            CertificatePolicies value8 = this.certprofile.getCertificatePolicies();
            IdentifiedCertprofile.addExtension(values, extType, (ASN1Encodable)value8, extControl, neededExtTypes, wantedExtTypes);
        }
        LinkedList<ASN1ObjectIdentifier> listToRm = null;
        for (ASN1ObjectIdentifier extnType : controls.keySet()) {
            Certprofile.ExtensionControl ctrl = (Certprofile.ExtensionControl)controls.get(extnType);
            if (ctrl.isRequired() || neededExtTypes.contains(extnType) || wantedExtTypes.contains(extnType) || requestedExtns.get(extnType) != null) continue;
            if (listToRm == null) {
                listToRm = new LinkedList<ASN1ObjectIdentifier>();
            }
            listToRm.add(extnType);
        }
        if (listToRm != null) {
            for (ASN1ObjectIdentifier extnType : listToRm) {
                controls.remove(extnType);
            }
        }
        ExtensionValues subvalues = this.certprofile.getExtensions(Collections.unmodifiableMap(controls), requestedSubject, grantedSubject, requestedExtns, notBefore, notAfter, publicCaInfo);
        HashSet extTypes = new HashSet(controls.keySet());
        for (Object type : extTypes) {
            boolean addMe = IdentifiedCertprofile.addMe((ASN1ObjectIdentifier)type, extControl = (Certprofile.ExtensionControl)controls.get(type), neededExtTypes, wantedExtTypes);
            if (addMe) {
                Extension reqExt;
                ExtensionValue value9 = subvalues.getExtensionValue((ASN1ObjectIdentifier)type);
                if (value9 == null && requestedExtns != null && extControl.isRequest() && (reqExt = (Extension)requestedExtns.get(type)) != null) {
                    value9 = new ExtensionValue(extControl.isCritical(), reqExt.getParsedValue());
                }
                if (value9 == null) continue;
                IdentifiedCertprofile.addExtension(values, (ASN1ObjectIdentifier)type, value9, extControl, neededExtTypes, wantedExtTypes);
                controls.remove(type);
                continue;
            }
            controls.remove(type);
        }
        HashSet<ASN1ObjectIdentifier> unprocessedExtTypes = new HashSet<ASN1ObjectIdentifier>();
        for (ASN1ObjectIdentifier type : controls.keySet()) {
            if (!((Certprofile.ExtensionControl)controls.get(type)).isRequired()) continue;
            unprocessedExtTypes.add(type);
        }
        if (CollectionUtil.isNonEmpty(unprocessedExtTypes)) {
            throw new CertprofileException("could not add required extensions " + IdentifiedCertprofile.toString(unprocessedExtTypes));
        }
        if (CollectionUtil.isNonEmpty(neededExtTypes)) {
            throw new BadCertTemplateException("could not add requested extensions " + IdentifiedCertprofile.toString(neededExtTypes));
        }
        if (this.certprofile.getCertDomain() == Certprofile.CertDomain.CABForumBR && this.getCertLevel() == Certprofile.CertLevel.EndEntity) {
            GeneralName[] genNames;
            String commonName = X509Util.getCommonName((X500Name)grantedSubject);
            boolean commonNameInSan = commonName == null;
            for (GeneralName m : genNames = GeneralNames.getInstance((Object)values.getExtensionValue(Extension.subjectAlternativeName).getValue()).getNames()) {
                byte[] octets;
                if (2 == m.getTagNo()) {
                    String domain = DERIA5String.getInstance((Object)m.getName()).getString();
                    if (!commonNameInSan && domain.equals(commonName)) {
                        commonNameInSan = true;
                    }
                    if (domain.indexOf(95) != -1) {
                        throw new BadCertTemplateException("invalid DNSName " + domain);
                    }
                    if (ExtensionSpec.isValidPublicDomain((String)domain)) continue;
                    throw new BadCertTemplateException("invalid DNSName " + domain);
                }
                if (7 != m.getTagNo() || (octets = DEROctetString.getInstance((Object)m.getName()).getOctets()).length != 4) continue;
                String ipAddressText = (0xFF & octets[0]) + "." + (0xFF & octets[1]) + "." + (0xFF & octets[2]) + "." + (0xFF & octets[3]);
                if (!commonNameInSan && ipAddressText.equals(commonName)) {
                    commonNameInSan = true;
                }
                if (ExtensionSpec.isValidPublicIPv4Address((byte[])octets)) continue;
                throw new BadCertTemplateException("invalid IPv4Address " + ipAddressText);
            }
            if (!commonNameInSan) {
                throw new BadCertTemplateException("content of subject:commonName is not included in extension:SubjectAlternativeNames");
            }
        }
        return values;
    }

    public Certprofile.CertLevel getCertLevel() {
        return this.certprofile.getCertLevel();
    }

    public KeypairGenControl getKeypairGenControl() {
        return this.certprofile.getKeypairGenControl();
    }

    public boolean isOnlyForRa() {
        return this.certprofile.isOnlyForRa();
    }

    public SubjectPublicKeyInfo checkPublicKey(SubjectPublicKeyInfo publicKey) throws CertprofileException, BadCertTemplateException {
        return this.certprofile.checkPublicKey((SubjectPublicKeyInfo)Args.notNull((Object)publicKey, (String)"publicKey"));
    }

    public boolean incSerialNumberIfSubjectExists() {
        return this.certprofile.incSerialNumberIfSubjectExists();
    }

    @Override
    public void close() {
        if (this.certprofile != null) {
            this.certprofile.close();
        }
    }

    public boolean useIssuerAndSerialInAki() {
        return this.certprofile.useIssuerAndSerialInAki();
    }

    public String incSerialNumber(String currentSerialNumber) throws BadFormatException {
        return this.certprofile.incSerialNumber(currentSerialNumber);
    }

    public boolean isSerialNumberInReqPermitted() {
        return this.certprofile.isSerialNumberInReqPermitted();
    }

    public Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> getExtensionControls() {
        return this.certprofile.getExtensionControls();
    }

    public Set<Certprofile.KeyUsageControl> getKeyUsage() {
        return this.certprofile.getKeyUsage();
    }

    public Integer getPathLenBasicConstraint() {
        return this.certprofile.getPathLenBasicConstraint();
    }

    public Set<Certprofile.ExtKeyUsageControl> getExtendedKeyUsages() {
        return this.certprofile.getExtendedKeyUsages();
    }

    public int getMaxCertSize() {
        return this.certprofile.getMaxCertSize();
    }

    public void validate() throws CertprofileException {
        int len;
        boolean withMontgomeryCurves;
        Map keyAlgorithms;
        Integer pathLen;
        Certprofile.ExtensionControl control;
        StringBuilder msg = new StringBuilder();
        Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> controls = this.getExtensionControls();
        HashSet<ASN1ObjectIdentifier> types = new HashSet<ASN1ObjectIdentifier>(controls.keySet());
        Certprofile.CertLevel certLevel = this.getCertLevel();
        Certprofile.CertDomain certDomain = this.certprofile.getCertDomain();
        ExtensionSpec spec = ExtensionSpec.getExtensionSpec((Certprofile.CertDomain)certDomain, (Certprofile.CertLevel)certLevel);
        HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : types) {
            control = controls.get(aSN1ObjectIdentifier);
            if (!control.isRequest() || !spec.isNonRequest(aSN1ObjectIdentifier)) continue;
            set.add(aSN1ObjectIdentifier);
        }
        if (CollectionUtil.isNonEmpty(set)) {
            msg.append("extensions ").append(IdentifiedCertprofile.toString(set)).append(" must not be contained in request, ");
        }
        set.clear();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : types) {
            if (!spec.isNotPermitted(aSN1ObjectIdentifier)) continue;
            set.add(aSN1ObjectIdentifier);
        }
        if (CollectionUtil.isNonEmpty(set)) {
            msg.append("extensions ").append(IdentifiedCertprofile.toString(set)).append(" must not be contained, ");
        }
        set.clear();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : types) {
            control = controls.get(aSN1ObjectIdentifier);
            if (!control.isCritical() || !spec.isNonCriticalOnly(aSN1ObjectIdentifier)) continue;
            set.add(aSN1ObjectIdentifier);
        }
        if (CollectionUtil.isNonEmpty(set)) {
            msg.append("critical only extensions are marked as non-critical ").append(IdentifiedCertprofile.toString(set)).append(", ");
        }
        set.clear();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : types) {
            control = controls.get(aSN1ObjectIdentifier);
            if (control.isCritical() || !spec.isCriticalOnly(aSN1ObjectIdentifier)) continue;
            set.add(aSN1ObjectIdentifier);
        }
        if (CollectionUtil.isNonEmpty(set)) {
            msg.append("non-critical only extensions are marked as critical ").append(IdentifiedCertprofile.toString(set)).append(", ");
        }
        set.clear();
        Set requiredTypes = spec.getRequiredExtensions();
        for (ASN1ObjectIdentifier type : requiredTypes) {
            KeyUsage[] extCtrl = controls.get(type);
            if (extCtrl != null && extCtrl.isRequired()) continue;
            set.add(type);
        }
        if (!set.isEmpty()) {
            msg.append("required extensions are not configured or not marked as required ").append(IdentifiedCertprofile.toString(set)).append(", ");
        }
        Set<Certprofile.KeyUsageControl> set2 = this.getKeyUsage();
        if (certLevel == Certprofile.CertLevel.SubCA || certLevel == Certprofile.CertLevel.RootCA) {
            KeyUsage[] requiredUsages;
            for (KeyUsage usage : requiredUsages = new KeyUsage[]{KeyUsage.keyCertSign, KeyUsage.cRLSign}) {
                if (IdentifiedCertprofile.containsKeyusage(set2, usage)) continue;
                msg.append("CA profile does not contain keyUsage ").append(usage).append(", ");
            }
        } else {
            KeyUsage[] caOnlyUsages = new KeyUsage[]{KeyUsage.keyCertSign};
            HashSet<KeyUsage> setUsages = new HashSet<KeyUsage>();
            for (KeyUsage caOnlyUsage : caOnlyUsages) {
                if (!IdentifiedCertprofile.containsKeyusage(set2, caOnlyUsage)) continue;
                setUsages.add(caOnlyUsage);
            }
            if (CollectionUtil.isNonEmpty(set)) {
                msg.append("EndEntity profile must not contain CA-only keyUsage ").append(setUsages).append(", ");
            }
        }
        if (certLevel == Certprofile.CertLevel.RootCA && (pathLen = this.getPathLenBasicConstraint()) != null) {
            msg.append("Root CA must not set PathLen, ");
        }
        if (certDomain == Certprofile.CertDomain.CABForumBR) {
            this.validateCABForumBR(msg);
        }
        boolean withEdwardsCurves = (keyAlgorithms = this.certprofile.getKeyAlgorithms()).containsKey(EdECConstants.id_Ed25519) || keyAlgorithms.containsKey(EdECConstants.id_Ed448);
        boolean bl = withMontgomeryCurves = keyAlgorithms.containsKey(EdECConstants.id_X25519) || keyAlgorithms.containsKey(EdECConstants.id_X448);
        if (withEdwardsCurves || withMontgomeryCurves) {
            List<KeyUsage> allowedUsages;
            HashSet<KeyUsage> requiredUsages = new HashSet<KeyUsage>();
            HashSet<KeyUsage> optionalUsages = new HashSet<KeyUsage>();
            if (set2 != null) {
                for (Certprofile.KeyUsageControl m : set2) {
                    if (m.isRequired()) {
                        requiredUsages.add(m.getKeyUsage());
                        continue;
                    }
                    optionalUsages.add(m.getKeyUsage());
                }
            }
            if (withMontgomeryCurves) {
                if (certLevel != Certprofile.CertLevel.EndEntity) {
                    msg.append("montgomery curves are not permitted in CA certificates, ");
                }
                if (!requiredUsages.contains(KeyUsage.keyAgreement)) {
                    msg.append("required KeyUsage KeyAgreement is not marked as 'required', ");
                }
                allowedUsages = Arrays.asList(KeyUsage.keyAgreement, KeyUsage.encipherOnly, KeyUsage.decipherOnly);
            } else if (certLevel == Certprofile.CertLevel.EndEntity) {
                if (!requiredUsages.contains(KeyUsage.digitalSignature) && !requiredUsages.contains(KeyUsage.contentCommitment)) {
                    msg.append("required KeyUsage digitalSignature or contentCommitment is not marked as 'required', ");
                }
                allowedUsages = Arrays.asList(KeyUsage.digitalSignature, KeyUsage.contentCommitment);
            } else {
                allowedUsages = Arrays.asList(KeyUsage.digitalSignature, KeyUsage.contentCommitment, KeyUsage.keyCertSign, KeyUsage.cRLSign);
            }
            requiredUsages.removeAll(allowedUsages);
            optionalUsages.removeAll(allowedUsages);
            if (!requiredUsages.isEmpty()) {
                msg.append("Required KeyUsage items ").append(requiredUsages).append(" are not permitted, ");
            }
            if (!optionalUsages.isEmpty()) {
                msg.append("Optional KeyUsage items ").append(requiredUsages).append(" are not permitted, ");
            }
        }
        if ((len = msg.length()) > 2) {
            msg.delete(len - 2, len);
            throw new CertprofileException(msg.toString());
        }
    }

    private void validateCABForumBR(StringBuilder msg) {
        CertificatePolicies certPolicyValue;
        List<String> sigAlgos;
        Validity validity;
        Certprofile.SubjectControl subjectCtl = this.certprofile.getSubjectControl();
        if (CollectionUtil.isNonEmpty((Collection)subjectCtl.getGroups())) {
            msg.append("multiple AttributeAndTypes in one RDN is not permitted, ");
        }
        for (ASN1ObjectIdentifier m : subjectCtl.getTypes()) {
            Certprofile.RdnControl ctl = subjectCtl.getControl(m);
            if (ctl.getMaxOccurs() <= 1) continue;
            msg.append("multiple RDNs of the same type are not permitted, ");
        }
        Certprofile.CertLevel certLevel = this.getCertLevel();
        if (certLevel == Certprofile.CertLevel.EndEntity && (validity = this.certprofile.getValidity()).compareTo(maxCabEeValidity) == 1) {
            msg.append("validity exceeds the maximal validity of subscriber certificate, ");
        }
        if ((sigAlgos = this.getSignatureAlgorithms()) == null) {
            msg.append("signature algorithms not defined, ");
        } else {
            List<HashAlgo> allowedHashAlgos = Arrays.asList(HashAlgo.SHA256, HashAlgo.SHA384, HashAlgo.SHA512);
            for (String string : sigAlgos) {
                try {
                    AlgorithmIdentifier sigAlgId = AlgorithmUtil.getSigAlgId((String)string);
                    AlgorithmIdentifier digestAlgId = AlgorithmUtil.extractDigesetAlgFromSigAlg((AlgorithmIdentifier)sigAlgId);
                    HashAlgo hashAlgo = HashAlgo.getNonNullInstance((ASN1ObjectIdentifier)digestAlgId.getAlgorithm());
                    if (allowedHashAlgos.contains(hashAlgo)) continue;
                    msg.append("unpermitted hash algorithm ").append(hashAlgo).append(", ");
                }
                catch (IllegalArgumentException | NoSuchAlgorithmException ex) {
                    msg.append("unknown signature algorithm ").append(string).append(", ");
                }
            }
        }
        Map keyAlgorithms = this.certprofile.getKeyAlgorithms();
        if (CollectionUtil.isEmpty((Map)keyAlgorithms)) {
            msg.append("keyAlgorithms is not configured, ");
        } else {
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : keyAlgorithms.keySet()) {
                KeyParametersOption opt = (KeyParametersOption)keyAlgorithms.get(aSN1ObjectIdentifier);
                if (aSN1ObjectIdentifier.equals((Object)PKCSObjectIdentifiers.rsaEncryption)) {
                    if (opt instanceof KeyParametersOption.RSAParametersOption) {
                        if (!((KeyParametersOption.RSAParametersOption)opt).allowsModulusLength(2047)) continue;
                        msg.append("minimum RSA modulus size 2048 bit not satisfied, ");
                        continue;
                    }
                    msg.append("unpermitted RSA modulus are configured, ");
                    continue;
                }
                if (aSN1ObjectIdentifier.equals((Object)X9ObjectIdentifiers.id_ecPublicKey)) {
                    if (opt instanceof KeyParametersOption.ECParamatersOption) {
                        HashSet curveOids = new HashSet(((KeyParametersOption.ECParamatersOption)opt).getCurveOids());
                        curveOids.remove(SECObjectIdentifiers.secp256r1);
                        curveOids.remove(SECObjectIdentifiers.secp384r1);
                        curveOids.remove(SECObjectIdentifiers.secp521r1);
                        if (curveOids.isEmpty()) continue;
                        msg.append("EC curves ").append(curveOids).append(" are not permitted, ");
                        continue;
                    }
                    msg.append("unpermitted EC curves are configured, ");
                    continue;
                }
                if (aSN1ObjectIdentifier.equals((Object)X9ObjectIdentifiers.id_dsa)) {
                    if (opt instanceof KeyParametersOption.DSAParametersOption) {
                        KeyParametersOption.DSAParametersOption dsaOpt = (KeyParametersOption.DSAParametersOption)opt;
                        if (dsaOpt.allowsPlength(2047)) {
                            msg.append("minimum L (2048) not satisfied, ");
                        }
                        if (!dsaOpt.allowsQlength(223)) continue;
                        msg.append("minimum N (224) not satisfied, ");
                        continue;
                    }
                    msg.append("unpermitted DSA (p,q) are configured, ");
                    continue;
                }
                msg.append("keyAlgorithm ").append(aSN1ObjectIdentifier.getId() + " is not permitted, ");
            }
        }
        Certprofile.CrlDistributionPointsControl crlDpControl = this.certprofile.getCrlDpControl();
        if (crlDpControl == null) {
            msg.append("restriction of CRLDistributionPoints is not configured, ");
        } else {
            Set set = crlDpControl.getProtocols();
            if (set == null || set.size() != 1 || !set.contains("http")) {
                msg.append("CRLDistributionPoints allows protocol other than http, ");
            }
        }
        Certprofile.CrlDistributionPointsControl crlDistributionPointsControl = this.certprofile.getFreshestCrlControl();
        if (crlDistributionPointsControl == null) {
            msg.append("restriction of FreshestCRL is not configured, ");
        } else {
            Set protocols = crlDistributionPointsControl.getProtocols();
            if (protocols == null || protocols.size() != 1 || !protocols.contains("http")) {
                msg.append("FreshestCRL allows protocol other than http, ");
            }
        }
        Certprofile.AuthorityInfoAccessControl aiaControl = this.certprofile.getAiaControl();
        if (aiaControl == null) {
            msg.append("restriction of AuthorityInfoAccess is not configured, ");
        } else {
            Set protocols;
            if (!aiaControl.isIncludesOcsp()) {
                msg.append("access method id-ad-ocsp is not configured, ");
            } else {
                protocols = aiaControl.getOcspProtocols();
                if (protocols == null || protocols.size() != 1 || !protocols.contains("http")) {
                    msg.append("AIA OCSP allows protocol other than http, ");
                }
            }
            if (!aiaControl.isIncludesCaIssuers()) {
                msg.append("access method id-ad-caIssuers is not configured, ");
            } else {
                protocols = aiaControl.getCaIssuersProtocols();
                if (protocols == null || protocols.size() != 1 || !protocols.contains("http")) {
                    msg.append("AIA CAIssuers allows protocol other than http, ");
                }
            }
        }
        if ((certLevel == Certprofile.CertLevel.SubCA || certLevel == Certprofile.CertLevel.EndEntity) && (certPolicyValue = this.certprofile.getCertificatePolicies()) == null) {
            msg.append("CertificatePolicies is not configured, ");
        }
        if (certLevel == Certprofile.CertLevel.EndEntity) {
            Set sanModes = this.certprofile.getSubjectAltNameModes();
            if (sanModes == null) {
                msg.append("Restriction of SubjectAltNames is not configured, ");
            } else {
                HashSet<Certprofile.GeneralNameMode> tmp = new HashSet<Certprofile.GeneralNameMode>(sanModes);
                for (Certprofile.GeneralNameMode generalNameMode : sanModes) {
                    if (generalNameMode.getTag() == Certprofile.GeneralNameTag.uniformResourceIdentifier || generalNameMode.getTag() != Certprofile.GeneralNameTag.IPAddress) continue;
                    tmp.add(generalNameMode);
                }
                if (!tmp.isEmpty()) {
                    msg.append("SubjectAltNames ").append(tmp).append(" is not configured, ");
                }
            }
        }
        Set<Certprofile.KeyUsageControl> usages = this.getKeyUsage();
        if (certLevel == Certprofile.CertLevel.RootCA || certLevel == Certprofile.CertLevel.SubCA) {
            if (!IdentifiedCertprofile.containsKeyusage(usages, KeyUsage.cRLSign)) {
                msg.append("RootCA profile does contain keyUsage ").append(KeyUsage.cRLSign).append(", ");
            }
        } else if (certLevel == Certprofile.CertLevel.EndEntity && IdentifiedCertprofile.containsKeyusage(usages, KeyUsage.cRLSign)) {
            msg.append("EndEntity profile must not contain keyUsage ").append(KeyUsage.cRLSign).append(", ");
        }
        Set<Certprofile.ExtKeyUsageControl> ekuControls = this.getExtendedKeyUsages();
        if (certLevel == Certprofile.CertLevel.EndEntity) {
            boolean bl;
            int xkuTlsServerRequired = 0;
            boolean bl2 = false;
            for (Certprofile.ExtKeyUsageControl m : ekuControls) {
                ASN1ObjectIdentifier oid = m.getExtKeyUsage();
                if (m.isRequired()) {
                    if (ObjectIdentifiers.XKU.id_kp_serverAuth.equals((Object)oid)) {
                        xkuTlsServerRequired = 1;
                    } else if (ObjectIdentifiers.XKU.id_kp_clientAuth.equals((Object)oid)) {
                        bl = true;
                    }
                }
                if (ObjectIdentifiers.XKU.id_kp_serverAuth.equals((Object)oid) || ObjectIdentifiers.XKU.id_kp_clientAuth.equals((Object)oid) || ObjectIdentifiers.XKU.id_kp_emailProtection.equals((Object)oid)) continue;
                msg.append("extendedKeyUsage ").append(oid.getId() + " is not permitted, ");
            }
            if ((bl | xkuTlsServerRequired) == 0) {
                msg.append("none of ").append(ObjectIdentifiers.XKU.id_kp_clientAuth).append(" and ").append(ObjectIdentifiers.XKU.id_kp_serverAuth).append(" is not configured, ");
            }
        } else if (ekuControls != null) {
            for (Certprofile.ExtKeyUsageControl extKeyUsageControl : ekuControls) {
                if (!extKeyUsageControl.getExtKeyUsage().equals((Object)ObjectIdentifiers.XKU.id_kp_anyExtendedKeyUsage)) continue;
                msg.append(ObjectIdentifiers.XKU.id_kp_clientAuth).append(" is not allowed, ");
            }
        }
    }

    private static boolean containsRdn(X500Name name, ASN1ObjectIdentifier rdnType) {
        RDN[] rdns = name.getRDNs(rdnType);
        return rdns != null && rdns.length > 0;
    }

    private static String toString(Set<ASN1ObjectIdentifier> oids) {
        if (oids == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ASN1ObjectIdentifier oid : oids) {
            String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
            if (name != null) {
                sb.append(name);
                sb.append(" (").append(oid.getId()).append(")");
            } else {
                sb.append(oid.getId());
            }
            sb.append(", ");
        }
        if (CollectionUtil.isNonEmpty(oids)) {
            int len = sb.length();
            sb.delete(len - 2, len);
        }
        sb.append("]");
        return sb.toString();
    }

    private static boolean containsKeyusage(Set<Certprofile.KeyUsageControl> usageControls, KeyUsage usage) {
        for (Certprofile.KeyUsageControl entry : usageControls) {
            if (usage != entry.getKeyUsage()) continue;
            return true;
        }
        return false;
    }

    private static boolean addMe(ASN1ObjectIdentifier extType, Certprofile.ExtensionControl extControl, Set<ASN1ObjectIdentifier> neededExtTypes, Set<ASN1ObjectIdentifier> wantedExtTypes) {
        if (extControl.isRequired()) {
            return true;
        }
        return neededExtTypes.contains(extType) || wantedExtTypes.contains(extType);
    }

    private static void addRequestedKeyusage(Set<KeyUsage> usages, Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Set<Certprofile.KeyUsageControl> usageOccs) {
        Extension extension = requestedExtensions.get(Extension.keyUsage);
        if (extension == null) {
            return;
        }
        org.bouncycastle.asn1.x509.KeyUsage reqKeyUsage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extension.getParsedValue());
        for (Certprofile.KeyUsageControl k : usageOccs) {
            if (k.isRequired() || !reqKeyUsage.hasUsages(k.getKeyUsage().getBcUsage())) continue;
            usages.add(k.getKeyUsage());
        }
    }

    private static void addRequestedExtKeyusage(List<ASN1ObjectIdentifier> usages, Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Set<Certprofile.ExtKeyUsageControl> usageOccs) {
        Extension extension = requestedExtensions.get(Extension.extendedKeyUsage);
        if (extension == null) {
            return;
        }
        ExtendedKeyUsage reqKeyUsage = ExtendedKeyUsage.getInstance((Object)extension.getParsedValue());
        for (Certprofile.ExtKeyUsageControl k : usageOccs) {
            if (k.isRequired() || !reqKeyUsage.hasKeyPurposeId(KeyPurposeId.getInstance((Object)k.getExtKeyUsage()))) continue;
            usages.add(k.getExtKeyUsage());
        }
    }

    private static ASN1Sequence createSubjectInfoAccess(Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Map<ASN1ObjectIdentifier, Set<Certprofile.GeneralNameMode>> modes) throws BadCertTemplateException {
        if (modes == null) {
            return null;
        }
        Extension extn = requestedExtensions.get(Extension.subjectInfoAccess);
        if (extn == null) {
            return null;
        }
        ASN1Encodable extValue = extn.getParsedValue();
        if (extValue == null) {
            return null;
        }
        ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)extValue);
        int size = reqSeq.size();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i < size; ++i) {
            AccessDescription ad = AccessDescription.getInstance((Object)reqSeq.getObjectAt(i));
            ASN1ObjectIdentifier accessMethod = ad.getAccessMethod();
            Set<Certprofile.GeneralNameMode> generalNameModes = modes.get(accessMethod);
            if (generalNameModes == null) {
                throw new BadCertTemplateException("subjectInfoAccess.accessMethod " + accessMethod.getId() + " is not allowed");
            }
            GeneralName accessLocation = BaseCertprofile.createGeneralName((GeneralName)ad.getAccessLocation(), generalNameModes);
            vec.add((ASN1Encodable)new AccessDescription(accessMethod, accessLocation));
        }
        return vec.size() > 0 ? new DERSequence(vec) : null;
    }

    private static void addExtension(ExtensionValues values, ASN1ObjectIdentifier extType, ExtensionValue extValue, Certprofile.ExtensionControl extControl, Set<ASN1ObjectIdentifier> neededExtensionTypes, Set<ASN1ObjectIdentifier> wantedExtensionTypes) throws CertprofileException {
        if (extValue != null) {
            values.addExtension(extType, extValue);
            neededExtensionTypes.remove(extType);
            wantedExtensionTypes.remove(extType);
        } else if (extControl.isRequired()) {
            String description = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extType);
            if (description == null) {
                description = extType.getId();
            }
            throw new CertprofileException("could not add required extension " + description);
        }
    }

    private static void addExtension(ExtensionValues values, ASN1ObjectIdentifier extType, ASN1Encodable extValue, Certprofile.ExtensionControl extControl, Set<ASN1ObjectIdentifier> neededExtensionTypes, Set<ASN1ObjectIdentifier> wantedExtensionTypes) throws CertprofileException {
        if (extValue != null) {
            values.addExtension(extType, extControl.isCritical(), extValue);
            neededExtensionTypes.remove(extType);
            wantedExtensionTypes.remove(extType);
        } else if (extControl.isRequired()) {
            String description = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extType);
            if (description == null) {
                description = extType.getId();
            }
            throw new CertprofileException("could not add required extension " + description);
        }
    }
}

