/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.server.ByUserRequestorInfo;
import org.xipki.ca.server.CaManagerImpl;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.KnowCertResult;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.X509Ca;
import org.xipki.scep.crypto.ScepHashAlgo;
import org.xipki.scep.exception.MessageDecodingException;
import org.xipki.scep.exception.MessageEncodingException;
import org.xipki.scep.message.CaCaps;
import org.xipki.scep.message.DecodedPkiMessage;
import org.xipki.scep.message.EnvelopedDataDecryptor;
import org.xipki.scep.message.EnvelopedDataDecryptorInstance;
import org.xipki.scep.message.IssuerAndSubject;
import org.xipki.scep.message.PkiMessage;
import org.xipki.scep.transaction.CaCapability;
import org.xipki.scep.transaction.FailInfo;
import org.xipki.scep.transaction.MessageType;
import org.xipki.scep.transaction.Nonce;
import org.xipki.scep.transaction.PkiStatus;
import org.xipki.scep.transaction.TransactionId;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class ScepResponder {
    private static final Logger LOG = LoggerFactory.getLogger(ScepResponder.class);
    private static final long DFLT_MAX_SIGNINGTIME_BIAS = 300000L;
    private static final Set<ASN1ObjectIdentifier> AES_ENC_ALGOS = new HashSet<ASN1ObjectIdentifier>();
    private final NameId caIdent;
    private final ScepControl control;
    private final CaManagerImpl caManager;
    private final CaCaps caCaps;
    private PrivateKey responderKey;
    private X509Certificate responderCert;
    private EnvelopedDataDecryptor envelopedDataDecryptor;
    private X509Cert caCert;
    private ScepCaCertRespBytes caCertRespBytes;
    private long maxSigningTimeBiasInMs = 300000L;

    public ScepResponder(CaManagerImpl caManager, MgmtEntry.Ca caEntry) throws CaMgmtException {
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.caIdent = ((MgmtEntry.Ca)Args.notNull((Object)caEntry, (String)"caEntry")).getIdent();
        this.control = caEntry.getScepControl();
        String responderName = caEntry.getScepResponderName();
        SignerEntryWrapper responder = caManager.getSignerWrapper(responderName);
        if (responder == null) {
            throw new CaMgmtException("Unknown responder " + responderName);
        }
        CaCaps caps = new CaCaps();
        caps.addCapabilities(new CaCapability[]{CaCapability.AES, CaCapability.DES3, CaCapability.POSTPKIOperation, CaCapability.Renewal, CaCapability.SHA1, CaCapability.SHA256, CaCapability.SHA512});
        this.caCaps = caps;
        this.setResponder(responder);
    }

    public final void setResponder(SignerEntryWrapper responder) throws CaMgmtException {
        if (responder == null) {
            this.responderKey = null;
            this.responderCert = null;
            this.envelopedDataDecryptor = null;
            return;
        }
        ConcurrentContentSigner signer = responder.getSigner();
        Key signingKey = signer.getSigningKey();
        if (!(signingKey instanceof PrivateKey)) {
            throw new CaMgmtException("Unsupported signer type: the signing key is not a PrivateKey");
        }
        if (!(signer.getCertificate().getPublicKey() instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("The SCEP responder key is not RSA key for CA " + this.caIdent.getName());
        }
        this.responderKey = (PrivateKey)signingKey;
        this.responderCert = signer.getCertificate();
        this.envelopedDataDecryptor = new EnvelopedDataDecryptor(new EnvelopedDataDecryptorInstance(this.responderCert, this.responderKey));
    }

    public void setMaxSigningTimeBias(long ms) {
        this.maxSigningTimeBiasInMs = ms;
    }

    public NameId getCaIdent() {
        return this.caIdent;
    }

    public CaCaps getCaCaps() {
        return this.caCaps;
    }

    public ScepCaCertRespBytes getCaCertResp() throws OperationException {
        this.refreshCa();
        return this.caCertRespBytes;
    }

    public boolean isOnService() {
        X509Ca ca;
        try {
            ca = this.caManager.getX509Ca(this.caIdent);
        }
        catch (CaMgmtException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex);
            return false;
        }
        if (ca == null) {
            return false;
        }
        if (!ca.getCaInfo().supportsScep()) {
            return false;
        }
        return ca.getCaInfo().getStatus() == CaStatus.ACTIVE;
    }

    public ContentInfo servicePkiOperation(CMSSignedData requestContent, String certprofileName, String msgId, AuditEvent event) throws MessageDecodingException, OperationException {
        if (!this.isOnService()) {
            LOG.warn("SCEP {} is not active", (Object)this.caIdent.getName());
            throw new OperationException(OperationException.ErrorCode.SYSTEM_UNAVAILABLE);
        }
        DecodedPkiMessage req = DecodedPkiMessage.decode((CMSSignedData)requestContent, (EnvelopedDataDecryptor)this.envelopedDataDecryptor, null);
        PkiMessage rep = this.servicePkiOperation0(requestContent, req, certprofileName, msgId, event);
        ScepResponder.audit(event, "pki_status", rep.getPkiStatus().toString());
        if (rep.getPkiStatus() == PkiStatus.FAILURE) {
            event.setStatus(AuditStatus.FAILED);
        }
        if (rep.getFailInfo() != null) {
            ScepResponder.audit(event, "fail_info", rep.getFailInfo().toString());
        }
        return this.encodeResponse(rep, req);
    }

    private PkiMessage servicePkiOperation0(CMSSignedData requestContent, DecodedPkiMessage req, String certprofileName, String msgId, AuditEvent event) throws MessageDecodingException, OperationException {
        X509Ca ca;
        String oid;
        ScepHashAlgo hashAlgo;
        Boolean bo;
        Args.notNull((Object)requestContent, (String)"requestContent");
        String tid = ((DecodedPkiMessage)Args.notNull((Object)req, (String)"req")).getTransactionId().getId();
        ScepResponder.audit(event, "tid", tid);
        if (req.getFailureMessage() != null) {
            ScepResponder.audit(event, "failure_message", req.getFailureMessage());
        }
        if ((bo = req.isSignatureValid()) != null && !bo.booleanValue()) {
            ScepResponder.audit(event, "signature", "invalid");
        }
        if ((bo = req.isDecryptionSuccessful()) != null && !bo.booleanValue()) {
            ScepResponder.audit(event, "decryption", "failed");
        }
        PkiMessage rep = new PkiMessage(req.getTransactionId(), MessageType.CertRep, Nonce.randomNonce());
        rep.setRecipientNonce(req.getSenderNonce());
        if (req.getFailureMessage() != null) {
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badRequest);
            return rep;
        }
        bo = req.isSignatureValid();
        if (bo != null && !bo.booleanValue()) {
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badMessageCheck);
            return rep;
        }
        bo = req.isDecryptionSuccessful();
        if (bo != null && !bo.booleanValue()) {
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badRequest);
            return rep;
        }
        Date signingTime = req.getSigningTime();
        if (this.maxSigningTimeBiasInMs > 0L) {
            boolean isTimeBad = false;
            if (signingTime == null) {
                isTimeBad = true;
            } else {
                long now = System.currentTimeMillis();
                long diff = now - signingTime.getTime();
                if (diff < 0L) {
                    diff = -1L * diff;
                }
                boolean bl = isTimeBad = diff > this.maxSigningTimeBiasInMs;
            }
            if (isTimeBad) {
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badTime);
                return rep;
            }
        }
        if ((hashAlgo = ScepHashAlgo.forNameOrOid((String)(oid = req.getDigestAlgorithm().getId()))) == null) {
            LOG.warn("tid={}: unknown digest algorithm {}", (Object)tid, (Object)oid);
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badAlg);
            return rep;
        }
        boolean supported = false;
        if (hashAlgo == ScepHashAlgo.SHA1) {
            if (this.caCaps.containsCapability(CaCapability.SHA1)) {
                supported = true;
            }
        } else if (hashAlgo == ScepHashAlgo.SHA256) {
            if (this.caCaps.containsCapability(CaCapability.SHA256)) {
                supported = true;
            }
        } else if (hashAlgo == ScepHashAlgo.SHA512 && this.caCaps.containsCapability(CaCapability.SHA512)) {
            supported = true;
        }
        if (!supported) {
            LOG.warn("tid={}: unsupported digest algorithm {}", (Object)tid, (Object)oid);
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badAlg);
            return rep;
        }
        ASN1ObjectIdentifier encOid = req.getContentEncryptionAlgorithm();
        if (CMSAlgorithm.DES_EDE3_CBC.equals((Object)encOid)) {
            if (!this.caCaps.containsCapability(CaCapability.DES3)) {
                LOG.warn("tid={}: encryption with DES3 algorithm is not permitted", (Object)tid, (Object)encOid);
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badAlg);
                return rep;
            }
        } else if (AES_ENC_ALGOS.contains(encOid)) {
            if (!this.caCaps.containsCapability(CaCapability.AES)) {
                LOG.warn("tid={}: encryption with AES algorithm {} is not permitted", (Object)tid, (Object)encOid);
                rep.setPkiStatus(PkiStatus.FAILURE);
                rep.setFailInfo(FailInfo.badAlg);
                return rep;
            }
        } else {
            LOG.warn("tid={}: encryption with algorithm {} is not permitted", (Object)tid, (Object)encOid);
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(FailInfo.badAlg);
            return rep;
        }
        try {
            ca = this.caManager.getX509Ca(this.caIdent);
        }
        catch (CaMgmtException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)(tid + "=" + tid + ",could not get X509CA"));
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        X500Name caX500Name = ca.getCaInfo().getCert().getSubjectAsX500Name();
        try {
            SignedData signedData;
            MessageType mt = req.getMessageType();
            ScepResponder.audit(event, "message_type", mt.toString());
            switch (mt) {
                case PKCSReq: 
                case RenewalReq: 
                case UpdateReq: {
                    X500Name tmp;
                    CertificationRequest csr = CertificationRequest.getInstance((Object)req.getMessageData());
                    X500Name reqSubject = csr.getCertificationRequestInfo().getSubject();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("tid={}, subject={}", (Object)tid, (Object)X509Util.getRfc4519Name((X500Name)reqSubject));
                    }
                    if (!ca.verifyCsr(csr)) {
                        LOG.warn("tid={} POPO verification failed", (Object)tid);
                        throw FailInfoException.BAD_MESSAGE_CHECK;
                    }
                    CertificationRequestInfo csrReqInfo = csr.getCertificationRequestInfo();
                    X509Certificate reqSignatureCert = req.getSignatureCert();
                    X500Principal reqSigCertSubject = reqSignatureCert.getSubjectX500Principal();
                    boolean selfSigned = reqSigCertSubject.equals(reqSignatureCert.getIssuerX500Principal());
                    if (selfSigned && !(tmp = X500Name.getInstance((Object)reqSigCertSubject.getEncoded())).equals((Object)csrReqInfo.getSubject())) {
                        LOG.warn("tid={}, self-signed identityCert.subject != csr.subject");
                        throw FailInfoException.BAD_REQUEST;
                    }
                    if (X509Util.getCommonName((X500Name)csrReqInfo.getSubject()) == null) {
                        throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "tid=" + tid + ": no CommonName in requested subject");
                    }
                    NameId userIdent = null;
                    String challengePwd = CaUtil.getChallengePassword(csrReqInfo);
                    if (challengePwd != null) {
                        String[] strs = challengePwd.split(":");
                        if (strs == null || strs.length != 2) {
                            LOG.warn("tid={}: challengePassword does not have the format <user>:<password>", (Object)tid);
                            throw FailInfoException.BAD_REQUEST;
                        }
                        String user = strs[0];
                        String password = strs[1];
                        userIdent = ca.authenticateUser(user, StringUtil.toUtf8Bytes((String)password));
                        if (userIdent == null) {
                            LOG.warn("tid={}: could not authenticate user {}", (Object)tid, (Object)user);
                            throw FailInfoException.BAD_REQUEST;
                        }
                    }
                    if (selfSigned) {
                        if (MessageType.PKCSReq != mt) {
                            LOG.warn("tid={}: self-signed certificate is not permitted for messageType {}", (Object)tid, (Object)mt);
                            throw FailInfoException.BAD_REQUEST;
                        }
                        if (userIdent == null) {
                            LOG.warn("tid={}: could not extract user & password from challengePassword, which are required for self-signed signature certificate", (Object)tid);
                            throw FailInfoException.BAD_REQUEST;
                        }
                    } else if (userIdent == null) {
                        KnowCertResult knowCertRes = ca.knowsCert(reqSignatureCert);
                        if (!knowCertRes.isKnown()) {
                            LOG.warn("tid={}: signature certificate is not trusted by the CA", (Object)tid);
                            throw FailInfoException.BAD_REQUEST;
                        }
                        Integer userId = knowCertRes.getUserId();
                        if (userId == null) {
                            LOG.warn("tid={}: could not extract user from the signature cert", (Object)tid);
                            throw FailInfoException.BAD_REQUEST;
                        }
                        userIdent = ca.getUserIdent(userId);
                    }
                    ByUserRequestorInfo requestor = ca.getByUserRequestor(userIdent);
                    ScepResponder.checkUserPermission(requestor, certprofileName);
                    byte[] tidBytes = ScepResponder.getTransactionIdBytes(tid);
                    Extensions extensions = CaUtil.getExtensions(csrReqInfo);
                    CertTemplateData certTemplateData = new CertTemplateData(csrReqInfo.getSubject(), csrReqInfo.getSubjectPublicKeyInfo(), null, null, extensions, certprofileName);
                    CertificateInfo cert = ca.generateCert(certTemplateData, (RequestorInfo)requestor, RequestType.SCEP, tidBytes, msgId);
                    signedData = this.buildSignedData(cert.getCert().getCert());
                    break;
                }
                case CertPoll: {
                    IssuerAndSubject is = IssuerAndSubject.getInstance((Object)req.getMessageData());
                    ScepResponder.audit(event, "issuer", X509Util.getRfc4519Name((X500Name)is.getIssuer()));
                    ScepResponder.audit(event, "subject", X509Util.getRfc4519Name((X500Name)is.getSubject()));
                    ScepResponder.ensureIssuedByThisCa(caX500Name, is.getIssuer());
                    signedData = this.pollCert(ca, is.getSubject(), req.getTransactionId());
                    break;
                }
                case GetCert: {
                    IssuerAndSerialNumber isn = IssuerAndSerialNumber.getInstance((Object)req.getMessageData());
                    BigInteger serial = isn.getSerialNumber().getPositiveValue();
                    ScepResponder.audit(event, "issuer", X509Util.getRfc4519Name((X500Name)isn.getName()));
                    ScepResponder.audit(event, "serial", LogUtil.formatCsn((BigInteger)serial));
                    ScepResponder.ensureIssuedByThisCa(caX500Name, isn.getName());
                    signedData = this.getCert(ca, isn.getSerialNumber().getPositiveValue());
                    break;
                }
                case GetCRL: {
                    IssuerAndSerialNumber isn = IssuerAndSerialNumber.getInstance((Object)req.getMessageData());
                    BigInteger serial = isn.getSerialNumber().getPositiveValue();
                    ScepResponder.audit(event, "issuer", X509Util.getRfc4519Name((X500Name)isn.getName()));
                    ScepResponder.audit(event, "serial", LogUtil.formatCsn((BigInteger)serial));
                    ScepResponder.ensureIssuedByThisCa(caX500Name, isn.getName());
                    signedData = this.getCrl(ca, serial);
                    break;
                }
                default: {
                    LOG.error("unknown SCEP messageType '{}'", (Object)req.getMessageType());
                    throw FailInfoException.BAD_REQUEST;
                }
            }
            ContentInfo ci = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)signedData);
            rep.setMessageData((ASN1Encodable)ci);
            rep.setPkiStatus(PkiStatus.SUCCESS);
        }
        catch (FailInfoException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            rep.setPkiStatus(PkiStatus.FAILURE);
            rep.setFailInfo(ex.getFailInfo());
        }
        return rep;
    }

    private SignedData getCert(X509Ca ca, BigInteger serialNumber) throws FailInfoException, OperationException {
        X509Certificate cert;
        try {
            cert = ca.getCert(serialNumber);
        }
        catch (CertificateException ex) {
            String message = "could not get certificate for CA '" + this.caIdent + "' and serialNumber=" + LogUtil.formatCsn((BigInteger)serialNumber) + ")";
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)message);
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        if (cert == null) {
            throw FailInfoException.BAD_CERTID;
        }
        return this.buildSignedData(cert);
    }

    private SignedData pollCert(X509Ca ca, X500Name subject, TransactionId tid) throws FailInfoException, OperationException {
        byte[] tidBytes = ScepResponder.getTransactionIdBytes(tid.getId());
        List<X509Certificate> certs = ca.getCert(subject, tidBytes);
        if (CollectionUtil.isEmpty(certs)) {
            certs = ca.getCert(subject, null);
        }
        if (CollectionUtil.isEmpty(certs)) {
            throw FailInfoException.BAD_CERTID;
        }
        if (certs.size() > 1) {
            LOG.warn("given certId (subject: {}) and transactionId {} match multiple certificates", (Object)X509Util.getRfc4519Name((X500Name)subject), (Object)tid.getId());
            throw FailInfoException.BAD_CERTID;
        }
        return this.buildSignedData(certs.get(0));
    }

    private SignedData buildSignedData(X509Certificate cert) throws OperationException {
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        try {
            X509CertificateHolder certHolder = new X509CertificateHolder(cert.getEncoded());
            cmsSignedDataGen.addCertificate(certHolder);
            if (this.control.isIncludeCaCert()) {
                this.refreshCa();
                cmsSignedDataGen.addCertificate(this.caCert.getCertHolder());
            }
            CMSSignedData signedData = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
            return SignedData.getInstance((Object)signedData.toASN1Structure().getContent());
        }
        catch (IOException | CertificateEncodingException | CMSException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex);
        }
    }

    private SignedData getCrl(X509Ca ca, BigInteger serialNumber) throws FailInfoException, OperationException {
        CMSSignedData signedData;
        if (!this.control.isSupportGetCrl()) {
            throw FailInfoException.BAD_REQUEST;
        }
        CertificateList crl = ca.getBcCurrentCrl();
        if (crl == null) {
            LOG.error("found no CRL");
            throw FailInfoException.BAD_REQUEST;
        }
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        cmsSignedDataGen.addCRL(new X509CRLHolder(crl));
        try {
            signedData = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
        }
        catch (CMSException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not generate CMSSignedData");
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        return SignedData.getInstance((Object)signedData.toASN1Structure().getContent());
    }

    private ContentInfo encodeResponse(PkiMessage response, DecodedPkiMessage request) throws OperationException {
        ContentInfo ci;
        Args.notNull((Object)response, (String)"response");
        Args.notNull((Object)request, (String)"request");
        String signatureAlgorithm = ScepResponder.getSignatureAlgorithm(this.responderKey, request.getDigestAlgorithm());
        try {
            X509Certificate[] x509CertificateArray;
            if (this.control.isIncludeSignerCert()) {
                X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                x509CertificateArray = x509CertificateArray2;
                x509CertificateArray2[0] = this.responderCert;
            } else {
                x509CertificateArray = null;
            }
            X509Certificate[] cmsCertSet = x509CertificateArray;
            ci = response.encode(this.responderKey, signatureAlgorithm, this.responderCert, cmsCertSet, request.getSignatureCert(), request.getContentEncryptionAlgorithm());
        }
        catch (MessageEncodingException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not encode response");
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        return ci;
    }

    private static void checkUserPermission(ByUserRequestorInfo requestor, String certprofile) throws OperationException {
        int permission = 1;
        if (!requestor.isPermitted(permission)) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, PermissionConstants.getTextForCode((int)permission) + " is not permitted for user " + requestor.getCaHasUser().getUserIdent().getName());
        }
        if (!requestor.isCertprofilePermitted(certprofile)) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "Certificate profile " + certprofile + " is not permitted for user " + requestor.getCaHasUser().getUserIdent().getName());
        }
    }

    private static String getSignatureAlgorithm(PrivateKey key, ASN1ObjectIdentifier digestOid) {
        String algorithm;
        ScepHashAlgo hashAlgo = ScepHashAlgo.forNameOrOid((String)digestOid.getId());
        if (hashAlgo == null) {
            hashAlgo = ScepHashAlgo.SHA256;
        }
        if ("RSA".equalsIgnoreCase(algorithm = key.getAlgorithm())) {
            return hashAlgo.getName() + "withRSA";
        }
        throw new UnsupportedOperationException("getSignatureAlgorithm() for non-RSA is not supported yet.");
    }

    private static void ensureIssuedByThisCa(X500Name thisCaX500Name, X500Name caX500Name) throws FailInfoException {
        if (!thisCaX500Name.equals((Object)caX500Name)) {
            throw FailInfoException.BAD_CERTID;
        }
    }

    static CMSSignedData createDegeneratedSigendData(X509Certificate ... certs) throws CMSException, CertificateException {
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        try {
            for (X509Certificate cert : certs) {
                cmsSignedDataGen.addCertificate(new X509CertificateHolder(cert.getEncoded()));
            }
            return cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
        }
        catch (IOException ex) {
            throw new CMSException("could not build CMS SignedDta");
        }
    }

    private static byte[] getTransactionIdBytes(String tid) throws OperationException {
        byte[] bytes;
        block8: {
            bytes = null;
            int n = tid.length();
            if (n % 2 != 0) {
                bytes = StringUtil.toUtf8Bytes((String)tid);
            } else {
                try {
                    bytes = Hex.decode((String)tid);
                }
                catch (Exception ex) {
                    if (n % 4 != 0) break block8;
                    try {
                        bytes = Base64.decode((String)tid);
                    }
                    catch (Exception ex2) {
                        LOG.error("could not decode (hex or base64) '{}': {}", (Object)tid, (Object)ex2.getMessage());
                    }
                }
            }
        }
        if (bytes == null) {
            bytes = StringUtil.toUtf8Bytes((String)tid);
        }
        if (bytes.length > 20) {
            throw new OperationException(OperationException.ErrorCode.BAD_REQUEST, "transactionID too long");
        }
        return bytes;
    }

    private static void audit(AuditEvent audit, String name, String value) {
        audit.addEventData(name, (Object)(value == null ? "null" : value));
    }

    private void refreshCa() throws OperationException {
        try {
            X509Ca ca = this.caManager.getX509Ca(this.caIdent);
            X509Cert currentCaCert = ca.getCaInfo().getCert();
            if (currentCaCert.equals((Object)this.caCert)) {
                return;
            }
            this.caCert = currentCaCert;
            this.caCertRespBytes = new ScepCaCertRespBytes(currentCaCert.getCert(), this.responderCert);
        }
        catch (CertificateException | CMSException | CaMgmtException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
    }

    static {
        AES_ENC_ALGOS.add(CMSAlgorithm.AES128_CBC);
        AES_ENC_ALGOS.add(CMSAlgorithm.AES128_CCM);
        AES_ENC_ALGOS.add(CMSAlgorithm.AES128_GCM);
        AES_ENC_ALGOS.add(CMSAlgorithm.AES192_CBC);
        AES_ENC_ALGOS.add(CMSAlgorithm.AES192_CCM);
        AES_ENC_ALGOS.add(CMSAlgorithm.AES192_GCM);
        AES_ENC_ALGOS.add(CMSAlgorithm.AES256_CBC);
        AES_ENC_ALGOS.add(CMSAlgorithm.AES256_CCM);
        AES_ENC_ALGOS.add(CMSAlgorithm.AES256_GCM);
    }

    private static class FailInfoException
    extends Exception {
        public static final FailInfoException BAD_CERTID = new FailInfoException(FailInfo.badCertId);
        public static final FailInfoException BAD_MESSAGE_CHECK = new FailInfoException(FailInfo.badMessageCheck);
        public static final FailInfoException BAD_REQUEST = new FailInfoException(FailInfo.badRequest);
        private static final long serialVersionUID = 1L;
        private final FailInfo failInfo;

        private FailInfoException(FailInfo failInfo) {
            super(((FailInfo)Args.notNull((Object)failInfo, (String)"failInfo")).name());
            this.failInfo = failInfo;
        }

        public FailInfo getFailInfo() {
            return this.failInfo;
        }
    }

    public static class ScepCaCertRespBytes {
        private final byte[] bytes;

        public ScepCaCertRespBytes(X509Certificate caCert, X509Certificate responderCert) throws CMSException, CertificateException {
            Args.notNull((Object)caCert, (String)"caCert");
            Args.notNull((Object)responderCert, (String)"responderCert");
            CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
            try {
                cmsSignedDataGen.addCertificate(new X509CertificateHolder(caCert.getEncoded()));
                cmsSignedDataGen.addCertificate(new X509CertificateHolder(responderCert.getEncoded()));
                CMSSignedData degenerateSignedData = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
                this.bytes = degenerateSignedData.getEncoded();
            }
            catch (IOException ex) {
                throw new CMSException("could not build CMS SignedDta");
            }
        }

        public byte[] getBytes() {
            return Arrays.copyOf(this.bytes, this.bytes.length);
        }
    }
}

