/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.BadFormatException;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.server.ByUserRequestorInfo;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaManagerImpl;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertRepublisher;
import org.xipki.ca.server.CertRevInfoWithSerial;
import org.xipki.ca.server.CertStatus;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.CtLogClient;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.KnowCertResult;
import org.xipki.ca.server.OperationExceptionWithIndex;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SerialWithId;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.cmp.CmpRequestorInfo;
import org.xipki.ca.server.store.CertStore;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.CtLog;
import org.xipki.security.EdECConstants;
import org.xipki.security.FpIdCalculator;
import org.xipki.security.KeyUsage;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.RSABrokenKey;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class X509Ca
implements Closeable {
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private static final long MS_PER_SECOND = 1000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_10MINUTES = 300000L;
    private static final int MINUTE_PER_DAY = 1440;
    private static final long MS_PER_DAY = 86400000L;
    private static final long MAX_CERT_TIME_MS = 253402300799982L;
    private static final Logger LOG = LoggerFactory.getLogger(X509Ca.class);
    private final CaInfo caInfo;
    private final NameId caIdent;
    private final X509Cert caCert;
    private final CtLogClient ctlogClient;
    private final KeypairGenControl keypairGenControlByImplictCA;
    private final CertStore certstore;
    private final CaIdNameMap caIdNameMap;
    private final boolean masterMode;
    private final CaManagerImpl caManager;
    private SecureRandom random = new SecureRandom();
    private AtomicBoolean crlGenInProcess = new AtomicBoolean(false);
    private ScheduledFuture<?> crlGenerationService;
    private ScheduledFuture<?> expiredCertsRemover;
    private ScheduledFuture<?> suspendedCertsRevoker;
    private final ConcurrentSkipListSet<Long> publicKeyCertsInProcess = new ConcurrentSkipListSet();
    private final ConcurrentSkipListSet<Long> subjectCertsInProcess = new ConcurrentSkipListSet();

    public X509Ca(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore, CtLogClient ctlogClient) throws OperationException {
        Object crlSignerCert;
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.masterMode = caManager.isMasterMode();
        this.caIdNameMap = caManager.idNameMap();
        this.caInfo = (CaInfo)Args.notNull((Object)caInfo, (String)"caInfo");
        this.ctlogClient = ctlogClient;
        this.caIdent = caInfo.getIdent();
        this.caCert = caInfo.getCert();
        this.certstore = (CertStore)Args.notNull((Object)certstore, (String)"certstore");
        SubjectPublicKeyInfo caSpki = this.caCert.getCertHolder().getSubjectPublicKeyInfo();
        ASN1ObjectIdentifier caSpkiAlgId = caSpki.getAlgorithm().getAlgorithm();
        if (caSpkiAlgId.equals((Object)PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPublicKey pubKey = (RSAPublicKey)this.caCert.getCert().getPublicKey();
            this.keypairGenControlByImplictCA = new KeypairGenControl.RSAKeypairGenControl(pubKey.getModulus().bitLength(), pubKey.getPublicExponent(), caSpkiAlgId);
        } else if (caSpkiAlgId.equals((Object)X9ObjectIdentifiers.id_ecPublicKey)) {
            ASN1ObjectIdentifier curveOid = ASN1ObjectIdentifier.getInstance((Object)caSpki.getAlgorithm().getParameters());
            this.keypairGenControlByImplictCA = new KeypairGenControl.ECKeypairGenControl(curveOid, caSpkiAlgId);
        } else if (caSpkiAlgId.equals((Object)X9ObjectIdentifiers.id_dsa)) {
            ASN1Sequence seq = DERSequence.getInstance((Object)caSpki.getAlgorithm().getParameters());
            BigInteger p = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
            BigInteger q = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue();
            BigInteger g = ASN1Integer.getInstance((Object)seq.getObjectAt(2)).getValue();
            this.keypairGenControlByImplictCA = new KeypairGenControl.DSAKeypairGenControl(p, q, g, caSpkiAlgId);
        } else {
            this.keypairGenControlByImplictCA = caSpkiAlgId.equals((Object)EdECConstants.id_Ed25519) || caSpkiAlgId.equals((Object)EdECConstants.id_Ed448) ? new KeypairGenControl.EDDSAKeypairGenControl(caSpkiAlgId) : null;
        }
        try {
            caInfo.initDhpocControl(caManager.getSecurityFactory());
        }
        catch (XiSecurityException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("initDhpocControl for CA " + this.caIdent));
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        if (caInfo.isSignerRequired()) {
            try {
                caInfo.initSigner(caManager.getSecurityFactory());
            }
            catch (XiSecurityException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("security.createSigner caSigner for CA " + this.caIdent));
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
            }
        }
        if (caInfo.getCrlControl() != null && !X509Util.hasKeyusage((X509Certificate)(crlSignerCert = caInfo.getCrlSignerName() != null ? this.getCrlSigner().getDbEntry().getCertificate() : this.caCert.getCert()), (KeyUsage)KeyUsage.cRLSign)) {
            String msg = "CRL signer does not have keyusage cRLSign";
            LOG.error("CRL signer does not have keyusage cRLSign");
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "CRL signer does not have keyusage cRLSign");
        }
        if (!this.masterMode) {
            return;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            publisher.caAdded(this.caCert);
        }
        Random random = new Random();
        ScheduledThreadPoolExecutor executor = caManager.getScheduledThreadPoolExecutor();
        this.crlGenerationService = executor.scheduleAtFixedRate(new CrlGenerationService(), 60 + random.nextInt(60), 60L, TimeUnit.SECONDS);
        int minutesOfDay = 1440;
        this.expiredCertsRemover = executor.scheduleAtFixedRate(new ExpiredCertsRemover(), 1440 + random.nextInt(60), 1440L, TimeUnit.MINUTES);
        this.suspendedCertsRevoker = executor.scheduleAtFixedRate(new SuspendedCertsRevoker(), random.nextInt(60), 60L, TimeUnit.MINUTES);
    }

    public CaInfo getCaInfo() {
        return this.caInfo;
    }

    public CmpControl getCmpControl() {
        return this.caInfo.getCmpControl();
    }

    public X509Certificate getCert(BigInteger serialNumber) throws CertificateException, OperationException {
        CertificateInfo certInfo = this.certstore.getCertInfo(this.caIdent, this.caCert, serialNumber, this.caIdNameMap);
        return certInfo == null ? null : certInfo.getCert().getCert();
    }

    public List<X509Certificate> getCert(X500Name subjectName, byte[] transactionId) throws OperationException {
        return this.certstore.getCert(subjectName, transactionId);
    }

    public KnowCertResult knowsCert(X509Certificate cert) throws OperationException {
        Args.notNull((Object)cert, (String)"cert");
        if (!this.caInfo.getSubject().equals(X509Util.getRfc4519Name((X500Principal)cert.getIssuerX500Principal()))) {
            return KnowCertResult.UNKNOWN;
        }
        return this.certstore.knowsCertForSerial(this.caIdent, cert.getSerialNumber());
    }

    public CertWithRevocationInfo getCertWithRevocationInfo(BigInteger serialNumber) throws CertificateException, OperationException {
        return this.certstore.getCertWithRevocationInfo(this.caIdent.getId(), serialNumber, this.caIdNameMap);
    }

    public byte[] getCertRequest(BigInteger serialNumber) throws OperationException {
        return this.certstore.getCertRequest(this.caIdent, serialNumber);
    }

    public boolean verifyCsr(CertificationRequest csr) {
        Args.notNull((Object)csr, (String)"csr");
        return CaUtil.verifyCsr(csr, this.caManager.getSecurityFactory(), this.getCmpControl().getPopoAlgoValidator(), this.caInfo.getDhpocControl());
    }

    public List<CertListInfo> listCerts(X500Name subjectPattern, Date validFrom, Date validTo, CertListOrderBy orderBy, int numEntries) throws OperationException {
        return this.certstore.listCerts(this.caIdent, subjectPattern, validFrom, validTo, orderBy, numEntries);
    }

    public NameId authenticateUser(String user, byte[] password) throws OperationException {
        return this.certstore.authenticateUser(user.toLowerCase(), password);
    }

    public NameId getUserIdent(int userId) throws OperationException {
        String name = this.certstore.getUsername(userId);
        return name == null ? null : new NameId(Integer.valueOf(userId), name);
    }

    public ByUserRequestorInfo getByUserRequestor(NameId userIdent) throws OperationException {
        MgmtEntry.CaHasUser caHasUser = this.certstore.getCaHasUser(this.caIdent, userIdent);
        return caHasUser == null ? null : this.caManager.createByUserRequestor(caHasUser);
    }

    public X509CRL getCurrentCrl() throws OperationException {
        return this.getCrl(null);
    }

    public X509CRL getCrl(BigInteger crlNumber) throws OperationException {
        LOG.info("     START getCrl: ca={}, crlNumber={}", (Object)this.caIdent.getName(), (Object)crlNumber);
        boolean successful = false;
        try {
            byte[] encodedCrl = this.certstore.getEncodedCrl(this.caIdent, crlNumber);
            if (encodedCrl == null) {
                X509CRL x509CRL = null;
                return x509CRL;
            }
            X509CRL crl = X509Util.parseCrl((byte[])encodedCrl);
            successful = true;
            if (LOG.isInfoEnabled()) {
                String timeStr = new Time(crl.getThisUpdate()).getTime();
                LOG.info("SUCCESSFUL getCrl: ca={}, thisUpdate={}", (Object)this.caIdent.getName(), (Object)timeStr);
            }
            X509CRL x509CRL = crl;
            return x509CRL;
        }
        finally {
            if (!successful) {
                LOG.info("    FAILED getCrl: ca={}", (Object)this.caIdent.getName());
            }
        }
    }

    public CertificateList getBcCurrentCrl() throws OperationException {
        return this.getBcCrl(null);
    }

    public CertificateList getBcCrl(BigInteger crlNumber) throws OperationException {
        LOG.info("     START getCrl: ca={}, crlNumber={}", (Object)this.caIdent.getName(), (Object)crlNumber);
        boolean successful = false;
        try {
            byte[] encodedCrl = this.certstore.getEncodedCrl(this.caIdent, crlNumber);
            if (encodedCrl == null) {
                CertificateList certificateList = null;
                return certificateList;
            }
            CertificateList crl = CertificateList.getInstance((Object)encodedCrl);
            successful = true;
            if (LOG.isInfoEnabled()) {
                LOG.info("SUCCESSFUL getCrl: ca={}, thisUpdate={}", (Object)this.caIdent.getName(), (Object)crl.getThisUpdate().getTime());
            }
            CertificateList certificateList = crl;
            return certificateList;
        }
        finally {
            if (!successful) {
                LOG.info("    FAILED getCrl: ca={}", (Object)this.caIdent.getName());
            }
        }
    }

    private void cleanupCrlsWithoutException(String msgId) throws OperationException {
        try {
            this.cleanupCrls(msgId);
        }
        catch (Throwable th) {
            LOG.warn("could not cleanup CRLs.{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
        }
    }

    private void cleanupCrls(String msgId) throws OperationException {
        int numCrls = this.caInfo.getNumCrls();
        LOG.info("     START cleanupCrls: ca={}, numCrls={}", (Object)this.caIdent.getName(), (Object)numCrls);
        boolean successful = false;
        AuditEvent event = this.newPerfAuditEvent("cleanup_crl", msgId);
        try {
            int num = numCrls <= 0 ? 0 : this.certstore.cleanupCrls(this.caIdent, this.caInfo.getNumCrls());
            successful = true;
            event.addEventData("num", (Object)num);
            LOG.info("SUCCESSFUL cleanupCrls: ca={}, num={}", (Object)this.caIdent.getName(), (Object)num);
        }
        catch (RuntimeException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        finally {
            if (!successful) {
                LOG.info("    FAILED cleanupCrls: ca={}", (Object)this.caIdent.getName());
            }
            this.finish(event, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRL generateCrlOnDemand(String msgId) throws OperationException {
        CrlControl control = this.caInfo.getCrlControl();
        if (control == null) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA could not generate CRL");
        }
        if (this.crlGenInProcess.get()) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_UNAVAILABLE, "TRY_LATER");
        }
        this.crlGenInProcess.set(true);
        try {
            Date thisUpdate = new Date();
            Date nearestScheduledIssueTime = this.getScheduledCrlGenTimeNotAfter(thisUpdate);
            int intervals = !control.isExtendedNextUpdate() && control.getDeltaCrlIntervals() > 0 ? control.getDeltaCrlIntervals() : control.getFullCrlIntervals();
            Date nextUpdate = new Date(nearestScheduledIssueTime.getTime() + (long)intervals * 86400000L);
            long maxIdOfDeltaCrlCache = this.certstore.getMaxIdOfDeltaCrlCache(this.caIdent);
            X509CRL crl = this.generateCrl(false, thisUpdate, nextUpdate, msgId);
            if (crl == null) {
                X509CRL x509CRL = null;
                return x509CRL;
            }
            try {
                this.certstore.clearDeltaCrlCache(this.caIdent, maxIdOfDeltaCrlCache);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not clear DeltaCRLCache of CA " + this.caIdent));
            }
            X509CRL x509CRL = crl;
            return x509CRL;
        }
        finally {
            this.crlGenInProcess.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRL generateCrl(boolean deltaCrl, Date thisUpdate, Date nextUpdate, String msgId) throws OperationException {
        boolean successful = false;
        AuditEvent event = this.newPerfAuditEvent("gen_crl", msgId);
        try {
            X509CRL crl = this.generateCrl0(deltaCrl, thisUpdate, nextUpdate, event, msgId);
            successful = true;
            X509CRL x509CRL = crl;
            return x509CRL;
        }
        finally {
            this.finish(event, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRL generateCrl0(boolean deltaCrl, Date thisUpdate, Date nextUpdate, AuditEvent event, String msgId) throws OperationException {
        CrlControl control = this.caInfo.getCrlControl();
        if (control == null) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CRL generation is not allowed");
        }
        LOG.info("     START generateCrl: ca={}, deltaCRL={}, nextUpdate={}", new Object[]{this.caIdent.getName(), deltaCrl, nextUpdate});
        event.addEventData("crl_type", (Object)(deltaCrl ? "DELTA_CRL" : "FULL_CRL"));
        if (nextUpdate == null) {
            event.addEventData("next_update", (Object)"null");
        } else {
            event.addEventData("next_update", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Date)nextUpdate));
            if (nextUpdate.getTime() - thisUpdate.getTime() < 600000L) {
                throw new OperationException(OperationException.ErrorCode.CRL_FAILURE, "nextUpdate and thisUpdate are too close");
            }
        }
        boolean successful = false;
        try {
            X509CRLHolder crlHolder;
            ConcurrentBagEntrySigner signer0;
            List<CertRevInfoWithSerial> revInfos;
            SignerEntryWrapper crlSigner = this.getCrlSigner();
            PublicCaInfo pci = this.caInfo.getPublicCaInfo();
            boolean indirectCrl = crlSigner != null;
            X500Name crlIssuer = indirectCrl ? crlSigner.getSubjectAsX500Name() : pci.getX500Subject();
            X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(crlIssuer, thisUpdate);
            if (nextUpdate != null) {
                crlBuilder.setNextUpdate(nextUpdate);
            }
            int numEntries = 100;
            Date notExpireAt = control.isIncludeExpiredCerts() ? new Date(0L) : new Date(thisUpdate.getTime() - 600000L);
            long startId = 1L;
            LinkedList<CertRevInfoWithSerial> allRevInfos = new LinkedList<CertRevInfoWithSerial>();
            do {
                revInfos = deltaCrl ? this.certstore.getCertsForDeltaCrl(this.caIdent, startId, 100, control.isOnlyContainsCaCerts(), control.isOnlyContainsUserCerts()) : this.certstore.getRevokedCerts(this.caIdent, notExpireAt, startId, 100, control.isOnlyContainsCaCerts(), control.isOnlyContainsUserCerts());
                allRevInfos.addAll(revInfos);
                long maxId = 1L;
                for (CertRevInfoWithSerial revInfo : revInfos) {
                    if (revInfo.getId() <= maxId) continue;
                    maxId = revInfo.getId();
                }
                startId = maxId + 1L;
            } while (revInfos.size() >= 100);
            if (revInfos != null) {
                revInfos.clear();
            }
            Collections.sort(allRevInfos);
            boolean isFirstCrlEntry = true;
            CrlControl crlControl = this.caInfo.getCrlControl();
            for (CertRevInfoWithSerial revInfo : allRevInfos) {
                Extension ext;
                CrlReason reason = revInfo.getReason();
                if (crlControl.isExcludeReason() && reason != CrlReason.REMOVE_FROM_CRL) {
                    reason = CrlReason.UNSPECIFIED;
                }
                Date revocationTime = revInfo.getRevocationTime();
                Date invalidityTime = revInfo.getInvalidityTime();
                switch (crlControl.getInvalidityDateMode()) {
                    case forbidden: {
                        invalidityTime = null;
                        break;
                    }
                    case optional: {
                        break;
                    }
                    case required: {
                        if (invalidityTime != null) break;
                        invalidityTime = revocationTime;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown TripleState " + crlControl.getInvalidityDateMode());
                    }
                }
                BigInteger serial = revInfo.getSerial();
                LOG.debug("added cert ca={} serial={} to CRL", (Object)this.caIdent, (Object)serial);
                if (!indirectCrl || !isFirstCrlEntry) {
                    if (invalidityTime != null) {
                        crlBuilder.addCRLEntry(serial, revocationTime, reason.getCode(), invalidityTime);
                        continue;
                    }
                    crlBuilder.addCRLEntry(serial, revocationTime, reason.getCode());
                    continue;
                }
                ArrayList<Extension> extensions = new ArrayList<Extension>(3);
                if (reason != CrlReason.UNSPECIFIED) {
                    ext = X509Ca.createReasonExtension(reason.getCode());
                    extensions.add(ext);
                }
                if (invalidityTime != null) {
                    ext = X509Ca.createInvalidityDateExtension(invalidityTime);
                    extensions.add(ext);
                }
                ext = X509Ca.createCertificateIssuerExtension(pci.getX500Subject());
                extensions.add(ext);
                crlBuilder.addCRLEntry(serial, revocationTime, new Extensions(extensions.toArray(new Extension[0])));
                isFirstCrlEntry = false;
            }
            allRevInfos.clear();
            BigInteger crlNumber = this.caInfo.nextCrlNumber();
            event.addEventData("crl_number", (Object)crlNumber);
            boolean onlyUserCerts = crlControl.isOnlyContainsUserCerts();
            boolean onlyCaCerts = crlControl.isOnlyContainsCaCerts();
            if (onlyUserCerts && onlyCaCerts) {
                throw new IllegalStateException("should not reach here, onlyUserCerts and onlyCACerts are both true");
            }
            try {
                byte[] akiValues = indirectCrl ? X509Util.extractSki((X509Certificate)crlSigner.getSigner().getCertificate()) : pci.getSubjectKeyIdentifer();
                AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(akiValues);
                crlBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)aki);
                crlBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new ASN1Integer(crlNumber));
                if (onlyUserCerts || onlyCaCerts || indirectCrl) {
                    IssuingDistributionPoint idp = new IssuingDistributionPoint((DistributionPointName)null, onlyUserCerts, onlyCaCerts, (ReasonFlags)null, indirectCrl, false);
                    crlBuilder.addExtension(Extension.issuingDistributionPoint, true, (ASN1Encodable)idp);
                }
                List deltaCrlUris = pci.getCaUris().getDeltaCrlUris();
                if (control.getDeltaCrlIntervals() > 0 && CollectionUtil.isNonEmpty((Collection)deltaCrlUris)) {
                    CRLDistPoint cdp = CaUtil.createCrlDistributionPoints(deltaCrlUris, pci.getX500Subject(), crlIssuer);
                    crlBuilder.addExtension(Extension.freshestCRL, false, (ASN1Encodable)cdp);
                }
            }
            catch (CertificateEncodingException | CertIOException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"crlBuilder.addExtension");
                throw new OperationException(OperationException.ErrorCode.INVALID_EXTENSION, ex);
            }
            this.addXipkiCertset(crlBuilder, deltaCrl, control, notExpireAt, onlyCaCerts, onlyUserCerts);
            ConcurrentContentSigner concurrentSigner = crlSigner == null ? this.caInfo.getSigner(null) : crlSigner.getSigner();
            try {
                signer0 = concurrentSigner.borrowSigner();
            }
            catch (NoIdleSignerException ex) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "NoIdleSignerException: " + ex.getMessage());
            }
            try {
                crlHolder = crlBuilder.build((ContentSigner)signer0.value());
            }
            finally {
                concurrentSigner.requiteSigner(signer0);
            }
            try {
                X509CRL crl = X509Util.toX509Crl((CertificateList)crlHolder.toASN1Structure());
                this.caInfo.getCaEntry().setNextCrlNumber(crlNumber.longValue() + 1L);
                this.caManager.commitNextCrlNo(this.caIdent, this.caInfo.getCaEntry().getNextCrlNumber());
                this.publishCrl(crl);
                successful = true;
                LOG.info("SUCCESSFUL generateCrl: ca={}, crlNumber={}, thisUpdate={}", new Object[]{this.caIdent.getName(), crlNumber, crl.getThisUpdate()});
                if (!deltaCrl) {
                    this.cleanupCrlsWithoutException(msgId);
                }
                X509CRL x509CRL = crl;
                return x509CRL;
            }
            catch (CRLException | CertificateException ex) {
                throw new OperationException(OperationException.ErrorCode.CRL_FAILURE, (Throwable)ex);
            }
        }
        finally {
            if (!successful) {
                LOG.info("    FAILED generateCrl: ca={}", (Object)this.caIdent.getName());
            }
        }
    }

    private void addXipkiCertset(X509v2CRLBuilder crlBuilder, boolean deltaCrl, CrlControl control, Date notExpireAt, boolean onlyCaCerts, boolean onlyUserCerts) throws OperationException {
        List<SerialWithId> serials;
        if (deltaCrl || !control.isXipkiCertsetIncluded()) {
            return;
        }
        ASN1EncodableVector vector = new ASN1EncodableVector();
        int numEntries = 100;
        long startId = 1L;
        do {
            serials = this.certstore.getSerialNumbers(this.caIdent, notExpireAt, startId, 100, false, onlyCaCerts, onlyUserCerts);
            long maxId = 1L;
            for (SerialWithId sid : serials) {
                if (sid.getId() > maxId) {
                    maxId = sid.getId();
                }
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)new ASN1Integer(sid.getSerial()));
                if (control.isXipkiCertsetCertIncluded()) {
                    CertificateInfo certInfo;
                    try {
                        certInfo = this.certstore.getCertForId(this.caIdent, this.caCert, sid.getId(), this.caIdNameMap);
                    }
                    catch (CertificateException ex) {
                        throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "CertificateException: " + ex.getMessage());
                    }
                    Certificate cert = Certificate.getInstance((Object)certInfo.getCert().getEncodedCert());
                    vec.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)cert));
                }
                vector.add((ASN1Encodable)new DERSequence(vec));
            }
            startId = maxId + 1L;
        } while (serials.size() >= 100);
        try {
            crlBuilder.addExtension(ObjectIdentifiers.Xipki.id_xipki_ext_crlCertset, false, (ASN1Encodable)new DERSet(vector));
        }
        catch (CertIOException ex) {
            throw new OperationException(OperationException.ErrorCode.INVALID_EXTENSION, "CertIOException: " + ex.getMessage());
        }
    }

    public CertificateInfo regenerateCert(CertTemplateData certTemplate, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        return this.regenerateCerts(Arrays.asList(certTemplate), requestor, reqType, transactionId, msgId).get(0);
    }

    public List<CertificateInfo> regenerateCerts(List<CertTemplateData> certTemplates, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        return this.generateCerts(certTemplates, requestor, true, reqType, transactionId, msgId);
    }

    public boolean publishCert(CertificateInfo certInfo) {
        return this.publishCert0(certInfo) == 0;
    }

    private int publishCert0(CertificateInfo certInfo) {
        Args.notNull((Object)certInfo, (String)"certInfo");
        if (certInfo.isAlreadyIssued()) {
            return 0;
        }
        if (!this.certstore.addCert(certInfo)) {
            return 1;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (!publisher.isAsyn()) {
                boolean successful;
                try {
                    successful = publisher.certificateAdded(certInfo);
                }
                catch (RuntimeException ex) {
                    successful = false;
                    LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not publish certificate to the publisher " + publisher.getIdent()));
                }
                if (successful) continue;
            }
            Long certId = certInfo.getCert().getCertId();
            try {
                this.certstore.addToPublishQueue(publisher.getIdent(), certId, this.caIdent);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not add entry to PublishQueue");
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean republishCerts(List<String> publisherNames, int numThreads) {
        List<IdentifiedCertPublisher> publishers;
        if (publisherNames == null) {
            publishers = this.publishers();
        } else {
            publishers = new ArrayList<IdentifiedCertPublisher>(publisherNames.size());
            for (String publisherName : publisherNames) {
                Object publisher = null;
                for (IdentifiedCertPublisher p : this.publishers()) {
                    if (!p.getIdent().getName().equals(publisherName)) continue;
                    publisher = p;
                    break;
                }
                if (publisher == null) {
                    throw new IllegalArgumentException("could not find publisher " + publisherName + " for CA " + this.caIdent.getName());
                }
                publishers.add((IdentifiedCertPublisher)publisher);
            }
        }
        if (CollectionUtil.isEmpty(publishers)) {
            return true;
        }
        CaStatus status = this.caInfo.getStatus();
        this.caInfo.setStatus(CaStatus.INACTIVE);
        boolean onlyRevokedCerts = true;
        for (IdentifiedCertPublisher publisher : publishers) {
            if (publisher.publishsGoodCert()) {
                onlyRevokedCerts = false;
            }
            NameId publisherIdent = publisher.getIdent();
            String name = publisherIdent.getName();
            try {
                LOG.info("clearing PublishQueue for publisher {}", (Object)name);
                this.certstore.clearPublishQueue(this.caIdent, publisherIdent);
                LOG.info(" cleared PublishQueue for publisher {}", (Object)name);
            }
            catch (OperationException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not clear PublishQueue for publisher " + name));
            }
        }
        try {
            for (IdentifiedCertPublisher publisher : publishers) {
                boolean successful = publisher.caAdded(this.caCert);
                if (successful) continue;
                LOG.error("republish CA certificate {} to publisher {} failed", (Object)this.caIdent.getName(), (Object)publisher.getIdent().getName());
                boolean bl = false;
                return bl;
            }
            if (this.caInfo.getRevocationInfo() != null) {
                for (IdentifiedCertPublisher publisher : publishers) {
                    boolean successful = publisher.caRevoked(this.caCert, this.caInfo.getRevocationInfo());
                    if (successful) continue;
                    LOG.error("republishing CA revocation to publisher {} failed", (Object)publisher.getIdent().getName());
                    boolean bl = false;
                    return bl;
                }
            }
            CertRepublisher republisher = new CertRepublisher(this.caIdent, this.caCert, this.caIdNameMap, this.certstore, publishers, onlyRevokedCerts, numThreads);
            boolean bl = republisher.republish();
            return bl;
        }
        finally {
            this.caInfo.setStatus(status);
        }
    }

    public void clearPublishQueue(List<String> publisherNames) throws CaMgmtException {
        if (publisherNames == null) {
            try {
                this.certstore.clearPublishQueue(this.caIdent, null);
            }
            catch (OperationException ex) {
                throw new CaMgmtException("could not clear publish queue of CA " + this.caIdent + ": " + ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        for (String publisherName : publisherNames) {
            NameId publisherIdent = this.caIdNameMap.getPublisher(publisherName);
            try {
                this.certstore.clearPublishQueue(this.caIdent, publisherIdent);
            }
            catch (OperationException ex) {
                throw new CaMgmtException("could not clear publish queue of CA " + this.caIdent + ": " + ex.getMessage() + " for publisher " + publisherName, (Throwable)ex);
            }
        }
    }

    public boolean publishCertsInQueue() {
        boolean allSuccessful = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (this.publishCertsInQueue(publisher)) continue;
            allSuccessful = false;
        }
        return allSuccessful;
    }

    private boolean publishCertsInQueue(IdentifiedCertPublisher publisher) {
        Args.notNull((Object)publisher, (String)"publisher");
        int numEntries = 500;
        block6: while (true) {
            List<Long> certIds;
            try {
                certIds = this.certstore.getPublishQueueEntries(this.caIdent, publisher.getIdent(), 500);
            }
            catch (OperationException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                return false;
            }
            if (CollectionUtil.isEmpty(certIds)) break;
            Iterator<Long> iterator = certIds.iterator();
            while (true) {
                CertificateInfo certInfo;
                if (!iterator.hasNext()) continue block6;
                Long certId = iterator.next();
                try {
                    certInfo = this.certstore.getCertForId(this.caIdent, this.caCert, certId, this.caIdNameMap);
                }
                catch (CertificateException | OperationException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex);
                    return false;
                }
                boolean successful = publisher.certificateAdded(certInfo);
                if (!successful) {
                    LOG.error("republishing certificate id={} failed", (Object)certId);
                    return false;
                }
                try {
                    this.certstore.removeFromPublishQueue(publisher.getIdent(), certId);
                }
                catch (OperationException ex) {
                    LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not remove republished cert id=" + certId + " and publisher=" + publisher.getIdent().getName()));
                }
            }
            break;
        }
        return true;
    }

    private boolean publishCrl(X509CRL crl) {
        try {
            this.certstore.addCrl(this.caIdent, crl);
        }
        catch (Exception ex) {
            LOG.error("could not add CRL ca={}, thisUpdate={}: {}, ", new Object[]{this.caIdent.getName(), crl.getThisUpdate(), ex.getMessage()});
            LOG.debug("Exception", (Throwable)ex);
            return false;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            try {
                publisher.crlAdded(this.caCert, crl);
            }
            catch (RuntimeException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not publish CRL to the publisher " + publisher.getIdent()));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertWithRevocationInfo revokeCert(BigInteger serialNumber, CrlReason reason, Date invalidityTime, String msgId) throws OperationException {
        if (this.caInfo.isSelfSigned() && this.caInfo.getSerialNumber().equals(serialNumber)) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "insufficient permission to revoke CA certificate");
        }
        if (reason == null) {
            reason = CrlReason.UNSPECIFIED;
        }
        switch (reason) {
            case CA_COMPROMISE: 
            case AA_COMPROMISE: 
            case REMOVE_FROM_CRL: {
                throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "insufficient permission to revoke certificate with reason " + reason.getDescription());
            }
            case UNSPECIFIED: 
            case KEY_COMPROMISE: 
            case AFFILIATION_CHANGED: 
            case SUPERSEDED: 
            case CESSATION_OF_OPERATION: 
            case CERTIFICATE_HOLD: 
            case PRIVILEGE_WITHDRAWN: {
                break;
            }
            default: {
                throw new IllegalStateException("unknown CRL reason " + reason);
            }
        }
        AuditEvent event = this.newPerfAuditEvent("revoke_cert", msgId);
        boolean successful = true;
        try {
            CertWithRevocationInfo ret = this.revokeCertificate0(serialNumber, reason, invalidityTime, false, event);
            successful = ret != null;
            CertWithRevocationInfo certWithRevocationInfo = ret;
            return certWithRevocationInfo;
        }
        finally {
            this.finish(event, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertWithDbId unrevokeCert(BigInteger serialNumber, String msgId) throws OperationException {
        if (this.caInfo.isSelfSigned() && this.caInfo.getSerialNumber().equals(serialNumber)) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "insufficient permission to unrevoke CA certificate");
        }
        AuditEvent event = this.newPerfAuditEvent("unrevoke_cert", msgId);
        boolean successful = true;
        try {
            CertWithDbId ret = this.unrevokeCert0(serialNumber, false, event);
            successful = true;
            CertWithDbId certWithDbId = ret;
            return certWithDbId;
        }
        finally {
            this.finish(event, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertWithDbId removeCert(BigInteger serialNumber, String msgId) throws OperationException {
        if (this.caInfo.isSelfSigned() && this.caInfo.getSerialNumber().equals(serialNumber)) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "insufficient permission to remove CA certificate");
        }
        AuditEvent event = this.newPerfAuditEvent("remove_cert", msgId);
        boolean successful = true;
        try {
            CertWithDbId ret = this.removeCert0(serialNumber, event);
            successful = ret != null;
            CertWithDbId certWithDbId = ret;
            return certWithDbId;
        }
        finally {
            this.finish(event, successful);
        }
    }

    private CertWithDbId removeCert0(BigInteger serialNumber, AuditEvent event) throws OperationException {
        event.addEventData("serial", (Object)LogUtil.formatCsn((BigInteger)serialNumber));
        CertWithRevocationInfo certWithRevInfo = this.certstore.getCertWithRevocationInfo(this.caIdent.getId(), serialNumber, this.caIdNameMap);
        if (certWithRevInfo == null) {
            return null;
        }
        boolean successful = true;
        CertWithDbId certToRemove = certWithRevInfo.getCert();
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            boolean singleSuccessful;
            try {
                singleSuccessful = publisher.certificateRemoved(this.caCert, certToRemove);
            }
            catch (RuntimeException ex) {
                singleSuccessful = false;
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not remove certificate from the publisher " + publisher.getIdent()));
            }
            if (singleSuccessful) continue;
            successful = false;
            X509Certificate cert = certToRemove.getCert();
            if (!LOG.isErrorEnabled()) continue;
            LOG.error("removing certificate issuer='{}', serial={}, subject='{}' from publisher {} failed.", new Object[]{X509Util.getRfc4519Name((X500Principal)cert.getIssuerX500Principal()), LogUtil.formatCsn((BigInteger)cert.getSerialNumber()), X509Util.getRfc4519Name((X500Principal)cert.getSubjectX500Principal()), publisher.getIdent()});
        }
        if (!successful) {
            return null;
        }
        this.certstore.removeCert(this.caIdent, serialNumber);
        return certToRemove;
    }

    private CertWithRevocationInfo revokeCertificate0(BigInteger serialNumber, CrlReason reason, Date invalidityTime, boolean force, AuditEvent event) throws OperationException {
        String hexSerial = LogUtil.formatCsn((BigInteger)serialNumber);
        event.addEventData("serial", (Object)hexSerial);
        event.addEventData("reason", (Object)reason.getDescription());
        if (invalidityTime != null) {
            event.addEventData("invalidity_time", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Date)invalidityTime));
        }
        LOG.info("     START revokeCertificate: ca={}, serialNumber={}, reason={}, invalidityTime={}", new Object[]{this.caIdent.getName(), hexSerial, reason.getDescription(), invalidityTime});
        CertWithRevocationInfo revokedCert = null;
        CertRevocationInfo revInfo = new CertRevocationInfo(reason, new Date(), invalidityTime);
        revokedCert = this.certstore.revokeCert(this.caIdent, serialNumber, revInfo, force, this.shouldPublishToDeltaCrlCache(), this.caIdNameMap);
        if (revokedCert == null) {
            return null;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (!publisher.isAsyn()) {
                boolean successful;
                try {
                    successful = publisher.certificateRevoked(this.caCert, revokedCert.getCert(), revokedCert.getCertprofile(), revokedCert.getRevInfo());
                }
                catch (RuntimeException ex) {
                    successful = false;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not publish revocation of certificate to the publisher " + publisher.getIdent()));
                }
                if (successful) continue;
            }
            Long certId = revokedCert.getCert().getCertId();
            try {
                this.certstore.addToPublishQueue(publisher.getIdent(), certId, this.caIdent);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not add entry to PublishQueue");
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("SUCCESSFUL revokeCertificate: ca={}, serialNumber={}, reason={}, invalidityTime={}, revocationResult=REVOKED", new Object[]{this.caIdent.getName(), hexSerial, reason.getDescription(), invalidityTime});
        }
        return revokedCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertWithRevocationInfo revokeSuspendedCert(BigInteger serialNumber, CrlReason reason, String msgId) throws OperationException {
        AuditEvent event = this.newPerfAuditEvent("revoke_suspended_cert", msgId);
        boolean successful = false;
        try {
            CertWithRevocationInfo ret = this.revokeSuspendedCert0(serialNumber, reason, event);
            successful = ret != null;
            CertWithRevocationInfo certWithRevocationInfo = ret;
            return certWithRevocationInfo;
        }
        finally {
            this.finish(event, successful);
        }
    }

    private CertWithRevocationInfo revokeSuspendedCert0(BigInteger serialNumber, CrlReason reason, AuditEvent event) throws OperationException {
        CertWithRevocationInfo revokedCert;
        String hexSerial = LogUtil.formatCsn((BigInteger)serialNumber);
        event.addEventData("serial", (Object)hexSerial);
        event.addEventData("reason", (Object)reason.getDescription());
        if (LOG.isInfoEnabled()) {
            LOG.info("     START revokeSuspendedCert: ca={}, serialNumber={}, reason={}", new Object[]{this.caIdent.getName(), hexSerial, reason.getDescription()});
        }
        if ((revokedCert = this.certstore.revokeSuspendedCert(this.caIdent, serialNumber, reason, this.shouldPublishToDeltaCrlCache(), this.caIdNameMap)) == null) {
            return null;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (!publisher.isAsyn()) {
                boolean successful;
                try {
                    successful = publisher.certificateRevoked(this.caCert, revokedCert.getCert(), revokedCert.getCertprofile(), revokedCert.getRevInfo());
                }
                catch (RuntimeException ex) {
                    successful = false;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not publish revocation of certificate to the publisher " + publisher.getIdent().getName()));
                }
                if (successful) continue;
            }
            Long certId = revokedCert.getCert().getCertId();
            try {
                this.certstore.addToPublishQueue(publisher.getIdent(), certId, this.caIdent);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not add entry to PublishQueue");
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("SUCCESSFUL revokeSuspendedCert: ca={}, serialNumber={}, reason={}", new Object[]{this.caIdent.getName(), hexSerial, reason.getDescription()});
        }
        return revokedCert;
    }

    private CertWithDbId unrevokeCert0(BigInteger serialNumber, boolean force, AuditEvent event) throws OperationException {
        String hexSerial = LogUtil.formatCsn((BigInteger)serialNumber);
        event.addEventData("serial", (Object)hexSerial);
        LOG.info("     START unrevokeCertificate: ca={}, serialNumber={}", (Object)this.caIdent.getName(), (Object)hexSerial);
        CertWithDbId unrevokedCert = this.certstore.unrevokeCert(this.caIdent, serialNumber, force, this.shouldPublishToDeltaCrlCache(), this.caIdNameMap);
        if (unrevokedCert == null) {
            return null;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (!publisher.isAsyn()) {
                boolean successful;
                try {
                    successful = publisher.certificateUnrevoked(this.caCert, unrevokedCert);
                }
                catch (RuntimeException ex) {
                    successful = false;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not publish unrevocation of certificate to the publisher " + publisher.getIdent().getName()));
                }
                if (successful) continue;
            }
            Long certId = unrevokedCert.getCertId();
            try {
                this.certstore.addToPublishQueue(publisher.getIdent(), certId, this.caIdent);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not add entry to PublishQueue");
            }
        }
        LOG.info("SUCCESSFUL unrevokeCertificate: ca={}, serialNumber={}, revocationResult=UNREVOKED", (Object)this.caIdent.getName(), (Object)hexSerial);
        return unrevokedCert;
    }

    private boolean shouldPublishToDeltaCrlCache() {
        CrlControl control = this.caInfo.getCrlControl();
        if (control == null) {
            return false;
        }
        int deltaCrlInterval = control.getDeltaCrlIntervals();
        return deltaCrlInterval != 0 && deltaCrlInterval < control.getFullCrlIntervals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeCa(CertRevocationInfo revocationInfo, String msgId) throws OperationException {
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        this.caInfo.setRevocationInfo(revocationInfo);
        if (this.caInfo.isSelfSigned()) {
            AuditEvent event = this.newPerfAuditEvent("revoke_cert", msgId);
            boolean successful = true;
            try {
                CertWithRevocationInfo ret = this.revokeCertificate0(this.caInfo.getSerialNumber(), revocationInfo.getReason(), revocationInfo.getInvalidityTime(), true, event);
                successful = ret != null;
            }
            finally {
                this.finish(event, successful);
            }
        }
        boolean failed = false;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            NameId ident = publisher.getIdent();
            boolean successful = publisher.caRevoked(this.caCert, revocationInfo);
            if (successful) {
                LOG.info("published event caRevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
                continue;
            }
            failed = true;
            LOG.error("could not publish event caRevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
        }
        if (failed) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "could not publish event caRevoked of CA " + this.caIdent + " to at least one publisher");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unrevokeCa(String msgId) throws OperationException {
        this.caInfo.setRevocationInfo(null);
        if (this.caInfo.isSelfSigned()) {
            AuditEvent event = this.newPerfAuditEvent("unrevoke_cert", msgId);
            boolean successful = true;
            try {
                this.unrevokeCert0(this.caInfo.getSerialNumber(), true, event);
                successful = true;
            }
            finally {
                this.finish(event, successful);
            }
        }
        boolean failed = false;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            NameId ident = publisher.getIdent();
            boolean successful = publisher.caUnrevoked(this.caCert);
            if (successful) {
                LOG.info("published event caUnrevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
                continue;
            }
            failed = true;
            LOG.error("could not publish event caUnrevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
        }
        if (failed) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "could not event caUnrevoked of CA " + this.caIdent + " to at least one publisher");
        }
    }

    public long addRequest(byte[] request) throws OperationException {
        return this.certstore.addRequest(request);
    }

    public void addRequestCert(long requestId, long certId) throws OperationException {
        this.certstore.addRequestCert(requestId, certId);
    }

    private List<IdentifiedCertPublisher> publishers() {
        return this.caManager.getIdentifiedPublishersForCa(this.caIdent.getName());
    }

    public List<CertificateInfo> generateCerts(List<CertTemplateData> certTemplates, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        return this.generateCerts(certTemplates, requestor, false, reqType, transactionId, msgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<CertificateInfo> generateCerts(List<CertTemplateData> certTemplates, RequestorInfo requestor, boolean update, RequestType reqType, byte[] transactionId, String msgId) throws OperationExceptionWithIndex {
        Args.notEmpty(certTemplates, (String)"certTemplates");
        int n = certTemplates.size();
        ArrayList<GrantedCertTemplate> gcts = new ArrayList<GrantedCertTemplate>(n);
        for (int i = 0; i < n; ++i) {
            CertTemplateData certTemplate = certTemplates.get(i);
            try {
                GrantedCertTemplate gct = this.createGrantedCertTemplate(certTemplate, requestor, update);
                gcts.add(gct);
                continue;
            }
            catch (OperationException ex) {
                LOG.error("     FAILED createGrantedCertTemplate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certTemplate.getCertprofileName(), certTemplate.getSubject()});
                throw new OperationExceptionWithIndex(i, ex);
            }
        }
        ArrayList<CertificateInfo> certInfos = new ArrayList<CertificateInfo>(n);
        OperationExceptionWithIndex exception = null;
        for (int i = 0; i < n && exception == null; ++i) {
            GrantedCertTemplate gct = (GrantedCertTemplate)gcts.get(i);
            NameId certprofilIdent = gct.certprofile.getIdent();
            String subjectText = gct.grantedSubjectText;
            LOG.info("     START generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
            boolean successful = false;
            try {
                CertificateInfo certInfo = this.generateCert(gct, requestor, reqType, transactionId, msgId);
                successful = true;
                certInfos.add(certInfo);
                if (LOG.isInfoEnabled()) {
                    String prefix = certInfo.isAlreadyIssued() ? "RETURN_OLD_CERT" : "SUCCESSFUL";
                    CertWithDbId cert = certInfo.getCert();
                    LOG.info("{} generateCertificate: CA={}, profile={}, subject='{}', serialNumber={}", new Object[]{prefix, this.caIdent.getName(), certprofilIdent.getName(), cert.getSubject(), LogUtil.formatCsn((BigInteger)cert.getCert().getSerialNumber())});
                }
                if (successful) continue;
            }
            catch (OperationException ex) {
                exception = new OperationExceptionWithIndex(i, ex);
                if (successful) continue;
                LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                continue;
            }
            catch (Throwable th) {
                exception = new OperationExceptionWithIndex(i, new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, th));
                if (successful) continue;
                {
                    catch (Throwable throwable) {
                        if (!successful) {
                            LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                        }
                        throw throwable;
                    }
                }
                LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                continue;
            }
            LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
            continue;
        }
        if (exception != null) {
            LOG.error("could not generate certificate for request[{}], reverted all generated certificates", (Object)exception.getIndex());
            for (CertificateInfo m : certInfos) {
                BigInteger serial = m.getCert().getCert().getSerialNumber();
                try {
                    this.removeCert(serial, msgId);
                }
                catch (Throwable thr) {
                    LogUtil.error((Logger)LOG, (Throwable)thr, (String)("could not delete certificate serial=" + serial));
                }
            }
            LogUtil.warn((Logger)LOG, (Throwable)((Object)exception));
            throw exception;
        }
        return certInfos;
    }

    public CertificateInfo generateCert(CertTemplateData certTemplate, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        Args.notNull((Object)certTemplate, (String)"certTemplate");
        return this.generateCerts(Arrays.asList(certTemplate), requestor, reqType, transactionId, msgId).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertificateInfo generateCert(GrantedCertTemplate gct, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        AuditEvent event = this.newPerfAuditEvent("gen_cert", msgId);
        boolean successful = false;
        try {
            CertificateInfo ret = this.generateCert0(gct, requestor, reqType, transactionId, event);
            successful = ret != null;
            CertificateInfo certificateInfo = ret;
            return certificateInfo;
        }
        finally {
            this.finish(event, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertificateInfo generateCert0(GrantedCertTemplate gct, RequestorInfo requestor, RequestType reqType, byte[] transactionId, AuditEvent event) throws OperationException {
        boolean ctlogEnabled;
        boolean duplicatedSubjectNotAllowed;
        Args.notNull((Object)gct, (String)"gct");
        event.addEventData("req_subject", (Object)X509Util.getRfc4519Name((X500Name)gct.requestedSubject));
        event.addEventData("certprofile", (Object)gct.certprofile.getIdent().getName());
        event.addEventData("not_before", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Date)gct.grantedNotBefore));
        event.addEventData("not_after", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Date)gct.grantedNotAfter));
        this.adaptGrantedSubejct(gct);
        IdentifiedCertprofile certprofile = gct.certprofile;
        boolean duplicatedKeyNotAllowed = !this.caInfo.isDuplicateKeyPermitted();
        boolean bl = duplicatedSubjectNotAllowed = !this.caInfo.isDuplicateSubjectPermitted();
        if (duplicatedKeyNotAllowed && !this.publicKeyCertsInProcess.add(gct.fpPublicKey)) {
            throw new OperationException(OperationException.ErrorCode.ALREADY_ISSUED, "certificate with the given public key already in process");
        }
        if (duplicatedSubjectNotAllowed && !this.subjectCertsInProcess.add(gct.fpSubject)) {
            if (duplicatedKeyNotAllowed) {
                this.publicKeyCertsInProcess.remove(gct.fpPublicKey);
            }
            throw new OperationException(OperationException.ErrorCode.ALREADY_ISSUED, "certificate with the given subject " + gct.grantedSubjectText + " already in process");
        }
        Certprofile.ExtensionControl extnSctCtrl = certprofile.getExtensionControls().get(ObjectIdentifiers.Extn.id_SCTs);
        boolean bl2 = ctlogEnabled = this.caInfo.getCtlogControl() != null && this.caInfo.getCtlogControl().isEnabled();
        if (!ctlogEnabled && extnSctCtrl != null && extnSctCtrl.isRequired()) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "extension " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)ObjectIdentifiers.Extn.id_SCTs) + " is required but CTLog of the CA is not activated");
        }
        try {
            CertificateInfo ret;
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(this.caInfo.getPublicCaInfo().getX500Subject(), this.caInfo.nextSerial(), gct.grantedNotBefore, gct.grantedNotAfter, gct.grantedSubject, gct.grantedPublicKey);
            try {
                X509Certificate cert;
                int certSize;
                Certificate bcCert;
                boolean addCtlog;
                SignerEntryWrapper crlSigner = this.getCrlSigner();
                X509Certificate crlSignerCert = crlSigner == null ? null : crlSigner.getSigner().getCertificate();
                ExtensionValues extensionTuples = certprofile.getExtensions(gct.requestedSubject, gct.grantedSubject, gct.extensions, gct.grantedPublicKey, this.caInfo.getPublicCaInfo(), crlSignerCert, gct.grantedNotBefore, gct.grantedNotAfter);
                if (extensionTuples != null) {
                    for (ASN1ObjectIdentifier extensionType : extensionTuples.getExtensionTypes()) {
                        ExtensionValue extValue = extensionTuples.getExtensionValue(extensionType);
                        certBuilder.addExtension(extensionType, extValue.isCritical(), extValue.getValue());
                    }
                }
                boolean bl3 = addCtlog = ctlogEnabled && extnSctCtrl != null;
                if (addCtlog) {
                    bcCert = this.buildCtloggedCert(certBuilder, gct, extnSctCtrl.isCritical());
                } else {
                    ConcurrentBagEntrySigner signer0;
                    try {
                        signer0 = gct.signer.borrowSigner();
                    }
                    catch (NoIdleSignerException ex) {
                        throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
                    }
                    try {
                        bcCert = certBuilder.build((ContentSigner)signer0.value()).toASN1Structure();
                    }
                    finally {
                        gct.signer.requiteSigner(signer0);
                    }
                }
                byte[] encodedCert = bcCert.getEncoded();
                int maxCertSize = gct.certprofile.getMaxCertSize();
                if (maxCertSize > 0 && (certSize = encodedCert.length) > maxCertSize) {
                    throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, String.format("certificate exceeds the maximal allowed size: %d > %d", certSize, maxCertSize));
                }
                try {
                    cert = X509Util.toX509Cert((Certificate)bcCert);
                }
                catch (CertificateException ex) {
                    String message = "should not happen, could not parse generated certificate";
                    LOG.error(message, (Throwable)ex);
                    throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
                }
                if (!this.verifySignature(cert)) {
                    throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "could not verify the signature of generated certificate");
                }
                CertWithDbId certWithMeta = new CertWithDbId(cert, encodedCert);
                ret = new CertificateInfo(certWithMeta, gct.privateKey, this.caIdent, this.caCert, gct.grantedPublicKeyData, gct.certprofile.getIdent(), requestor.getIdent());
                if (requestor instanceof ByUserRequestorInfo) {
                    ret.setUser(Integer.valueOf(((ByUserRequestorInfo)requestor).getUserId()));
                }
                ret.setReqType(reqType);
                ret.setTransactionId(transactionId);
                ret.setRequestedSubject(gct.requestedSubject);
                if (this.publishCert0(ret) == 1) {
                    throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "could not save certificate");
                }
            }
            catch (BadCertTemplateException ex) {
                throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
            }
            catch (OperationException ex) {
                throw ex;
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not generate certificate");
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, th);
            }
            if (gct.warning != null) {
                ret.setWarningMessage(gct.warning);
            }
            CertificateInfo certificateInfo = ret;
            return certificateInfo;
        }
        finally {
            if (duplicatedKeyNotAllowed) {
                this.publicKeyCertsInProcess.remove(gct.fpPublicKey);
            }
            if (duplicatedSubjectNotAllowed) {
                this.subjectCertsInProcess.remove(gct.fpSubject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate buildCtloggedCert(X509v3CertificateBuilder certBuilder, GrantedCertTemplate gct, boolean critical) throws CertIOException, OperationException {
        DEROctetString extnValue;
        byte[] encodedPreCert;
        Certificate precert;
        ConcurrentBagEntrySigner signer0;
        certBuilder.addExtension(ObjectIdentifiers.Extn.id_precertificate, true, (ASN1Encodable)DERNull.INSTANCE);
        try {
            signer0 = gct.signer.borrowSigner();
        }
        catch (NoIdleSignerException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        try {
            precert = certBuilder.build((ContentSigner)signer0.value()).toASN1Structure();
        }
        finally {
            gct.signer.requiteSigner(signer0);
        }
        try {
            encodedPreCert = precert.getEncoded();
        }
        catch (IOException ex) {
            throw new CertIOException("could not encode PreCert", (Throwable)ex);
        }
        CtLog.SignedCertificateTimestampList scts = this.getCtlogScts(encodedPreCert);
        ASN1Sequence preTbsCert = ASN1Sequence.getInstance((Object)precert.getTBSCertificate().toASN1Primitive());
        ASN1EncodableVector tbsVec = new ASN1EncodableVector();
        tbsVec.add(preTbsCert.getObjectAt(0));
        tbsVec.add(preTbsCert.getObjectAt(1));
        tbsVec.add(preTbsCert.getObjectAt(2));
        tbsVec.add(preTbsCert.getObjectAt(3));
        tbsVec.add(preTbsCert.getObjectAt(4));
        tbsVec.add(preTbsCert.getObjectAt(5));
        tbsVec.add(preTbsCert.getObjectAt(6));
        ASN1TaggedObject taggedExtensions = ASN1TaggedObject.getInstance((Object)preTbsCert.getObjectAt(7));
        ASN1Sequence extnSeq = ASN1Sequence.getInstance((Object)taggedExtensions.getObject());
        ASN1EncodableVector extnVec = new ASN1EncodableVector();
        int size = extnSeq.size();
        for (int i = 0; i < size; ++i) {
            ASN1Encodable asn1Extn = extnSeq.getObjectAt(i);
            Extension extn = Extension.getInstance((Object)asn1Extn);
            if (extn.getExtnId().equals((Object)ObjectIdentifiers.Extn.id_precertificate)) continue;
            extnVec.add(asn1Extn);
        }
        try {
            extnValue = new DEROctetString(new DEROctetString(scts.getEncoded()).getEncoded());
        }
        catch (IOException ex) {
            throw new CertIOException("could not encode SCT extension", (Throwable)ex);
        }
        extnVec.add((ASN1Encodable)new Extension(ObjectIdentifiers.Extn.id_SCTs, critical, (ASN1OctetString)extnValue));
        tbsVec.add((ASN1Encodable)new DERTaggedObject(taggedExtensions.isExplicit(), taggedExtensions.getTagNo(), (ASN1Encodable)new DERSequence(extnVec)));
        DERSequence tbsCert = new DERSequence(tbsVec);
        try {
            signer0 = gct.signer.borrowSigner();
        }
        catch (NoIdleSignerException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        ASN1EncodableVector certVec = new ASN1EncodableVector();
        certVec.add((ASN1Encodable)tbsCert);
        try {
            XiContentSigner xiSigner = (XiContentSigner)signer0.value();
            certVec.add((ASN1Encodable)xiSigner.getAlgorithmIdentifier());
            OutputStream os = xiSigner.getOutputStream();
            os.write(tbsCert.getEncoded());
            byte[] signature = xiSigner.getSignature();
            certVec.add((ASN1Encodable)new DERBitString(signature));
        }
        catch (IOException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        finally {
            gct.signer.requiteSigner(signer0);
        }
        return Certificate.getInstance((Object)new DERSequence(certVec));
    }

    private void adaptGrantedSubejct(GrantedCertTemplate gct) throws OperationException {
        String latestSn;
        if (this.caInfo.isDuplicateSubjectPermitted()) {
            return;
        }
        long fpSubject = X509Util.fpCanonicalizedName((X500Name)gct.grantedSubject);
        String grantedSubjectText = X509Util.getRfc4519Name((X500Name)gct.grantedSubject);
        boolean incSerial = gct.certprofile.incSerialNumberIfSubjectExists();
        boolean certIssued = this.certstore.isCertForSubjectIssued(this.caIdent, fpSubject);
        if (certIssued && !incSerial) {
            throw new OperationException(OperationException.ErrorCode.ALREADY_ISSUED, "certificate for the given subject " + grantedSubjectText + " already issued");
        }
        if (!certIssued) {
            return;
        }
        X500Name subject = gct.grantedSubject;
        try {
            Object[] objs = X509Ca.incSerialNumber(gct.certprofile, subject, null);
            latestSn = this.certstore.getLatestSerialNumber((X500Name)objs[0]);
        }
        catch (BadFormatException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        boolean foundUniqueSubject = false;
        for (int i = 0; i < 100; ++i) {
            try {
                Object[] objs = X509Ca.incSerialNumber(gct.certprofile, subject, latestSn);
                subject = (X500Name)objs[0];
                if (CompareUtil.equalsObject((Object)latestSn, (Object)objs[1])) break;
                latestSn = (String)objs[1];
            }
            catch (BadFormatException ex) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
            }
            boolean bl = foundUniqueSubject = !this.certstore.isCertForSubjectIssued(this.caIdent, X509Util.fpCanonicalizedName((X500Name)subject));
            if (foundUniqueSubject) break;
        }
        if (!foundUniqueSubject) {
            throw new OperationException(OperationException.ErrorCode.ALREADY_ISSUED, "certificate for the given subject " + grantedSubjectText + " and profile " + gct.certprofile.getIdent().getName() + " already issued, and could not create new unique serial number");
        }
        gct.setGrantedSubject(subject);
    }

    private GrantedCertTemplate createGrantedCertTemplate(CertTemplateData certTemplate, RequestorInfo requestor, boolean update) throws OperationException {
        Date grantedNotAfter;
        Validity validity;
        Certprofile.SubjectInfo subjectInfo;
        PrivateKeyInfo privateKey;
        SubjectPublicKeyInfo grantedPublicKeyInfo;
        RDN[] rdns;
        Args.notNull((Object)certTemplate, (String)"certTemplate");
        if (this.caInfo.getRevocationInfo() != null) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA is revoked");
        }
        IdentifiedCertprofile certprofile = this.getX509Certprofile(certTemplate.getCertprofileName());
        if (certprofile == null) {
            throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT_PROFILE, "unknown cert profile " + certTemplate.getCertprofileName());
        }
        ConcurrentContentSigner signer = this.caInfo.getSigner(certprofile.getSignatureAlgorithms());
        if (signer == null) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "CA does not support any signature algorithm restricted by the cert profile");
        }
        NameId certprofileIdent = certprofile.getIdent();
        if (certprofile.getVersion() != Certprofile.X509CertVersion.v3) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "unknown cert version " + certprofile.getVersion());
        }
        if (certprofile.isOnlyForRa() && (requestor == null || !requestor.isRa())) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "profile " + certprofileIdent + " not applied to non-RA");
        }
        X500Name requestedSubject = X509Ca.removeEmptyRdns(certTemplate.getSubject());
        if (!certprofile.isSerialNumberInReqPermitted() && (rdns = requestedSubject.getRDNs(ObjectIdentifiers.DN.SN)) != null && rdns.length > 0) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "subjectDN SerialNumber in request is not permitted");
        }
        Date reqNotBefore = certTemplate.getNotBefore();
        Date grantedNotBefore = certprofile.getNotBefore(reqNotBefore);
        long currentMillis = System.currentTimeMillis();
        if (currentMillis - grantedNotBefore.getTime() > 300000L) {
            grantedNotBefore = new Date(currentMillis - 300000L);
        }
        long time = this.caInfo.getNoNewCertificateAfter();
        if (grantedNotBefore.getTime() > time) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA is not permitted to issue certifate after " + new Date(time));
        }
        if (grantedNotBefore.before(this.caInfo.getNotBefore())) {
            grantedNotBefore = this.caInfo.getNotBefore();
        }
        if ((grantedPublicKeyInfo = certTemplate.getPublicKeyInfo()) != null) {
            privateKey = null;
            try {
                grantedPublicKeyInfo = X509Util.toRfc3279Style((SubjectPublicKeyInfo)certTemplate.getPublicKeyInfo());
            }
            catch (InvalidKeySpecException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"invalid SubjectPublicKeyInfo");
                throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "invalid SubjectPublicKeyInfo");
            }
            if (grantedPublicKeyInfo.getAlgorithm().getAlgorithm().equals((Object)PKCSObjectIdentifiers.rsaEncryption)) {
                try {
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)grantedPublicKeyInfo.getPublicKeyData().getOctets());
                    if (seq.size() != 2) {
                        throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "invalid format of RSA public key");
                    }
                    BigInteger modulus = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue();
                    if (RSABrokenKey.isAffected((BigInteger)modulus)) {
                        throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "RSA public key is too weak");
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "invalid format of RSA public key");
                }
            }
        } else if (certTemplate.isCaGenerateKeypair()) {
            KeypairGenControl kg = certprofile.getKeypairGenControl();
            try {
                KeypairGenControl.RSAKeypairGenControl tkg;
                if (kg instanceof KeypairGenControl.InheritCAKeypairGenControl) {
                    kg = this.keypairGenControlByImplictCA;
                }
                if (kg == null || kg instanceof KeypairGenControl.ForbiddenKeypairGenControl) {
                    throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "no public key is specified");
                }
                if (kg instanceof KeypairGenControl.RSAKeypairGenControl) {
                    tkg = (KeypairGenControl.RSAKeypairGenControl)kg;
                    int keysize = tkg.getKeysize();
                    if (keysize > 4096) {
                        throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "keysize too large");
                    }
                    BigInteger publicExponent = tkg.getPublicExponent();
                    KeyPair kp = KeyUtil.generateRSAKeypair((int)keysize, (BigInteger)publicExponent, (SecureRandom)this.random);
                    RSAPublicKey rsaPubKey = (RSAPublicKey)kp.getPublic();
                    grantedPublicKeyInfo = new SubjectPublicKeyInfo(tkg.getKeyAlgorithm(), (ASN1Encodable)new org.bouncycastle.asn1.pkcs.RSAPublicKey(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent()));
                    RSAPrivateCrtKey priv = (RSAPrivateCrtKey)kp.getPrivate();
                    privateKey = new PrivateKeyInfo(tkg.getKeyAlgorithm(), (ASN1Encodable)new RSAPrivateKey(priv.getModulus(), priv.getPublicExponent(), priv.getPrivateExponent(), priv.getPrimeP(), priv.getPrimeQ(), priv.getPrimeExponentP(), priv.getPrimeExponentQ(), priv.getCrtCoefficient()));
                }
                if (kg instanceof KeypairGenControl.ECKeypairGenControl) {
                    tkg = (KeypairGenControl.ECKeypairGenControl)kg;
                    ASN1ObjectIdentifier curveOid = tkg.getCurveOid();
                    KeyPair kp = KeyUtil.generateECKeypair((ASN1ObjectIdentifier)curveOid, (SecureRandom)this.random);
                    ECPublicKey pub = (ECPublicKey)kp.getPublic();
                    int orderBitLength = pub.getParams().getOrder().bitLength();
                    byte[] keyData = KeyUtil.getUncompressedEncodedECPoint((ECPoint)pub.getW(), (int)orderBitLength);
                    grantedPublicKeyInfo = new SubjectPublicKeyInfo(tkg.getKeyAlgorithm(), keyData);
                    ECPrivateKey priv = (ECPrivateKey)kp.getPrivate();
                    privateKey = new PrivateKeyInfo(tkg.getKeyAlgorithm(), (ASN1Encodable)new org.bouncycastle.asn1.sec.ECPrivateKey(orderBitLength, priv.getS()));
                }
                if (kg instanceof KeypairGenControl.DSAKeypairGenControl) {
                    tkg = (KeypairGenControl.DSAKeypairGenControl)kg;
                    KeyPair kp = KeyUtil.generateDSAKeypair((DSAParameterSpec)tkg.getParameterSpec(), (SecureRandom)this.random);
                    grantedPublicKeyInfo = new SubjectPublicKeyInfo(tkg.getKeyAlgorithm(), (ASN1Encodable)new ASN1Integer(((DSAPublicKey)kp.getPublic()).getY()));
                    DSAPrivateKey priv = (DSAPrivateKey)kp.getPrivate();
                    privateKey = new PrivateKeyInfo(grantedPublicKeyInfo.getAlgorithm(), (ASN1Encodable)new ASN1Integer(priv.getX()));
                }
                if (kg instanceof KeypairGenControl.EDDSAKeypairGenControl) {
                    tkg = (KeypairGenControl.EDDSAKeypairGenControl)kg;
                    KeyPair kp = KeyUtil.generateEdECKeypair((String)tkg.getCurveName(), (SecureRandom)this.random);
                    grantedPublicKeyInfo = KeyUtil.createSubjectPublicKeyInfo((PublicKey)kp.getPublic());
                    if (!grantedPublicKeyInfo.getAlgorithm().equals((Object)tkg.getKeyAlgorithm())) {
                        throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "invalid SubjectPublicKeyInfo.algorithm");
                    }
                    privateKey = PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
                }
                throw new RuntimeCryptoException("unknown KeyPairGenControl " + kg);
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
            }
        } else {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "no public key is specified  genkey");
        }
        try {
            grantedPublicKeyInfo = certprofile.checkPublicKey(grantedPublicKeyInfo);
        }
        catch (CertprofileException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofileIdent);
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        try {
            subjectInfo = certprofile.getSubject(requestedSubject);
        }
        catch (CertprofileException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofileIdent);
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        X500Name grantedSubject = subjectInfo.getGrantedSubject();
        ASN1ObjectIdentifier[] attrTypes = grantedSubject.getAttributeTypes();
        if (attrTypes == null || attrTypes.length == 0) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "empty subject is not permitted");
        }
        if (X509Util.canonicalizName((X500Name)grantedSubject).equals(this.caInfo.getPublicCaInfo().getC14nSubject())) {
            throw new OperationException(OperationException.ErrorCode.ALREADY_ISSUED, "certificate with the same subject as CA is not allowed");
        }
        boolean duplicateKeyPermitted = this.caInfo.isDuplicateKeyPermitted();
        byte[] subjectPublicKeyData = grantedPublicKeyInfo.getPublicKeyData().getBytes();
        long fpPublicKey = FpIdCalculator.hash((byte[])subjectPublicKeyData);
        if (update) {
            CertStatus certStatus = this.certstore.getCertStatusForSubject(this.caIdent, grantedSubject);
            if (certStatus == CertStatus.REVOKED) {
                throw new OperationException(OperationException.ErrorCode.CERT_REVOKED);
            }
            if (certStatus == CertStatus.UNKNOWN) {
                throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT);
            }
        } else if (!duplicateKeyPermitted && this.certstore.isCertForKeyIssued(this.caIdent, fpPublicKey)) {
            throw new OperationException(OperationException.ErrorCode.ALREADY_ISSUED, "certificate for the given public key already issued");
        }
        StringBuilder msgBuilder = new StringBuilder();
        if (subjectInfo.getWarning() != null) {
            msgBuilder.append(", ").append(subjectInfo.getWarning());
        }
        if ((validity = certprofile.getValidity()) == null) {
            validity = this.caInfo.getMaxValidity();
        } else if (validity.compareTo(this.caInfo.getMaxValidity()) > 0) {
            validity = this.caInfo.getMaxValidity();
        }
        Date maxNotAfter = validity.add(grantedNotBefore);
        if (maxNotAfter.getTime() > 253402300799982L) {
            maxNotAfter = new Date(253402300799982L);
        }
        if ((grantedNotAfter = certTemplate.getNotAfter()) != null) {
            if (grantedNotAfter.after(maxNotAfter)) {
                grantedNotAfter = maxNotAfter;
                msgBuilder.append(", notAfter modified");
            }
        } else {
            grantedNotAfter = maxNotAfter;
        }
        if (grantedNotAfter.after(this.caInfo.getNotAfter())) {
            ValidityMode mode = this.caInfo.getValidityMode();
            if (mode == ValidityMode.CUTOFF) {
                grantedNotAfter = this.caInfo.getNotAfter();
            } else {
                if (mode == ValidityMode.STRICT) {
                    throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "notAfter outside of CA's validity is not permitted");
                }
                if (mode != ValidityMode.LAX) {
                    throw new IllegalStateException("should not reach here, unknown CA ValidityMode " + mode);
                }
            }
        }
        String warning = null;
        if (msgBuilder.length() > 2) {
            warning = msgBuilder.substring(2);
        }
        GrantedCertTemplate gct = new GrantedCertTemplate(certTemplate.getExtensions(), certprofile, grantedNotBefore, grantedNotAfter, requestedSubject, grantedPublicKeyInfo, fpPublicKey, privateKey, subjectPublicKeyData, signer, warning);
        gct.setGrantedSubject(grantedSubject);
        return gct;
    }

    public IdentifiedCertprofile getX509Certprofile(String certprofileName) {
        if (certprofileName == null) {
            return null;
        }
        Set<String> profileNames = this.caManager.getCertprofilesForCa(this.caIdent.getName());
        return profileNames == null || !profileNames.contains(certprofileName) ? null : this.caManager.getIdentifiedCertprofile(certprofileName);
    }

    public boolean supportsCertprofile(String certprofileName) {
        Args.notNull((Object)certprofileName, (String)"certprofileName");
        Set<String> profileNames = this.caManager.getCertprofilesForCa(this.caIdent.getName());
        return profileNames.contains(certprofileName.toLowerCase());
    }

    public CmpRequestorInfo getRequestor(X500Name requestorSender) {
        Set<MgmtEntry.CaHasRequestor> requestorEntries = this.caManager.getRequestorsForCa(this.caIdent.getName());
        if (CollectionUtil.isEmpty(requestorEntries)) {
            return null;
        }
        for (MgmtEntry.CaHasRequestor m : requestorEntries) {
            RequestorEntryWrapper entry = this.caManager.getRequestorWrapper(m.getRequestorIdent().getName());
            if (entry.getDbEntry().isFaulty() || !"cert".equals(entry.getDbEntry().getType()) || !entry.getCert().getSubjectAsX500Name().equals((Object)requestorSender)) continue;
            return new CmpRequestorInfo(m, entry.getCert());
        }
        return null;
    }

    public CmpRequestorInfo getRequestor(X509Certificate requestorCert) {
        Set<MgmtEntry.CaHasRequestor> requestorEntries = this.caManager.getRequestorsForCa(this.caIdent.getName());
        if (CollectionUtil.isEmpty(requestorEntries)) {
            return null;
        }
        for (MgmtEntry.CaHasRequestor m : requestorEntries) {
            RequestorEntryWrapper entry = this.caManager.getRequestorWrapper(m.getRequestorIdent().getName());
            if (!"cert".equals(entry.getDbEntry().getType()) || !entry.getCert().getCert().equals(requestorCert)) continue;
            return new CmpRequestorInfo(m, entry.getCert());
        }
        return null;
    }

    public CmpRequestorInfo getMacRequestor(X500Name sender, byte[] senderKID) {
        Set<MgmtEntry.CaHasRequestor> requestorEntries = this.caManager.getRequestorsForCa(this.caIdent.getName());
        if (CollectionUtil.isEmpty(requestorEntries)) {
            return null;
        }
        for (MgmtEntry.CaHasRequestor m : requestorEntries) {
            RequestorEntryWrapper entry = this.caManager.getRequestorWrapper(m.getRequestorIdent().getName());
            if (!"pbm".equals(entry.getDbEntry().getType()) || !entry.matchKeyId(senderKID)) continue;
            return new CmpRequestorInfo(m, entry.getPassword(), senderKID);
        }
        return null;
    }

    public CaManagerImpl getCaManager() {
        return this.caManager;
    }

    private Date getScheduledCrlGenTimeNotAfter(Date time) {
        Calendar cal = Calendar.getInstance(TIMEZONE_UTC);
        cal.setTime(time);
        CrlControl.HourMinute hm = this.caInfo.getCrlControl().getIntervalDayTime();
        cal.set(10, hm.getHour());
        cal.set(12, hm.getMinute());
        cal.set(13, 0);
        cal.set(14, 0);
        long t1 = time.getTime() / 1000L;
        long tcal = cal.getTimeInMillis() / 1000L;
        return t1 >= tcal ? cal.getTime() : new Date(cal.getTimeInMillis() - 86400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeExpirtedCerts(Date expiredAtTime, String msgId) throws OperationException {
        LOG.debug("revoking suspended certificates");
        AuditEvent event = this.newPerfAuditEvent("remove_expired_certs", msgId);
        boolean successful = false;
        try {
            int num = this.removeExpirtedCerts0(expiredAtTime, event, msgId);
            LOG.info("removed {} expired certificates of CA {}", (Object)num, (Object)this.caIdent);
            successful = true;
            int n = num;
            return n;
        }
        finally {
            this.finish(event, successful);
        }
    }

    private int removeExpirtedCerts0(Date expiredAtTime, AuditEvent event, String msgId) throws OperationException {
        Args.notNull((Object)expiredAtTime, (String)"expiredtime");
        if (!this.masterMode) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA could not remove expired certificates in slave mode");
        }
        event.addEventData("expired_at", (Object)expiredAtTime);
        int numEntries = 100;
        long expiredAt = expiredAtTime.getTime() / 1000L;
        int sum = 0;
        List<BigInteger> serials;
        block2: while (!CollectionUtil.isEmpty(serials = this.certstore.getExpiredSerialNumbers(this.caIdent, expiredAt, 100))) {
            Iterator<BigInteger> iterator = serials.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                BigInteger serial = iterator.next();
                if (this.caInfo.isSelfSigned() && this.caInfo.getSerialNumber().equals(serial)) continue;
                try {
                    if (this.removeCert(serial, msgId) == null) continue;
                    ++sum;
                }
                catch (OperationException ex) {
                    LOG.info("removed {} expired certificates of CA {}", (Object)sum, (Object)this.caIdent.getName());
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not remove expired certificate with serial" + serial));
                    throw ex;
                }
            }
            break;
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int revokeSuspendedCerts(String msgId) throws OperationException {
        LOG.debug("revoking suspended certificates");
        AuditEvent event = this.newPerfAuditEvent("revoke_suspended_cert", msgId);
        boolean successful = false;
        try {
            int num = this.revokeSuspendedCerts0(event, msgId);
            LOG.info("revoked {} suspended certificates of CA {}", (Object)num, (Object)this.caIdent.getName());
            successful = true;
            int n = num;
            return n;
        }
        finally {
            this.finish(event, successful);
        }
    }

    private int revokeSuspendedCerts0(AuditEvent event, String msgId) throws OperationException {
        long ms;
        if (!this.masterMode) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA could not remove expired certificates in slave mode");
        }
        int numEntries = 100;
        Validity val = this.caInfo.revokeSuspendedCertsControl().getUnchangedSince();
        switch (val.getUnit()) {
            case DAY: {
                ms = (long)val.getValidity() * 86400000L;
                break;
            }
            case HOUR: {
                ms = (long)val.getValidity() * 86400000L / 24L;
                break;
            }
            case YEAR: {
                ms = (long)(val.getValidity() * 365) * 86400000L;
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here, unknown Validity Unit " + val.getUnit());
            }
        }
        long latestLastUpdatedAt = (System.currentTimeMillis() - ms) / 1000L;
        CrlReason reason = this.caInfo.revokeSuspendedCertsControl().getTargetReason();
        int sum = 0;
        List<BigInteger> serials;
        block7: while (!CollectionUtil.isEmpty(serials = this.certstore.getSuspendedCertSerials(this.caIdent, latestLastUpdatedAt, 100))) {
            Iterator<BigInteger> iterator = serials.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block7;
                BigInteger serial = iterator.next();
                boolean revoked = false;
                try {
                    revoked = this.revokeSuspendedCert(serial, reason, msgId) != null;
                    if (!revoked) continue;
                    ++sum;
                }
                catch (OperationException ex) {
                    LOG.info("revoked {} suspended certificates of CA {}", (Object)sum, (Object)this.caIdent.getName());
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not revoke suspended certificate with serial" + serial));
                    throw ex;
                }
            }
            break;
        }
        return sum;
    }

    public HealthCheckResult healthCheck() {
        HealthCheckResult result = new HealthCheckResult();
        result.setName("X509CA");
        boolean healthy = true;
        ConcurrentContentSigner signer = this.caInfo.getSigner(null);
        if (signer != null) {
            boolean caSignerHealthy = signer.isHealthy();
            healthy &= caSignerHealthy;
            HealthCheckResult signerHealth = new HealthCheckResult();
            signerHealth.setName("Signer");
            signerHealth.setHealthy(caSignerHealthy);
            result.addChildCheck(signerHealth);
        }
        boolean databaseHealthy = this.certstore.isHealthy();
        healthy &= databaseHealthy;
        HealthCheckResult databaseHealth = new HealthCheckResult();
        databaseHealth.setName("Database");
        databaseHealth.setHealthy(databaseHealthy);
        result.addChildCheck(databaseHealth);
        SignerEntryWrapper crlSigner = this.getCrlSigner();
        if (crlSigner != null && crlSigner.getSigner() != null) {
            boolean crlSignerHealthy = crlSigner.getSigner().isHealthy();
            healthy &= crlSignerHealthy;
            HealthCheckResult crlSignerHealth = new HealthCheckResult();
            crlSignerHealth.setName("CRLSigner");
            crlSignerHealth.setHealthy(crlSignerHealthy);
            result.addChildCheck(crlSignerHealth);
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            boolean ph = publisher.isHealthy();
            healthy &= ph;
            HealthCheckResult publisherHealth = new HealthCheckResult();
            publisherHealth.setName("Publisher");
            publisherHealth.setHealthy(publisher.isHealthy());
            result.addChildCheck(publisherHealth);
        }
        result.setHealthy(healthy);
        return result;
    }

    private AuditService auditService() {
        return Audits.getAuditService();
    }

    private AuditEvent newPerfAuditEvent(String eventType, String msgId) {
        return this.newAuditEvent("perf", eventType, msgId);
    }

    private AuditEvent newAuditEvent(String name, String eventType, String msgId) {
        Args.notNull((Object)name, (String)"name");
        Args.notNull((Object)eventType, (String)"eventType");
        Args.notNull((Object)msgId, (String)"msgId");
        AuditEvent event = new AuditEvent(new Date());
        event.setApplicationName("ca");
        event.setName(name);
        event.addEventData("ca", (Object)this.caIdent.getName());
        event.addEventType(eventType);
        event.addEventData("mid", (Object)msgId);
        return event;
    }

    private boolean verifySignature(X509Certificate cert) {
        Args.notNull((Object)cert, (String)"cert");
        PublicKey caPublicKey = this.caCert.getCert().getPublicKey();
        try {
            cert.verify(caPublicKey);
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException ex) {
            LOG.debug("{} while verifying signature: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            return false;
        }
    }

    private SignerEntryWrapper getCrlSigner() {
        if (this.caInfo.getCrlControl() == null) {
            return null;
        }
        String crlSignerName = this.caInfo.getCrlSignerName();
        if (crlSignerName == null) {
            return null;
        }
        return this.caManager.getSignerWrapper(crlSignerName);
    }

    public NameId getCaIdent() {
        return this.caIdent;
    }

    public String getHexSha1OfCert() {
        return this.caInfo.getCaEntry().getHexSha1OfCert();
    }

    @Override
    public void close() {
        ScheduledThreadPoolExecutor executor;
        if (this.crlGenerationService != null) {
            this.crlGenerationService.cancel(false);
            this.crlGenerationService = null;
        }
        if (this.expiredCertsRemover != null) {
            this.expiredCertsRemover.cancel(false);
            this.expiredCertsRemover = null;
        }
        if (this.suspendedCertsRevoker != null) {
            this.suspendedCertsRevoker.cancel(false);
            this.suspendedCertsRevoker = null;
        }
        if ((executor = this.caManager.getScheduledThreadPoolExecutor()) != null) {
            executor.purge();
        }
    }

    private static Extension createReasonExtension(int reasonCode) {
        CRLReason crlReason = CRLReason.lookup((int)reasonCode);
        try {
            return new Extension(Extension.reasonCode, false, crlReason.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private static Extension createInvalidityDateExtension(Date invalidityDate) {
        try {
            ASN1GeneralizedTime asnTime = new ASN1GeneralizedTime(invalidityDate);
            return new Extension(Extension.invalidityDate, false, asnTime.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private static Extension createCertificateIssuerExtension(X500Name certificateIssuer) {
        try {
            GeneralNames generalNames = new GeneralNames(new GeneralName(certificateIssuer));
            return new Extension(Extension.certificateIssuer, true, generalNames.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private static X500Name removeEmptyRdns(X500Name name) {
        RDN[] rdns = name.getRDNs();
        ArrayList<RDN> tmpRdns = new ArrayList<RDN>(rdns.length);
        boolean changed = false;
        for (RDN rdn : rdns) {
            String textValue = X509Util.rdnValueToString((ASN1Encodable)rdn.getFirst().getValue());
            if (StringUtil.isBlank((String)textValue)) {
                changed = true;
                continue;
            }
            tmpRdns.add(rdn);
        }
        return changed ? new X500Name(tmpRdns.toArray(new RDN[0])) : name;
    }

    private static Object[] incSerialNumber(IdentifiedCertprofile profile, X500Name origName, String latestSn) throws BadFormatException {
        X500Name newName;
        RDN[] rdns = origName.getRDNs();
        int commonNameIndex = -1;
        int serialNumberIndex = -1;
        for (int i = 0; i < rdns.length; ++i) {
            RDN rdn = rdns[i];
            ASN1ObjectIdentifier type = rdn.getFirst().getType();
            if (ObjectIdentifiers.DN.CN.equals((Object)type)) {
                commonNameIndex = i;
                continue;
            }
            if (!ObjectIdentifiers.DN.serialNumber.equals((Object)type)) continue;
            serialNumberIndex = i;
        }
        String newSerialNumber = profile.incSerialNumber(latestSn);
        RDN serialNumberRdn = new RDN(ObjectIdentifiers.DN.serialNumber, (ASN1Encodable)new DERPrintableString(newSerialNumber));
        if (serialNumberIndex != -1) {
            rdns[serialNumberIndex] = serialNumberRdn;
            newName = new X500Name(rdns);
        } else {
            ArrayList<RDN> newRdns = new ArrayList<RDN>(rdns.length + 1);
            if (commonNameIndex == -1) {
                newRdns.add(serialNumberRdn);
            }
            for (int i = 0; i < rdns.length; ++i) {
                newRdns.add(rdns[i]);
                if (i != commonNameIndex) continue;
                newRdns.add(serialNumberRdn);
            }
            newName = new X500Name(newRdns.toArray(new RDN[0]));
        }
        return new Object[]{newName, newSerialNumber};
    }

    private void finish(AuditEvent event, boolean successful) {
        event.finish();
        event.setLevel(successful ? AuditLevel.INFO : AuditLevel.ERROR);
        event.setStatus(successful ? AuditStatus.SUCCESSFUL : AuditStatus.FAILED);
        this.auditService().logEvent(event);
    }

    private CtLog.SignedCertificateTimestampList getCtlogScts(byte[] encodedPrecert) throws OperationException {
        return this.ctlogClient.getCtLogScts(encodedPrecert, this.caCert, this.caInfo.getCertchain());
    }

    private class SuspendedCertsRevoker
    implements Runnable {
        private boolean inProcess;

        private SuspendedCertsRevoker() {
        }

        @Override
        public void run() {
            if (X509Ca.this.caInfo.revokeSuspendedCertsControl() == null) {
                return;
            }
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                LOG.debug("revoking suspended certificates");
                int num = X509Ca.this.revokeSuspendedCerts("ca_routine");
                if (num == 0) {
                    LOG.debug("revoked {} suspended certificates of CA '{}'", (Object)num, (Object)X509Ca.this.caIdent);
                } else {
                    LOG.info("revoked {} suspended certificates of CA '{}'", (Object)num, (Object)X509Ca.this.caIdent);
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not revoke suspended certificates");
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class CrlGenerationService
    implements Runnable {
        private CrlGenerationService() {
        }

        @Override
        public void run() {
            CrlControl crlControl = X509Ca.this.caInfo.getCrlControl();
            if (crlControl == null) {
                return;
            }
            if (X509Ca.this.crlGenInProcess.get()) {
                return;
            }
            X509Ca.this.crlGenInProcess.set(true);
            try {
                this.run0();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th);
            }
            finally {
                X509Ca.this.crlGenInProcess.set(false);
            }
        }

        private void run0() throws OperationException {
            long maxIdOfDeltaCrlCache;
            long lastIssueTimeOfDeltaCrl;
            long lastIssueTime;
            Date nearestScheduledCrlIssueTime;
            Date nextScheduledCrlIssueTime;
            CrlControl control = X509Ca.this.caInfo.getCrlControl();
            long lastIssueTimeOfFullCrl = X509Ca.this.certstore.getThisUpdateOfCurrentCrl(X509Ca.this.caIdent, false);
            Date now = new Date();
            boolean createFullCrlNow = false;
            if (lastIssueTimeOfFullCrl == 0L) {
                createFullCrlNow = true;
            } else {
                Date nearestScheduledCrlIssueTime2 = X509Ca.this.getScheduledCrlGenTimeNotAfter(new Date(lastIssueTimeOfFullCrl * 1000L));
                Date nextScheduledCrlIssueTime2 = new Date(nearestScheduledCrlIssueTime2.getTime() + (long)control.getFullCrlIntervals() * 86400000L);
                if (!nextScheduledCrlIssueTime2.after(now)) {
                    createFullCrlNow = true;
                }
            }
            boolean createDeltaCrlNow = false;
            if (control.getDeltaCrlIntervals() > 0 && !createFullCrlNow && !(nextScheduledCrlIssueTime = new Date((nearestScheduledCrlIssueTime = X509Ca.this.getScheduledCrlGenTimeNotAfter(new Date((lastIssueTime = Math.max(lastIssueTimeOfDeltaCrl = X509Ca.this.certstore.getThisUpdateOfCurrentCrl(X509Ca.this.caIdent, true), lastIssueTimeOfFullCrl)) * 1000L))).getTime() + (long)control.getDeltaCrlIntervals() * 86400000L)).after(now)) {
                createDeltaCrlNow = true;
            }
            if (!createFullCrlNow && !createDeltaCrlNow) {
                LOG.info("No CRL is needed to be created");
                return;
            }
            int intervals = createDeltaCrlNow ? control.getDeltaCrlIntervals() : (!control.isExtendedNextUpdate() && control.getDeltaCrlIntervals() > 0 ? control.getDeltaCrlIntervals() : control.getFullCrlIntervals());
            Date nextUpdate = new Date(X509Ca.this.getScheduledCrlGenTimeNotAfter(now).getTime() + (long)intervals * 86400000L + (long)control.getOverlapMinutes() * 60000L);
            try {
                maxIdOfDeltaCrlCache = X509Ca.this.certstore.getMaxIdOfDeltaCrlCache(X509Ca.this.caIdent);
                X509Ca.this.generateCrl(createDeltaCrlNow, now, nextUpdate, "ca_routine");
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th);
                return;
            }
            try {
                X509Ca.this.certstore.clearDeltaCrlCache(X509Ca.this.caIdent, maxIdOfDeltaCrlCache);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not clear DeltaCRLCache of CA " + X509Ca.this.caIdent));
            }
        }
    }

    private class ExpiredCertsRemover
    implements Runnable {
        private boolean inProcess;

        private ExpiredCertsRemover() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int keepDays = X509Ca.this.caInfo.getKeepExpiredCertInDays();
            if (keepDays < 0) {
                return;
            }
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            Date expiredAt = new Date(System.currentTimeMillis() - 86400000L * (long)(keepDays + 1));
            try {
                int num = X509Ca.this.removeExpirtedCerts(expiredAt, "ca_routine");
                LOG.info("removed {} certificates expired at {}", (Object)num, (Object)expiredAt.toString());
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not remove expired certificates");
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private static class GrantedCertTemplate {
        private final ConcurrentContentSigner signer;
        private final Extensions extensions;
        private final IdentifiedCertprofile certprofile;
        private final Date grantedNotBefore;
        private final Date grantedNotAfter;
        private final X500Name requestedSubject;
        private final SubjectPublicKeyInfo grantedPublicKey;
        private final PrivateKeyInfo privateKey;
        private final byte[] grantedPublicKeyData;
        private final long fpPublicKey;
        private final String warning;
        private X500Name grantedSubject;
        private String grantedSubjectText;
        private long fpSubject;

        public GrantedCertTemplate(Extensions extensions, IdentifiedCertprofile certprofile, Date grantedNotBefore, Date grantedNotAfter, X500Name requestedSubject, SubjectPublicKeyInfo grantedPublicKey, long fpPublicKey, PrivateKeyInfo privateKey, byte[] grantedPublicKeyData, ConcurrentContentSigner signer, String warning) {
            this.extensions = extensions;
            this.certprofile = certprofile;
            this.grantedNotBefore = grantedNotBefore;
            this.grantedNotAfter = grantedNotAfter;
            this.requestedSubject = requestedSubject;
            this.grantedPublicKey = grantedPublicKey;
            this.grantedPublicKeyData = grantedPublicKeyData;
            this.privateKey = privateKey;
            this.fpPublicKey = fpPublicKey;
            this.signer = signer;
            this.warning = warning;
        }

        public void setGrantedSubject(X500Name subject) {
            this.grantedSubject = subject;
            this.grantedSubjectText = X509Util.getRfc4519Name((X500Name)subject);
            this.fpSubject = X509Util.fpCanonicalizedName((X500Name)subject);
        }
    }
}

