/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.cmp;

import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.InsuffientPermissionException;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.util.Args;

public class CmpRequestorInfo
implements RequestorInfo {
    private final MgmtEntry.CaHasRequestor caHasRequestor;
    private final CertWithDbId cert;
    private final char[] password;
    private final byte[] keyId;

    public CmpRequestorInfo(MgmtEntry.CaHasRequestor caHasRequestor, CertWithDbId cert) {
        this.caHasRequestor = (MgmtEntry.CaHasRequestor)Args.notNull((Object)caHasRequestor, (String)"caHasRequestor");
        this.cert = (CertWithDbId)Args.notNull((Object)cert, (String)"cert");
        this.password = null;
        this.keyId = null;
    }

    public CmpRequestorInfo(MgmtEntry.CaHasRequestor caHasRequestor, char[] password, byte[] keyId) {
        this.caHasRequestor = (MgmtEntry.CaHasRequestor)Args.notNull((Object)caHasRequestor, (String)"caHasRequestor");
        this.cert = null;
        this.password = (char[])Args.notNull((Object)password, (String)"password");
        this.keyId = (byte[])Args.notNull((Object)keyId, (String)"keyId");
    }

    public MgmtEntry.CaHasRequestor getCaHasRequestor() {
        return this.caHasRequestor;
    }

    public CertWithDbId getCert() {
        return this.cert;
    }

    public char[] getPassword() {
        return this.password;
    }

    public byte[] getKeyId() {
        return this.keyId;
    }

    public NameId getIdent() {
        return this.caHasRequestor.getRequestorIdent();
    }

    public boolean isRa() {
        return this.caHasRequestor.isRa();
    }

    public boolean isCertprofilePermitted(String certprofile) {
        return this.caHasRequestor.isCertprofilePermitted(certprofile);
    }

    public boolean isPermitted(int permission) {
        return this.caHasRequestor.isPermitted(permission);
    }

    public void assertCertprofilePermitted(String certprofile) throws InsuffientPermissionException {
        if (!this.isCertprofilePermitted(certprofile)) {
            throw new InsuffientPermissionException("Certprofile " + certprofile + " is not permitted");
        }
    }

    public void assertPermitted(int permission) throws InsuffientPermissionException {
        if (!this.isPermitted(permission)) {
            throw new InsuffientPermissionException("Permission " + PermissionConstants.getTextForCode((int)permission) + " is not permitted");
        }
    }
}

