/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.OperationException;
import org.xipki.security.CtLog;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Curl;
import org.xipki.util.DefaultCurl;
import org.xipki.util.StringUtil;
import org.xipki.util.http.SslContextConf;

public class CtLogClient {
    private static Logger LOG = LoggerFactory.getLogger(CtLogClient.class);
    private final Curl curl;
    private final List<String> addPreChainUrls;

    public CtLogClient(List<String> serverUrls, SslContextConf sslContextConf) {
        Args.notEmpty(serverUrls, (String)"serverUrls");
        DefaultCurl dfltCurl = new DefaultCurl();
        dfltCurl.setSslContextConf(sslContextConf);
        this.curl = dfltCurl;
        this.addPreChainUrls = new ArrayList<String>(serverUrls.size());
        for (String m : serverUrls) {
            String addPreChainUrl = m.endsWith("/") ? m + "ct/v1/add-pre-chain" : m + "/ct/v1/add-pre-chain";
            this.addPreChainUrls.add(addPreChainUrl);
        }
    }

    public CtLog.SignedCertificateTimestampList getCtLogScts(byte[] precert, X509Cert caCert, List<X509Cert> certchain) throws OperationException {
        AddPreChainRequest request = new AddPreChainRequest();
        LinkedList<byte[]> chain = new LinkedList<byte[]>();
        request.setChain(chain);
        chain.add(precert);
        chain.add(caCert.getEncodedCert());
        if (certchain != null) {
            for (X509Cert m : certchain) {
                chain.add(m.getEncodedCert());
            }
        }
        byte[] content = JSON.toJSONBytes((Object)request, (SerializerFeature[])new SerializerFeature[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CTLog Request: {}", (Object)StringUtil.toUtf8String((byte[])content));
        }
        ArrayList<CtLog.SignedCertificateTimestamp> scts = new ArrayList<CtLog.SignedCertificateTimestamp>(this.addPreChainUrls.size());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        for (String url : this.addPreChainUrls) {
            Curl.CurlResult res;
            try {
                res = this.curl.curlPost(url, false, headers, null, content);
            }
            catch (Exception ex) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "error while calling " + url + ": " + ex.getMessage());
            }
            byte[] respContent = res.getContent();
            if (respContent == null) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "server does not return any content while responding " + url);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("CTLog Response: {}", (Object)StringUtil.toUtf8String((byte[])respContent));
            }
            AddPreChainResponse resp = (AddPreChainResponse)JSON.parseObject((byte[])respContent, AddPreChainResponse.class, (Feature[])new Feature[0]);
            CtLog.DigitallySigned ds = CtLog.DigitallySigned.getInstance((byte[])resp.getSignature(), (AtomicInteger)new AtomicInteger(0));
            CtLog.SignedCertificateTimestamp sct = new CtLog.SignedCertificateTimestamp(resp.getSct_version(), resp.getId(), resp.getTimestamp(), resp.getExtensions(), ds);
            scts.add(sct);
        }
        return new CtLog.SignedCertificateTimestampList(new CtLog.SerializedSCT(scts));
    }

    public static class AddPreChainResponse {
        private byte sct_version;
        private byte[] id;
        private long timestamp;
        private byte[] extensions;
        private byte[] signature;

        public byte getSct_version() {
            return this.sct_version;
        }

        public void setSct_version(byte sct_version) {
            this.sct_version = sct_version;
        }

        public byte[] getId() {
            return this.id;
        }

        public void setId(byte[] id) {
            this.id = id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public byte[] getExtensions() {
            return this.extensions;
        }

        public void setExtensions(byte[] extensions) {
            this.extensions = extensions;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public void setSignature(byte[] signature) {
            this.signature = signature;
        }
    }

    public static class AddPreChainRequest {
        private List<byte[]> chain;

        public List<byte[]> getChain() {
            return this.chain;
        }

        public void setChain(List<byte[]> chain) {
            this.chain = chain;
        }
    }
}

