/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.cmp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertOrEncCert;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertStatus;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.GenRepContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContentBuilder;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.Controls;
import org.bouncycastle.asn1.crmf.DhSigStatic;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.InsuffientPermissionException;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaManagerImpl;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.DhpocControl;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.cmp.BaseCmpResponder;
import org.xipki.ca.server.cmp.CrmfKeyWrapper;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.security.cmp.CmpUtf8Pairs;
import org.xipki.security.cmp.CmpUtil;
import org.xipki.security.cmp.PkiStatusInfo;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

public class CmpResponder
extends BaseCmpResponder {
    private static final Set<String> KNOWN_GENMSG_IDS;
    private static final Logger LOG;
    private static final AlgorithmIdentifier prf_hmacWithSHA256;
    private static final ConcurrentBag<ConcurrentBagEntry<Cipher>> aesGcm_ciphers;
    private static final ConcurrentBag<ConcurrentBagEntry<SecretKeyFactory>> pbkdf2_kdfs;
    private static boolean aesGcm_ciphers_initialized;
    private static boolean pbkdf2_kdfs_initialized;
    private static final Set<String> kupCertExtnIds;
    private final PendingCertificatePool pendingCertPool;
    private final KeyGenerator aesKeyGen = KeyGenerator.getInstance("AES");
    private final String caName;
    private final CaManagerImpl caManager;

    public CmpResponder(CaManagerImpl caManager, String caName) throws NoSuchAlgorithmException {
        super(caManager.getSecurityFactory());
        this.caManager = caManager;
        this.pendingCertPool = new PendingCertificatePool();
        this.caName = caName;
        PendingPoolCleaner pendingPoolCleaner = new PendingPoolCleaner();
        caManager.getScheduledThreadPoolExecutor().scheduleAtFixedRate(pendingPoolCleaner, 10L, 10L, TimeUnit.MINUTES);
    }

    public X509Ca getCa() {
        try {
            return this.caManager.getX509Ca(this.caName);
        }
        catch (CaMgmtException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isOnService() {
        if (!super.isOnService()) {
            return false;
        }
        CaInfo caInfo = this.getCa().getCaInfo();
        return caInfo.getStatus() == CaStatus.ACTIVE && caInfo.supportsCmp();
    }

    public HealthCheckResult healthCheck() {
        HealthCheckResult result = this.getCa().healthCheck();
        boolean healthy = result.isHealthy();
        boolean responderHealthy = this.caManager.getSignerWrapper(this.getResponderName()).getSigner().isHealthy();
        HealthCheckResult responderHealth = new HealthCheckResult();
        responderHealth.setName("Responder");
        responderHealth.setHealthy(responderHealthy);
        result.addChildCheck(responderHealth);
        result.setHealthy(healthy &= responderHealthy);
        return result;
    }

    public String getCaName() {
        return this.caName;
    }

    public String getResponderName() {
        return this.getCa().getCaInfo().getCmpResponderName();
    }

    @Override
    protected PKIMessage processPkiMessage0(PKIMessage request, RequestorInfo requestor, ASN1OctetString tid, GeneralPKIMessage message, String msgId, Map<String, String> parameters, AuditEvent event) {
        PKIBody respBody;
        if (!(requestor instanceof RequestorInfo.CmpRequestorInfo)) {
            throw new IllegalArgumentException("unknown requestor type " + requestor.getClass().getName());
        }
        RequestorInfo.CmpRequestorInfo cmpRequestor = (RequestorInfo.CmpRequestorInfo)requestor;
        event.addEventData("requestor", (Object)cmpRequestor.getIdent().getName());
        PKIHeader reqHeader = message.getHeader();
        PKIHeaderBuilder respHeader = new PKIHeaderBuilder(reqHeader.getPvno().getValue().intValue(), this.getSender(), reqHeader.getSender());
        respHeader.setTransactionID(tid);
        ASN1OctetString senderNonce = reqHeader.getSenderNonce();
        if (senderNonce != null) {
            respHeader.setRecipNonce(senderNonce);
        }
        PKIBody reqBody = message.getBody();
        int type = reqBody.getType();
        CmpControl cmpControl = this.getCmpControl();
        try {
            switch (type) {
                case 0: 
                case 2: 
                case 4: 
                case 7: 
                case 13: {
                    String eventType = null;
                    if (2 == type) {
                        eventType = "cr";
                    } else if (0 == type) {
                        eventType = "ir";
                    } else if (7 == type) {
                        eventType = "kur";
                    } else if (4 == type) {
                        eventType = "p10cr";
                    } else if (13 == type) {
                        eventType = "ccr";
                    }
                    if (eventType != null) {
                        event.addEventType(eventType);
                    }
                    String dfltCertprofileName = null;
                    Boolean dfltCaGenerateKeypair = null;
                    if (parameters != null) {
                        dfltCertprofileName = parameters.get("certprofile");
                        String str = parameters.get("ca-generate-keypair");
                        if (str != null) {
                            dfltCaGenerateKeypair = "true".equalsIgnoreCase(str);
                        }
                    }
                    respBody = this.cmpEnrollCert(dfltCertprofileName, dfltCaGenerateKeypair, request, respHeader, cmpControl, reqHeader, reqBody, cmpRequestor, tid, msgId, event);
                    break;
                }
                case 24: {
                    event.addEventType("cert_conf");
                    CertConfirmContent certConf = (CertConfirmContent)reqBody.getContent();
                    respBody = this.confirmCertificates(tid, certConf, msgId);
                    break;
                }
                case 11: {
                    respBody = this.cmpUnRevokeRemoveCertificates(request, respHeader, cmpControl, reqHeader, reqBody, cmpRequestor, msgId, event);
                    break;
                }
                case 19: {
                    event.addEventType("pkiconf");
                    respBody = new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
                    break;
                }
                case 21: {
                    respBody = this.cmpGeneralMsg(respHeader, cmpControl, reqHeader, reqBody, cmpRequestor, tid, msgId, event);
                    break;
                }
                case 23: {
                    event.addEventType("error");
                    this.revokePendingCertificates(tid, msgId);
                    respBody = new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
                    break;
                }
                default: {
                    event.addEventType("PKIBody." + type);
                    respBody = CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "unsupported type " + type);
                    break;
                }
            }
        }
        catch (InsuffientPermissionException ex) {
            ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(ex.getMessage()), new PKIFailureInfo(65536)));
            respBody = new PKIBody(23, (ASN1Encodable)emc);
        }
        if (respBody.getType() == 23) {
            ErrorMsgContent errorMsgContent = (ErrorMsgContent)respBody.getContent();
            PkiStatusInfo pkiStatus = new PkiStatusInfo(errorMsgContent.getPKIStatusInfo());
            event.setStatus(AuditStatus.FAILED);
            String statusString = pkiStatus.statusMessage();
            if (statusString != null) {
                event.addEventData("message", (Object)statusString);
            }
        } else if (event.getStatus() == null) {
            event.setStatus(AuditStatus.SUCCESSFUL);
        }
        return new PKIMessage(respHeader.build(), respBody);
    }

    private PKIBody processIr(String dfltCertprofileName, Boolean dfltCaGenKeypair, PKIMessage request, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, PKIHeader reqHeader, CertReqMessages cr, CmpControl cmpControl, String msgId, AuditEvent event) throws InsuffientPermissionException {
        CertRepMessage repMessage = this.processCertReqMessages(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, reqHeader, cr, true, cmpControl, msgId, event);
        return new PKIBody(1, (ASN1Encodable)repMessage);
    }

    private PKIBody processCr(String dfltCertprofileName, Boolean dfltCaGenKeypair, PKIMessage request, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, PKIHeader reqHeader, CertReqMessages cr, CmpControl cmpControl, String msgId, AuditEvent event) throws InsuffientPermissionException {
        CertRepMessage repMessage = this.processCertReqMessages(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, reqHeader, cr, true, cmpControl, msgId, event);
        return new PKIBody(3, (ASN1Encodable)repMessage);
    }

    private PKIBody processKur(String dfltCertprofileName, Boolean dfltCaGenKeypair, PKIMessage request, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, PKIHeader reqHeader, CertReqMessages kur, CmpControl cmpControl, String msgId, AuditEvent event) throws InsuffientPermissionException {
        CertRepMessage repMessage = this.processCertReqMessages(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, reqHeader, kur, true, cmpControl, msgId, event);
        return new PKIBody(8, (ASN1Encodable)repMessage);
    }

    private PKIBody processCcp(String dfltCertprofileName, PKIMessage request, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, PKIHeader reqHeader, CertReqMessages cr, CmpControl cmpControl, String msgId, AuditEvent event) throws InsuffientPermissionException {
        CertRepMessage repMessage = this.processCertReqMessages(dfltCertprofileName, Boolean.FALSE, request, requestor, tid, reqHeader, cr, false, cmpControl, msgId, event);
        return new PKIBody(14, (ASN1Encodable)repMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CertRepMessage processCertReqMessages(String dfltCertprofileName, Boolean dfltCaGenKeypair, PKIMessage request, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, PKIHeader reqHeader, CertReqMessages cr, boolean allowKeyGen, CmpControl cmpControl, String msgId, AuditEvent event) throws InsuffientPermissionException {
        RequestorInfo.CmpRequestorInfo tmpRequestor = requestor;
        CertReqMsg[] certReqMsgs = cr.toCertReqMsgArray();
        int n = certReqMsgs.length;
        ArrayList<CertTemplateData> certTemplateDatas = new ArrayList<CertTemplateData>(n);
        ArrayList<CertResponse> certResponses = new ArrayList<CertResponse>(1);
        boolean kup = request.getBody().getType() == 7;
        int i = 0;
        while (true) {
            block31: {
                boolean caGenerateKeypair;
                String certprofileName;
                Extensions extensions;
                X500Name subject;
                SubjectPublicKeyInfo publicKey;
                CertTemplate certTemp;
                ASN1Integer certReqId;
                block45: {
                    block46: {
                        block47: {
                            block43: {
                                CertificateRequestMessage req;
                                block44: {
                                    block42: {
                                        block36: {
                                            ASN1ObjectIdentifier[] oldOids;
                                            CertWithRevocationInfo oldCert;
                                            block41: {
                                                block40: {
                                                    BigInteger serialNumber;
                                                    X500Name issuer;
                                                    block39: {
                                                        CertId oldCertId;
                                                        block38: {
                                                            AttributeTypeAndValue oldCertIdAtv;
                                                            block37: {
                                                                block34: {
                                                                    int seqSize;
                                                                    ASN1Sequence seq;
                                                                    block35: {
                                                                        block32: {
                                                                            block33: {
                                                                                String tmpStr;
                                                                                if (i >= n || cmpControl.isGroupEnroll() && certTemplateDatas.size() != i) break block32;
                                                                                CertReqMsg reqMsg = certReqMsgs[i];
                                                                                certReqId = reqMsg.getCertReq().getCertReqId();
                                                                                req = new CertificateRequestMessage(reqMsg);
                                                                                certTemp = req.getCertTemplate();
                                                                                CmpUtf8Pairs keyvalues = CmpUtil.extract((AttributeTypeAndValue[])reqMsg.getRegInfo());
                                                                                publicKey = certTemp.getPublicKey();
                                                                                subject = certTemp.getSubject();
                                                                                extensions = certTemp.getExtensions();
                                                                                String string = certprofileName = keyvalues == null ? null : keyvalues.value("certprofile");
                                                                                if (certprofileName == null) {
                                                                                    certprofileName = dfltCertprofileName;
                                                                                }
                                                                                if (certprofileName != null) {
                                                                                    certprofileName = certprofileName.toLowerCase();
                                                                                }
                                                                                String string2 = tmpStr = keyvalues == null ? null : keyvalues.value("ca-generate-keypair");
                                                                                if (dfltCaGenKeypair == null) {
                                                                                    caGenerateKeypair = tmpStr == null ? false : "true".equalsIgnoreCase(tmpStr);
                                                                                } else {
                                                                                    boolean bl = caGenerateKeypair = tmpStr == null ? dfltCaGenKeypair.booleanValue() : "true".equalsIgnoreCase(tmpStr);
                                                                                }
                                                                                if (!kup) break block33;
                                                                                Controls controls = reqMsg.getCertReq().getControls();
                                                                                oldCertIdAtv = null;
                                                                                if (controls == null) break block34;
                                                                                try {
                                                                                    seq = ASN1Sequence.getInstance((Object)controls.getEncoded());
                                                                                }
                                                                                catch (IOException ex) {
                                                                                    certResponses.add(this.buildErrorCertResponse(certReqId, 0x40000000, "could not parse the controls"));
                                                                                    break block31;
                                                                                }
                                                                                seqSize = seq.size();
                                                                                break block35;
                                                                            }
                                                                            if (certprofileName != null) break block36;
                                                                            LOG.warn("no certprofile is specified");
                                                                            certResponses.add(this.buildErrorCertResponse(certReqId, 0x100000, "no certificate profile"));
                                                                            break block31;
                                                                        }
                                                                        if (certResponses.size() == n) {
                                                                            CertResponse[] certResps = new CertResponse[n];
                                                                            int i2 = 0;
                                                                            while (true) {
                                                                                if (i2 >= n) {
                                                                                    event.setStatus(AuditStatus.FAILED);
                                                                                    return new CertRepMessage(null, certResps);
                                                                                }
                                                                                certResps[i2] = (CertResponse)certResponses.get(i2);
                                                                                ++i2;
                                                                            }
                                                                        }
                                                                        if (cmpControl.isGroupEnroll() && certTemplateDatas.size() != n) break;
                                                                        List<CertResponse> generateCertResponses = this.generateCertificates(certTemplateDatas, tmpRequestor, tid, kup, request, cmpControl, msgId, event);
                                                                        CertResponse[] certResps = new CertResponse[n];
                                                                        int index = 0;
                                                                        for (CertResponse errorResp : certResponses) {
                                                                            certResps[index++] = errorResp;
                                                                        }
                                                                        for (CertResponse certResp : generateCertResponses) {
                                                                            certResps[index++] = certResp;
                                                                        }
                                                                        CMPCertificate[] caPubs = null;
                                                                        if (cmpControl.isSendCaCert()) {
                                                                            boolean anyCertEnrolled = false;
                                                                            for (CertResponse certResp : generateCertResponses) {
                                                                                if (certResp.getCertifiedKeyPair() == null) continue;
                                                                                anyCertEnrolled = true;
                                                                                break;
                                                                            }
                                                                            if (anyCertEnrolled && cmpControl.isSendCaCert()) {
                                                                                caPubs = new CMPCertificate[]{this.getCa().getCaInfo().getCertInCmpFormat()};
                                                                            }
                                                                        }
                                                                        return new CertRepMessage(caPubs, certResps);
                                                                    }
                                                                    for (int j = 0; j < seqSize; ++j) {
                                                                        AttributeTypeAndValue atv = AttributeTypeAndValue.getInstance((Object)seq.getObjectAt(j));
                                                                        if (!atv.getType().equals((Object)CMPObjectIdentifiers.regCtrl_oldCertID)) continue;
                                                                        oldCertIdAtv = atv;
                                                                        break;
                                                                    }
                                                                }
                                                                if (oldCertIdAtv != null) break block37;
                                                                certResponses.add(this.buildErrorCertResponse(certReqId, 0x100000, "no getCtrl oldCertID is specified"));
                                                                break block31;
                                                            }
                                                            oldCertId = CertId.getInstance((Object)oldCertIdAtv.getValue());
                                                            if (4 == oldCertId.getIssuer().getTagNo()) break block38;
                                                            certResponses.add(this.buildErrorCertResponse(certReqId, 8, "invalid regCtrl oldCertID"));
                                                            break block31;
                                                        }
                                                        issuer = X500Name.getInstance((Object)oldCertId.getIssuer().getName());
                                                        serialNumber = oldCertId.getSerialNumber().getValue();
                                                        try {
                                                            oldCert = this.caManager.getCert(issuer, serialNumber);
                                                        }
                                                        catch (CaMgmtException ex) {
                                                            certResponses.add(this.buildErrorCertResponse(certReqId, 0x40000000, "error while finding certificate with the issuer " + issuer + "and serial number " + serialNumber));
                                                            break block31;
                                                        }
                                                        if (oldCert != null) break block39;
                                                        certResponses.add(this.buildErrorCertResponse(certReqId, 8, "found no certificate with the issuer " + issuer + "and serial number " + serialNumber));
                                                        break block31;
                                                    }
                                                    if (!oldCert.isRevoked()) break block40;
                                                    certResponses.add(this.buildErrorCertResponse(certReqId, 8192, "could not update a revoked certificate with the issuer " + issuer + "and serial number " + serialNumber));
                                                    break block31;
                                                }
                                                if (certprofileName == null) {
                                                    certprofileName = oldCert.getCertprofile();
                                                }
                                                if (certprofileName != null) break block41;
                                                LOG.warn("no certprofile is specified");
                                                certResponses.add(this.buildErrorCertResponse(certReqId, 0x100000, "no certificate profile"));
                                                break block31;
                                            }
                                            if (subject == null) {
                                                subject = oldCert.getCert().getSubjectAsX500Name();
                                            }
                                            if (publicKey == null && !caGenerateKeypair) {
                                                publicKey = oldCert.getCert().getCertHolder().getSubjectPublicKeyInfo();
                                            }
                                            HashMap<String, Extension> extns = new HashMap<String, Extension>();
                                            if (extensions != null) {
                                                ASN1ObjectIdentifier[] oids;
                                                for (ASN1ObjectIdentifier oid : oids = extensions.getExtensionOIDs()) {
                                                    extns.put(oid.getId(), extensions.getExtension(oid));
                                                }
                                            }
                                            Extensions oldExtensions = oldCert.getCert().getCertHolder().getExtensions();
                                            for (ASN1ObjectIdentifier oid : oldOids = oldExtensions.getExtensionOIDs()) {
                                                String id = oid.getId();
                                                if (extns.containsKey(id) || kupCertExtnIds.contains(id)) continue;
                                                extns.put(id, oldExtensions.getExtension(oid));
                                            }
                                            extensions = new Extensions(extns.values().toArray(new Extension[0]));
                                        }
                                        if (tmpRequestor.isCertprofilePermitted(certprofileName)) break block42;
                                        String msg = "certprofile " + certprofileName + " is not allowed";
                                        certResponses.add(this.buildErrorCertResponse(certReqId, 65536, msg));
                                        break block31;
                                    }
                                    if (publicKey == null) break block43;
                                    if (req.hasProofOfPossession()) break block44;
                                    certResponses.add(this.buildErrorCertResponse(certReqId, 16384, "no POP"));
                                    break block31;
                                }
                                if (this.verifyPopo(req, publicKey, tmpRequestor.isRa())) break block45;
                                LOG.warn("could not validate POP for request {}", (Object)certReqId.getValue());
                                certResponses.add(this.buildErrorCertResponse(certReqId, 16384, "invalid POP"));
                                break block31;
                            }
                            if (!caGenerateKeypair) break block46;
                            if (!allowKeyGen) break block47;
                            this.checkPermission(requestor, 256);
                            break block45;
                        }
                        LOG.warn("no public key is specified and key generation is not allowed {}", (Object)certReqId.getValue());
                        certResponses.add(this.buildErrorCertResponse(certReqId, 0x100000, "no public key"));
                        break block31;
                    }
                    LOG.warn("no public key is specified {}", (Object)certReqId.getValue());
                    certResponses.add(this.buildErrorCertResponse(certReqId, 0x100000, "no public key"));
                    break block31;
                }
                OptionalValidity validity = certTemp.getValidity();
                Date notBefore = null;
                Date notAfter = null;
                if (validity != null) {
                    Time time = validity.getNotBefore();
                    if (time != null) {
                        notBefore = time.getDate();
                    }
                    if ((time = validity.getNotAfter()) != null) {
                        notAfter = time.getDate();
                    }
                }
                CertTemplateData certTempData = new CertTemplateData(subject, publicKey, notBefore, notAfter, extensions, certprofileName, certReqId, caGenerateKeypair);
                certTemplateDatas.add(certTempData);
            }
            ++i;
        }
        event.setStatus(AuditStatus.FAILED);
        int lastFailureIndex = certTemplateDatas.size();
        BigInteger failCertReqId = certReqMsgs[lastFailureIndex].getCertReq().getCertReqId().getValue();
        CertResponse failCertResp = (CertResponse)certResponses.get(lastFailureIndex);
        Iterator<Object> failStatus = PKIStatus.getInstance((Object)new ASN1Integer(failCertResp.getStatus().getStatus()));
        PKIFailureInfo failureInfo = new PKIFailureInfo(failCertResp.getStatus().getFailInfo());
        CertResponse[] certResps = new CertResponse[n];
        int i3 = 0;
        while (i3 < n) {
            if (i3 == lastFailureIndex) {
                certResps[i3] = failCertResp;
            } else {
                ASN1Integer certReqId = certResps[i3].getCertReqId();
                String msg = "error in certReq " + failCertReqId;
                PKIStatusInfo tmpStatus = this.generateRejectionStatus((PKIStatus)failStatus, failureInfo.intValue(), msg);
                certResps[i3] = new CertResponse(certReqId, tmpStatus);
            }
            ++i3;
        }
        return new CertRepMessage(null, certResps);
    }

    private PKIBody processP10cr(String dfltCertprofileName, PKIMessage request, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, PKIHeader reqHeader, CertificationRequest p10cr, CmpControl cmpControl, String msgId, AuditEvent event) {
        int status;
        CertResponse certResp = null;
        ASN1Integer certReqId = new ASN1Integer(-1L);
        boolean certGenerated = false;
        X509Ca ca = this.getCa();
        if (!ca.verifyCsr(p10cr)) {
            LOG.warn("could not validate POP for the pkcs#10 requst");
            certResp = this.buildErrorCertResponse(certReqId, 16384, "invalid POP");
        } else {
            Extensions extensions;
            CertificationRequestInfo certTemp = p10cr.getCertificationRequestInfo();
            try {
                extensions = CaUtil.getExtensions(certTemp);
            }
            catch (IllegalArgumentException ex) {
                extensions = null;
                LOG.warn("could not parse extensions of the pkcs#10 requst");
                certResp = this.buildErrorCertResponse(certReqId, 0x100000, "invalid extensions");
            }
            if (certResp == null) {
                X500Name subject = certTemp.getSubject();
                SubjectPublicKeyInfo publicKeyInfo = certTemp.getSubjectPublicKeyInfo();
                CmpUtf8Pairs keyvalues = CmpUtil.extract((InfoTypeAndValue[])reqHeader.getGeneralInfo());
                Date notBefore = null;
                Date notAfter = null;
                String certprofileName = null;
                if (keyvalues != null) {
                    certprofileName = keyvalues.value("certprofile");
                    String str = keyvalues.value("notbefore");
                    if (str != null) {
                        notBefore = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    }
                    if ((str = keyvalues.value("notafter")) != null) {
                        notAfter = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    }
                }
                if (certprofileName == null) {
                    certprofileName = dfltCertprofileName;
                }
                if (certprofileName == null) {
                    LOG.warn("no certprofile is specified");
                    certResp = this.buildErrorCertResponse(certReqId, 0x100000, "badCertTemplate");
                } else if (!requestor.isCertprofilePermitted(certprofileName = certprofileName.toLowerCase())) {
                    String msg = "certprofile " + certprofileName + " is not allowed";
                    certResp = this.buildErrorCertResponse(certReqId, 65536, msg);
                } else {
                    CertTemplateData certTemplateData = new CertTemplateData(subject, publicKeyInfo, notBefore, notAfter, extensions, certprofileName, certReqId, false);
                    certResp = this.generateCertificates(Arrays.asList(certTemplateData), requestor, tid, false, request, cmpControl, msgId, event).get(0);
                    certGenerated = true;
                }
            }
        }
        CMPCertificate[] caPubs = null;
        if (certGenerated && cmpControl.isSendCaCert()) {
            caPubs = new CMPCertificate[]{ca.getCaInfo().getCertInCmpFormat()};
        }
        if ((event.getStatus() == null || event.getStatus() != AuditStatus.FAILED) && (status = certResp.getStatus().getStatus().intValue()) != 0 && status != 1 && status != 3) {
            event.setStatus(AuditStatus.FAILED);
            PKIFreeText statusStr = certResp.getStatus().getStatusString();
            if (statusStr != null) {
                event.addEventData("message", (Object)statusStr.getStringAt(0).getString());
            }
        }
        CertRepMessage repMessage = new CertRepMessage(caPubs, new CertResponse[]{certResp});
        return new PKIBody(3, (ASN1Encodable)repMessage);
    }

    private List<CertResponse> generateCertificates(List<CertTemplateData> certTemplates, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, boolean kup, PKIMessage request, CmpControl cmpControl, String msgId, AuditEvent event) {
        X509Ca ca = this.getCa();
        int n = certTemplates.size();
        ArrayList<CertResponse> ret = new ArrayList<CertResponse>(n);
        if (cmpControl.isGroupEnroll()) {
            List<CertificateInfo> certInfos = null;
            try {
                certInfos = kup ? ca.regenerateCerts(certTemplates, (RequestorInfo)requestor, RequestType.CMP, tid.getOctets(), msgId) : ca.generateCerts(certTemplates, (RequestorInfo)requestor, RequestType.CMP, tid.getOctets(), msgId);
                Long reqDbId = null;
                if (ca.getCaInfo().isSaveRequest()) {
                    try {
                        byte[] encodedRequest = request.getEncoded();
                        reqDbId = ca.addRequest(encodedRequest);
                    }
                    catch (Exception ex) {
                        LOG.warn("could not save request");
                    }
                }
                for (int i = 0; i < n; ++i) {
                    CertificateInfo certInfo = certInfos.get(i);
                    ret.add(this.postProcessCertInfo(certTemplates.get(i).getCertReqId(), requestor, certInfo, tid, cmpControl));
                    if (reqDbId == null) continue;
                    ca.addRequestCert(reqDbId, certInfo.getCert().getCertId());
                }
            }
            catch (OperationException ex) {
                if (certInfos != null) {
                    for (CertificateInfo certInfo : certInfos) {
                        BigInteger sn = certInfo.getCert().getCertHolder().getSerialNumber();
                        try {
                            ca.revokeCert(sn, CrlReason.CESSATION_OF_OPERATION, null, msgId);
                        }
                        catch (OperationException ex2) {
                            LogUtil.error((Logger)LOG, (Throwable)ex2, (String)("CA " + this.getCaName() + " could not revoke certificate " + sn));
                        }
                    }
                }
                event.setStatus(AuditStatus.FAILED);
                ret.clear();
                for (int i = 0; i < n; ++i) {
                    ret.add(this.postProcessException(certTemplates.get(i).getCertReqId(), ex));
                }
            }
        } else {
            Long reqDbId = null;
            boolean savingRequestFailed = false;
            for (int i = 0; i < n; ++i) {
                CertTemplateData certTemplate = certTemplates.get(i);
                ASN1Integer certReqId = certTemplate.getCertReqId();
                try {
                    CertificateInfo certInfo = kup ? ca.regenerateCert(certTemplate, (RequestorInfo)requestor, RequestType.CMP, tid.getOctets(), msgId) : ca.generateCert(certTemplate, (RequestorInfo)requestor, RequestType.CMP, tid.getOctets(), msgId);
                    if (ca.getCaInfo().isSaveRequest()) {
                        if (reqDbId == null && !savingRequestFailed) {
                            try {
                                byte[] encodedRequest = request.getEncoded();
                                reqDbId = ca.addRequest(encodedRequest);
                            }
                            catch (Exception ex) {
                                savingRequestFailed = true;
                                LOG.warn("could not save request");
                            }
                        }
                        if (reqDbId != null) {
                            ca.addRequestCert(reqDbId, certInfo.getCert().getCertId());
                        }
                    }
                    CertResponse certResponse = this.postProcessCertInfo(certReqId, requestor, certInfo, tid, cmpControl);
                    ret.add(certResponse);
                    continue;
                }
                catch (OperationException ex) {
                    event.setStatus(AuditStatus.FAILED);
                    ret.add(this.postProcessException(certReqId, ex));
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertResponse postProcessCertInfo(ASN1Integer certReqId, RequestorInfo.CmpRequestorInfo requestor, CertificateInfo certInfo, ASN1OctetString tid, CmpControl cmpControl) {
        EncryptedValue encKey;
        CertOrEncCert cec;
        PKIStatusInfo statusInfo;
        block36: {
            String warningMsg;
            if (cmpControl.isConfirmCert()) {
                this.pendingCertPool.addCertificate(tid.getOctets(), certReqId.getPositiveValue(), certInfo, System.currentTimeMillis() + cmpControl.getConfirmWaitTimeMs());
            }
            statusInfo = StringUtil.isBlank((String)(warningMsg = certInfo.getWarningMessage())) ? (certInfo.isAlreadyIssued() ? new PKIStatusInfo(PKIStatus.grantedWithMods, new PKIFreeText("ALREADY_ISSUED")) : new PKIStatusInfo(PKIStatus.granted)) : new PKIStatusInfo(PKIStatus.grantedWithMods, new PKIFreeText(warningMsg));
            cec = new CertOrEncCert(CMPCertificate.getInstance((Object)certInfo.getCert().getEncodedCert()));
            if (certInfo.getPrivateKey() == null) {
                return new CertResponse(certReqId, statusInfo, new CertifiedKeyPair(cec), null);
            }
            int aesGcmTagByteLen = 16;
            int aesGcmNonceLen = 12;
            PrivateKeyInfo privKey = certInfo.getPrivateKey();
            AlgorithmIdentifier intendedAlg = privKey.getPrivateKeyAlgorithm();
            try {
                byte[] encValue;
                SecretKey key;
                if (requestor.getCert() != null) {
                    byte[] encValue2;
                    PublicKey reqPub = requestor.getCert().getCert().getPublicKey();
                    CrmfKeyWrapper wrapper = null;
                    if (reqPub instanceof RSAPublicKey) {
                        wrapper = new CrmfKeyWrapper.RSAOAEPAsymmetricKeyWrapper(reqPub);
                    } else if (reqPub instanceof ECPublicKey) {
                        wrapper = new CrmfKeyWrapper.ECIESAsymmetricKeyWrapper(reqPub);
                    } else {
                        String msg = "Requestors's public key can not be used for encryption";
                        LOG.error(msg);
                        return new CertResponse(certReqId, new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(msg)));
                    }
                    byte[] symmKeyBytes = new byte[16];
                    KeyGenerator keyGenerator = this.aesKeyGen;
                    synchronized (keyGenerator) {
                        symmKeyBytes = this.aesKeyGen.generateKey().getEncoded();
                    }
                    byte[] encSymmKey = wrapper.generateWrappedKey(symmKeyBytes);
                    AlgorithmIdentifier keyAlg = wrapper.getAlgorithmIdentifier();
                    ASN1ObjectIdentifier symmAlgOid = NISTObjectIdentifiers.id_aes128_GCM;
                    byte[] nonce = this.randomBytes(12);
                    ConcurrentBagEntry cipher0 = null;
                    if (aesGcm_ciphers_initialized) {
                        try {
                            cipher0 = (ConcurrentBagEntry)aesGcm_ciphers.borrow(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Cipher dataCipher = cipher0 != null ? (Cipher)cipher0.value() : Cipher.getInstance(symmAlgOid.getId());
                    try {
                        try {
                            dataCipher.init(1, (Key)new SecretKeySpec(symmKeyBytes, "AES"), new GCMParameterSpec(128, nonce));
                        }
                        catch (InvalidAlgorithmParameterException | InvalidKeyException ex) {
                            throw new IllegalStateException(ex);
                        }
                        encValue2 = dataCipher.doFinal(privKey.getEncoded());
                    }
                    finally {
                        if (cipher0 != null) {
                            aesGcm_ciphers.requite((ConcurrentBag.IConcurrentBagEntry)cipher0);
                        }
                    }
                    GCMParameters params = new GCMParameters(nonce, 16);
                    AlgorithmIdentifier symmAlg = new AlgorithmIdentifier(symmAlgOid, (ASN1Encodable)params);
                    encKey = new EncryptedValue(intendedAlg, symmAlg, new DERBitString(encSymmKey), keyAlg, null, new DERBitString(encValue2));
                    break block36;
                }
                ASN1ObjectIdentifier encAlgOid = NISTObjectIdentifiers.id_aes128_GCM;
                int keysizeBits = 128;
                int iterationCount = 10240;
                int nonceLen = 12;
                int tagByteLen = 16;
                byte[] nonce = this.randomBytes(12);
                byte[] pbkdfSalt = this.randomBytes(16);
                ConcurrentBagEntry keyFact0 = null;
                if (pbkdf2_kdfs_initialized) {
                    try {
                        keyFact0 = (ConcurrentBagEntry)pbkdf2_kdfs.borrow(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException dataCipher) {
                        // empty catch block
                    }
                }
                SecretKeyFactory keyFact = keyFact0 != null ? (SecretKeyFactory)keyFact0.value() : SecretKeyFactory.getInstance(PKCSObjectIdentifiers.id_PBKDF2.getId());
                try {
                    key = keyFact.generateSecret((KeySpec)new PBKDF2KeySpec(requestor.getPassword(), pbkdfSalt, 10240, 128, prf_hmacWithSHA256));
                    byte[] encoded = key.getEncoded();
                    key = new SecretKeySpec(encoded, "AES");
                }
                finally {
                    if (keyFact0 != null) {
                        pbkdf2_kdfs.requite((ConcurrentBag.IConcurrentBagEntry)keyFact0);
                    }
                }
                GCMParameterSpec gcmParamSpec = new GCMParameterSpec(128, nonce);
                ConcurrentBagEntry cipher0 = null;
                if (aesGcm_ciphers_initialized) {
                    try {
                        cipher0 = (ConcurrentBagEntry)aesGcm_ciphers.borrow(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Cipher dataCipher = cipher0 != null ? (Cipher)cipher0.value() : Cipher.getInstance(encAlgOid.getId());
                try {
                    dataCipher.init(1, (Key)key, gcmParamSpec);
                    encValue = dataCipher.doFinal(privKey.getEncoded());
                }
                finally {
                    if (cipher0 != null) {
                        aesGcm_ciphers.requite((ConcurrentBag.IConcurrentBagEntry)cipher0);
                    }
                }
                AlgorithmIdentifier symmAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(pbkdfSalt, 10240, 16, prf_hmacWithSHA256)), new EncryptionScheme(encAlgOid, (ASN1Encodable)new GCMParameters(nonce, 16))));
                encKey = new EncryptedValue(intendedAlg, symmAlg, null, null, null, new DERBitString(encValue));
            }
            catch (Throwable th) {
                String msg = "error while encrypting the private key";
                LOG.error(msg);
                return new CertResponse(certReqId, new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(msg)));
            }
        }
        return new CertResponse(certReqId, statusInfo, new CertifiedKeyPair(cec, encKey, null), null);
    }

    private PKIBody unRevokeRemoveCertificates(PKIMessage request, RevReqContent rr, int permission, CmpControl cmpControl, String msgId, AuditEvent event) {
        RevDetails[] revContent = rr.toRevDetailsArray();
        RevRepContentBuilder repContentBuilder = new RevRepContentBuilder();
        int n = revContent.length;
        for (int i = 0; i < n; ++i) {
            RevDetails revDetails = revContent[i];
            CertTemplate certDetails = revDetails.getCertDetails();
            X500Name issuer = certDetails.getIssuer();
            ASN1Integer serialNumber = certDetails.getSerialNumber();
            try {
                BigInteger caSerial;
                Extension ext;
                X500Name caSubject = this.getCa().getCaInfo().getCert().getSubjectAsX500Name();
                if (issuer == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer is not present");
                }
                if (!issuer.equals((Object)caSubject)) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer does not target at the CA");
                }
                if (serialNumber == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "serialNumber is not present");
                }
                if (certDetails.getSigningAlg() != null || certDetails.getValidity() != null || certDetails.getSubject() != null || certDetails.getPublicKey() != null || certDetails.getIssuerUID() != null || certDetails.getSubjectUID() != null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "only version, issuer and serialNumber in RevDetails.certDetails are allowed, but more is specified");
                }
                if (certDetails.getExtensions() == null) {
                    if (!cmpControl.isRrAkiRequired()) continue;
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer's AKI not present");
                }
                Extensions exts = certDetails.getExtensions();
                ASN1ObjectIdentifier[] oids = exts.getCriticalExtensionOIDs();
                if (oids != null) {
                    for (ASN1ObjectIdentifier oid : oids) {
                        if (Extension.authorityKeyIdentifier.equals((Object)oid)) continue;
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "unknown critical extension " + oid.getId());
                    }
                }
                if ((ext = exts.getExtension(Extension.authorityKeyIdentifier)) == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer's AKI not present");
                }
                AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)ext.getParsedValue());
                if (aki.getKeyIdentifier() == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer's AKI not present");
                }
                boolean issuerMatched = true;
                byte[] caSki = this.getCa().getCaInfo().getCert().getSubjectKeyIdentifier();
                if (!Arrays.equals(caSki, aki.getKeyIdentifier())) {
                    issuerMatched = false;
                }
                if (issuerMatched && aki.getAuthorityCertSerialNumber() != null && !(caSerial = this.getCa().getCaInfo().getSerialNumber()).equals(aki.getAuthorityCertSerialNumber())) {
                    issuerMatched = false;
                }
                if (issuerMatched && aki.getAuthorityCertIssuer() != null) {
                    GeneralName[] names;
                    for (GeneralName name : names = aki.getAuthorityCertIssuer().getNames()) {
                        if (name.getTagNo() != 4) {
                            issuerMatched = false;
                            break;
                        }
                        if (caSubject.equals((Object)name.getName())) continue;
                        issuerMatched = false;
                        break;
                    }
                }
                if (issuerMatched) continue;
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer does not target at the CA");
            }
            catch (IllegalArgumentException ex) {
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "the request is not invalid");
            }
        }
        byte[] encodedRequest = null;
        if (this.getCa().getCaInfo().isSaveRequest()) {
            try {
                encodedRequest = request.getEncoded();
            }
            catch (IOException ex) {
                LOG.warn("could not encode request");
            }
        }
        Long reqDbId = null;
        for (int i = 0; i < n; ++i) {
            PKIStatusInfo status;
            RevDetails revDetails = revContent[i];
            CertTemplate certDetails = revDetails.getCertDetails();
            ASN1Integer serialNumber = certDetails.getSerialNumber();
            X500Name caSubject = this.getCa().getCaInfo().getCert().getSubjectAsX500Name();
            BigInteger snBigInt = serialNumber.getPositiveValue();
            CertId certId = new CertId(new GeneralName(caSubject), serialNumber);
            try {
                CertWithDbId returnedObj = null;
                Long certDbId = null;
                X509Ca ca = this.getCa();
                if (4 == permission) {
                    returnedObj = ca.unrevokeCert(snBigInt, msgId);
                    if (returnedObj != null) {
                        certDbId = returnedObj.getCertId();
                    }
                } else if (8 == permission) {
                    returnedObj = ca.removeCert(snBigInt, msgId);
                } else {
                    Date invalidityDate = null;
                    CrlReason reason = null;
                    Extensions crlDetails = revDetails.getCrlEntryDetails();
                    if (crlDetails != null) {
                        ASN1ObjectIdentifier extId = Extension.reasonCode;
                        ASN1Encodable extValue = crlDetails.getExtensionParsedValue(extId);
                        if (extValue != null) {
                            int reasonCode = ASN1Enumerated.getInstance((Object)extValue).getValue().intValue();
                            reason = CrlReason.forReasonCode((int)reasonCode);
                        }
                        if ((extValue = crlDetails.getExtensionParsedValue(extId = Extension.invalidityDate)) != null) {
                            try {
                                invalidityDate = ASN1GeneralizedTime.getInstance((Object)extValue).getDate();
                            }
                            catch (ParseException ex) {
                                throw new OperationException(OperationException.ErrorCode.INVALID_EXTENSION, "invalid extension " + extId.getId());
                            }
                        }
                    }
                    if (reason == null) {
                        reason = CrlReason.UNSPECIFIED;
                    }
                    if ((returnedObj = ca.revokeCert(snBigInt, reason, invalidityDate, msgId)) != null) {
                        certDbId = ((CertWithRevocationInfo)returnedObj).getCert().getCertId();
                    }
                }
                if (returnedObj == null) {
                    throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT, "cert not exists");
                }
                if (certDbId != null && ca.getCaInfo().isSaveRequest()) {
                    if (reqDbId == null) {
                        reqDbId = ca.addRequest(encodedRequest);
                    }
                    ca.addRequestCert(reqDbId, certDbId);
                }
                status = new PKIStatusInfo(PKIStatus.granted);
            }
            catch (OperationException ex) {
                String errorMessage;
                OperationException.ErrorCode code = ex.getErrorCode();
                LOG.warn("{}, OperationException: code={}, message={}", new Object[]{PermissionConstants.getTextForCode((int)permission), code.name(), ex.getErrorMessage()});
                switch (code) {
                    case DATABASE_FAILURE: 
                    case SYSTEM_FAILURE: {
                        errorMessage = code.name();
                        break;
                    }
                    default: {
                        errorMessage = code.name() + ": " + ex.getErrorMessage();
                    }
                }
                int failureInfo = this.getPKiFailureInfo(ex);
                status = this.generateRejectionStatus(failureInfo, errorMessage);
                event.setLevel(AuditLevel.ERROR);
                event.setStatus(AuditStatus.FAILED);
                event.addEventData("message", (Object)errorMessage);
            }
            repContentBuilder.add(status, certId);
        }
        return new PKIBody(12, (ASN1Encodable)repContentBuilder.build());
    }

    private CertResponse postProcessException(ASN1Integer certReqId, OperationException ex) {
        String errorMessage;
        OperationException.ErrorCode code = ex.getErrorCode();
        LOG.warn("generate certificate, OperationException: code={}, message={}", (Object)code.name(), (Object)ex.getErrorMessage());
        switch (code) {
            case DATABASE_FAILURE: 
            case SYSTEM_FAILURE: {
                errorMessage = code.name();
                break;
            }
            default: {
                errorMessage = code.name() + ": " + ex.getErrorMessage();
            }
        }
        int failureInfo = this.getPKiFailureInfo(ex);
        return new CertResponse(certReqId, this.generateRejectionStatus(failureInfo, errorMessage));
    }

    private int getPKiFailureInfo(OperationException ex) {
        int failureInfo;
        OperationException.ErrorCode code = ex.getErrorCode();
        switch (code) {
            case ALREADY_ISSUED: {
                failureInfo = 32;
                break;
            }
            case BAD_CERT_TEMPLATE: {
                failureInfo = 0x100000;
                break;
            }
            case BAD_REQUEST: {
                failureInfo = 32;
                break;
            }
            case CERT_REVOKED: {
                failureInfo = 8192;
                break;
            }
            case CERT_UNREVOKED: {
                failureInfo = 65536;
                break;
            }
            case BAD_POP: {
                failureInfo = 16384;
                break;
            }
            case CRL_FAILURE: {
                failureInfo = 0x40000000;
                break;
            }
            case DATABASE_FAILURE: {
                failureInfo = 0x40000000;
                break;
            }
            case NOT_PERMITTED: {
                failureInfo = 65536;
                break;
            }
            case INVALID_EXTENSION: {
                failureInfo = 32;
                break;
            }
            case SYSTEM_FAILURE: {
                failureInfo = 0x40000000;
                break;
            }
            case SYSTEM_UNAVAILABLE: {
                failureInfo = Integer.MIN_VALUE;
                break;
            }
            case UNKNOWN_CERT: {
                failureInfo = 8;
                break;
            }
            case UNKNOWN_CERT_PROFILE: {
                failureInfo = 0x100000;
                break;
            }
            default: {
                failureInfo = 0x40000000;
            }
        }
        return failureInfo;
    }

    private PKIBody confirmCertificates(ASN1OctetString transactionId, CertConfirmContent certConf, String msgId) {
        CertStatus[] certStatuses = certConf.toCertStatusArray();
        boolean successful = true;
        for (CertStatus certStatus : certStatuses) {
            int status;
            ASN1Integer certReqId = certStatus.getCertReqId();
            byte[] certHash = certStatus.getCertHash().getOctets();
            CertificateInfo certInfo = this.pendingCertPool.removeCertificate(transactionId.getOctets(), certReqId.getPositiveValue(), certHash);
            if (certInfo == null) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("no cert under transactionId={}, certReqId={} and certHash=0X{}", new Object[]{transactionId, certReqId.getPositiveValue(), Hex.encode((byte[])certHash)});
                continue;
            }
            PKIStatusInfo statusInfo = certStatus.getStatusInfo();
            boolean accept = true;
            if (statusInfo != null && 0 != (status = statusInfo.getStatus().intValue()) && 1 != status) {
                accept = false;
            }
            if (accept) continue;
            BigInteger serialNumber = certInfo.getCert().getCert().getSerialNumber();
            X509Ca ca = this.getCa();
            try {
                ca.revokeCert(serialNumber, CrlReason.CESSATION_OF_OPERATION, new Date(), msgId);
            }
            catch (OperationException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not revoke certificate ca=" + ca.getCaInfo().getIdent() + " serialNumber=" + LogUtil.formatCsn((BigInteger)serialNumber)));
            }
            successful = false;
        }
        if (this.revokePendingCertificates(transactionId, msgId)) {
            successful = false;
        }
        if (successful) {
            return new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
        }
        return new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, null, new PKIFailureInfo(0x40000000))));
    }

    private boolean revokePendingCertificates(ASN1OctetString transactionId, String msgId) {
        Set<CertificateInfo> remainingCerts = this.pendingCertPool.removeCertificates(transactionId.getOctets());
        if (CollectionUtil.isEmpty(remainingCerts)) {
            return true;
        }
        boolean successful = true;
        Date invalidityDate = new Date();
        X509Ca ca = this.getCa();
        for (CertificateInfo remainingCert : remainingCerts) {
            try {
                ca.revokeCert(remainingCert.getCert().getCert().getSerialNumber(), CrlReason.CESSATION_OF_OPERATION, invalidityDate, msgId);
            }
            catch (OperationException ex) {
                successful = false;
            }
        }
        return successful;
    }

    private boolean verifyPopo(CertificateRequestMessage certRequest, SubjectPublicKeyInfo spki, boolean allowRaPopo) {
        int popType = certRequest.getProofOfPossessionType();
        if (popType == 0 && allowRaPopo) {
            return true;
        }
        if (popType != 1) {
            LOG.error("unsupported POP type: " + popType);
            return false;
        }
        ProofOfPossession pop = certRequest.toASN1Structure().getPopo();
        POPOSigningKey popoSign = POPOSigningKey.getInstance((Object)pop.getObject());
        AlgorithmIdentifier popoAlgId = popoSign.getAlgorithmIdentifier();
        AlgorithmValidator algoValidator = this.getCmpControl().getPopoAlgoValidator();
        if (!algoValidator.isAlgorithmPermitted(popoAlgId)) {
            String algoName;
            try {
                algoName = AlgorithmUtil.getSignatureAlgoName((AlgorithmIdentifier)popoAlgId);
            }
            catch (NoSuchAlgorithmException ex) {
                algoName = popoAlgId.getAlgorithm().getId();
            }
            LOG.error("POPO signature algorithm {} not permitted", (Object)algoName);
            return false;
        }
        try {
            PublicKey publicKey = this.securityFactory.generatePublicKey(spki);
            ASN1ObjectIdentifier algOid = popoAlgId.getAlgorithm();
            DhpocControl dhpocControl = this.getCa().getCaInfo().getDhpocControl();
            DHSigStaticKeyCertPair kaKeyAndCert = null;
            if (ObjectIdentifiers.Xipki.id_alg_dhPop_x25519_sha256.equals((Object)algOid) || ObjectIdentifiers.Xipki.id_alg_dhPop_x448_sha512.equals((Object)algOid)) {
                if (dhpocControl != null) {
                    DhSigStatic dhSigStatic = DhSigStatic.getInstance((Object)popoSign.getSignature().getBytes());
                    IssuerAndSerialNumber isn = dhSigStatic.getIssuerAndSerial();
                    ASN1ObjectIdentifier keyAlgOid = spki.getAlgorithm().getAlgorithm();
                    kaKeyAndCert = dhpocControl.getKeyCertPair(isn.getName(), isn.getSerialNumber().getValue(), EdECConstants.getKeyAlgNameForKeyAlg((ASN1ObjectIdentifier)keyAlgOid));
                }
                if (kaKeyAndCert == null) {
                    return false;
                }
            }
            ContentVerifierProvider cvp = this.securityFactory.getContentVerifierProvider(publicKey, kaKeyAndCert);
            return certRequest.isValidSigningKeyPOP(cvp);
        }
        catch (IllegalStateException | InvalidKeyException | CRMFException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            return false;
        }
    }

    @Override
    protected CmpControl getCmpControl() {
        return this.getCa().getCmpControl();
    }

    private void checkPermission(RequestorInfo.CmpRequestorInfo requestor, int requiredPermission) throws InsuffientPermissionException {
        X509Ca ca = this.getCa();
        int permission = ca.getCaInfo().getPermission();
        if (!PermissionConstants.contains((int)permission, (int)requiredPermission)) {
            throw new InsuffientPermissionException("Permission " + PermissionConstants.getTextForCode((int)requiredPermission) + "is not permitted");
        }
        requestor.assertPermitted(requiredPermission);
    }

    private String getSystemInfo(RequestorInfo.CmpRequestorInfo requestor, Set<Integer> acceptVersions) throws OperationException {
        DhpocControl dhpocControl;
        X509Ca ca = this.getCa();
        CaInfo caInfo = ca.getCaInfo();
        int version = 3;
        if (acceptVersions != null && !acceptVersions.contains(version)) {
            throw new OperationException(OperationException.ErrorCode.BAD_REQUEST, "none of versions " + acceptVersions + " is supported");
        }
        JSONObject root = new JSONObject(false);
        root.put("version", (Object)version);
        LinkedList<byte[]> certchain = new LinkedList<byte[]>();
        certchain.add(caInfo.getCert().getEncodedCert());
        for (X509Cert m : caInfo.getCertchain()) {
            certchain.add(m.getEncodedCert());
        }
        root.put("caCertchain", certchain);
        JSONObject jsonCmpControl = new JSONObject(false);
        jsonCmpControl.put("rrAkiRequired", (Object)this.getCmpControl().isRrAkiRequired());
        root.put("cmpControl", (Object)jsonCmpControl);
        Set requestorProfiles = requestor.getCaHasRequestor().getProfiles();
        HashSet<String> supportedProfileNames = new HashSet<String>();
        Set<String> caProfileNames = ca.getCaManager().getCertprofilesForCa(caInfo.getIdent().getName());
        for (String string : caProfileNames) {
            if (!requestorProfiles.contains("all") && !requestorProfiles.contains(string)) continue;
            supportedProfileNames.add(string);
        }
        if (CollectionUtil.isNotEmpty(supportedProfileNames)) {
            LinkedList<JSONObject> jsonCertprofiles = new LinkedList<JSONObject>();
            root.put("certprofiles", jsonCertprofiles);
            for (String name : supportedProfileNames) {
                MgmtEntry.Certprofile entry = ca.getCaManager().getCertprofile(name);
                if (entry.isFaulty()) continue;
                JSONObject jsonCertprofile = new JSONObject(false);
                jsonCertprofile.put("name", (Object)name);
                jsonCertprofile.put("type", (Object)entry.getType());
                jsonCertprofile.put("conf", (Object)entry.getConf());
                jsonCertprofiles.add(jsonCertprofile);
            }
        }
        if ((dhpocControl = ca.getCaInfo().getDhpocControl()) != null) {
            X509Cert[] x509CertArray = dhpocControl.getCertificates();
            LinkedList<byte[]> dhpocCerts = new LinkedList<byte[]>();
            for (X509Cert m : x509CertArray) {
                dhpocCerts.add(m.getEncodedCert());
            }
            root.put("dhpocs", dhpocCerts);
        }
        return JSON.toJSONString((Object)root, (boolean)false);
    }

    @Override
    protected ConcurrentContentSigner getSigner() {
        String name = this.getResponderName();
        return this.caManager.getSignerWrapper(name).getSigner();
    }

    @Override
    protected GeneralName getSender() {
        return this.caManager.getSignerWrapper(this.getResponderName()).getSubjectAsGeneralName();
    }

    @Override
    protected boolean intendsMe(GeneralName requestRecipient) {
        X500Name x500Name;
        if (requestRecipient == null) {
            return false;
        }
        if (this.getSender().equals((Object)requestRecipient)) {
            return true;
        }
        return requestRecipient.getTagNo() == 4 && (x500Name = X500Name.getInstance((Object)requestRecipient.getName())).equals((Object)this.caManager.getSignerWrapper(this.getResponderName()).getSubjectAsX500Name());
    }

    @Override
    public RequestorInfo.CmpRequestorInfo getRequestor(X500Name requestorSender) {
        return this.getCa().getRequestor(requestorSender);
    }

    @Override
    public RequestorInfo.CmpRequestorInfo getRequestor(X509Certificate requestorCert) {
        return this.getCa().getRequestor(requestorCert);
    }

    @Override
    public RequestorInfo.CmpRequestorInfo getMacRequestor(X500Name requestorSender, byte[] senderKID) {
        return this.getCa().getMacRequestor(requestorSender, senderKID);
    }

    private PKIBody cmpEnrollCert(String dfltCertprofileName, Boolean dfltCaGenKeypair, PKIMessage request, PKIHeaderBuilder respHeader, CmpControl cmpControl, PKIHeader reqHeader, PKIBody reqBody, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, String msgId, AuditEvent event) throws InsuffientPermissionException {
        PKIBody respBody;
        long confirmWaitTime = cmpControl.getConfirmWaitTime();
        if (confirmWaitTime < 0L) {
            confirmWaitTime *= -1L;
        }
        confirmWaitTime *= 1000L;
        int type = reqBody.getType();
        switch (type) {
            case 0: {
                this.checkPermission(requestor, 1);
                respBody = this.processIr(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, reqHeader, CertReqMessages.getInstance((Object)reqBody.getContent()), cmpControl, msgId, event);
                break;
            }
            case 2: {
                this.checkPermission(requestor, 1);
                respBody = this.processCr(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, reqHeader, CertReqMessages.getInstance((Object)reqBody.getContent()), cmpControl, msgId, event);
                break;
            }
            case 7: {
                this.checkPermission(requestor, 16);
                respBody = this.processKur(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, reqHeader, CertReqMessages.getInstance((Object)reqBody.getContent()), cmpControl, msgId, event);
                break;
            }
            case 4: {
                this.checkPermission(requestor, 1);
                respBody = this.processP10cr(dfltCertprofileName, request, requestor, tid, reqHeader, CertificationRequest.getInstance((Object)reqBody.getContent()), cmpControl, msgId, event);
                break;
            }
            case 13: {
                this.checkPermission(requestor, 128);
                respBody = this.processCcp(dfltCertprofileName, request, requestor, tid, reqHeader, CertReqMessages.getInstance((Object)reqBody.getContent()), cmpControl, msgId, event);
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here");
            }
        }
        InfoTypeAndValue tv = null;
        if (!cmpControl.isConfirmCert() && CmpUtil.isImplictConfirm((PKIHeader)reqHeader)) {
            this.pendingCertPool.removeCertificates(tid.getOctets());
            tv = CmpUtil.getImplictConfirmGeneralInfo();
        } else {
            Date now = new Date();
            respHeader.setMessageTime(new ASN1GeneralizedTime(now));
            tv = new InfoTypeAndValue(CMPObjectIdentifiers.it_confirmWaitTime, (ASN1Encodable)new ASN1GeneralizedTime(new Date(System.currentTimeMillis() + confirmWaitTime)));
        }
        respHeader.setGeneralInfo(tv);
        return respBody;
    }

    private PKIBody cmpUnRevokeRemoveCertificates(PKIMessage request, PKIHeaderBuilder respHeader, CmpControl cmpControl, PKIHeader reqHeader, PKIBody reqBody, RequestorInfo.CmpRequestorInfo requestor, String msgId, AuditEvent event) {
        Integer requiredPermission = null;
        boolean allRevdetailsOfSameType = true;
        RevReqContent rr = RevReqContent.getInstance((Object)reqBody.getContent());
        for (RevDetails revDetails : rr.toRevDetailsArray()) {
            ASN1ObjectIdentifier extId;
            ASN1Encodable extValue;
            Extensions crlDetails = revDetails.getCrlEntryDetails();
            int reasonCode = CrlReason.UNSPECIFIED.getCode();
            if (crlDetails != null && (extValue = crlDetails.getExtensionParsedValue(extId = Extension.reasonCode)) != null) {
                reasonCode = ASN1Enumerated.getInstance((Object)extValue).getValue().intValue();
            }
            if (reasonCode == -1) {
                if (requiredPermission == null) {
                    event.addEventType("rr_remove");
                    requiredPermission = 8;
                    continue;
                }
                if (requiredPermission == 8) continue;
                allRevdetailsOfSameType = false;
                break;
            }
            if (reasonCode == CrlReason.REMOVE_FROM_CRL.getCode()) {
                if (requiredPermission == null) {
                    event.addEventType("rr_unrevoke");
                    requiredPermission = 4;
                    continue;
                }
                if (requiredPermission == 4) continue;
                allRevdetailsOfSameType = false;
                break;
            }
            if (requiredPermission == null) {
                event.addEventType("rr_revoke");
                requiredPermission = 2;
                continue;
            }
            if (requiredPermission == 2) continue;
            allRevdetailsOfSameType = false;
            break;
        }
        if (!allRevdetailsOfSameType) {
            ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText("not all revDetails are of the same type"), new PKIFailureInfo(32)));
            return new PKIBody(23, (ASN1Encodable)emc);
        }
        try {
            this.checkPermission(requestor, requiredPermission);
        }
        catch (InsuffientPermissionException ex) {
            event.setStatus(AuditStatus.FAILED);
            event.addEventData("message", (Object)"NOT_PERMITTED");
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 65536, null);
        }
        return this.unRevokeRemoveCertificates(request, rr, requiredPermission, cmpControl, msgId, event);
    }

    private PKIBody cmpGeneralMsg(PKIHeaderBuilder respHeader, CmpControl cmpControl, PKIHeader reqHeader, PKIBody reqBody, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, String msgId, AuditEvent event) throws InsuffientPermissionException {
        GenMsgContent genMsgBody = GenMsgContent.getInstance((Object)reqBody.getContent());
        InfoTypeAndValue[] itvs = genMsgBody.toInfoTypeAndValueArray();
        InfoTypeAndValue itv = null;
        if (itvs != null && itvs.length > 0) {
            for (InfoTypeAndValue entry : itvs) {
                String itvType = entry.getInfoType().getId();
                if (!KNOWN_GENMSG_IDS.contains(itvType)) continue;
                itv = entry;
                break;
            }
        }
        if (itv == null) {
            String statusMessage = "PKIBody type 21 is only supported with the sub-types " + KNOWN_GENMSG_IDS.toString();
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, statusMessage);
        }
        InfoTypeAndValue itvResp = null;
        ASN1ObjectIdentifier infoType = itv.getInfoType();
        try {
            X509Ca ca = this.getCa();
            if (CMPObjectIdentifiers.it_currentCRL.equals((Object)infoType)) {
                event.addEventType("genm_current_crl");
                this.checkPermission(requestor, 64);
                CertificateList crl = ca.getBcCurrentCrl();
                if (itv.getInfoValue() == null) {
                    crl = ca.getBcCurrentCrl();
                } else {
                    ASN1Integer crlNumber = ASN1Integer.getInstance((Object)itv.getInfoValue());
                    crl = ca.getBcCrl(crlNumber.getPositiveValue());
                }
                if (crl == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, "no CRL is available");
                }
                itvResp = new InfoTypeAndValue(infoType, (ASN1Encodable)crl);
            } else if (ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg.equals((Object)infoType)) {
                CertificateList respValue;
                ASN1Encodable asn1 = itv.getInfoValue();
                ASN1Integer asn1Code = null;
                ASN1Encodable reqValue = null;
                try {
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)asn1);
                    asn1Code = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
                    if (seq.size() > 1) {
                        reqValue = seq.getObjectAt(1);
                    }
                }
                catch (IllegalArgumentException ex) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "invalid value of the InfoTypeAndValue for " + infoType.getId());
                }
                int action = asn1Code.getPositiveValue().intValue();
                switch (action) {
                    case 1: {
                        event.addEventType("genm_gen_crl");
                        this.checkPermission(requestor, 32);
                        X509CRL tmpCrl = ca.generateCrlOnDemand(msgId);
                        if (tmpCrl == null) {
                            String statusMessage = "CRL generation is not activated";
                            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, statusMessage);
                        }
                        respValue = CertificateList.getInstance((Object)tmpCrl.getEncoded());
                        break;
                    }
                    case 2: {
                        event.addEventType("genm_crl4number");
                        this.checkPermission(requestor, 64);
                        ASN1Integer crlNumber = ASN1Integer.getInstance((Object)reqValue);
                        respValue = ca.getBcCrl(crlNumber.getPositiveValue());
                        if (respValue != null) break;
                        String statusMessage = "no CRL is available";
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, statusMessage);
                    }
                    case 3: {
                        event.addEventType("genm_cainfo");
                        HashSet<Integer> acceptVersions = new HashSet<Integer>();
                        if (reqValue != null) {
                            ASN1Sequence seq = DERSequence.getInstance((Object)reqValue);
                            int size = seq.size();
                            for (int i = 0; i < size; ++i) {
                                ASN1Integer ai = ASN1Integer.getInstance((Object)seq.getObjectAt(i));
                                acceptVersions.add(ai.getPositiveValue().intValue());
                            }
                        }
                        if (CollectionUtil.isEmpty(acceptVersions)) {
                            acceptVersions.add(3);
                        }
                        String systemInfo = this.getSystemInfo(requestor, acceptVersions);
                        respValue = new DERUTF8String(systemInfo);
                        break;
                    }
                    default: {
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "unsupported XiPKI action code " + action);
                    }
                }
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)asn1Code);
                if (respValue != null) {
                    vec.add((ASN1Encodable)respValue);
                }
                itvResp = new InfoTypeAndValue(infoType, (ASN1Encodable)new DERSequence(vec));
            } else if (ObjectIdentifiers.Xipki.id_xipki_cmp_cacertchain.equals((Object)infoType)) {
                event.addEventType("genm_cacertchain");
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)ca.getCaInfo().getCertInCmpFormat());
                List<X509Cert> certchain = ca.getCaInfo().getCertchain();
                if (CollectionUtil.isNotEmpty(certchain)) {
                    for (X509Cert m : certchain) {
                        vec.add((ASN1Encodable)m.getCertHolder().toASN1Structure());
                    }
                }
                itvResp = new InfoTypeAndValue(infoType, (ASN1Encodable)new DERSequence(vec));
            }
            GenRepContent genRepContent = new GenRepContent(itvResp);
            return new PKIBody(22, (ASN1Encodable)genRepContent);
        }
        catch (OperationException ex) {
            String errorMessage;
            int failureInfo = this.getPKiFailureInfo(ex);
            OperationException.ErrorCode code = ex.getErrorCode();
            switch (code) {
                case DATABASE_FAILURE: 
                case SYSTEM_FAILURE: {
                    errorMessage = code.name();
                    break;
                }
                default: {
                    errorMessage = code.name() + ": " + ex.getErrorMessage();
                }
            }
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, failureInfo, errorMessage);
        }
        catch (CRLException ex) {
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, "CRLException: " + ex.getMessage());
        }
    }

    public CertificateList getCrl(RequestorInfo.CmpRequestorInfo requestor, BigInteger crlNumber) throws OperationException {
        Args.notNull((Object)requestor, (String)"requestor");
        try {
            this.checkPermission(requestor, 64);
        }
        catch (InsuffientPermissionException ex) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, ex.getMessage());
        }
        X509Ca ca = this.getCa();
        return crlNumber == null ? ca.getBcCurrentCrl() : ca.getBcCrl(crlNumber);
    }

    public X509CRL generateCrlOnDemand(RequestorInfo.CmpRequestorInfo requestor, RequestType reqType, String msgId) throws OperationException {
        Args.notNull((Object)requestor, (String)"requestor");
        try {
            this.checkPermission(requestor, 32);
        }
        catch (InsuffientPermissionException ex) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, ex.getMessage());
        }
        return this.getCa().generateCrlOnDemand(msgId);
    }

    public void revokeCert(RequestorInfo.CmpRequestorInfo requestor, BigInteger serialNumber, CrlReason reason, Date invalidityDate, RequestType reqType, String msgId) throws OperationException {
        Args.notNull((Object)requestor, (String)"requestor");
        int permission = reason == CrlReason.REMOVE_FROM_CRL ? 4 : 2;
        try {
            this.checkPermission(requestor, permission);
        }
        catch (InsuffientPermissionException ex) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, ex.getMessage());
        }
        X509Ca ca = this.getCa();
        Object returnedObj = 4 == permission ? ca.unrevokeCert(serialNumber, msgId) : ca.revokeCert(serialNumber, reason, invalidityDate, msgId);
        if (returnedObj == null) {
            throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT, "cert not exists");
        }
    }

    public void removeCert(RequestorInfo.CmpRequestorInfo requestor, BigInteger serialNumber, RequestType reqType, String msgId) throws OperationException {
        Args.notNull((Object)requestor, (String)"requestor");
        try {
            this.checkPermission(requestor, 8);
        }
        catch (InsuffientPermissionException ex) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, ex.getMessage());
        }
        CertWithDbId returnedObj = this.getCa().removeCert(serialNumber, msgId);
        if (returnedObj == null) {
            throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT, "cert not exists");
        }
    }

    private static PKIBody buildErrorMsgPkiBody(PKIStatus pkiStatus, int failureInfo, String statusMessage) {
        PKIFreeText pkiStatusMsg = statusMessage == null ? null : new PKIFreeText(statusMessage);
        ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(pkiStatus, pkiStatusMsg, new PKIFailureInfo(failureInfo)));
        return new PKIBody(23, (ASN1Encodable)emc);
    }

    private CertResponse buildErrorCertResponse(ASN1Integer certReqId, int pkiFailureInfo, String pkiStatusText) {
        return new CertResponse(certReqId, this.generateRejectionStatus(pkiFailureInfo, pkiStatusText));
    }

    static {
        int size;
        KNOWN_GENMSG_IDS = new HashSet<String>();
        LOG = LoggerFactory.getLogger(CmpResponder.class);
        prf_hmacWithSHA256 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256, (ASN1Encodable)DERNull.INSTANCE);
        KNOWN_GENMSG_IDS.add(CMPObjectIdentifiers.it_currentCRL.getId());
        KNOWN_GENMSG_IDS.add(ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg.getId());
        KNOWN_GENMSG_IDS.add(ObjectIdentifiers.Xipki.id_xipki_cmp_cacertchain.getId());
        String oid = NISTObjectIdentifiers.id_aes128_GCM.getId();
        aesGcm_ciphers = new ConcurrentBag();
        for (int i = 0; i < 64; ++i) {
            Cipher cipher;
            try {
                cipher = Cipher.getInstance(oid);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not get Cipher of " + oid));
                break;
            }
            aesGcm_ciphers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)cipher));
        }
        boolean bl = aesGcm_ciphers_initialized = (size = aesGcm_ciphers.size()) > 0;
        if (size > 0) {
            LOG.info("initialized {} AES GCM Cipher instances", (Object)size);
        } else {
            LOG.error("could not initialize any AES GCM Cipher instance");
        }
        oid = PKCSObjectIdentifiers.id_PBKDF2.getId();
        pbkdf2_kdfs = new ConcurrentBag();
        for (int i = 0; i < 64; ++i) {
            SecretKeyFactory keyFact;
            try {
                keyFact = SecretKeyFactory.getInstance(oid);
            }
            catch (NoSuchAlgorithmException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not get SecretKeyFactory of " + oid));
                break;
            }
            pbkdf2_kdfs.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)keyFact));
        }
        boolean bl2 = pbkdf2_kdfs_initialized = (size = pbkdf2_kdfs.size()) > 0;
        if (size > 0) {
            LOG.info("initialized {} PBKDF2 SecretKeyFactory instances", (Object)size);
        } else {
            LOG.error("could not initialize any PBKDF2 SecretKeyFactory instance");
        }
        kupCertExtnIds = new HashSet<String>();
        kupCertExtnIds.add(Extension.biometricInfo.getId());
        kupCertExtnIds.add(Extension.extendedKeyUsage.getId());
        kupCertExtnIds.add(Extension.keyUsage.getId());
        kupCertExtnIds.add(Extension.qCStatements.getId());
        kupCertExtnIds.add(Extension.subjectAlternativeName.getId());
        kupCertExtnIds.add(Extension.subjectInfoAccess.getId());
    }

    private class PendingPoolCleaner
    implements Runnable {
        private PendingPoolCleaner() {
        }

        @Override
        public void run() {
            Set<CertificateInfo> remainingCerts = CmpResponder.this.pendingCertPool.removeConfirmTimeoutedCertificates();
            if (CollectionUtil.isEmpty(remainingCerts)) {
                return;
            }
            Date invalidityDate = new Date();
            X509Ca ca = CmpResponder.this.getCa();
            for (CertificateInfo remainingCert : remainingCerts) {
                BigInteger serialNumber = null;
                try {
                    serialNumber = remainingCert.getCert().getCert().getSerialNumber();
                    ca.revokeCert(serialNumber, CrlReason.CESSATION_OF_OPERATION, invalidityDate, "ca_routine");
                }
                catch (Throwable th) {
                    LOG.error("could not revoke certificate (CA={}, serialNumber={}): {}", new Object[]{ca.getCaInfo().getIdent(), LogUtil.formatCsn((BigInteger)serialNumber), th.getMessage()});
                }
            }
        }
    }

    private static class PendingCertificatePool {
        private final Map<String, Set<MyEntry>> map = new HashMap<String, Set<MyEntry>>();

        PendingCertificatePool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addCertificate(byte[] transactionId, BigInteger certReqId, CertificateInfo certInfo, long waitForConfirmTill) {
            Args.notNull((Object)transactionId, (String)"transactionId");
            Args.notNull((Object)certInfo, (String)"certInfo");
            if (certInfo.isAlreadyIssued()) {
                return;
            }
            String hexTid = Hex.encode((byte[])transactionId);
            MyEntry myEntry = new MyEntry(certReqId, waitForConfirmTill, certInfo);
            Map<String, Set<MyEntry>> map = this.map;
            synchronized (map) {
                Set<MyEntry> entries = this.map.get(hexTid);
                if (entries == null) {
                    entries = new HashSet<MyEntry>();
                    this.map.put(hexTid, entries);
                }
                entries.add(myEntry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CertificateInfo removeCertificate(byte[] transactionId, BigInteger certReqId, byte[] certHash) {
            Args.notNull((Object)transactionId, (String)"transactionId");
            Args.notNull((Object)certReqId, (String)"certReqId");
            Args.notNull((Object)certHash, (String)"certHash");
            String hexTid = Hex.encode((byte[])transactionId);
            MyEntry retEntry = null;
            Map<String, Set<MyEntry>> map = this.map;
            synchronized (map) {
                Set<MyEntry> entries = this.map.get(hexTid);
                if (entries == null) {
                    return null;
                }
                for (MyEntry entry : entries) {
                    if (!certReqId.equals(entry.certReqId)) continue;
                    retEntry = entry;
                    break;
                }
                if (retEntry != null && Arrays.equals(certHash, retEntry.certHash)) {
                    entries.remove(retEntry);
                    if (CollectionUtil.isEmpty(entries)) {
                        this.map.remove(hexTid);
                    }
                }
            }
            return retEntry == null ? null : retEntry.certInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<CertificateInfo> removeCertificates(byte[] transactionId) {
            Set<MyEntry> entries;
            Args.notNull((Object)transactionId, (String)"transactionId");
            String hexId = Hex.encode((byte[])transactionId);
            Map<String, Set<MyEntry>> map = this.map;
            synchronized (map) {
                entries = this.map.remove(hexId);
            }
            if (entries == null) {
                return null;
            }
            HashSet<CertificateInfo> ret = new HashSet<CertificateInfo>();
            for (MyEntry myEntry : entries) {
                ret.add(myEntry.certInfo);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<CertificateInfo> removeConfirmTimeoutedCertificates() {
            Map<String, Set<MyEntry>> map = this.map;
            synchronized (map) {
                if (CollectionUtil.isEmpty(this.map)) {
                    return null;
                }
                long now = System.currentTimeMillis();
                HashSet<CertificateInfo> ret = new HashSet<CertificateInfo>();
                for (String tid : this.map.keySet()) {
                    Set<MyEntry> entries = this.map.get(tid);
                    for (MyEntry entry : entries) {
                        if (entry.waitForConfirmTill >= now) continue;
                        ret.add(entry.certInfo);
                    }
                }
                return ret;
            }
        }

        private static class MyEntry {
            private final BigInteger certReqId;
            private final long waitForConfirmTill;
            private final CertificateInfo certInfo;
            private final byte[] certHash;

            MyEntry(BigInteger certReqId, long waitForConfirmTill, CertificateInfo certInfo) {
                this.certReqId = (BigInteger)Args.notNull((Object)certReqId, (String)"certReqId");
                this.certInfo = (CertificateInfo)Args.notNull((Object)certInfo, (String)"certInfo");
                this.waitForConfirmTill = waitForConfirmTill;
                this.certHash = HashAlgo.SHA1.hash((byte[][])new byte[][]{certInfo.getCert().getEncodedCert()});
            }

            public int hashCode() {
                return this.certReqId.hashCode() + 961 * (int)this.waitForConfirmTill + 31 * this.certInfo.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof MyEntry)) {
                    return false;
                }
                MyEntry another = (MyEntry)obj;
                return this.certReqId.equals(another.certReqId) && this.certInfo.equals(another.certInfo);
            }
        }
    }
}

