/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.InsuffientPermissionException;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.server.CaManagerImpl;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.DhpocControl;
import org.xipki.ca.server.HttpRequestMetadataRetriever;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.cmp.CmpResponder;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.DateUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.PemEncoder;
import org.xipki.util.RandomUtil;
import org.xipki.util.StringUtil;

public class RestResponder {
    private static final int OK = 200;
    private static final int BAD_REQUEST = 400;
    private static final int UNAUTHORIZED = 401;
    private static final int NOT_FOUND = 404;
    private static final int CONFLICT = 409;
    private static final int UNSUPPORTED_MEDIA_TYPE = 415;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final Logger LOG = LoggerFactory.getLogger(RestResponder.class);
    private final CaManagerImpl responderManager;

    public RestResponder(CaManagerImpl responderManager) {
        this.responderManager = responderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse service(String path, AuditEvent event, byte[] request, HttpRequestMetadataRetriever httpRetriever) {
        event.setApplicationName("ca");
        event.setName("perf");
        event.addEventData("req_type", (Object)RequestType.REST.name());
        String msgId = RandomUtil.nextHexLong();
        event.addEventData("mid", (Object)msgId);
        AuditLevel auditLevel = AuditLevel.INFO;
        AuditStatus auditStatus = AuditStatus.SUCCESSFUL;
        String auditMessage = null;
        try {
            RequestorInfo.CmpRequestorInfo requestor;
            int i;
            String message;
            if (this.responderManager == null) {
                String message2 = "responderManager in servlet not configured";
                LOG.error(message2);
                throw new HttpRespAuditException(500, message2, AuditLevel.ERROR, AuditStatus.FAILED);
            }
            String caName = null;
            String command = null;
            X509Ca ca = null;
            if (path.length() > 1) {
                CmpResponder caResponder;
                String coreUri = path;
                int sepIndex = coreUri.indexOf(47, 1);
                if (sepIndex == -1 || sepIndex == coreUri.length() - 1) {
                    String message3 = "invalid path " + path;
                    LOG.error(message3);
                    throw new HttpRespAuditException(404, message3, AuditLevel.ERROR, AuditStatus.FAILED);
                }
                String caAlias = coreUri.substring(1, sepIndex).toLowerCase();
                command = coreUri.substring(sepIndex + 1).toLowerCase();
                caName = this.responderManager.getCaNameForAlias(caAlias);
                if (caName == null) {
                    caName = caAlias;
                }
                if ((caResponder = this.responderManager.getX509CaResponder(caName)) != null) {
                    ca = caResponder.getCa();
                }
            }
            if (StringUtil.isBlank(command)) {
                message = "command is not specified";
                LOG.warn(message);
                throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            if (caName == null || ca == null || !ca.getCaInfo().supportsRest() || ca.getCaInfo().getStatus() != CaStatus.ACTIVE) {
                message = caName == null ? "no CA is specified" : (ca == null ? "unknown CA '" + caName + "'" : (!ca.getCaInfo().supportsRest() ? "REST is not supported by the CA '" + caName + "'" : "CA '" + caName + "' is out of service"));
                LOG.warn(message);
                throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            event.addEventData("ca", (Object)ca.getCaIdent().getName());
            event.addEventType(command);
            String hdrValue = httpRetriever.getHeader("Authorization");
            if (hdrValue != null && hdrValue.startsWith("Basic ")) {
                String user = null;
                byte[] password = null;
                if (hdrValue.length() > 6) {
                    String b64 = hdrValue.substring(6);
                    byte[] userPwd = Base64.decodeFast((String)b64);
                    int idx = -1;
                    for (i = 0; i < userPwd.length; ++i) {
                        if (userPwd[i] != 58) continue;
                        idx = i;
                        break;
                    }
                    if (idx != -1 && idx < userPwd.length - 1) {
                        user = new String(Arrays.copyOfRange((byte[])userPwd, (int)0, (int)idx));
                        password = Arrays.copyOfRange((byte[])userPwd, (int)(idx + 1), (int)userPwd.length);
                    }
                }
                if (user == null) {
                    throw new HttpRespAuditException(401, "invalid Authorization information", AuditLevel.INFO, AuditStatus.FAILED);
                }
                NameId userIdent = ca.authenticateUser(user, password);
                if (userIdent == null) {
                    throw new HttpRespAuditException(401, "could not authenticate user", AuditLevel.INFO, AuditStatus.FAILED);
                }
                requestor = ca.getByUserRequestor(userIdent);
            } else {
                X509Cert clientCert = httpRetriever.getTlsClientCert();
                if (clientCert == null) {
                    throw new HttpRespAuditException(401, "no client certificate", AuditLevel.INFO, AuditStatus.FAILED);
                }
                requestor = ca.getRequestor(clientCert);
            }
            if (requestor == null) {
                throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "no requestor specified");
            }
            event.addEventData("requestor", (Object)requestor.getIdent().getName());
            String respCt = null;
            byte[] respBytes = null;
            if ("cacert".equals(command)) {
                respCt = "application/pkix-cert";
                respBytes = ca.getCaInfo().getCert().getEncoded();
            } else if ("dhpoc-certs".equals(command)) {
                DhpocControl control = this.responderManager.getX509Ca(caName).getCaInfo().getDhpocControl();
                if (control == null) {
                    respBytes = new byte[]{};
                } else {
                    respCt = "application/x-pem-file";
                    respBytes = StringUtil.toUtf8Bytes((String)X509Util.encodeCertificates((X509Cert[])control.getCertificates()));
                }
            } else if ("cacertchain".equals(command)) {
                respCt = "application/x-pem-file";
                List<X509Cert> certchain = ca.getCaInfo().getCertchain();
                int size = 1 + (certchain == null ? 0 : certchain.size());
                X509Cert[] certchainWithCaCert = new X509Cert[size];
                certchainWithCaCert[0] = ca.getCaInfo().getCert();
                if (size > 1) {
                    for (i = 1; i < size; ++i) {
                        certchainWithCaCert[i] = certchain.get(i - 1);
                    }
                }
                respBytes = StringUtil.toUtf8Bytes((String)X509Util.encodeCertificates((X509Cert[])certchainWithCaCert));
            } else if ("enroll-cert".equals(command) || "enroll-cert-cagenkeypair".equals(command)) {
                Date notAfter;
                String profile = httpRetriever.getParameter("profile");
                if (StringUtil.isBlank((String)profile)) {
                    throw new HttpRespAuditException(400, "required parameter profile not specified", AuditLevel.INFO, AuditStatus.FAILED);
                }
                profile = profile.toLowerCase();
                try {
                    requestor.assertPermitted(1);
                }
                catch (InsuffientPermissionException ex) {
                    throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, ex.getMessage());
                }
                if (!requestor.isCertprofilePermitted(profile)) {
                    throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "certprofile " + profile + " is not allowed");
                }
                String strNotBefore = httpRetriever.getParameter("not-before");
                Date notBefore = strNotBefore == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)strNotBefore);
                String strNotAfter = httpRetriever.getParameter("not-after");
                Date date = notAfter = strNotAfter == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)strNotAfter);
                if ("enroll-cert-cagenkeypair".equals(command)) {
                    Extensions extensions;
                    X500Name subject;
                    String ct = httpRetriever.getHeader("Content-Type");
                    if (ct.startsWith("text/plain")) {
                        Properties props = new Properties();
                        props.load(new ByteArrayInputStream(request));
                        String strSubject = props.getProperty("subject");
                        if (strSubject == null) {
                            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "subject is not specified");
                        }
                        try {
                            subject = new X500Name(strSubject);
                        }
                        catch (Exception ex) {
                            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "invalid subject");
                        }
                        extensions = null;
                    } else if ("application/pkcs10".equalsIgnoreCase(ct)) {
                        request = X509Util.toDerEncoded((byte[])request);
                        CertificationRequestInfo certTemp = CertificationRequest.getInstance((Object)request).getCertificationRequestInfo();
                        subject = certTemp.getSubject();
                        extensions = CaUtil.getExtensions(certTemp);
                    } else {
                        String message4 = "unsupported media type " + ct;
                        throw new HttpRespAuditException(415, message4, AuditLevel.INFO, AuditStatus.FAILED);
                    }
                    CertTemplateData certTemplate = new CertTemplateData(subject, null, notBefore, notAfter, extensions, profile, null, true);
                    CertificateInfo certInfo = ca.generateCert(certTemplate, (RequestorInfo)requestor, RequestType.REST, null, msgId);
                    if (ca.getCaInfo().isSaveRequest()) {
                        long dbId = ca.addRequest(request);
                        ca.addRequestCert(dbId, certInfo.getCert().getCertId());
                    }
                    respCt = "application/x-pem-file";
                    byte[] keyBytes = PemEncoder.encode((byte[])certInfo.getPrivateKey().getEncoded(), (PemEncoder.PemLabel)PemEncoder.PemLabel.PRIVATE_KEY);
                    byte[] certBytes = PemEncoder.encode((byte[])certInfo.getCert().getCert().getEncoded(), (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE);
                    respBytes = new byte[keyBytes.length + 2 + certBytes.length];
                    System.arraycopy(keyBytes, 0, respBytes, 0, keyBytes.length);
                    respBytes[keyBytes.length] = 13;
                    respBytes[keyBytes.length + 1] = 10;
                    System.arraycopy(certBytes, 0, respBytes, keyBytes.length + 2, certBytes.length);
                } else {
                    CertWithDbId cert;
                    String ct = httpRetriever.getHeader("Content-Type");
                    if (!"application/pkcs10".equalsIgnoreCase(ct)) {
                        String message5 = "unsupported media type " + ct;
                        throw new HttpRespAuditException(415, message5, AuditLevel.INFO, AuditStatus.FAILED);
                    }
                    CertificationRequest csr = CertificationRequest.getInstance((Object)request);
                    if (!ca.verifyCsr(csr)) {
                        throw new OperationException(OperationException.ErrorCode.BAD_POP);
                    }
                    CertificationRequestInfo certTemp = csr.getCertificationRequestInfo();
                    X500Name subject = certTemp.getSubject();
                    SubjectPublicKeyInfo publicKeyInfo = certTemp.getSubjectPublicKeyInfo();
                    Extensions extensions = CaUtil.getExtensions(certTemp);
                    CertTemplateData certTemplate = new CertTemplateData(subject, publicKeyInfo, notBefore, notAfter, extensions, profile);
                    CertificateInfo certInfo = ca.generateCert(certTemplate, (RequestorInfo)requestor, RequestType.REST, null, msgId);
                    if (ca.getCaInfo().isSaveRequest()) {
                        long dbId = ca.addRequest(request);
                        ca.addRequestCert(dbId, certInfo.getCert().getCertId());
                    }
                    if ((cert = certInfo.getCert()) == null) {
                        String message6 = "could not generate certificate";
                        LOG.warn(message6);
                        throw new HttpRespAuditException(500, message6, AuditLevel.INFO, AuditStatus.FAILED);
                    }
                    respCt = "application/pkix-cert";
                    respBytes = cert.getCert().getEncoded();
                }
            } else if ("revoke-cert".equals(command) || "delete-cert".equals(command)) {
                int permission = "revoke-cert".equals(command) ? 2 : 8;
                try {
                    requestor.assertPermitted(permission);
                }
                catch (InsuffientPermissionException ex) {
                    throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, ex.getMessage());
                }
                String strCaSha1 = httpRetriever.getParameter("ca-sha1");
                if (StringUtil.isBlank((String)strCaSha1)) {
                    throw new HttpRespAuditException(400, "required parameter ca-sha1 not specified", AuditLevel.INFO, AuditStatus.FAILED);
                }
                String strSerialNumber = httpRetriever.getParameter("serial-number");
                if (StringUtil.isBlank((String)strSerialNumber)) {
                    throw new HttpRespAuditException(400, "required parameter serial-number not specified", AuditLevel.INFO, AuditStatus.FAILED);
                }
                if (!strCaSha1.equalsIgnoreCase(ca.getHexSha1OfCert())) {
                    throw new HttpRespAuditException(400, "unknown ca-sha1", AuditLevel.INFO, AuditStatus.FAILED);
                }
                BigInteger serialNumber = RestResponder.toBigInt(strSerialNumber);
                if ("revoke-cert".equals(command)) {
                    CrlReason reason;
                    String strReason = httpRetriever.getParameter("reason");
                    CrlReason crlReason = reason = strReason == null ? CrlReason.UNSPECIFIED : CrlReason.forNameOrText((String)strReason);
                    if (reason == CrlReason.REMOVE_FROM_CRL) {
                        ca.unrevokeCert(serialNumber, msgId);
                    } else {
                        Date invalidityTime = null;
                        String strInvalidityTime = httpRetriever.getParameter("invalidity-time");
                        if (StringUtil.isNotBlank((String)strInvalidityTime)) {
                            invalidityTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)strInvalidityTime);
                        }
                        ca.revokeCert(serialNumber, reason, invalidityTime, msgId);
                    }
                } else if ("delete-cert".equals(command)) {
                    ca.removeCert(serialNumber, msgId);
                }
            } else if ("crl".equals(command)) {
                X509CRLHolder crl;
                try {
                    requestor.assertPermitted(64);
                }
                catch (InsuffientPermissionException ex) {
                    throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, ex.getMessage());
                }
                String strCrlNumber = httpRetriever.getParameter("crl-number");
                BigInteger crlNumber = null;
                if (StringUtil.isNotBlank((String)strCrlNumber)) {
                    try {
                        crlNumber = RestResponder.toBigInt(strCrlNumber);
                    }
                    catch (NumberFormatException ex) {
                        String message7 = "invalid crlNumber '" + strCrlNumber + "'";
                        LOG.warn(message7);
                        throw new HttpRespAuditException(400, message7, AuditLevel.INFO, AuditStatus.FAILED);
                    }
                }
                if ((crl = ca.getCrl(crlNumber)) == null) {
                    String message8 = "could not get CRL";
                    LOG.warn(message8);
                    throw new HttpRespAuditException(500, message8, AuditLevel.INFO, AuditStatus.FAILED);
                }
                respCt = "application/pkix-crl";
                respBytes = crl.getEncoded();
            } else if ("new-crl".equals(command)) {
                try {
                    requestor.assertPermitted(32);
                }
                catch (InsuffientPermissionException ex) {
                    throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, ex.getMessage());
                }
                X509CRLHolder crl = ca.generateCrlOnDemand(msgId);
                if (crl == null) {
                    String message9 = "could not generate CRL";
                    LOG.warn(message9);
                    throw new HttpRespAuditException(500, message9, AuditLevel.INFO, AuditStatus.FAILED);
                }
                respCt = "application/pkix-crl";
                respBytes = crl.getEncoded();
            } else {
                String message10 = "invalid command '" + command + "'";
                LOG.error(message10);
                throw new HttpRespAuditException(404, message10, AuditLevel.INFO, AuditStatus.FAILED);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-xipki-pkistatus", "accepted");
            RestResponse restResponse = new RestResponse(200, respCt, headers, respBytes);
            return restResponse;
        }
        catch (OperationException ex) {
            String failureInfo;
            int sc;
            OperationException.ErrorCode code = ex.getErrorCode();
            if (LOG.isWarnEnabled()) {
                String msg = StringUtil.concat((String)"generate certificate, OperationException: code=", (String[])new String[]{code.name(), ", message=", ex.getErrorMessage()});
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)msg);
            }
            switch (code) {
                case ALREADY_ISSUED: {
                    sc = 400;
                    failureInfo = "badRequest";
                    break;
                }
                case BAD_CERT_TEMPLATE: {
                    sc = 400;
                    failureInfo = "badCertTemplate";
                    break;
                }
                case BAD_REQUEST: {
                    sc = 400;
                    failureInfo = "badRequest";
                    break;
                }
                case CERT_REVOKED: {
                    sc = 409;
                    failureInfo = "certRevoked";
                    break;
                }
                case CRL_FAILURE: {
                    sc = 500;
                    failureInfo = "systemFailure";
                    break;
                }
                case DATABASE_FAILURE: {
                    sc = 500;
                    failureInfo = "systemFailure";
                    break;
                }
                case NOT_PERMITTED: {
                    sc = 401;
                    failureInfo = "notAuthorized";
                    break;
                }
                case INVALID_EXTENSION: {
                    sc = 400;
                    failureInfo = "badRequest";
                    break;
                }
                case SYSTEM_FAILURE: {
                    sc = 500;
                    failureInfo = "systemFailure";
                    break;
                }
                case SYSTEM_UNAVAILABLE: {
                    sc = 503;
                    failureInfo = "systemUnavail";
                    break;
                }
                case UNKNOWN_CERT: {
                    sc = 400;
                    failureInfo = "badCertId";
                    break;
                }
                case UNKNOWN_CERT_PROFILE: {
                    sc = 400;
                    failureInfo = "badCertTemplate";
                    break;
                }
                default: {
                    sc = 500;
                    failureInfo = "systemFailure";
                }
            }
            event.setStatus(AuditStatus.FAILED);
            event.addEventData("message", (Object)code.name());
            switch (code) {
                case DATABASE_FAILURE: 
                case SYSTEM_FAILURE: {
                    auditMessage = code.name();
                    break;
                }
                default: {
                    auditMessage = code.name() + ": " + ex.getErrorMessage();
                }
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-xipki-pkistatus", "rejection");
            if (StringUtil.isNotBlank((String)failureInfo)) {
                headers.put("X-xipki-fail-info", failureInfo);
            }
            RestResponse restResponse = new RestResponse(sc, null, headers, null);
            return restResponse;
        }
        catch (HttpRespAuditException ex) {
            auditStatus = ex.getAuditStatus();
            auditLevel = ex.getAuditLevel();
            auditMessage = ex.getAuditMessage();
            RestResponse restResponse = new RestResponse(ex.getHttpStatus(), null, null, null);
            return restResponse;
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen!", th);
            }
            auditLevel = AuditLevel.ERROR;
            auditStatus = AuditStatus.FAILED;
            auditMessage = "internal error";
            RestResponse restResponse = new RestResponse(500, null, null, null);
            return restResponse;
        }
        finally {
            event.setStatus(auditStatus);
            event.setLevel(auditLevel);
            if (auditMessage != null) {
                event.addEventData("message", (Object)auditMessage);
            }
        }
    }

    private static BigInteger toBigInt(String str) {
        String tmpStr = str.trim();
        if (tmpStr.startsWith("0x") || tmpStr.startsWith("0X")) {
            if (tmpStr.length() > 2) {
                return new BigInteger(tmpStr.substring(2), 16);
            }
            throw new NumberFormatException("invalid integer '" + tmpStr + "'");
        }
        return new BigInteger(tmpStr);
    }

    private static class HttpRespAuditException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final int httpStatus;
        private final String auditMessage;
        private final AuditLevel auditLevel;
        private AuditStatus auditStatus;

        public HttpRespAuditException(int httpStatus, String auditMessage, AuditLevel auditLevel, AuditStatus auditStatus) {
            this.httpStatus = httpStatus;
            this.auditMessage = Args.notBlank((String)auditMessage, (String)"auditMessage");
            this.auditLevel = (AuditLevel)Args.notNull((Object)auditLevel, (String)"auditLevel");
            this.auditStatus = (AuditStatus)Args.notNull((Object)auditStatus, (String)"auditStatus");
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public String getAuditMessage() {
            return this.auditMessage;
        }

        public AuditLevel getAuditLevel() {
            return this.auditLevel;
        }

        public AuditStatus getAuditStatus() {
            return this.auditStatus;
        }
    }

    public static class RestResponse {
        private int statusCode;
        private String contentType;
        private Map<String, String> headers = new HashMap<String, String>();
        private byte[] body;

        public RestResponse(int statusCode, String contentType, Map<String, String> headers, byte[] body) {
            this.statusCode = statusCode;
            this.contentType = contentType;
            this.headers = headers;
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public byte[] getBody() {
            return this.body;
        }

        public void setBody(byte[] body) {
            this.body = body;
        }
    }
}

